/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.requester.AllgChoiceRequester;

public class CSUserLanguage
extends CSAllg {
    private static final String[] LANGS;
    public String ivLanguage = null;
    private String ivValue = null;

    static {
        Vector v = Babel.AVAILABLE_LANGUAGES;
        LANGS = new String[v.size()];
        int i = 0;
        while (i < LANGS.length) {
            CSUserLanguage.LANGS[i] = (String)v.elementAt(i);
            ++i;
        }
    }

    public CSUserLanguage(InspectorPanel ip) {
        super(ip, Babel.get("LANGUAGE"));
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public String getLanguage() {
        return this.ivLanguage;
    }

    private boolean activePossible(Vector v) {
        String group;
        if (v != null && !v.isEmpty() && Privileges.hasPrivilege("USR_CH_LANGUAGE") && (group = IDObject.commonGroup(v)) != null) {
            User u;
            boolean weiter = false;
            if (Privileges.hasPrivilege("CHANGE_USER")) {
                weiter = true;
            } else if (v.size() == 1 && (u = (User)v.firstElement()).getID() == UserManager.getIDOFUser() && u.getGroup().equals(UserManager.getUser().getGroup())) {
                weiter = true;
            }
            if (weiter) {
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    User u2 = (User)iter.next();
                    if (u2.isAliveAndVisible()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
        } else {
            this.ivChanged = false;
            this.ivLanguage = this.getCommonUserLanguage(v, "NULL", "MULTI");
            if (this.ivLanguage.equals("MULTI")) {
                this.ivLanguage = null;
                this.ivStatus = -2;
            } else if (this.ivLanguage.equals("NULL")) {
                this.ivLanguage = null;
                this.ivStatus = -1;
            } else {
                this.ivValue = Babel.getStringForLang(this.ivLanguage);
                this.ivStatus = -3;
            }
            this.setTextAccordingly();
            if (this.activePossible(v)) {
                this.setToActive();
            } else {
                this.setToPassive();
            }
        }
    }

    private String getCommonUserLanguage(Vector v, String nullVal, String multiVal) {
        String lang = null;
        int i = 0;
        while (i < v.size()) {
            User u = (User)v.elementAt(i);
            String tl = u.getString("USR_LANGUAGE", nullVal);
            if (i == 0) {
                lang = tl;
            } else if (!tl.equals(lang)) {
                return multiVal;
            }
            ++i;
        }
        return lang;
    }

    public String getNotSetLabel() {
        return String.valueOf(Babel.get("NOTSET")) + " [" + Babel.getStringForLang(null) + "]";
    }

    public String getValueLabel() {
        return this.ivValue != null ? this.ivValue : Babel.get("NOTSET");
    }

    public void actionPerformed(ActionEvent e) {
        String newLanguage = AllgChoiceRequester.getStringAnswer(Inspector.getInspector(), Babel.get("LANGUAGE"), LANGS);
        String string = newLanguage = newLanguage != null ? Babel.getLangForString(newLanguage) : null;
        if (!(newLanguage == null || this.ivStatus != -1 && this.ivStatus != -2 && this.ivLanguage != null && this.ivLanguage.equals(newLanguage))) {
            this.ivLanguage = newLanguage;
            this.ivValue = Babel.getStringForLang(this.ivLanguage);
            this.changed(true);
            this.setLabel(this.ivValue);
        }
    }
}

