/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.user.NewUserRequester;

public class CSUserStatus
extends CSAllg {
    private int ivUserStatus;

    public CSUserStatus(InspectorPanel ip) {
        super(ip, Babel.get("STATUS"));
    }

    public int getUserStatus() {
        return this.ivUserStatus;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        Vector v = new Vector(selectedObjects.size());
        Iterator iter = selectedObjects.iterator();
        while (iter.hasNext()) {
            User u;
            Object ooo = iter.next();
            if (!(ooo instanceof User) || this.ivUserStatus == (u = (User)ooo).getInt("USR_MODE", 0)) continue;
            v.add(ooo);
        }
        return v;
    }

    private boolean activePossible(Vector v) {
        String group;
        if (v != null && !v.isEmpty() && Privileges.hasPrivilege("CHANGE_USER") && (group = IDObject.commonGroup(v)) != null) {
            long myID = UserManager.getIDOFUser();
            String myGroup = UserManager.getUser().getGroup();
            Vector gurus = UserManager.getGurus(group, true);
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                User u = (User)iter.next();
                if (u.getID() == myID && u.getGroup().equals(myGroup)) {
                    return false;
                }
                if (!u.isAliveAndVisible()) {
                    return false;
                }
                gurus.remove(u);
            }
            return !gurus.isEmpty();
        }
        return false;
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
        } else {
            this.ivChanged = false;
            this.ivUserStatus = IDObject.getCommonIntValue(v, "USR_MODE", 0, -1);
            this.ivStatus = this.ivUserStatus == -1 ? -2 : -3;
            this.setTextAccordingly();
            if (this.activePossible(v)) {
                this.setToActive();
            } else {
                this.setToPassive();
            }
        }
    }

    public String getValueLabel() {
        return User.getStringForStatus(this.ivUserStatus);
    }

    public void actionPerformed(ActionEvent e) {
        Vector users;
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && this.activePossible(users = ip.ivSelObjects)) {
            int ind;
            String[] choices = null;
            if (MausoleumClient.isRegular()) {
                choices = NewUserRequester.CHOICES_REGULAR;
            } else if (MausoleumClient.isHeadOfService()) {
                choices = NewUserRequester.CHOICES_HEAD_OF_SERVICE;
            } else if (MausoleumClient.isHeadOfTGService()) {
                choices = NewUserRequester.CHOICES_HEAD_OF_TGSERVICE;
            }
            if (choices != null && (ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("STATUS"), choices)) != -1) {
                boolean ungleich;
                int chosenValue = User.getStatusForString(choices[ind]);
                boolean bl = ungleich = chosenValue != this.ivUserStatus;
                if (ungleich) {
                    this.ivUserStatus = chosenValue;
                    this.changed(ungleich);
                    this.setTextAccordingly();
                }
            }
        }
    }
}

