/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.license;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.tierschutz.TierSchutz;

public class License
extends IDObject {
    private static final long serialVersionUID = 4542435L;
    public static final String LIC_PREFIX = "LIC_";
    public static final String NAME = "LIC_NAME";
    public static final String HOLDER = "LIC_LH";
    public static final String STARTDATE = "LIC_SD";
    public static final String ENDDATE = "LIC_ED";
    public static final String MAX_MOUSE_COUNT = "LIC_MMC";
    public static final String USERIDS = "LIC_UI";
    public static final String COMMENT = "LIC_CO";
    public static final String COLOR = "LIC_COL";
    public static final String IS_LINE_LIC = "LIC_ILL";
    public static final String LIC_SUBTYPE = "LIC_LIC_SUBTYPE";
    public static final String NEEDS_MAUS_BELASTUNG = "LIC_NMB";
    private static final String AKT_MOUSE_COUNT = "LIC_AMC";
    private static final String REM_BY_DEATH = "LIC_RBD";
    private static final String REM_BY_SACRIFICE = "LIC_RBS";
    private static final String REM_BY_EXPORT = "LIC_RBE";
    private static final String REM_BY_REMOVAL = "LIC_RBR";
    public static final String[] ATTRIBUTES_LIC;
    public static final String[] ORDERED_ATTRIBUTES;
    public static final int LIC_SUBTYP_UNDEFINED = 0;
    public static final int LIC_SUBTYP_HALTUNG = 1;
    public static final int LIC_SUBTYP_TIERVERSUCH = 2;
    public static final int[] LIC_SUBTYPES;
    public static final int[] LIC_SUBTYPES_SELECTION;
    public static final String[] LIC_SUBTYPE_BABELS;
    public static final String[] LIC_SUBTYPE_SELECTION_BABELS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        String[] stringArray = new String[32];
        stringArray[0] = NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = HOLDER;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = STARTDATE;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = ENDDATE;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = MAX_MOUSE_COUNT;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = AKT_MOUSE_COUNT;
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = USERIDS;
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = COMMENT;
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        stringArray[16] = COLOR;
        Class<?> clazz9 = class$3;
        if (clazz9 == null) {
            try {
                clazz9 = class$3 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz9.getName();
        stringArray[18] = REM_BY_DEATH;
        Class<?> clazz10 = class$1;
        if (clazz10 == null) {
            try {
                clazz10 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz10.getName();
        stringArray[20] = REM_BY_SACRIFICE;
        Class<?> clazz11 = class$1;
        if (clazz11 == null) {
            try {
                clazz11 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz11.getName();
        stringArray[22] = REM_BY_EXPORT;
        Class<?> clazz12 = class$1;
        if (clazz12 == null) {
            try {
                clazz12 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz12.getName();
        stringArray[24] = REM_BY_REMOVAL;
        Class<?> clazz13 = class$1;
        if (clazz13 == null) {
            try {
                clazz13 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[25] = clazz13.getName();
        stringArray[26] = IS_LINE_LIC;
        Class<?> clazz14 = class$4;
        if (clazz14 == null) {
            try {
                clazz14 = class$4 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[27] = clazz14.getName();
        stringArray[28] = NEEDS_MAUS_BELASTUNG;
        Class<?> clazz15 = class$4;
        if (clazz15 == null) {
            try {
                clazz15 = class$4 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[29] = clazz15.getName();
        stringArray[30] = LIC_SUBTYPE;
        Class<?> clazz16 = class$1;
        if (clazz16 == null) {
            try {
                clazz16 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[31] = clazz16.getName();
        ATTRIBUTES_LIC = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", NAME, HOLDER, STARTDATE, ENDDATE, MAX_MOUSE_COUNT, AKT_MOUSE_COUNT, USERIDS, COMMENT, COLOR, REM_BY_DEATH, REM_BY_SACRIFICE, REM_BY_EXPORT, REM_BY_REMOVAL, IS_LINE_LIC, NEEDS_MAUS_BELASTUNG, LIC_SUBTYPE};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        LIC_SUBTYPES = nArray;
        LIC_SUBTYPES_SELECTION = new int[]{1, 2};
        LIC_SUBTYPE_BABELS = new String[]{"UNDEFINED", "LIC_HALTUNG", "LIC_TIERVERUSCH"};
        LIC_SUBTYPE_SELECTION_BABELS = new String[]{"LIC_HALTUNG", "LIC_TIERVERUSCH"};
    }

    public String getName(String nullVal) {
        return this.getString(NAME, nullVal);
    }

    public String getName() {
        return this.getName(null);
    }

    public String getBrowseName() {
        return this.getName("License " + this.getID());
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        String s;
        Color c;
        long[] arr;
        String dateStr;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Type = " + (this.isLineLicense() ? "Line" : "Mouse"));
        if (this.get(NAME) != null) {
            target.add("Name = " + this.getString(NAME, ""));
        }
        if (this.get(HOLDER) != null) {
            target.add("Holder = " + this.getString(HOLDER, ""));
        }
        if (this.get(STARTDATE) != null) {
            dateStr = DatumFormat.getJustDateString(new Date(new MyDate(this.getInt(STARTDATE, 0)).getTime()));
            target.add("Begin of validity = " + dateStr);
        }
        if (this.get(ENDDATE) != null) {
            dateStr = DatumFormat.getJustDateString(new Date(new MyDate(this.getInt(ENDDATE, 0)).getTime()));
            target.add("Expiry date = " + dateStr);
        }
        target.add("max. mice = " + this.getInt(MAX_MOUSE_COUNT, 0));
        if (!this.isLineLicense()) {
            target.add("needs stress input = " + (this.needsMausBelastung() ? "yes" : "no"));
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(6))) && (arr = (long[])this.get(USERIDS)) != null) {
            int j = 0;
            while (j < arr.length) {
                IDObject ido = ObjectStore.getObjectDeadOrAlive(6, arr[j], group, null, false);
                target.add("User: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + arr[j]);
                ++j;
            }
        }
        if ((c = (Color)this.get(COLOR)) != null) {
            target.add("Color = (" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        }
        if ((s = this.getString(COMMENT, null)) != null && s.trim().length() != 0) {
            target.add("Comment\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public boolean isLineLicense() {
        return this.getBoolean(IS_LINE_LIC, false);
    }

    public boolean isMouseLicense() {
        return !this.isLineLicense();
    }

    public boolean isTierversuchsLicense() {
        return !this.isLineLicense() && this.getInt(LIC_SUBTYPE, 0) == 2;
    }

    public boolean isHaltungsLicense() {
        return this.isLineLicense() || this.getInt(LIC_SUBTYPE, 0) == 1;
    }

    public String getSubtypeLabel() {
        if (this.isLineLicense()) {
            return Babel.get("LIC_HALTUNG");
        }
        if (this.isMouseLicense()) {
            return StringHelper.getStringForInt(this.getInt(LIC_SUBTYPE, 0), LIC_SUBTYPES, LIC_SUBTYPE_BABELS, true, "?");
        }
        return "?";
    }

    public boolean needsMausBelastung() {
        return TierSchutz.belastungNeeded() && TierSchutz.isForcedStressReportInputPossible(this) && this.getBoolean(NEEDS_MAUS_BELASTUNG, false);
    }

    public void addUserID(long id) {
        long[] userids = (long[])this.get(USERIDS);
        long[] newUserids = null;
        if (userids == null || userids.length == 0) {
            newUserids = new long[1];
        } else {
            int i = 0;
            while (i < userids.length) {
                if (userids[i] == id) {
                    return;
                }
                ++i;
            }
            newUserids = new long[userids.length + 1];
            i = 0;
            while (i < userids.length) {
                newUserids[i] = userids[i];
                ++i;
            }
        }
        newUserids[newUserids.length - 1] = id;
        this.set(USERIDS, newUserids);
    }

    public void removeUserID(long id) {
        long[] userids = (long[])this.get(USERIDS);
        long[] newUserids = null;
        if (userids != null && userids.length != 0) {
            Vector<Long> rein = new Vector<Long>();
            int i = 0;
            while (i < userids.length) {
                if (userids[i] != id) {
                    rein.add(new Long(userids[i]));
                }
                ++i;
            }
            if (rein.size() != 0) {
                newUserids = new long[rein.size()];
                i = 0;
                while (i < newUserids.length) {
                    newUserids[i] = (Long)rein.elementAt(i);
                    ++i;
                }
            }
            this.set(USERIDS, newUserids);
        }
    }

    public void incCount(String tag) {
        if (ProcessDefinition.isServer()) {
            this.setInt(tag, this.getInt(tag, 0) + 1);
        }
    }

    public void decMouseCount() {
        int bisher;
        if (ProcessDefinition.isServer() && (bisher = this.getInt(AKT_MOUSE_COUNT, 0)) > 0) {
            this.setInt(AKT_MOUSE_COUNT, bisher - 1);
        }
    }

    public boolean isFullServicableObject() {
        return true;
    }

    public boolean isAllowed() {
        if (ProcessDefinition.isClient()) {
            return this.isAllowed(UserManager.getIDOFUser());
        }
        return false;
    }

    public boolean isAllowed(long userid) {
        long[] uids;
        if (ProcessDefinition.isClient() && (uids = (long[])this.get(USERIDS)) != null) {
            int i = 0;
            while (i < uids.length) {
                if (uids[i] == userid) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getUserNames() {
        Vector<String> userNames = new Vector<String>();
        long[] uids = (long[])this.get(USERIDS);
        if (uids != null) {
            int i = 0;
            while (i < uids.length) {
                User user = UserManager.getUser(uids[i], this.getGroup());
                if (user != null) {
                    userNames.add(user.getBrowseName());
                }
                ++i;
            }
        }
        Collections.sort(userNames);
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < userNames.size()) {
            if (i != 0) {
                msb.append(", ");
            }
            msb.append(userNames.elementAt(i));
            ++i;
        }
        return msb.toString();
    }

    public boolean isValid() {
        int start = this.getInt(STARTDATE, Integer.MIN_VALUE);
        int end = this.getInt(ENDDATE, Integer.MAX_VALUE);
        return MyDate.HEUTE >= start && MyDate.HEUTE <= end;
    }

    public boolean isObjectIdenticalForGroupTransfer(IDObject idObject) {
        return false;
    }
}

