/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.license;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.documents.PureIntegerDocument;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.color.ColorRequester;
import mausoleum.ui.UIDef;

public class LicenseAddRequester
extends BasicRequester {
    private static final long serialVersionUID = 14564486135L;
    private static final int RAND = UIDef.RAND;
    private static final int INNER_RAND = UIDef.INNER_RAND;
    private static final int LABEL_WIDTH = 140;
    private static final int FIELD_WIDTH = 280;
    private static final int SBUTT_WIDTH = 24;
    private static final int R_WIDTH = 250;
    private static final int X1 = RAND;
    private static final int X2 = X1 + 140 + INNER_RAND;
    private static final int HALB_FIELD_WIDTH = 256;
    private static final int X3 = X2 + 256;
    private static final int X4 = X2 + 280 + RAND;
    private static final int IBREITE = 140 + INNER_RAND + 280 + RAND + 250;
    private static final int BREITE = RAND + IBREITE + RAND;
    private static final int LINE_HEIGHT = 24;
    private static final int BIG_BUT_HEIGHT = 34;
    private static final int ANZ_LINES = 7;
    private static final int FIELD_HEIGHT = 168 + 6 * INNER_RAND;
    private static final int DESC_HEIGHT = 120;
    private static final int HOEHE = RAND + FIELD_HEIGHT + INNER_RAND + 120 + RAND + 34 + RAND;
    public static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(1);
    private JTextField ivNameField = new JTextField();
    private JComboBox ivTypeCombo = new JComboBox<String>(new String[]{Babel.get("LIC_MOUSE_LICENSE"), Babel.get("LIC_LINE_LICENSE")});
    private JTextField ivHolderField = new JTextField();
    private JTextField ivStartDateField = new JTextField();
    private JTextField ivEndDateField = new JTextField();
    private KomfortTextField ivMaxMouseCountField = new KomfortTextField();
    private JTextArea ivDescArea = new JTextArea();
    private JLabel ivColorLabel = new JLabel();
    private JLabel ivListLabel = new JLabel();
    private Date ivStartDate = null;
    private Date ivEndDate = null;
    private Color ivColor = Color.white;
    private Vector ivPotentialUsers = new Vector();
    private HashSet ivWantedUserIDs = new HashSet();
    private CaretListener ivCaretListener = new CaretListener(){

        public void caretUpdate(CaretEvent arg0) {
            LicenseAddRequester.this.adaptButtons();
        }
    };

    public static void getNewLicense(Frame sender) {
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) {
            LicenseAddRequester lar = new LicenseAddRequester(sender);
            lar.setVisible(true);
            if (lar.ivWarOK) {
                StringBuffer msb = new StringBuffer();
                msb.append("LIC_NEW").append(" ");
                msb.append(Base64Manager.encodeBase64(lar.ivNameField.getText().trim())).append(" ");
                msb.append(Base64Manager.encodeBase64(lar.ivHolderField.getText().trim())).append(" ");
                if (lar.ivStartDate == null) {
                    msb.append("-1 ");
                } else {
                    msb.append(lar.ivStartDate.getTime() / 86400000L).append(" ");
                }
                if (lar.ivEndDate == null) {
                    msb.append("-1 ");
                } else {
                    msb.append(lar.ivEndDate.getTime() / 86400000L).append(" ");
                }
                msb.append(lar.ivMaxMouseCountField.getInt(0)).append(" ");
                StringBuffer usb = new StringBuffer();
                Iterator iter = lar.ivWantedUserIDs.iterator();
                while (iter.hasNext()) {
                    Long lid = (Long)iter.next();
                    if (usb.length() != 0) {
                        usb.append("|");
                    }
                    usb.append(lid);
                }
                msb.append(usb.toString()).append(" ");
                String comment = lar.ivDescArea.getText().trim();
                if (comment.length() != 0) {
                    msb.append(Base64Manager.encodeBase64(comment));
                }
                msb.append(" ");
                msb.append(CommandManagerExecutive.convertColor(lar.ivColor));
                msb.append(" ");
                msb.append(lar.ivTypeCombo.getSelectedIndex() == 0 ? "0" : "1");
                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), UserManager.getFirstGroup());
            }
        }
    }

    private LicenseAddRequester(Frame sender) {
        super(sender, BREITE, HOEHE);
        this.setTitle(Babel.get("LIC_NEW_LICENSE"));
        int y = RAND;
        this.addPermanentLabel(Babel.get("NAME"), X1, y + 2, 24);
        this.ivNameField.setFont(FontManager.getFont("SSB14"));
        this.ivNameField.addCaretListener(this.ivCaretListener);
        this.addAndApplyBounds(this.ivNameField, X2, y, 280, 24);
        this.addPermanentLabel(Babel.get("LIC_LICENSE_TYPE"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivTypeCombo.setFont(FontManager.getFont("SSB14"));
        this.addAndApplyBounds(this.ivTypeCombo, X2, y, 280, 24);
        this.addPermanentLabel(Babel.get("LIC_HOLDER"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivHolderField.setFont(FontManager.getFont("SSB14"));
        this.ivHolderField.addCaretListener(this.ivCaretListener);
        this.addAndApplyBounds(this.ivHolderField, X2, y, 280, 24);
        this.addPermanentLabel(Babel.get("LIC_STARTDATE"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivStartDateField.setFont(FontManager.getFont("SSB14"));
        this.ivStartDateField.setEnabled(false);
        this.ivStartDateField.setOpaque(false);
        this.ivStartDateField.setBorder(new LineBorder(Color.black));
        this.addAndApplyBounds(this.ivStartDateField, X2, y, 256, 24);
        MGButton but = new MGButton("...");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date d = CalendarRequester.getDate((Frame)Inspector.getInspector(), null, null);
                if (d != null) {
                    LicenseAddRequester.this.ivStartDate = d;
                    LicenseAddRequester.this.ivStartDateField.setText(" " + DATE_FORMAT.format(d) + " ");
                }
            }
        });
        this.addAndApplyBounds(but, X3, y, 24, 24);
        this.addPermanentLabel(Babel.get("LIC_ENDDATE"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivEndDateField.setFont(FontManager.getFont("SSB14"));
        this.ivEndDateField.setEnabled(false);
        this.ivEndDateField.setOpaque(false);
        this.ivEndDateField.setBorder(new LineBorder(Color.black));
        this.addAndApplyBounds(this.ivEndDateField, X2, y, 256, 24);
        but = new MGButton("...");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date d = CalendarRequester.getDate((Frame)Inspector.getInspector(), null, null);
                if (d != null) {
                    LicenseAddRequester.this.ivEndDate = d;
                    LicenseAddRequester.this.ivEndDateField.setText(" " + DATE_FORMAT.format(d) + " ");
                }
            }
        });
        this.addAndApplyBounds(but, X3, y, 24, 24);
        this.addPermanentLabel(Babel.get("LIC_MOUSECOUNT"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivMaxMouseCountField.setDocument(new PureIntegerDocument(this.ivMaxMouseCountField));
        this.ivMaxMouseCountField.setFont(FontManager.getFont("SSB14"));
        this.ivMaxMouseCountField.addCaretListener(this.ivCaretListener);
        this.addAndApplyBounds(this.ivMaxMouseCountField, X2, y, 280, 24);
        this.addPermanentLabel(Babel.get("LIC_COLOR"), X1, (y += 24 + INNER_RAND) + 2, 24);
        this.ivColorLabel.setBackground(this.ivColor);
        this.ivColorLabel.setOpaque(true);
        this.ivColorLabel.setBorder(new LineBorder(Color.black));
        this.addAndApplyBounds(this.ivColorLabel, X2, y, 256, 24);
        but = new MGButton("...");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color c = ColorRequester.getNewColor(LicenseAddRequester.this.ivColor, true);
                if (c != null) {
                    LicenseAddRequester.this.ivColor = c;
                    LicenseAddRequester.this.ivColorLabel.setBackground(c);
                }
            }
        });
        this.addAndApplyBounds(but, X3, y, 24, 24);
        y += 24 + INNER_RAND;
        this.ivDescArea.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.ivDescArea.setWrapStyleWord(true);
        this.ivDescArea.setLineWrap(true);
        this.ivDescArea.setFont(FontManager.getFont("SSB11"));
        BorderPanel mbp = new BorderPanel(new JScrollPane(this.ivDescArea), Babel.get("DESCRIPTION"));
        this.addAndApplyBounds(mbp, X1, y, IBREITE, 120);
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, RAND, y += 120 + RAND, IBREITE, 34);
        Vector allUsers = UserManager.getActualAndVisibleObjects(UserManager.getFirstGroup());
        Iterator iter = allUsers.iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            if (!Privileges.hasPrivilege(user, "ADD_LICENSE_TO_MOUSE") || Privileges.hasPrivilege(user, "ADD_LICENSE_TO_MOUSE_ALWAYS")) continue;
            this.ivPotentialUsers.add(user);
            this.ivWantedUserIDs.add(user.get("IDO_ID"));
        }
        JList list = new JList(this.ivPotentialUsers);
        JPanel mp = new JPanel(new BorderLayout());
        mp.add("Center", new JScrollPane(list));
        mbp = new BorderPanel(mp, Babel.get("LIC_USERS"));
        this.addAndApplyBounds(mbp, X4, RAND, 250, FIELD_HEIGHT);
        this.ivListLabel.setFont(FontManager.getFont("SSB12"));
        list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList rlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                User user = (User)value;
                if (LicenseAddRequester.this.ivWantedUserIDs.contains(user.get("IDO_ID"))) {
                    LicenseAddRequester.this.ivListLabel.setIcon(ImageProvider.HAKEN_ICON);
                } else {
                    LicenseAddRequester.this.ivListLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
                }
                LicenseAddRequester.this.ivListLabel.setText(" " + user.getBrowseName() + " ");
                return LicenseAddRequester.this.ivListLabel;
            }
        });
        list.setSelectionMode(0);
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JList jlist = (JList)e.getSource();
                int sind = jlist.getSelectedIndex();
                if (sind >= 0 && sind < LicenseAddRequester.this.ivPotentialUsers.size()) {
                    User user = (User)LicenseAddRequester.this.ivPotentialUsers.elementAt(sind);
                    Long id = (Long)user.get("IDO_ID");
                    if (LicenseAddRequester.this.ivWantedUserIDs.contains(id)) {
                        LicenseAddRequester.this.ivWantedUserIDs.remove(id);
                    } else {
                        LicenseAddRequester.this.ivWantedUserIDs.add(id);
                    }
                    jlist.repaint();
                }
            }
        });
    }

    private void adaptButtons() {
        boolean ok = true;
        if (ok && this.ivNameField.getText().trim().length() == 0) {
            ok = false;
        }
        if (ok && this.ivHolderField.getText().trim().length() == 0) {
            ok = false;
        }
        if (ok && this.ivMaxMouseCountField.getInt(0) <= 0) {
            ok = false;
        }
        this.ivOkButton.setEnabled(ok);
    }
}

