/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.license;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.user.Privileges;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.license.License;
import mausoleum.main.ProcessDefinition;

public class LicenseManager
extends ObjectManager {
    public static LicenseManager cvInstance;

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new LicenseManager();
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Vector getAllowedLicenses(String group, boolean forMouse) {
        Vector allLicenses;
        if (group != null && (allLicenses = cvInstance.getActualObjectVector(group, true, true)) != null && !allLicenses.isEmpty()) {
            String privAlways;
            Vector<License> possibleLicenses = new Vector<License>(allLicenses.size());
            String privNormal = forMouse ? "ADD_LICENSE_TO_MOUSE" : "LIN_CH_LICENSE";
            String string = privAlways = forMouse ? "ADD_LICENSE_TO_MOUSE_ALWAYS" : "LIN_CH_LICENSE_ALWAYS";
            if (allLicenses != null && !allLicenses.isEmpty()) {
                License license;
                Iterator iter;
                if (Privileges.hasPrivilege(privAlways)) {
                    iter = allLicenses.iterator();
                    while (iter.hasNext()) {
                        license = (License)iter.next();
                        if (!(forMouse ? license.isMouseLicense() : license.isLineLicense())) continue;
                        possibleLicenses.add(license);
                    }
                }
                if (Privileges.hasPrivilege(privNormal)) {
                    iter = allLicenses.iterator();
                    while (iter.hasNext()) {
                        license = (License)iter.next();
                        if (!(forMouse ? license.isMouseLicense() : license.isLineLicense()) || !license.isAllowed()) continue;
                        possibleLicenses.add(license);
                    }
                }
            }
            return possibleLicenses;
        }
        return null;
    }

    public static boolean hasAllowedLicenses(String group, boolean forMouse) {
        Vector v = LicenseManager.getAllowedLicenses(group, forMouse);
        return v != null && !v.isEmpty();
    }

    private LicenseManager() {
        super(16);
    }
}

