/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.line;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.objectstore.AftermathObject;
import mausoleum.rack.frame.RackOverview;

public class LineManager
extends ObjectManager {
    public static LineManager cvInstance;
    private static final HashMap MATURITYLIMIT_BY_LINE_ID;

    static {
        MATURITYLIMIT_BY_LINE_ID = new HashMap();
    }

    public static void init() {
        if (ProcessDefinition.isClient()) {
            if (cvInstance == null) {
                cvInstance = new LineManager();
            }
            Enumeration en = cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Line line = (Line)en.nextElement();
                LineManager.enterMaturityLimit(line, MATURITYLIMIT_BY_LINE_ID, "LIN_MATLIM");
            }
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Line getLineWithUniqueID(long uniqueId, String group) {
        return (Line)cvInstance.getObjectWithUniqueLong(uniqueId, group);
    }

    public static Line getBreederLine(String group) {
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            Line line = (Line)en.nextElement();
            if (!line.isBreeder()) continue;
            return line;
        }
        return null;
    }

    public static Integer getMatlimit(Long id, String group) {
        return LineManager.getMatlimit(id, group, MATURITYLIMIT_BY_LINE_ID);
    }

    public static Integer getMatlimit(long id, String group) {
        return id > 0L ? LineManager.getMatlimit(new Long(id), group, MATURITYLIMIT_BY_LINE_ID) : null;
    }

    private LineManager() {
        super(7);
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && MausoleumClient.cvManagerInitialized && sentObjects != null && !sentObjects.isEmpty() && !MausoleumClient.isHeadOfService()) {
            long[] ids = new long[sentObjects.size()];
            int i = 0;
            while (i < sentObjects.size()) {
                Line line = (Line)sentObjects.elementAt(i);
                ids[i] = line.getID();
                LineManager.enterMaturityLimit(line, MATURITYLIMIT_BY_LINE_ID, "LIN_MATLIM");
                ++i;
            }
            Vector mice = MouseManager.getActualMiceOfLines(sentObjects);
            HashSet<Cage> hs = new HashSet<Cage>();
            int i2 = 0;
            while (i2 < mice.size()) {
                Cage c = ((Mouse)mice.elementAt(i2)).getActCage();
                if (c != null) {
                    hs.add(c);
                }
                ++i2;
            }
            Vector cageMice = new Vector();
            Iterator iterator = hs.iterator();
            while (iterator.hasNext()) {
                Cage c = (Cage)iterator.next();
                aftermathObject.addCage(c);
                c.addActualMice(cageMice);
                if (DefaultManager.getCageDisplayMode() == 0 || DefaultManager.getCageDisplayMode() == 18) {
                    boolean itsMine = c.itsMine(null);
                    c.prepareColorsForMode(DefaultManager.getCageDisplayMode(), itsMine, cageMice, null);
                }
                cageMice.clear();
            }
        }
        aftermathObject.redrawRackFrame();
        int dispMode = DefaultManager.getCageDisplayMode();
        if (dispMode == 0 || dispMode == 18) {
            RackOverview.cageColorModeChanged();
        }
    }
}

