/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class EditLocusAllelesRequester
extends BasicRequester
implements ListCellRenderer {
    private static final long serialVersionUID = -8725572587601097790L;
    private static final int BREITE = UIDef.getScaled(450);
    private static final int HOEHE = UIDef.getScaled(600);
    private JLabel ivLocusLabel = new JLabel();
    private JList ivAllelList = null;
    private JLabel ivAllelLabel = new JLabel();
    private Locus ivActualLocus = null;
    private Vector ivAlleles = new Vector();
    private Vector ivSelectedAlleles = new Vector();
    private boolean ivOnlyAdd = false;

    public static LocusAndAlleles editLocusAndAlleles(Frame sender, LocusAndAlleles locus, boolean onlyAdd, String group) {
        EditLocusAllelesRequester saar = new EditLocusAllelesRequester(sender, locus, onlyAdd, group);
        if (saar.ivWarOK && saar.ivActualLocus != null && !saar.ivSelectedAlleles.isEmpty()) {
            return new LocusAndAlleles(saar.ivActualLocus, saar.ivSelectedAlleles);
        }
        return null;
    }

    private EditLocusAllelesRequester(Frame sender, LocusAndAlleles locusAndAlleles, boolean onlyAdd, String group) {
        super(sender, BREITE, HOEHE);
        this.ivActualLocus = LocusManager.getLocus(locusAndAlleles.ivLocusID, group);
        this.ivOnlyAdd = onlyAdd;
        this.setTitle(Babel.get("EDITLOCUS"));
        int y = UIDef.RAND;
        int innerBreite = BREITE - 2 * UIDef.RAND;
        this.ivLocusLabel.setFont(FontManager.getFont("SSB14"));
        this.ivLocusLabel.setText("Locus: " + this.ivActualLocus.getString("LOC_NAME"));
        this.addAndApplyBounds(this.ivLocusLabel, UIDef.RAND, y, innerBreite, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.RAND;
        int oh = HOEHE - 4 * UIDef.RAND - UIDef.BUT_HEIGHT - UIDef.LINE_HEIGHT;
        this.ivActualLocus.addAllAlleles(this.ivAlleles, false, true);
        int i = 0;
        while (i < locusAndAlleles.ivAllele.length) {
            this.ivSelectedAlleles.addElement(locusAndAlleles.ivAllele[i]);
            ++i;
        }
        Collections.sort(this.ivSelectedAlleles);
        this.ivAllelList = new JList(this.ivAlleles);
        this.ivAllelLabel.setFont(FontManager.getFont("SSB12"));
        this.ivAllelLabel.setHorizontalTextPosition(4);
        this.ivAllelList.setCellRenderer(this);
        this.ivAllelList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                int selind = EditLocusAllelesRequester.this.ivAllelList.locationToIndex(arg0.getPoint());
                if (selind != -1) {
                    String selallel = (String)EditLocusAllelesRequester.this.ivAllelList.getModel().getElementAt(selind);
                    if (EditLocusAllelesRequester.this.ivSelectedAlleles.contains(selallel)) {
                        if (!EditLocusAllelesRequester.this.ivOnlyAdd) {
                            EditLocusAllelesRequester.this.ivSelectedAlleles.remove(selallel);
                        }
                    } else {
                        EditLocusAllelesRequester.this.ivSelectedAlleles.addElement(selallel);
                    }
                    EditLocusAllelesRequester.this.checkButton();
                    EditLocusAllelesRequester.this.repaint();
                }
            }
        });
        JPanel mp = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        mp.setOpaque(false);
        mp.add("Center", new JScrollPane(this.ivAllelList));
        BorderPanel mbp = new BorderPanel(mp, Babel.get("ALLELES"));
        this.addAndApplyBounds(mbp, UIDef.RAND, y, innerBreite, oh);
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, UIDef.RAND, HOEHE - UIDef.RAND - UIDef.BUT_HEIGHT, BREITE - 2 * UIDef.RAND, UIDef.BUT_HEIGHT);
        this.setVisible(true);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void checkButton() {
        this.ivOkButton.setEnabled(this.ivActualLocus != null && !this.ivSelectedAlleles.isEmpty());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String allel = (String)value;
        this.ivAllelLabel.setText(" " + allel + " ");
        if (this.ivSelectedAlleles.contains(allel)) {
            this.ivAllelLabel.setOpaque(true);
            this.ivAllelLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            this.ivAllelLabel.setIcon(ImageProvider.HAKEN_ICON);
        } else {
            this.ivAllelLabel.setOpaque(false);
            this.ivAllelLabel.setBackground(null);
            this.ivAllelLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
        }
        return this.ivAllelLabel;
    }
}

