/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.locus.Locus;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.TextRequester;
import mausoleum.ui.UIDef;

public class LocusAddRequester
extends BasicRequester {
    private static final long serialVersionUID = 2883912638150434445L;
    private static final int BREITE = 600;
    private static final int HOEHE = 450;
    private static final int RAND = UIDef.RAND;
    private static final int BUT_WIDTH = 150;
    private static final int BUT_HEIGHT = UIDef.BUT_HEIGHT;
    private JTextField ivNameField = new JTextField("", 5);
    private JTextField ivENSEMBLNameField = new JTextField("", 5);
    private JCheckBox ivAutosomalBox = new JCheckBox("Autosomal", true);
    private JList ivAllelesList = new JList();
    private JTextArea ivAllelDescriptionBox = new JTextArea();
    private MGButton ivAddAllelButton = MGButton.getRequesterButton(Babel.get("ADDALLEL"));
    private MGButton ivRemoveAllelButton = MGButton.getRequesterButton(Babel.get("REMOVEALLEL"));
    private MGButton ivSetWildtypButton = MGButton.getRequesterButton(Babel.get("SETWILDTYPEALLEL"));
    private JLabel ivAllelLabel = new JLabel();
    private Vector ivAlleles = new Vector();
    private Hashtable ivAllelComments = new Hashtable();
    private String ivSelectedAllel = null;
    private String ivWildtypAllel = "+";

    public static Locus getNewLocus() {
        LocusAddRequester lar = new LocusAddRequester();
        if (lar.ivWarOK) {
            Locus locus = new Locus();
            locus.set("LOC_NAME", lar.ivNameField.getText().trim());
            if (lar.ivENSEMBLNameField.getText().trim().length() != 0) {
                locus.set("LOC_ENSEMBL_NAME", lar.ivENSEMBLNameField.getText().trim());
            }
            locus.setBoolean("LOC_AUTOSOMAL", lar.ivAutosomalBox.isSelected());
            String[] alleles = new String[lar.ivAlleles.size()];
            int i = 0;
            while (i < lar.ivAlleles.size()) {
                alleles[i] = (String)lar.ivAlleles.elementAt(i);
                ++i;
            }
            locus.set("LOC_ALLELES", alleles);
            String alldesc = Locus.getAllelDescriptionString(lar.ivAllelComments, lar.ivAlleles);
            if (alldesc.length() != 0) {
                locus.set("LOC_ALLEL_DESC", alldesc);
            }
            if (lar.ivWildtypAllel != null) {
                locus.set("LOC_WT_ALLEL", lar.ivWildtypAllel);
            }
            return locus;
        }
        return null;
    }

    private LocusAddRequester() {
        super((Frame)Inspector.getInspector(), 600, 450);
        this.ivAlleles.addElement("+");
        this.ivAlleles.addElement("-");
        this.setTitle(Babel.get("NEWLOCUS"));
        int y = RAND;
        int h = 50;
        int lbr = (600 - 3 * RAND) / 2;
        int rbr = 600 - 3 * RAND - lbr;
        JPanel mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        this.ivNameField.setFont(FontManager.getFont("SSB14"));
        this.ivNameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                LocusAddRequester.this.checkOKButton();
            }
        });
        mp.add("Center", this.ivNameField);
        BorderPanel mbp = new BorderPanel(mp, Babel.get("LOCUSNAME"));
        this.addAndApplyBounds(mbp, RAND, y, lbr, h);
        this.applyBounds(this.ivOkButton, 2 * RAND + lbr, y, rbr, h);
        this.checkOKButton();
        y += h + RAND;
        mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        this.ivENSEMBLNameField.setFont(FontManager.getFont("SSB14"));
        mp.add("Center", this.ivENSEMBLNameField);
        mbp = new BorderPanel(mp, Babel.get("ENSEMBLNAME"));
        this.addAndApplyBounds(mbp, RAND, y, lbr, h);
        mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        this.ivAutosomalBox.setOpaque(false);
        mp.add("Center", this.ivAutosomalBox);
        mbp = new BorderPanel(mp, Babel.get("ATTRIBUTES"));
        this.addAndApplyBounds(mbp, 2 * RAND + lbr, y, rbr, h);
        int ty = y += h + RAND;
        this.ivAddAllelButton.setActionCommand("ADDALLEL");
        this.ivAddAllelButton.setFont(FontManager.getFont("SSB14"));
        this.ivAddAllelButton.addActionListener(this);
        this.addAndApplyBounds(this.ivAddAllelButton, RAND, ty, 150, BUT_HEIGHT);
        this.ivRemoveAllelButton.setActionCommand("REMOVEALLEL");
        this.ivRemoveAllelButton.setFont(FontManager.getFont("SSB14"));
        this.ivRemoveAllelButton.addActionListener(this);
        this.addAndApplyBounds(this.ivRemoveAllelButton, RAND, ty += BUT_HEIGHT + RAND, 150, BUT_HEIGHT);
        this.ivSetWildtypButton.setActionCommand("SETWILDTYPE");
        this.ivSetWildtypButton.setFont(FontManager.getFont("SSB14"));
        this.ivSetWildtypButton.addActionListener(this);
        this.ivSetWildtypButton.setEnabled(false);
        this.addAndApplyBounds(this.ivSetWildtypButton, RAND, ty += BUT_HEIGHT + RAND, 150, BUT_HEIGHT);
        ty += BUT_HEIGHT + RAND;
        int restbreite = 600 - 2 * RAND - 150 - RAND;
        mp = new JPanel(new BorderLayout(RAND, RAND));
        mp.setOpaque(false);
        this.alleleListChanged();
        this.ivAllelesList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value.equals(LocusAddRequester.this.ivWildtypAllel)) {
                    LocusAddRequester.this.ivAllelLabel.setText(" " + value + " [wt] ");
                } else {
                    LocusAddRequester.this.ivAllelLabel.setText(" " + value + " ");
                }
                if (isSelected) {
                    LocusAddRequester.this.ivAllelLabel.setOpaque(true);
                    LocusAddRequester.this.ivAllelLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                } else {
                    LocusAddRequester.this.ivAllelLabel.setOpaque(false);
                    LocusAddRequester.this.ivAllelLabel.setBackground(null);
                }
                return LocusAddRequester.this.ivAllelLabel;
            }
        });
        this.ivAllelesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                LocusAddRequester.this.storeOldComment();
                LocusAddRequester.this.ivSelectedAllel = (String)LocusAddRequester.this.ivAllelesList.getSelectedValue();
                if (LocusAddRequester.this.ivSelectedAllel != null) {
                    LocusAddRequester.this.ivAllelDescriptionBox.setText((String)LocusAddRequester.this.ivAllelComments.get(LocusAddRequester.this.ivSelectedAllel));
                } else {
                    LocusAddRequester.this.ivAllelDescriptionBox.setText(null);
                }
                if (LocusAddRequester.this.ivSelectedAllel != null) {
                    LocusAddRequester.this.ivAllelDescriptionBox.setEnabled(true);
                    LocusAddRequester.this.ivSetWildtypButton.setEnabled(!LocusAddRequester.this.ivSelectedAllel.equals(LocusAddRequester.this.ivWildtypAllel));
                } else {
                    LocusAddRequester.this.ivAllelDescriptionBox.setEnabled(false);
                    LocusAddRequester.this.ivSetWildtypButton.setEnabled(false);
                }
            }
        });
        this.ivAllelesList.setFont(FontManager.getFont("SSB12"));
        JScrollPane jsp = new JScrollPane(this.ivAllelesList);
        jsp.setPreferredSize(new Dimension(120, 300));
        mp.add("West", jsp);
        this.ivAllelDescriptionBox.setFont(FontManager.getFont("SSB12"));
        this.ivAllelDescriptionBox.setMargin(new Insets(4, 4, 4, 4));
        this.ivAllelDescriptionBox.setEnabled(false);
        jsp = new JScrollPane(this.ivAllelDescriptionBox);
        jsp.setPreferredSize(new Dimension(150, 300));
        mp.add("Center", jsp);
        mbp = new BorderPanel(mp, Babel.get("ALLELES"));
        this.addAndApplyBounds(mbp, 2 * RAND + 150, y, restbreite, 450 - y - RAND);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                LocusAddRequester.this.ivNameField.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public void OKPressed() {
        if (this.ivNameField.getText().trim().length() == 0) {
            Alert.showAlert(Babel.get("NAMEISMISSING"), true);
            return;
        }
        if (this.ivAlleles.isEmpty()) {
            Alert.showAlert(Babel.get("ALLELESAREMISSING"), true);
            return;
        }
        if (this.ivAlleles.contains("Y")) {
            Alert.showAlert(Babel.get("ALLELYNOTALLOWED"), true);
            return;
        }
        this.storeOldComment();
        super.OKPressed();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void alleleListChanged() {
        this.ivAllelesList.setModel(new AbstractListModel(){
            private static final long serialVersionUID = -8814077566963101200L;

            public int getSize() {
                return LocusAddRequester.this.ivAlleles.size();
            }

            public Object getElementAt(int row) {
                if (LocusAddRequester.this.ivAlleles != null && row < LocusAddRequester.this.ivAlleles.size()) {
                    return LocusAddRequester.this.ivAlleles.elementAt(row);
                }
                return null;
            }
        });
    }

    private void storeOldComment() {
        if (this.ivSelectedAllel != null) {
            String comment = this.ivAllelDescriptionBox.getText();
            if (comment.trim().length() != 0) {
                this.ivAllelComments.put(this.ivSelectedAllel, comment);
            } else {
                this.ivAllelComments.remove(this.ivSelectedAllel);
            }
        }
    }

    private void checkOKButton() {
        boolean okEnabled = true;
        if (this.ivNameField.getText().trim().length() == 0) {
            okEnabled = false;
        }
        if (this.ivAlleles.size() == 0) {
            okEnabled = false;
        }
        if (this.ivWildtypAllel == null) {
            okEnabled = false;
        }
        this.ivOkButton.setEnabled(okEnabled);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String comm = e.getActionCommand();
        if (comm.equals("ADDALLEL")) {
            String inputValue = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("ENTERALLELTOADD"));
            if (inputValue != null) {
                inputValue = inputValue.trim();
                if ((inputValue = StringHelper.gSub(inputValue, " ", "")).length() != 0) {
                    if (this.ivAlleles.contains(inputValue)) {
                        Alert.showAlert(Babel.get("ALLELALREADYPRESENT"), true);
                    } else {
                        this.ivAlleles.addElement(inputValue);
                        this.alleleListChanged();
                        this.checkOKButton();
                        this.repaint();
                    }
                }
            }
        } else if (comm.equals("REMOVEALLEL")) {
            if (this.ivSelectedAllel != null) {
                this.ivAlleles.removeElement(this.ivSelectedAllel);
                if (this.ivSelectedAllel.equals(this.ivWildtypAllel)) {
                    this.ivWildtypAllel = null;
                }
                this.checkOKButton();
                this.repaint();
            }
            this.ivSelectedAllel = null;
        } else if (comm.equals("SETWILDTYPE") && this.ivSelectedAllel != null) {
            this.ivWildtypAllel = this.ivSelectedAllel;
            this.checkOKButton();
            this.repaint();
        }
    }
}

