/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.locus.Locus;
import mausoleum.main.ProcessDefinition;

public class LocusAndAlleles
implements Externalizable {
    static final long serialVersionUID = -871764367526504937L;
    public static String NO_ALLEL = "?/?";
    private static final int VERSION = 1;
    public long ivLocusID = -1L;
    public String[] ivAllele = null;
    static /* synthetic */ Class class$0;

    public static String getTransportString(LocusAndAlleles[] array) {
        StringBuffer msb = new StringBuffer();
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    msb.append("|");
                }
                msb.append(Base64Manager.encodeBase64(array[i].getTransportString()));
                ++i;
            }
        }
        return msb.toString();
    }

    public static LocusAndAlleles[] decodeFromTransportString(String transportString) {
        if (transportString == null || transportString.length() == 0) {
            return null;
        }
        Vector v = StringHelper.splitStringByAny(transportString, "|");
        LocusAndAlleles[] erg = new LocusAndAlleles[v.size()];
        int i = 0;
        while (i < v.size()) {
            erg[i] = new LocusAndAlleles(Base64Manager.getDecodedString((String)v.elementAt(i)));
            ++i;
        }
        return erg;
    }

    public static LocusAndAlleles[] addToArray(LocusAndAlleles laa, LocusAndAlleles[] laaArray) {
        if (laa != null) {
            if (laaArray == null) {
                return new LocusAndAlleles[]{laa};
            }
            boolean schonda = false;
            int i = 0;
            while (i < laaArray.length) {
                if (laaArray[i].ivLocusID == laa.ivLocusID) {
                    schonda = true;
                }
                ++i;
            }
            if (schonda) {
                if (ProcessDefinition.isClient()) {
                    Alert.showAlert(Babel.get("LOCUSALREADYUSED"), true);
                }
                return laaArray;
            }
            LocusAndAlleles[] neuLineLoci = new LocusAndAlleles[laaArray.length + 1];
            int i2 = 0;
            while (i2 < laaArray.length) {
                neuLineLoci[i2] = laaArray[i2];
                ++i2;
            }
            neuLineLoci[neuLineLoci.length - 1] = laa;
            return neuLineLoci;
        }
        return laaArray;
    }

    public static LocusAndAlleles findElement(LocusAndAlleles laa, LocusAndAlleles[] laaArray) {
        if (laaArray == null || laa == null) {
            return null;
        }
        int i = 0;
        while (i < laaArray.length) {
            if (laaArray[i].ivLocusID == laa.ivLocusID) {
                return laaArray[i];
            }
            ++i;
        }
        return null;
    }

    public static String getGenotypeString(LocusAndAlleles[] lalArray, String group) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < lalArray.length) {
            if (i != 0) {
                msb.append(";");
            }
            if (lalArray[i] == null) {
                msb.append("?");
            } else {
                msb.append(lalArray[i].toGenotypeString(group));
            }
            ++i;
        }
        return msb.toString();
    }

    public static LocusAndAlleles findLocusAndAlleles(LocusAndAlleles[] lalArray, long locusID) {
        if (lalArray != null) {
            int i = 0;
            while (i < lalArray.length) {
                if (lalArray[i].ivLocusID == locusID) {
                    return lalArray[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean mustIInvertAlleles(String a1, String a2, Locus locus) {
        int i1;
        if (a1.equals("+")) {
            return true;
        }
        if (a1.equals("-") && !a2.equals("+")) {
            return true;
        }
        if (a1.equals("?") && !a2.equals("-") && !a2.equals("+")) {
            return true;
        }
        int i0 = locus.getIndexOfAllel(a1, Integer.MAX_VALUE);
        return i0 > (i1 = locus.getIndexOfAllel(a2, Integer.MAX_VALUE));
    }

    public static LocusAndAlleles[] createCopy(LocusAndAlleles[] orig) {
        if (orig != null) {
            LocusAndAlleles[] erg = new LocusAndAlleles[orig.length];
            int i = 0;
            while (i < orig.length) {
                erg[i] = new LocusAndAlleles(orig[i].ivLocusID, orig[i].ivAllele);
                ++i;
            }
            return erg;
        }
        return null;
    }

    public static String toString(LocusAndAlleles[] orig) {
        StringBuilder msb = new StringBuilder();
        msb.append("[");
        if (orig != null) {
            int i = 0;
            while (i < orig.length) {
                if (i != 0) {
                    msb.append(", ");
                }
                msb.append(orig[i].toString());
                ++i;
            }
        }
        msb.append("]");
        return msb.toString();
    }

    public LocusAndAlleles() {
    }

    public LocusAndAlleles(long locusID) {
        this.ivLocusID = locusID;
    }

    public LocusAndAlleles(long locusID, String allel1) {
        this(locusID, new String[]{allel1});
    }

    public LocusAndAlleles(long locusID, String allel1, String allel2) {
        this(locusID, new String[]{allel1, allel2});
    }

    public LocusAndAlleles(Locus locus, Vector alleles) {
        this.ivLocusID = locus.getID();
        this.ivAllele = new String[alleles.size()];
        int i = 0;
        while (i < alleles.size()) {
            this.ivAllele[i] = (String)alleles.elementAt(i);
            ++i;
        }
    }

    public LocusAndAlleles(long locusID, String[] allele) {
        int i;
        this.ivLocusID = locusID;
        Vector<String> v = new Vector<String>();
        if (allele != null) {
            i = 0;
            while (i < allele.length) {
                if (allele[i] != null) {
                    v.addElement(allele[i]);
                }
                ++i;
            }
        }
        if (!v.isEmpty()) {
            this.ivAllele = new String[v.size()];
            i = 0;
            while (i < v.size()) {
                this.ivAllele[i] = (String)v.elementAt(i);
                ++i;
            }
        }
    }

    public LocusAndAlleles(String transportString) {
        if (transportString != null && transportString.length() != 0) {
            Vector v = StringHelper.splitStringByAny(transportString, "|");
            try {
                this.ivLocusID = Long.parseLong((String)v.elementAt(0));
                v.removeElementAt(0);
                if (!v.isEmpty()) {
                    this.ivAllele = new String[v.size()];
                    int i = 0;
                    while (i < v.size()) {
                        this.ivAllele[i] = Base64Manager.getDecodedString((String)v.elementAt(i));
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                String string = "Problem bei Konstruktor LocusAndAlleles: TransportString: " + transportString;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.locus.LocusAndAlleles");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
    }

    public static String getLocusName(String group, long locusID) {
        Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, locusID, group, null, false);
        if (locus != null) {
            return locus.getName();
        }
        return "?";
    }

    public String getAlleleString(String group) {
        Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, this.ivLocusID, group, null, false);
        return this.getAlleleString(locus);
    }

    public String getAlleleString(Locus locus) {
        return LocusAndAlleles.getAlleleString(locus, this.ivAllele);
    }

    public static String getAlleleString(Locus locus, String[] allele) {
        StringBuffer msb = new StringBuffer();
        if (allele != null) {
            if (allele.length == 1) {
                msb.append(locus.getAlias(allele[0]));
            } else if (allele.length == 2 && locus != null) {
                String a0 = allele[0];
                String a1 = allele[1];
                if (LocusAndAlleles.mustIInvertAlleles(a0, a1, locus)) {
                    msb.append(locus.getAlias(a1)).append("/").append(locus.getAlias(a0));
                } else {
                    msb.append(locus.getAlias(a0)).append("/").append(locus.getAlias(a1));
                }
            } else {
                int i = 0;
                while (i < allele.length) {
                    if (i != 0) {
                        msb.append("/");
                    }
                    msb.append(locus.getAlias(allele[i]));
                    ++i;
                }
            }
        } else {
            msb.append(NO_ALLEL);
        }
        return msb.toString();
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("{Locus ID:").append(this.ivLocusID).append(" Alleles:[");
        if (this.ivAllele != null && this.ivAllele.length != 0) {
            int i = 0;
            while (i < this.ivAllele.length) {
                if (i != 0) {
                    msb.append(", ");
                }
                msb.append(this.ivAllele[i]);
                ++i;
            }
        }
        msb.append("]}");
        return msb.toString();
    }

    public String toGenotypeString(String group) {
        StringBuffer msb = new StringBuffer();
        msb.append(LocusAndAlleles.getLocusName(group, this.ivLocusID));
        msb.append(this.getAlleleString(group));
        return msb.toString();
    }

    public String toGenotypeStringMultiFont(String group) {
        StringBuffer msb = new StringBuffer("<html><i>");
        msb.append(LocusAndAlleles.getLocusName(group, this.ivLocusID)).append("</i> <b>");
        msb.append(this.getAlleleString(group)).append("</b></html>");
        return msb.toString();
    }

    public String getTransportString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.ivLocusID);
        if (this.ivAllele != null) {
            int i = 0;
            while (i < this.ivAllele.length) {
                msb.append("|").append(Base64Manager.encodeBase64(this.ivAllele[i]));
                ++i;
            }
        }
        return msb.toString();
    }

    public boolean isAllelContained(String allel) {
        if (this.ivAllele != null) {
            int i = 0;
            while (i < this.ivAllele.length) {
                if (this.ivAllele[i].equals(allel)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void addAllel(String allel) {
        if (this.ivAllele == null) {
            this.ivAllele = new String[1];
            this.ivAllele[0] = allel;
        } else {
            String[] neu = new String[this.ivAllele.length + 1];
            int i = 0;
            while (i < this.ivAllele.length) {
                neu[i] = this.ivAllele[i];
                ++i;
            }
            neu[neu.length - 1] = allel;
            this.ivAllele = neu;
        }
    }

    public void removeAllel(String allel) {
        if (this.ivAllele != null) {
            if (this.ivAllele.length == 1) {
                this.ivAllele = null;
            } else {
                int col = 0;
                String[] neu = new String[this.ivAllele.length - 1];
                int i = 0;
                while (i < this.ivAllele.length) {
                    if (!this.ivAllele[i].equals(allel) && col != neu.length) {
                        neu[col++] = this.ivAllele[i];
                    }
                    ++i;
                }
                this.ivAllele = neu;
            }
        }
    }

    public boolean isHomozygous() {
        if (this.ivAllele != null) {
            if (this.ivAllele.length == 1) {
                return true;
            }
            if (this.ivAllele.length == 2) {
                return this.ivAllele[0].equals(this.ivAllele[1]);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LocusAndAlleles) {
            LocusAndAlleles l = (LocusAndAlleles)obj;
            if (this.ivLocusID != l.ivLocusID) {
                return false;
            }
            return LocusAndAlleles.compareObjectArrays(this.ivAllele, l.ivAllele);
        }
        return false;
    }

    private static boolean compareObjectArrays(Object[] arr1, Object[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null) {
            return arr2.length == 0;
        }
        if (arr2 == null) {
            return arr1.length == 0;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (!arr1[i].equals(arr2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeLong(this.ivLocusID);
        out.writeObject(this.ivAllele);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int server = in.readInt();
        if (server == 1) {
            this.ivLocusID = in.readLong();
            this.ivAllele = (String[])in.readObject();
        }
    }
}

