/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mail;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.exceptions.NoGroupsException;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.mail.Mail;
import mausoleum.mail.RecipientRequester;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class NewMailRequester
extends BasicRequester
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = 400;
    private static final int HOEHE = 500;
    private static final int RAND = UIDef.INNER_RAND;
    private static final int ADDRESSHEIGHT = 90;
    private static final int IWIDTH = 400 - 2 * RAND;
    private static final int IV = 4;
    private static final int BUTH = 40;
    private static final int BUTY = 460 - RAND;
    private static final int BUTOBR = (IWIDTH - 4) / 2;
    private static final int BUTCBR = IWIDTH - 4 - BUTOBR;
    private static final int BUTCX = RAND + BUTOBR + 4;
    private static final int CBH = 24;
    private static final int CBY = BUTY - 4 - 24;
    private static final int LABH = 24;
    private static final int LABY = BUTY - 4 - 24 - 4 - 24;
    private static final int TEXTH = 500 - 2 * RAND - 20 - 24 - 24 - 90 - 40;
    private static final int SUBJY = RAND + 90 + 4;
    private static final int TEXTY = SUBJY + 24 + 4;
    private static final int TEXTH_WO_ADRESSES = 500 - 2 * RAND - 16 - 24 - 24 - 40;
    private static final int SUBJY_WO_ADRESSES = RAND;
    private static final int TEXTY_WO_ADRESSES = SUBJY_WO_ADRESSES + 24 + 4;
    private JTextPane ivBodyArea = new JTextPane();
    private JTextField ivSubject = new JTextField("");
    private JCheckBox ivWantReceipt = new JCheckBox("", false);
    private JList ivAddressList = null;
    private JScrollPane ivAddressPane = null;
    public MGButton ivAddRecipient = null;
    public MGButton ivRemRecipient = null;
    private String ivAttachMessage = null;
    private String ivAttachment = null;
    private boolean ivBriefVersendet = false;
    private final boolean ivForExport;
    private boolean ivForReply = false;
    private final boolean ivForMouseOwnerMail;
    private final boolean ivNeedsAdresses;
    private final Vector ivRecInfos = new Vector();
    private JLabel ivAddressLabel = new JLabel();
    private Mail ivModelMail = null;
    private CaretListener ivCaretListener = new CaretListener(){

        public void caretUpdate(CaretEvent arg0) {
            NewMailRequester.this.checkButtons();
        }
    };

    public static void createNewMail() {
        try {
            NewMailRequester nmr = new NewMailRequester(Inspector.getInspector(), null, false, null, null, null, false, false);
            nmr.setVisible(true);
        }
        catch (NoGroupsException e) {
            Alert.showAlert(Babel.get("NO_GROUPS_AVAILABLE"), true);
        }
        catch (Exception e) {
            Alert.showAlert(Babel.get("MAIL_NOT_SENT"), true);
        }
    }

    public static void createReply(Mail orig) {
        if (orig != null) {
            try {
                NewMailRequester nmr = new NewMailRequester(Inspector.getInspector(), null, false, orig.getString("MAI_SENDER"), orig.getString("MAI_SGROUP"), (Long)orig.get("MAI_SENDER_ID"), false, false);
                nmr.ivSubject.setText("Re: " + orig.getString("MAI_SUBJECT"));
                String origText = orig.getString("MAI_TEXT");
                if (origText.toLowerCase().trim().startsWith("<html>")) {
                    origText.trim();
                    nmr.ivBodyArea.setContentType("text/html");
                    nmr.ivBodyArea.setText("<html><br><br>Transcript of original message below<br><br>===================================<br><br>" + origText.substring(6, origText.length()));
                } else {
                    nmr.ivBodyArea.setContentType("text/plain");
                    nmr.ivBodyArea.setText("\n\nTranscript of original message below\n\n===================================\n\n" + origText);
                }
                nmr.setVisible(true);
            }
            catch (NoGroupsException e) {
                Alert.showAlert(Babel.get("NO_GROUPS_AVAILABLE"), true);
            }
            catch (Exception e) {
                Alert.showAlert(Babel.get("MAIL_NOT_SENT"), true);
            }
        }
    }

    public static String createExportMailAndGetTargetGroup(String attachMessage, String attachment, String defGroupReturnVal) {
        try {
            NewMailRequester nmr = new NewMailRequester(Inspector.getInspector(), attachMessage, true, null, null, null, true, false);
            nmr.ivAttachMessage = attachMessage;
            nmr.ivAttachment = attachment;
            nmr.setVisible(true);
            if (nmr.ivWarOK) {
                if (nmr.ivBriefVersendet) {
                    if (nmr.ivRecInfos != null && nmr.ivRecInfos.size() == 1) {
                        RecipientRequester.RecInfo recInfo = (RecipientRequester.RecInfo)nmr.ivRecInfos.firstElement();
                        return recInfo.ivGroup;
                    }
                    return defGroupReturnVal;
                }
                Alert.showAlert(Babel.get("ALERTEXPORTFAILED"), true);
            }
        }
        catch (NoGroupsException e) {
            Alert.showAlert(Babel.get("NO_GROUPS_AVAILABLE"), true);
        }
        catch (Exception e) {
            Alert.showAlert(Babel.get("ALERTEXPORTFAILED"), true);
        }
        return null;
    }

    public static boolean createNonMouseExportMail(Frame sender, String attachMessage, String attachment) {
        try {
            NewMailRequester nmr = new NewMailRequester(sender, attachMessage, true, null, null, null, false, false);
            nmr.ivAttachMessage = attachMessage;
            nmr.ivAttachment = attachment;
            nmr.setVisible(true);
            if (nmr.ivWarOK && nmr.ivBriefVersendet) {
                return true;
            }
        }
        catch (NoGroupsException e) {
            Alert.showAlert(Babel.get("NO_GROUPS_AVAILABLE"), true);
        }
        catch (Exception e) {
            Alert.showAlert(Babel.get("ALERTEXPORTFAILED"), true);
        }
        return false;
    }

    public static Mail createMouseOwnerMail(Vector mice) {
        try {
            NewMailRequester nmr = new NewMailRequester(Inspector.getInspector(), null, true, null, null, null, false, true);
            nmr.setVisible(true);
            return nmr.ivWarOK ? nmr.ivModelMail : null;
        }
        catch (Exception e) {
            Alert.showAlert(Babel.get("MAIL_NOT_SENT"), true);
            return null;
        }
    }

    private NewMailRequester(Frame sender, String attachMessage, boolean modal, String receiver, String receiverGroup, Long receiverID, boolean istFuerExport, boolean forMouseOwnerMail) throws NoGroupsException {
        super(sender, 400, 500);
        this.ivForExport = istFuerExport;
        this.ivForMouseOwnerMail = forMouseOwnerMail;
        this.ivNeedsAdresses = !forMouseOwnerMail;
        this.setModal(modal);
        attachMessage = attachMessage == null ? "NO ATTACHMENT" : StringHelper.gSub(attachMessage, "_", " ");
        JTextField tf = new JTextField(attachMessage);
        tf.setEnabled(false);
        tf.setEditable(false);
        tf.setBackground(Color.lightGray);
        tf.setForeground(Color.black);
        tf.setFont(FontManager.getFont("SSB14"));
        tf.setOpaque(false);
        this.ivSubject.setFont(FontManager.getFont("SSB14"));
        this.ivSubject.addCaretListener(this.ivCaretListener);
        this.ivWantReceipt.setOpaque(false);
        this.ivBodyArea.setFont(FontManager.getFont("SSB12"));
        this.ivBodyArea.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
        this.ivBodyArea.addCaretListener(this.ivCaretListener);
        JScrollPane jsp = new JScrollPane(this.ivBodyArea);
        int textYPos = this.ivNeedsAdresses ? TEXTY : TEXTY_WO_ADRESSES;
        int textHeight = this.ivNeedsAdresses ? TEXTH : TEXTH_WO_ADRESSES;
        int subjectYPos = this.ivNeedsAdresses ? SUBJY : SUBJY_WO_ADRESSES;
        this.addAndApplyBounds(jsp, RAND, textYPos, IWIDTH, textHeight);
        this.addAndApplyBounds(this.ivWantReceipt, RAND, CBY, 15, 15);
        this.addAndApplyBounds(tf, RAND, LABY, IWIDTH, 24);
        this.addAndApplyBounds(this.ivSubject, RAND + 60, subjectYPos, IWIDTH - 60, 24);
        this.applyBounds(this.ivOkButton, RAND, BUTY, BUTOBR, 40);
        this.applyBounds(this.ivNoButton, BUTCX, BUTY, BUTCBR, 40);
        this.addPermanentLabel(Babel.get("WANTRECEIPT"), RAND + 20, CBY, 15);
        this.addPermanentLabel(Babel.get("SUBJECT"), RAND, subjectYPos, 24);
        if (this.ivNeedsAdresses) {
            this.ivAddressList = new JList();
            this.ivAddressPane = new JScrollPane(this.ivAddressList);
            this.ivAddRecipient = new MGButton(Babel.get("ADD_RECIPIENT"), "ADDREC");
            this.ivRemRecipient = new MGButton(Babel.get("REMOVE_RECIPIENT"), "REMREC");
            if (receiver != null && receiverGroup != null && receiverID != null) {
                this.ivRecInfos.add(new RecipientRequester.RecInfo(receiverGroup, receiver, receiverID, false));
                this.ivAddressList.setListData(this.ivRecInfos);
                this.ivAddressList.setEnabled(false);
                this.ivForReply = true;
            }
            JPanel pan = new JPanel(new SimpleLayoutManager(){

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int bh = 20;
                    int by = d.height - bh;
                    int oh = d.height - bh;
                    int lw = d.width / 2;
                    int rw = d.width - lw;
                    NewMailRequester.this.ivAddressPane.setBounds(0, 0, d.width, oh);
                    NewMailRequester.this.ivAddRecipient.setBounds(0, by, lw, bh);
                    NewMailRequester.this.ivRemRecipient.setBounds(lw, by, rw, bh);
                }
            });
            pan.add(this.ivAddressPane);
            pan.add(this.ivAddRecipient);
            pan.add(this.ivRemRecipient);
            pan.setOpaque(false);
            this.addAndApplyBounds(new BorderPanel(pan, Babel.get("RECIPIENTS")), RAND, RAND, IWIDTH, 90);
            this.ivAddressLabel.setFont(FontManager.getFont("SSB11"));
            this.ivAddressLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            this.ivAddressList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    RecipientRequester.RecInfo recInfo = (RecipientRequester.RecInfo)value;
                    NewMailRequester.this.ivAddressLabel.setText(" " + recInfo.ivName + "@" + recInfo.ivGroup + " ");
                    NewMailRequester.this.ivAddressLabel.setOpaque(isSelected);
                    return NewMailRequester.this.ivAddressLabel;
                }
            });
            this.ivAddRecipient.setFont(FontManager.getFont("SSB11"));
            this.ivRemRecipient.setFont(FontManager.getFont("SSB11"));
            this.ivAddRecipient.addActionListener(this);
            this.ivRemRecipient.addActionListener(this);
            this.ivAddressList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent arg0) {
                    NewMailRequester.this.checkButtons();
                }
            });
        }
        this.checkButtons();
    }

    private void checkButtons() {
        boolean enabled = false;
        if (this.ivNeedsAdresses) {
            if (!this.ivRecInfos.isEmpty()) {
                if (this.ivForExport) {
                    if (this.ivRecInfos.size() == 1) {
                        RecipientRequester.RecInfo recInfo = (RecipientRequester.RecInfo)this.ivRecInfos.firstElement();
                        if (!recInfo.ivGroup.equals(UserManager.getFirstGroup())) {
                            enabled = true;
                        }
                    }
                } else {
                    enabled = true;
                }
            }
        } else {
            enabled = true;
        }
        if (enabled && this.ivBodyArea.getText().trim().length() == 0) {
            enabled = false;
        }
        this.ivOkButton.setEnabled(enabled);
        if (this.ivAddRecipient != null) {
            enabled = false;
            if (!this.ivForReply) {
                enabled = this.ivForExport ? this.ivRecInfos.isEmpty() : true;
            }
            this.ivAddRecipient.setEnabled(enabled);
        }
        if (this.ivRemRecipient != null) {
            enabled = false;
            if (!this.ivForReply && this.ivAddressList.getSelectedIndex() != -1) {
                enabled = true;
            }
            this.ivRemRecipient.setEnabled(enabled);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        if (e.getActionCommand().equals("OK")) {
            if (this.ivForMouseOwnerMail) {
                this.ivModelMail = this.makeBriefOhneCheck(null, null, null);
                this.ivModelMail.set("MAI_ATTINFO", this.ivAttachMessage);
                this.ivModelMail.set("MAI_ATTACHMENT", this.ivAttachment);
                this.ivWarOK = true;
            } else {
                RecipientRequester.RecInfo recInfo;
                if (this.ivRecInfos.isEmpty()) {
                    Alert.showAlert(Babel.get("ALERTENTERRECIP"), true);
                    return;
                }
                Iterator iter = this.ivRecInfos.iterator();
                while (iter.hasNext()) {
                    recInfo = (RecipientRequester.RecInfo)iter.next();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)11, recInfo.ivName, null, recInfo.ivGroup);
                    this.setCursor(Cursor.getDefaultCursor());
                    if (!mor.isDenied()) continue;
                    this.repaint();
                    Alert.showAlert(Babel.get("ALERTRECIPUNKNOWN"), true);
                    return;
                }
                this.ivWarOK = true;
                iter = this.ivRecInfos.iterator();
                while (iter.hasNext()) {
                    recInfo = (RecipientRequester.RecInfo)iter.next();
                    Mail brief = this.makeBrief(recInfo.ivName, recInfo.ivGroup, recInfo.ivID);
                    if (brief == null) continue;
                    this.ivBriefVersendet = brief.versendeDich(UserManager.getFirstGroup());
                }
            }
            this.dispose();
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.ivWarOK = false;
            this.dispose();
        } else if (e.getActionCommand().equals("ADDREC")) {
            try {
                RecipientRequester.RecInfo recInfo;
                RecipientRequester rr = new RecipientRequester(this, this.ivForExport);
                if (rr.ivWarOK && (recInfo = rr.getAddress()) != null) {
                    Iterator iter = this.ivRecInfos.iterator();
                    while (iter.hasNext()) {
                        if (!recInfo.equals((RecipientRequester.RecInfo)iter.next())) continue;
                        return;
                    }
                    this.ivRecInfos.add(recInfo);
                    this.setListData();
                }
            }
            catch (NoGroupsException nge) {
                Alert.showAlert(Babel.get("NO_GROUPS_AVAILABLE"), true);
            }
        } else if (e.getActionCommand().equals("REMREC") && (ind = this.ivAddressList.getSelectedIndex()) != -1) {
            this.ivRecInfos.removeElementAt(ind);
            this.setListData();
        }
    }

    private void setListData() {
        this.ivAddressList.setListData(this.ivRecInfos);
        this.ivAddressList.repaint();
        this.checkButtons();
    }

    private Mail makeBrief(String receiver, String receiverGroup, Long receiverID) {
        Mail brief = null;
        if (receiver != null && receiverGroup != null) {
            receiver = receiver.trim();
            receiverGroup = receiverGroup.trim();
            if (receiver.length() != 0 && receiverGroup.length() != 0) {
                brief = this.makeBriefOhneCheck(receiver, receiverGroup, receiverID);
            }
        }
        return brief;
    }

    private Mail makeBriefOhneCheck(String receiver, String receiverGroup, Long receiverID) {
        Mail brief = Mail.getMailFromMeTo(receiver, receiverGroup, receiverID);
        String subject = this.ivSubject.getText();
        if (subject == null || subject.length() == 0) {
            subject = "no subject";
        }
        brief.set("MAI_SUBJECT", subject);
        String body = this.ivBodyArea.getText();
        if (body.toLowerCase().trim().startsWith("<html>")) {
            int ind2;
            int ind1 = (body = body.trim()).indexOf("<head>");
            if (ind1 != -1 && (ind2 = body.indexOf("</head>")) != -1 && ind2 > ind1) {
                body = String.valueOf(body.substring(0, ind1)) + body.substring(ind2 + 7, body.length());
            }
            body = StringHelper.gSub(body, "\n", "");
        }
        brief.set("MAI_TEXT", body);
        brief.set("MAI_ATTINFO", this.ivAttachMessage);
        brief.set("MAI_ATTACHMENT", this.ivAttachment);
        brief.setBoolean("MAI_WANTSREC", this.ivWantReceipt.isSelected());
        return brief;
    }
}

