/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.main;

import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.tools.FileManager;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumServer;
import mausoleum.util.InstallationType;

public abstract class StatusHTMLWriter {
    private static final String DIRNAME = "HTML";
    private static final String LOGO_GIF_NAME = InstallationType.isFish() ? "HTMLOGOF.GIF" : "HTMLOGO.GIF";
    private static boolean cvStarted = false;

    public static void start() {
        if (!cvStarted) {
            cvStarted = true;
            FileManager.prepareDirs(DIRNAME);
            StatusHTMLWriter.doIt();
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        StatusHTMLWriter.doIt();
                    }
                }
            }).start();
        }
    }

    private static void doIt() {
        try {
            StatusHTMLWriter.ensurePresenceOfGIF("HTMLBACK.GIF");
            StatusHTMLWriter.ensurePresenceOfGIF(LOGO_GIF_NAME);
            FileWriter out = new FileWriter("HTML/status.html");
            out.write("<html>\n");
            out.write("<head>\n");
            if (InstallationType.isFish()) {
                out.write("<title>Fisholeum Server Status</title>\n");
            } else if (InstallationType.isMouse()) {
                out.write("<title>Mausoleum Server Status</title>\n");
            }
            out.write("<META HTTP-EQUIV=Refresh CONTENT=\"30\"\n");
            out.write("</head>\n");
            out.write("<body background=\"HTMLBACK.GIF\">\n");
            out.write("<h1><img border=\"0\" src=\"" + LOGO_GIF_NAME + "\" width=\"275\" height=\"115\"></h1>\n");
            out.write("<hr>\n");
            if (MausoleumServer.isInitialized()) {
                out.write("<h2>Server (" + DefaultManager.getLongServerVersionInfo() + ") Status: READY</h2>\n");
                out.write("<table border=\"1\" width=\"100%\" bordercolorlight=\"#FFFFFF\" bordercolordark=\"#000000\">\n");
                out.write("  <tr>\n");
                out.write("    <td width=\"20%\"><h3 align=\"center\"><b>User</b></h3></td>\n");
                out.write("    <td width=\"20%\"><h3 align=\"center\"><b>Group</b></h3></td>\n");
                out.write("    <td width=\"20%\"><h3 align=\"center\"><b>Address</b></h3></td>\n");
                out.write("    <td width=\"20%\"><h3 align=\"center\"><b>Status</b></h3></td>\n");
                out.write("    <td width=\"20%\"><h3 align=\"center\"><b>Commands</b></h3></td>\n");
                out.write("  </tr>\n");
                Enumeration en = ServerPortal.getCommunicators();
                while (en.hasMoreElements()) {
                    ServerCommunicator sc = (ServerCommunicator)en.nextElement();
                    out.write("  <tr>\n");
                    String s = sc.getUserName();
                    if (s == null) {
                        s = "unknown";
                    }
                    out.write("    <td width=\"20%\">" + s + "</td>\n");
                    s = sc.getGroupName();
                    if (s == null) {
                        s = "unknown";
                    }
                    out.write("    <td width=\"20%\">" + s + "</td>\n");
                    s = sc.getNetAddress();
                    if (s == null) {
                        s = "unknown";
                    }
                    out.write("    <td width=\"20%\">" + s + "</td>\n");
                    out.write("    <td width=\"20%\">" + sc.getStatusString() + "</td>\n");
                    out.write("    <td width=\"20%\">" + sc.getNumCommands() + "</td>\n");
                    out.write("  </tr>\n");
                }
            } else {
                out.write("<h2>Server Status: INITIALIZING</h2>\n");
            }
            out.write("</table>\n");
            out.write("</body>\n");
            out.write("</html>\n");
            out.flush();
            out.close();
        }
        catch (Exception exc) {
            System.out.println("HTML-MURKS " + exc);
        }
    }

    private static void ensurePresenceOfGIF(String in) {
        byte[] arr;
        File f = new File("HTML/" + in);
        if (!f.exists() && (arr = FileManager.getBytesFromFile("images/" + in)) != null) {
            FileManager.saveBytesToFile("HTML/" + in, arr);
        }
    }
}

