/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.main;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.main.TaskCounterTable;
import mausoleum.task.TaskCounter;
import mausoleum.ui.UIDef;

public class TaskCounterDialog
extends JDialog {
    private static final long serialVersionUID = 45434L;
    private static final int TABLE_WIDTH = UIDef.getScaled(600);
    private static final int TABLE_HEIGHT = UIDef.getScaled(300);
    private static final int BREITE = UIDef.RAND + TABLE_WIDTH + UIDef.RAND;
    private static final int HOEHE = UIDef.RAND + UIDef.LINE_HEIGHT + UIDef.INNER_RAND + TABLE_HEIGHT + UIDef.INNER_RAND + UIDef.BUT_HEIGHT + UIDef.RAND;
    private static final int[] MODE_INTS;
    private static final String[] MODE_STRINGS;
    private static final String ALL;
    private static final String OTHER;
    private TaskCounterTable ivTable = new TaskCounterTable();
    private MGButton ivOKButton = new MGButton(Babel.get("YES"));
    private TaskCounter ivSelectedTaskCounter = null;
    private Vector ivTaskTypeMarks = null;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        MODE_INTS = nArray;
        MODE_STRINGS = new String[]{Babel.get("TASKS"), Babel.get("TASKMICE"), Babel.get("TASKCAGES")};
        ALL = Babel.get("ALL");
        OTHER = Babel.get("TASK_STD_OTHER");
    }

    public static TaskCounter selectRoom(Frame sender, HashMap taskcounters) {
        if (taskcounters != null && !taskcounters.isEmpty()) {
            long[] restictedServiceRoomIds = (long[])UserManager.getUser().get("USR_R_ROOMS");
            Vector<TaskCounter> v = new Vector<TaskCounter>(taskcounters.size());
            Iterator iterator = taskcounters.values().iterator();
            while (iterator.hasNext()) {
                TaskCounter tc = (TaskCounter)iterator.next();
                if (restictedServiceRoomIds != null && ArrayHelper.findLongInArray(tc.ivRoomServiceID, restictedServiceRoomIds) == -1) continue;
                v.add(tc);
            }
            if (v.isEmpty()) {
                return null;
            }
            if (v.size() == 1) {
                return (TaskCounter)v.firstElement();
            }
            Collections.sort(v);
            TaskCounterDialog tcd = new TaskCounterDialog(sender, v);
            return tcd.ivSelectedTaskCounter;
        }
        return null;
    }

    private TaskCounterDialog(Frame sender, Vector taskcounters) {
        super(sender, true);
        String s;
        this.setResizable(false);
        this.setContentPane(new RequesterPane(new NULLLayoutManager(BREITE, HOEHE)));
        this.setTitle(Babel.get("SELECT_ROOM"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.getContentPane().setLayout(null);
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        TreeSet taskTypeTS = new TreeSet();
        Iterator iterator = taskcounters.iterator();
        while (iterator.hasNext()) {
            TaskCounter tc = (TaskCounter)iterator.next();
            tc.addTaskTypes(taskTypeTS);
        }
        Vector<String> taskTypes = new Vector<String>(taskTypeTS.size() + 2);
        this.ivTaskTypeMarks = new Vector(taskTypeTS.size() + 2);
        taskTypes.add(ALL);
        this.ivTaskTypeMarks.add("#*?ALL");
        Iterator iterator2 = taskTypeTS.iterator();
        while (iterator2.hasNext()) {
            s = (String)iterator2.next();
            if (!s.startsWith("[M] ")) continue;
            taskTypes.add(s);
            this.ivTaskTypeMarks.add(s);
        }
        iterator2 = taskTypeTS.iterator();
        while (iterator2.hasNext()) {
            s = (String)iterator2.next();
            if (!s.startsWith("[S] ")) continue;
            taskTypes.add(s);
            this.ivTaskTypeMarks.add(s);
        }
        iterator2 = taskTypeTS.iterator();
        while (iterator2.hasNext()) {
            s = (String)iterator2.next();
            if (!s.startsWith("[G] ")) continue;
            taskTypes.add(s);
            this.ivTaskTypeMarks.add(s);
        }
        taskTypes.add(OTHER);
        this.ivTaskTypeMarks.add("#*?OTHERS");
        JComboBox<String> modeCombo = new JComboBox<String>(MODE_STRINGS);
        JComboBox taskTypeCombo = new JComboBox(taskTypes);
        int z1iw = TABLE_WIDTH - UIDef.INNER_RAND;
        int combo1Width = taskTypeCombo.getPreferredSize().width;
        int combo2Width = modeCombo.getPreferredSize().width;
        if (combo1Width < z1iw / 2) {
            combo2Width = combo1Width = z1iw / 2;
        } else {
            combo1Width = z1iw - combo2Width;
        }
        taskTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                ((TaskCounterDialog)TaskCounterDialog.this).ivTable.ivTaskDescr = (String)TaskCounterDialog.this.ivTaskTypeMarks.elementAt(combo.getSelectedIndex());
                TaskCounterDialog.this.ivTable.repaint();
            }
        });
        taskTypeCombo.setBounds(x, y, combo1Width, UIDef.LINE_HEIGHT);
        this.getContentPane().add(taskTypeCombo);
        modeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                ((TaskCounterDialog)TaskCounterDialog.this).ivTable.ivMode = MODE_INTS[combo.getSelectedIndex()];
                TaskCounterDialog.this.ivTable.repaint();
            }
        });
        modeCombo.setBounds(x += combo1Width + UIDef.INNER_RAND, y, combo2Width, UIDef.LINE_HEIGHT);
        this.getContentPane().add(modeCombo);
        x = UIDef.RAND;
        this.ivTable.setObjects(taskcounters);
        this.ivTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                TaskCounterDialog.this.ivOKButton.setEnabled(TaskCounterDialog.this.ivTable.getSelectedRow() != -1);
            }
        });
        this.ivTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TaskCounterDialog.this.ivOKButton.isEnabled()) {
                    TaskCounterDialog.this.okPressed();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.ivTable);
        scrollPane.setBounds(x, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, TABLE_WIDTH, TABLE_HEIGHT);
        this.getContentPane().add(scrollPane);
        int lbw = (TABLE_WIDTH - UIDef.INNER_RAND) / 2;
        int rbw = TABLE_WIDTH - UIDef.INNER_RAND - lbw;
        this.ivOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskCounterDialog.this.okPressed();
            }
        });
        this.ivOKButton.setEnabled(false);
        this.ivOKButton.setBounds(x, y += TABLE_HEIGHT + UIDef.INNER_RAND, lbw, UIDef.BUT_HEIGHT);
        this.getContentPane().add(this.ivOKButton);
        MGButton cancelButton = new MGButton(Babel.get("NO"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskCounterDialog.this.leave(null);
            }
        });
        cancelButton.setBounds(x += lbw + UIDef.INNER_RAND, y, rbw, UIDef.BUT_HEIGHT);
        this.getContentPane().add(cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TaskCounterDialog.this.leave(null);
            }
        });
        WindowUtils.bringUpCenteredDialog(this, BREITE, HOEHE, true);
    }

    public void dispose() {
        this.ivTaskTypeMarks.clear();
        this.ivTaskTypeMarks = null;
        this.ivTable.dispose();
        super.dispose();
    }

    private void okPressed() {
        this.leave((TaskCounter)this.ivTable.getObjectAtRow(this.ivTable.getSelectedRow()));
    }

    private void leave(TaskCounter res) {
        this.ivSelectedTaskCounter = res;
        this.dispose();
    }
}

