/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.main;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import mausoleum.cage.colors.TaskColor;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.task.TaskCounter;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.ui.table.TableSortable;

public class TaskCounterTable
extends SortableTable
implements TableCellRenderer {
    private static final long serialVersionUID = 1789416513L;
    private static int COL_ROOM_NAME = 0;
    private static int COL_FUTURE = 5;
    private static final String[] COLS = new String[]{Babel.get("TCT_ROOM"), Babel.get("TCT_OVER_DUE"), Babel.get("TCT_TODAY"), Babel.get("TCT_DAY_1_2"), Babel.get("TCT_DAY_3_5"), Babel.get("TCT_FUTURE")};
    private static final int[] WIDTHS = new int[]{150, 70, 70, 70, 70, 70};
    private static final int[] TERMIN_TYPES;
    public MGButton ivColHeaderLabel = new MGButton();
    public JLabel ivListLabel = new JLabel("QyAq");
    public int ivMode = 0;
    public String ivTaskDescr = "#*?ALL";
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        TERMIN_TYPES = nArray;
    }

    public TaskCounterTable() {
        this.ivListLabel.setBackground(UIDef.NEW_BACKGROUND);
        this.setObjects(new Vector());
        this.ivColHeaderLabel.setFont(FontManager.getFont("SSB12"));
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                TaskCounterTable.this.ivColHeaderLabel.setText((String)value);
                return TaskCounterTable.this.ivColHeaderLabel;
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this);
        this.getSelectionModel().setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        int i = 0;
        while (i < WIDTHS.length) {
            this.getColumnModel().getColumn(i).setPreferredWidth(WIDTHS[i]);
            ++i;
        }
        this.setRowHeight(this.ivListLabel.getPreferredSize().height);
    }

    public int getColumnCount() {
        return COLS.length;
    }

    public String getColumnName(int columnIndex) {
        return COLS[columnIndex];
    }

    public int getRowCount() {
        return this.ivObjects == null ? 0 : this.ivObjects.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        TaskCounter tc = (TaskCounter)this.getObjectAtRow(rowIndex);
        if (tc != null) {
            if (columnIndex == COL_ROOM_NAME) {
                return tc.ivRoomname;
            }
            int anz = this.getNumber(columnIndex, rowIndex);
            if (anz != 0) {
                return Integer.toString(anz);
            }
        }
        return "";
    }

    public Vector fillSortablesVector(int col) {
        int rows = this.getRowCount();
        if (rows <= 1) {
            return null;
        }
        Vector<TableSortable> erg = new Vector<TableSortable>(rows);
        int row = 0;
        while (row < rows) {
            TaskCounter tc = (TaskCounter)this.getObjectAtRow(row);
            erg.addElement(col == 0 ? new TableSortable(row, (Comparable)((Object)tc.ivRoomname)) : new TableSortable(row, new Integer(this.getNumber(col, row))));
            ++row;
        }
        return erg;
    }

    private int getNumber(int col, int row) {
        int type;
        TaskCounter tc;
        int res = 0;
        if (col >= 0 && col < TERMIN_TYPES.length && (tc = (TaskCounter)this.getObjectAtRow(row)) != null && (type = TERMIN_TYPES[col]) != -1) {
            res = tc.getNumber(this.ivTaskDescr, TERMIN_TYPES[col], this.ivMode);
        }
        return res;
    }

    private int getSum(int row) {
        int res = 0;
        TaskCounter tc = (TaskCounter)this.getObjectAtRow(row);
        if (tc != null) {
            int i = 0;
            while (i < TERMIN_TYPES.length) {
                if (TERMIN_TYPES[i] != -1) {
                    res += tc.getNumber(this.ivTaskDescr, TERMIN_TYPES[i], this.ivMode);
                }
                ++i;
            }
        }
        return res;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String valS = (String)value;
        this.ivListLabel.setIcon(null);
        if (column == COL_ROOM_NAME) {
            this.ivListLabel.setFont(FontManager.getFont(this.getSum(row) == 0 ? "SSP11" : "SSB11"));
            this.ivListLabel.setForeground(Color.black);
            if (isSelected) {
                this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                this.ivListLabel.setOpaque(true);
            } else {
                this.ivListLabel.setBackground(null);
                this.ivListLabel.setOpaque(false);
            }
            this.ivListLabel.setHorizontalAlignment(2);
            this.ivListLabel.setText(" " + valS + " ");
        } else if (column == COL_FUTURE) {
            this.ivListLabel.setFont(FontManager.getFont("SSB11"));
            this.ivListLabel.setText(valS.length() != 0 ? " " + valS + " " : "");
            this.ivListLabel.setHorizontalAlignment(4);
            this.ivListLabel.setForeground(Color.black);
            if (isSelected) {
                this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                this.ivListLabel.setOpaque(true);
            } else {
                this.ivListLabel.setBackground(null);
                this.ivListLabel.setOpaque(false);
            }
        } else {
            int taskTerminTyp = TERMIN_TYPES[column];
            Color back = TaskColor.TASK_COUNTER_BACKGROUNDS[taskTerminTyp];
            if (valS.length() == 0) {
                back = isSelected ? TaskColor.TASK_COUNTER_BACKGROUNDS_MATT_MIX[taskTerminTyp] : TaskColor.TASK_COUNTER_BACKGROUNDS_MATT[taskTerminTyp];
                this.ivListLabel.setText("");
            } else {
                this.ivListLabel.setText(" " + valS + " ");
                this.ivListLabel.setFont(FontManager.getFont("SSB11"));
                this.ivListLabel.setForeground(TaskColor.TASK_COUNTER_FOREGROUNDS[taskTerminTyp]);
                this.ivListLabel.setHorizontalAlignment(4);
            }
            this.ivListLabel.setBackground(back);
            this.ivListLabel.setOpaque(true);
        }
        return this.ivListLabel;
    }
}

