/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.AftermathObject;
import mausoleum.result.MResult;
import mausoleum.result.MResultWrapper;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.TableFrameTasks;

public class MouseManager
extends ObjectManager {
    public static MouseManager cvInstance;

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new MouseManager();
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Mouse getMouse(long id, String group) {
        return (Mouse)cvInstance.getObject(id, group);
    }

    public static int getNumberOfActuals() {
        return cvInstance.getActualNumber();
    }

    private MouseManager() {
        super(1);
    }

    public static Mouse getMouseIfThere(long id, String group) {
        Long key = new Long(id);
        return (Mouse)cvInstance.getLocalObject(key, group);
    }

    public static Vector getActualObjects(String group) {
        return cvInstance.getActualObjectVector(group);
    }

    public static Vector getActualObjectsOfAllGroups() {
        return cvInstance.getActualObjectVectorAllGroups();
    }

    public static Vector getActualMiceOfLines(Vector lines) {
        Vector<Mouse> erg = new Vector<Mouse>();
        HashMap uidhm = MouseManager.createIDMap(lines);
        if (uidhm != null) {
            Iterator iter = uidhm.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                HashSet ghs = (HashSet)uidhm.get(group);
                Vector mice = cvInstance.getActualObjectVector(group);
                if (mice == null) continue;
                int i = 0;
                while (i < mice.size()) {
                    Mouse mouse = (Mouse)mice.elementAt(i);
                    Long lineid = (Long)mouse.get("MOS_LINEID");
                    if (lineid != null && ghs.contains(lineid)) {
                        erg.addElement(mouse);
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    public static Vector getActualMiceOfStrains(Vector strains) {
        Vector<Mouse> erg = new Vector<Mouse>();
        HashMap uidhm = MouseManager.createIDMap(strains);
        if (uidhm != null) {
            Iterator iter = uidhm.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                HashSet ghs = (HashSet)uidhm.get(group);
                Vector mice = cvInstance.getActualObjectVector(group);
                if (mice == null) continue;
                int i = 0;
                while (i < mice.size()) {
                    Mouse mouse = (Mouse)mice.elementAt(i);
                    if (mouse.ofStrains(ghs)) {
                        erg.addElement(mouse);
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    public static Vector getActualMiceOfLoci(Vector loci) {
        Vector<Mouse> erg = new Vector<Mouse>();
        HashMap uidhm = MouseManager.createIDMap(loci);
        if (uidhm != null) {
            Iterator iter = uidhm.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                HashSet ghs = (HashSet)uidhm.get(group);
                Vector mice = cvInstance.getActualObjectVector(group);
                if (mice == null) continue;
                int i = 0;
                while (i < mice.size()) {
                    Mouse mouse = (Mouse)mice.elementAt(i);
                    if (mouse.hasLocus(ghs)) {
                        erg.addElement(mouse);
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    public static Vector getResultsInActualMice(String group, long expID) {
        Vector mice;
        Vector<MResultWrapper> erg = new Vector<MResultWrapper>();
        Vector vector = mice = expID >= 5000L ? cvInstance.getActualObjectVectorAllGroups() : cvInstance.getActualObjectVector(group);
        if (mice != null) {
            int i = 0;
            while (i < mice.size()) {
                Mouse mouse = (Mouse)mice.elementAt(i);
                Vector mresults = (Vector)mouse.get("MOS_MRESULTS");
                if (mresults != null) {
                    Iterator iterator = mresults.iterator();
                    while (iterator.hasNext()) {
                        MResult mres = (MResult)iterator.next();
                        if (mres.getExperimentID() != expID) continue;
                        erg.addElement(new MResultWrapper(mouse, mres));
                    }
                }
                ++i;
            }
        }
        return erg;
    }

    public static Vector getActualMiceOfUsersOrUserGroups(Vector objects, String tag) {
        Vector<Mouse> erg = new Vector<Mouse>();
        HashMap uidhm = MouseManager.createIDMap(objects);
        if (uidhm != null) {
            Iterator iter = uidhm.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                HashSet ghs = (HashSet)uidhm.get(group);
                Vector mice = cvInstance.getActualObjectVector(group);
                if (mice == null) continue;
                int i = 0;
                while (i < mice.size()) {
                    Mouse mouse = (Mouse)mice.elementAt(i);
                    if (mouse.isOwnedBy(ghs, tag)) {
                        erg.addElement(mouse);
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    public static Vector getActualMiceOfLicense(Vector licenses) {
        Vector<Mouse> erg = new Vector<Mouse>();
        HashMap uidhm = MouseManager.createIDMap(licenses);
        if (uidhm != null) {
            Iterator iter = uidhm.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                HashSet ghs = (HashSet)uidhm.get(group);
                Vector mice = cvInstance.getActualObjectVector(group);
                if (mice == null) continue;
                int i = 0;
                while (i < mice.size()) {
                    Long lic2;
                    Mouse mouse = (Mouse)mice.elementAt(i);
                    Long lic1 = (Long)mouse.get(Mouse.getLicenseTag(1));
                    if (lic1 != null && ghs.contains(lic1)) {
                        erg.addElement(mouse);
                    }
                    if ((lic2 = (Long)mouse.get(Mouse.getLicenseTag(2))) != null && ghs.contains(lic2)) {
                        erg.addElement(mouse);
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    private static HashMap createIDMap(Vector idObjects) {
        HashMap<String, HashSet<Object>> uidhm = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            uidhm = new HashMap<String, HashSet<Object>>();
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                String group = ido.getGroup("");
                HashSet<Object> ghs = (HashSet<Object>)uidhm.get(group);
                if (ghs == null) {
                    ghs = new HashSet<Object>();
                    uidhm.put(group, ghs);
                }
                ghs.add(ido.get("IDO_ID"));
            }
        }
        return uidhm;
    }

    public static String getFirstCollisionEartag(int startWert, String prefix, Vector maeuse) {
        HashMap<String, Vector<Mouse>> testMaeuseByGroup = new HashMap<String, Vector<Mouse>>();
        Iterator<Object> iter = maeuse.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            String group = mouse.getGroup();
            Vector<Mouse> v = (Vector<Mouse>)testMaeuseByGroup.get(group);
            if (v == null) {
                v = new Vector<Mouse>();
                testMaeuseByGroup.put(group, v);
            }
            v.add(mouse);
        }
        iter = testMaeuseByGroup.keySet().iterator();
        while (iter.hasNext()) {
            String group = (String)iter.next();
            Vector testMaeuse = (Vector)testMaeuseByGroup.get(group);
            Vector mice = cvInstance.getActualObjectVector(group);
            HashSet<String> eartags = new HashSet<String>(mice.size() * 3 / 2);
            int i = 0;
            while (i < mice.size()) {
                Mouse mausi = (Mouse)mice.elementAt(i);
                int et = mausi.getInt("MOS_EARTAG");
                if (et > 0) {
                    eartags.add(mausi.getCLLWEartagString("", true, true));
                }
                ++i;
            }
            int test = 0;
            while (test < testMaeuse.size()) {
                Mouse maus = (Mouse)testMaeuse.elementAt(test);
                String s = maus.getCLLWEartagString(startWert + test, "", true, prefix, true, true);
                if (eartags.contains(s)) {
                    eartags.clear();
                    testMaeuseByGroup.clear();
                    return s;
                }
                ++test;
            }
            eartags.clear();
        }
        testMaeuseByGroup.clear();
        return null;
    }

    public static void performPlugAlertControl(boolean forceShowFrame) {
        Vector v;
        if (ProcessDefinition.isClient() && Privileges.hasPrivilege("PLUG_ALERT") && (v = cvInstance.getActualObjectVectorAllGroups()) != null && !v.isEmpty()) {
            Vector<Mouse> erg = new Vector<Mouse>();
            int i = 0;
            while (i < v.size()) {
                Mouse mausi = (Mouse)v.elementAt(i);
                if (MouseManager.isPlugAlert(mausi)) {
                    erg.addElement(mausi);
                }
                ++i;
            }
            if (!erg.isEmpty()) {
                TableFrameTasks.showPlugAlert(erg, forceShowFrame);
            }
        }
    }

    public static boolean isPlugAlert(Mouse mausi) {
        Date pd = mausi.getDate("MOS_PLUGDATE");
        if (pd != null) {
            int diff = MyDate.HEUTE - MyDate.getTage(pd);
            int alertdate = mausi.getInt("MOS_PLUGALERT", 0);
            if (alertdate == 0) {
                alertdate = (int)(mausi.getMaturityLimit() / 86400000L);
            }
            if (diff >= alertdate - 1) {
                return true;
            }
        }
        return false;
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && MausoleumClient.cvManagerInitialized && sentObjects != null && !sentObjects.isEmpty()) {
            Vector weanedMiceIdentifiers;
            Vector newMice;
            if (!or.isFinished() || !or.isCommandUNDOREDORequest()) {
                return;
            }
            int i = 0;
            while (i < sentObjects.size()) {
                Mouse maus;
                IDObject obj = (IDObject)sentObjects.elementAt(i);
                if (obj instanceof Mouse && UserManager.groupContained((maus = (Mouse)obj).getGroup(""))) {
                    aftermathObject.addCage(maus.getActCage());
                }
                ++i;
            }
            if (!or.ivClientString.equals(StringHelper.getClientString())) {
                return;
            }
            HashMap primerg = (HashMap)or.ivObject;
            HashSet specialCommands = (HashSet)primerg.get("#soc");
            if (specialCommands != null && specialCommands.contains("MR")) {
                Vector<Mouse> killedMice = new Vector<Mouse>();
                int i2 = 0;
                while (i2 < sentObjects.size()) {
                    Mouse mausi = (Mouse)sentObjects.elementAt(i2);
                    if (mausi.isDead()) {
                        killedMice.addElement(mausi);
                    }
                    ++i2;
                }
                if (!killedMice.isEmpty()) {
                    TableFrameMouse.addKilledMice(killedMice);
                }
            }
            if ((newMice = MouseManager.extractNewMice(or)) != null && !newMice.isEmpty()) {
                Iterator iterator = newMice.iterator();
                while (iterator.hasNext()) {
                    Mouse maus = (Mouse)iterator.next();
                    if (!UserRoomRestriction.areRoomsRestricted()) continue;
                    UserRoomRestriction.addRestrictionOverrideObject(maus);
                    this.notifyConsumers(maus);
                }
                TableFrameMouse.addNewMice(newMice);
            }
            if ((weanedMiceIdentifiers = (Vector)primerg.get("#swm")) != null) {
                Vector<Mouse> weanedMice = new Vector<Mouse>();
                int i3 = 0;
                while (i3 < weanedMiceIdentifiers.size()) {
                    String mausIdentifier = (String)weanedMiceIdentifiers.elementAt(i3);
                    Zeile idz = new Zeile(mausIdentifier, '|');
                    if (idz.size() == 3) {
                        String groupName = idz.getString(0);
                        long mouseID = idz.getLong(2, 0L);
                        Mouse maus = MouseManager.getMouse(mouseID, groupName);
                        if (maus != null) {
                            weanedMice.addElement(maus);
                        }
                    }
                    ++i3;
                }
                if (!weanedMice.isEmpty()) {
                    TableFrameMouse.addWeanedMice(weanedMice);
                }
            }
            TableFrameMouse.showNewMice(sentObjects, specialCommands);
        }
    }

    public static Vector extractNewMice(ObjectRequest or) {
        Vector neueMausIDs;
        HashMap neueObjekte;
        HashMap primerg = (HashMap)or.ivObject;
        HashMap newObjectsByGroup = (HashMap)primerg.get("#sno");
        if (newObjectsByGroup != null && (neueObjekte = (HashMap)newObjectsByGroup.get(or.ivGroup)) != null && (neueMausIDs = (Vector)neueObjekte.get(new Integer(1))) != null) {
            Vector<Mouse> newMice = new Vector<Mouse>();
            int i = 0;
            while (i < neueMausIDs.size()) {
                Long mausID = (Long)neueMausIDs.elementAt(i);
                Mouse maus = MouseManager.getMouse(mausID, or.ivGroup);
                if (maus != null) {
                    newMice.addElement(maus);
                }
                ++i;
            }
            if (!newMice.isEmpty()) {
                return newMice;
            }
        }
        return null;
    }

    public static HashMap prepareGenealogy(Mouse mouse, boolean parents, int runden) {
        String group = mouse.getGroup();
        ObjectRequest mor = RequestManager.createSendAndGetAnswer(parents ? (byte)48 : 49, mouse.get("IDO_ID"), group, new Integer(runden));
        if (mor.isFinished()) {
            HashSet gebraucht = (HashSet)mor.ivObject;
            Vector<Long> fehlend = new Vector<Long>(gebraucht.size());
            Iterator iter = gebraucht.iterator();
            while (iter.hasNext()) {
                Long key = (Long)iter.next();
                if (cvInstance.getLocalObject(key, group) != null) continue;
                fehlend.add(key);
            }
            if (!fehlend.isEmpty()) {
                long[] arr = new long[fehlend.size()];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = (Long)fehlend.elementAt(i);
                    ++i;
                }
                cvInstance.getObjectsFromServer(arr, false, group);
            }
            return (HashMap)mor.ivExtraObject;
        }
        return null;
    }
}

