/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.TaskColor;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.HTMLHelper;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.DefaultManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.Task;
import mausoleum.mouse.TaskPredecessor;
import mausoleum.mouse.TaskRudelBums;
import mausoleum.rack.frame.TriangleRestrictor;
import mausoleum.requester.calendar.WeekdayPanel;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.requester.task.TaskRequester;
import mausoleum.room.Room;
import mausoleum.task.DisplayTask;
import mausoleum.task.PeriodTaskHelper;
import mausoleum.task.TaskTreeNode;
import mausoleum.task.standards.StandardTask;

public class TaskExtended
extends Task
implements Comparable {
    private static final long serialVersionUID = 11531531351354L;
    public static final long DISPOSAL_TIME = 3628800000L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_ISSUED = 1;
    public static final int STATUS_INPROGRESS = 2;
    public static final int STATUS_DONE = 3;
    public static final int STATUS_REJECTED = 4;
    public static final int STATUS_WITHDRAWN = 5;
    public static final int STATUS_UNFINISHED_REMOVED = 6;
    public static final int STATUS_PLANNED = 7;
    public static final int PROC_UNKNOWN = 0;
    public static final int PROC_OTHER = -1;
    public static final int[] STATUS_INTS;
    public static final String[] STATUS_STRINGS;
    public static int[] FINISHED_STATUS;
    public static int[] REVIVABLE_STATUS;
    public static int[] UNFINISHED_STATUS;
    public static int[] NONSTARTED_STATUS;
    public static int[] ALL_STATUS;
    public static final long NO_FAVORIT_CHANGE = -2L;
    public static final long NO_FAVORIT = -1L;
    public static final int TIME_UNSET = 0;
    public static final int TIME_MORNING = -1;
    public static final int TIME_NOON = -2;
    public static final int TIME_AFTERNOON = -3;
    public static final int TIME_EVENING = -4;
    public static final int TIME_DONT_CHANGE = Integer.MAX_VALUE;
    public static final int[] TIME_INTS;
    public static final String[] TIME_STRINGS;
    public static final String[] TIME_STRINGS_SHORT;
    public static final int FREQ_NONE = 0;
    public static final int FREQ_DAILY = 1;
    public static final int FREQ_2ND_DAY = 2;
    public static final int FREQ_3RD_DAY = 3;
    public static final int FREQ_4TH_DAY = 4;
    public static final int FREQ_WEEKLY = 7;
    public static final int FREQ_BIWEEKLY = 14;
    public static final int FREQ_MONTHLY = 30;
    public static final int FREQ_BIMONTHLY = 34;
    public static final int FREQ_TRIMONTHLY = 35;
    public static final int FREQ_SEMI_ANNUAL = 36;
    public static final int FREQ_ANNUAL = 37;
    public static final int FREQ_SU = 70;
    public static final int FREQ_MO = 71;
    public static final int FREQ_TU = 72;
    public static final int FREQ_WE = 73;
    public static final int FREQ_TH = 74;
    public static final int FREQ_FR = 75;
    public static final int FREQ_SA = 76;
    public static final int FREQ_MORE_DAYS = 128;
    public static final int SUB_FREQ_SU = 1;
    public static final int SUB_FREQ_MO = 2;
    public static final int SUB_FREQ_TU = 4;
    public static final int SUB_FREQ_WE = 8;
    public static final int SUB_FREQ_TH = 16;
    public static final int SUB_FREQ_FR = 32;
    public static final int SUB_FREQ_SA = 64;
    public static final int[] FREQ_INTS;
    public static final String[] FREQ_STRINGS;
    public static final String[] FREQ_SHORT_STRINGS;
    private static Vector cvServiceCaretakerNames;
    private static Vector cvServiceCaretakerIDs;
    public static transient TreeSet cvTaskRestrictors;
    public long ivObjectID = 0L;
    public int ivObjectType = 0;
    public int ivStatus = 0;
    public int ivProcType = 0;
    public long ivIssueMillis = 0L;
    public long ivIssuerID = 0L;
    public String ivIssuerGroup = null;
    public String ivComment = null;
    public String ivErledigerGroup = null;
    public long ivErledigerID = 0L;
    public String ivFavoritGroup = null;
    public long ivFavoritID = 0L;
    public long ivFinishMillis = 0L;
    public int ivTime = 0;
    public String ivDetails = null;
    public int ivPeriodEnd = Integer.MIN_VALUE;
    public int ivPeriodFrequency = 0;
    public int[] ivKnipser = null;
    public int[] ivActionDatesForKnipser = null;
    public Object ivExtraObject = null;
    public TaskPredecessor ivPredecessor = null;
    public String ivHoSIssuedGroup = null;
    public transient TreeSet ivNextExecDates = null;
    public transient String ivGroup = null;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        STATUS_INTS = nArray;
        STATUS_STRINGS = new String[]{"TASK_UNKNOWN", "TASK_PENDING", "TASK_IN_PROGRESS", "TASK_DONE", "TASK_REJECTED", "TASK_WITHDRAWN", "TASK_UNFINISHED_REMOVED", "TASK_PLANNED"};
        FINISHED_STATUS = new int[]{3, 4, 5, 6};
        REVIVABLE_STATUS = new int[]{3, 4, 5};
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        UNFINISHED_STATUS = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        NONSTARTED_STATUS = nArray3;
        int[] nArray4 = new int[8];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 6;
        nArray4[7] = 7;
        ALL_STATUS = nArray4;
        int[] nArray5 = new int[5];
        nArray5[1] = -1;
        nArray5[2] = -2;
        nArray5[3] = -3;
        nArray5[4] = -4;
        TIME_INTS = nArray5;
        TIME_STRINGS = new String[]{"TASK_TIME_NO_PREF", "TASK_TIME_MORNING", "TASK_TIME_NOON", "TASK_TIME_AFTERNOON", "TASK_TIME_EVENING"};
        TIME_STRINGS_SHORT = new String[]{"", "TASK_TIME_MORNING", "TASK_TIME_NOON", "TASK_TIME_AFTERNOON", "TASK_TIME_EVENING"};
        int[] nArray6 = new int[20];
        nArray6[1] = 1;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 7;
        nArray6[6] = 14;
        nArray6[7] = 30;
        nArray6[8] = 34;
        nArray6[9] = 35;
        nArray6[10] = 36;
        nArray6[11] = 37;
        nArray6[12] = 70;
        nArray6[13] = 71;
        nArray6[14] = 72;
        nArray6[15] = 73;
        nArray6[16] = 74;
        nArray6[17] = 75;
        nArray6[18] = 76;
        nArray6[19] = 128;
        FREQ_INTS = nArray6;
        FREQ_STRINGS = new String[]{"", "FREQ_DAILY", "FREQ_2ND_DAY", "FREQ_3RD_DAY", "FREQ_4TH_DAY", "FREQ_WEEKLY", "FREQ_BIWEEKLY", "FREQ_MONTHLY", "FREQ_BIMONTHLY", "FREQ_TRIMONTHLY", "FREQ_SEMI_ANNUAL", "FREQ_ANNUAL", "FREQ_SU", "FREQ_MO", "FREQ_TU", "FREQ_WE", "FREQ_TH", "FREQ_FR", "FREQ_SA", "FREQ_MORE_DAYS"};
        FREQ_SHORT_STRINGS = new String[]{"", "FREQ_SH_DAILY", "FREQ_SH_2ND_DAY", "FREQ_SH_3RD_DAY", "FREQ_SH_4TH_DAY", "FREQ_SH_WEEKLY", "FREQ_SH_BIWEEKLY", "FREQ_SH_MONTHLY", "FREQ_SH_BIMONTHLY", "FREQ_SH_TRIMONTHLY", "FREQ_SH_SEMI_ANNUAL", "FREQ_SH_ANNUAL", "FREQ_SH_SU", "FREQ_SH_MO", "FREQ_SH_TU", "FREQ_SH_WE", "FREQ_SH_TH", "FREQ_SH_FR", "FREQ_SH_SA", "FREQ_SH_MORE_DAYS"};
        cvServiceCaretakerNames = null;
        cvServiceCaretakerIDs = null;
        cvTaskRestrictors = new TreeSet();
    }

    public static boolean polishTaskArray(IDObject erg) {
        Mouse mouse;
        Task[] altTaskArray;
        if (erg instanceof Mouse && (altTaskArray = (Task[])(mouse = (Mouse)erg).get("MOS_TASKS")) != null) {
            Vector<TaskExtended> neueTasks = new Vector<TaskExtended>(altTaskArray.length);
            int i = 0;
            while (i < altTaskArray.length) {
                if (altTaskArray[i] != null) {
                    TaskExtended te = new TaskExtended();
                    te.ivDatum = altTaskArray[i].ivDatum;
                    te.ivPseudoID = altTaskArray[i].ivPseudoID;
                    te.ivDescription = altTaskArray[i].ivDescription;
                    te.ivObjectID = mouse.getID();
                    te.ivObjectType = 1;
                    te.ivStatus = 1;
                    neueTasks.add(te);
                }
                ++i;
            }
            mouse.set("MOS_TASKS", null);
            if (!neueTasks.isEmpty()) {
                TaskExtended[] neuArray = new TaskExtended[neueTasks.size()];
                int i2 = 0;
                while (i2 < neueTasks.size()) {
                    neuArray[i2] = (TaskExtended)neueTasks.elementAt(i2);
                    ++i2;
                }
                mouse.set("MOS_TASKSEXT", neuArray);
            }
            mouse.commit(true);
            return true;
        }
        return false;
    }

    public static void polishMouseTasksDuringImport(Mouse mouse) {
        TaskExtended[] oarr = (TaskExtended[])mouse.get("MOS_TASKSEXT");
        if (oarr != null) {
            TaskExtended[] narr = new TaskExtended[oarr.length];
            int i = 0;
            while (i < narr.length) {
                narr[i] = new TaskExtended(oarr[i]);
                narr[i].ivObjectID = mouse.getID();
                if (narr[i].ivIssuerID == 0L || !"service".equals(narr[i].ivIssuerGroup)) {
                    narr[i].ivIssuerID = 0L;
                    narr[i].ivIssuerGroup = null;
                }
                if (narr[i].ivFavoritID == 0L || !"service".equals(narr[i].ivFavoritGroup)) {
                    narr[i].ivFavoritID = 0L;
                    narr[i].ivFavoritGroup = null;
                }
                if (narr[i].ivErledigerID == 0L || !"service".equals(narr[i].ivErledigerGroup)) {
                    narr[i].ivErledigerID = 0L;
                    narr[i].ivErledigerGroup = null;
                }
                ++i;
            }
            mouse.set("MOS_TASKSEXT", narr);
        }
    }

    public static boolean shouldTaskBeShown(TaskExtended task, String objectGroup, boolean checkFavorit) {
        if (!checkFavorit) {
            return true;
        }
        if (task.ivFavoritGroup == null || task.ivFavoritGroup.length() == 0) {
            return true;
        }
        User loggedinUser = UserManager.getUser();
        if (loggedinUser == null) {
            return false;
        }
        String issuergroup = task.getIssuerGroup(objectGroup);
        if (loggedinUser.getGroup().equals(issuergroup) && loggedinUser.getID() == task.ivIssuerID) {
            return true;
        }
        if (task.ivFavoritGroup.equalsIgnoreCase(loggedinUser.getGroup())) {
            if (task.ivFavoritID == 0L) {
                return true;
            }
            return task.ivFavoritID == UserManager.getIDOFUser();
        }
        return false;
    }

    public static void addNewTasks(Vector targetObjects, int objectType) {
        if (targetObjects != null && !targetObjects.isEmpty()) {
            String commonGroup = IDObject.commonGroup(targetObjects);
            TaskRequester tr = new TaskRequester(Inspector.getInspector(), objectType, targetObjects, 0, IDObject.commonGroup(targetObjects), null);
            if (tr.ivWarOK) {
                int taskDatum;
                int taskProc = tr.getTaskProc(-1);
                if (!PopeAlert.checkForEmbryoTransferAndKilltask(taskProc, taskDatum = MyDate.getTage(tr.getDate()), targetObjects)) {
                    return;
                }
                if (!PopeAlert.checkForTaskMinMaxDateProblem(taskProc, taskDatum, targetObjects)) {
                    return;
                }
                TaskExtended.addNewTasks(commonGroup, objectType, tr.getDate(), tr.getPeriodEnd(Integer.MIN_VALUE), tr.getDescription(), tr.getTaskProc(-1), TIME_INTS[tr.ivTimeCombo.getSelectedIndex()], tr.getDetails(), tr.getPeriodFrequency(0), tr.getFavoritID(), tr.getFavoritGroup(), targetObjects, null, true);
            }
        }
    }

    public static void addNewTasks(String commonGroup, int objectType, Date startOrSpecDate, int periodEnd, String description, int procType, int time, String details, int periodFrequency, long favoritID, String favoritGroup, Vector targetObjects, Vector objectIDsForCommonGroup, boolean checkForHolidays) {
        long millis = TimeMachine.getCurrentMillis();
        if (startOrSpecDate != null) {
            int date = (int)(startOrSpecDate.getTime() / 86400000L);
            if (periodEnd == Integer.MIN_VALUE && checkForHolidays && !PopeAlert.checkTaskDateForHoliday(date)) {
                return;
            }
            TaskExtended task = new TaskExtended();
            if (targetObjects != null && !TaskExtended.checkForSpecials(procType, targetObjects, commonGroup, date, task)) {
                return;
            }
            task.ivIssueMillis = millis;
            task.ivDatum = (int)(startOrSpecDate.getTime() / 86400000L);
            task.ivDescription = description;
            task.ivIssuerID = UserManager.getUserIDWithoutDisguise();
            task.ivIssuerGroup = UserManager.getUserGroupWithoutDisguise();
            task.ivObjectType = objectType;
            task.ivStatus = 1;
            task.ivProcType = procType;
            task.ivTime = time;
            task.ivDetails = details;
            task.ivPeriodEnd = periodEnd;
            task.ivPeriodFrequency = periodFrequency;
            if (favoritID != -1L && favoritGroup != null && favoritGroup.length() != 0) {
                task.ivFavoritGroup = favoritGroup;
                task.ivFavoritID = favoritID;
            }
            Vector<TaskExtended> tasks = new Vector<TaskExtended>();
            if (task.ivProcType == -1) {
                tasks.add(task);
            } else {
                StandardTask st = StandardTask.findTask(commonGroup, task.ivProcType);
                if (st == null || st.isPrimaerTask()) {
                    tasks.add(task);
                } else {
                    int i = 0;
                    while (i < st.ivCombiIDs.length) {
                        TaskExtended ctask = new TaskExtended();
                        ctask.ivIssueMillis = task.ivIssueMillis;
                        ctask.ivDatum = task.ivDatum + st.ivCombiDayOffsets[i];
                        ctask.ivDescription = "";
                        ctask.ivDetails = task.ivDetails;
                        ctask.ivIssuerID = task.ivIssuerID;
                        ctask.ivIssuerGroup = task.ivIssuerGroup;
                        ctask.ivObjectType = task.ivObjectType;
                        ctask.ivStatus = task.ivStatus;
                        ctask.ivProcType = st.ivCombiIDs[i];
                        ctask.ivTime = st.ivCombiTimePrefs[i];
                        ctask.ivFavoritGroup = task.ivFavoritGroup;
                        ctask.ivFavoritID = task.ivFavoritID;
                        ctask.ivComment = String.valueOf(Babel.get("PART_OF_TASK_BUNDLE")) + " " + StandardTask.getDescription(commonGroup, st.ivID, "", false, null);
                        tasks.add(ctask);
                        ++i;
                    }
                }
            }
            HashMap<String, Object> obsByGroup = null;
            if (targetObjects != null) {
                obsByGroup = IDObject.sortByGroup(targetObjects);
            } else {
                obsByGroup = new HashMap<String, Object>();
                obsByGroup.put(commonGroup, objectIDsForCommonGroup);
            }
            if (obsByGroup != null) {
                String group;
                Iterator iter = obsByGroup.keySet().iterator();
                while (iter.hasNext()) {
                    group = (String)iter.next();
                    Vector objects = (Vector)obsByGroup.get(group);
                    StringBuffer msb = new StringBuffer();
                    int i = 0;
                    while (i < objects.size()) {
                        long objectID = -1L;
                        String serviceRoomTag = "";
                        Object ooo = objects.elementAt(i);
                        if (ooo instanceof IDObject) {
                            IDObject ido = (IDObject)ooo;
                            objectID = ido.getID();
                            serviceRoomTag = CommandManagerExecutive.getServiceRoomTag(ido, "");
                        } else if (ooo instanceof Long) {
                            objectID = (Long)ooo;
                        }
                        Iterator iter2 = tasks.iterator();
                        while (iter2.hasNext()) {
                            TaskExtended superTask;
                            TaskExtended te = (TaskExtended)iter2.next();
                            msb.append(serviceRoomTag);
                            msb.append("MALTERTASK").append(" ");
                            msb.append(objectID).append(" ");
                            msb.append(objectType).append(" ");
                            te.ivPseudoID = MilliSpender.getMillis();
                            te.ivObjectID = objectID;
                            if (te.ivPredecessor != null && (superTask = (TaskExtended)tasks.elementAt((int)te.ivPredecessor.ivPredTaskID)) != null) {
                                te.ivPredecessor.ivPredTaskID = superTask.ivPseudoID;
                            }
                            msb.append(Base64Manager.encodeBase64(te.getInitString())).append("\n");
                        }
                        ++i;
                    }
                    String groupCommand = msb.toString();
                    if (groupCommand != null && groupCommand.length() != 0) {
                        obsByGroup.put(group, groupCommand);
                        continue;
                    }
                    obsByGroup.put(group, "");
                }
                iter = obsByGroup.keySet().iterator();
                while (iter.hasNext()) {
                    group = (String)iter.next();
                    String groupCommand = (String)obsByGroup.get(group);
                    if (groupCommand.length() == 0) continue;
                    InspectorCommandSender.executeCommand(groupCommand, group);
                }
            }
        }
    }

    public static void addExactPoolingTaskFinish(Vector miceToTransfer, long cageID, StringBuffer msb, int actionDate) {
        String group = IDObject.commonGroup(miceToTransfer);
        if (group != null) {
            Cage targetCage;
            HashMap<Long, Mouse> allMiceByID = new HashMap<Long, Mouse>();
            HashSet<Long> cageIDs = new HashSet<Long>();
            Iterator iterator = miceToTransfer.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                allMiceByID.put(mouse.getLongID(), mouse);
                long fromCageID = mouse.getActCageID(-1L);
                if (fromCageID == -1L) continue;
                cageIDs.add(new Long(fromCageID));
            }
            Vector<Mouse> remainigMice = new Vector<Mouse>();
            Iterator iterator2 = cageIDs.iterator();
            while (iterator2.hasNext()) {
                Vector cActMice;
                Long fromCageID = (Long)iterator2.next();
                Cage cage = (Cage)ObjectStore.getClientObject(2, fromCageID, group);
                if (cage == null || (cActMice = cage.getActualMice()) == null || cActMice.isEmpty()) continue;
                remainigMice.clear();
                Iterator iterator22 = cActMice.iterator();
                while (iterator22.hasNext()) {
                    Mouse mouse = (Mouse)iterator22.next();
                    if (allMiceByID.containsKey(mouse.getLongID())) continue;
                    remainigMice.add(mouse);
                }
                if (remainigMice.isEmpty()) continue;
                TaskExtended.checkForExactPoolingTaskFinish(remainigMice, group, msb, actionDate);
            }
            if (cageID != -1L && (targetCage = (Cage)ObjectStore.getClientObject(2, cageID, group)) != null) {
                Vector cageMice = targetCage.getActualMice();
                Iterator iterator3 = cageMice.iterator();
                while (iterator3.hasNext()) {
                    Mouse mouse = (Mouse)iterator3.next();
                    allMiceByID.put(mouse.getLongID(), mouse);
                }
            }
            Vector targetCommunity = new Vector(allMiceByID.values());
            allMiceByID.clear();
            allMiceByID = null;
            TaskExtended.checkForExactPoolingTaskFinish(targetCommunity, group, msb, actionDate);
        }
    }

    private static boolean checkForSpecials(int taskProc, Vector targetObjects, String commonGroup, int date, TaskExtended taskextended) {
        StandardTask st;
        if (taskProc != -1 && (st = StandardTask.findTask(commonGroup, taskProc)) != null && "TASK_AC_RUDELBUMS".equals(st.ivAutocompletion)) {
            return TaskRudelBums.checkWhileSettingUp(targetObjects, date, taskextended);
        }
        return true;
    }

    private static void checkForExactPoolingTaskFinish(Vector miceCommunity, String group, StringBuffer msb, int actionDate) {
        HashMap<LongPunkt, Integer> countsByPseuodID = new HashMap<LongPunkt, Integer>();
        Iterator iterator = miceCommunity.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            Vector ufst = StandardTask.getUnfinishedStandardTasks(mouse, mouse.getTaskKey(), "TASK_AC_PRECISE_POOLING", 0L);
            if (ufst == null) {
                return;
            }
            Iterator iter = ufst.iterator();
            while (iter.hasNext()) {
                TaskExtended task = (TaskExtended)iter.next();
                LongPunkt groupIdentifier = task.getTaskGroupIdentifier();
                Integer count = (Integer)countsByPseuodID.get(groupIdentifier);
                if (count == null) {
                    countsByPseuodID.put(groupIdentifier, new Integer(1));
                    continue;
                }
                countsByPseuodID.put(groupIdentifier, new Integer(count + 1));
            }
        }
        HashSet<LongPunkt> nextRoundPseudoIDs = new HashSet<LongPunkt>();
        Iterator iterator2 = countsByPseuodID.keySet().iterator();
        while (iterator2.hasNext()) {
            LongPunkt groupIdentifier = (LongPunkt)iterator2.next();
            Integer count = (Integer)countsByPseuodID.get(groupIdentifier);
            if (count.intValue() != miceCommunity.size()) continue;
            nextRoundPseudoIDs.add(groupIdentifier);
        }
        if (nextRoundPseudoIDs.isEmpty()) {
            return;
        }
        Vector tasksWithPseudoID = new Vector();
        Iterator iterator3 = nextRoundPseudoIDs.iterator();
        while (iterator3.hasNext()) {
            tasksWithPseudoID.clear();
            LongPunkt groupIdentifier = (LongPunkt)iterator3.next();
            TaskTreeNode.collectActiveTasksWithPseudoID(tasksWithPseudoID, groupIdentifier, group, 1);
            if (tasksWithPseudoID.size() != miceCommunity.size()) continue;
            Iterator iterator22 = tasksWithPseudoID.iterator();
            while (iterator22.hasNext()) {
                DisplayTask dt = (DisplayTask)iterator22.next();
                IDObject ido = dt.getUnderlying();
                if (ido == null) continue;
                TaskExtended.addSingleTaskFinishsToComBuff(dt.ivTask, ido, msb, actionDate);
            }
        }
    }

    public static void addTaskFinishsToMiceComBuff(Vector mice, String autocompletionTag, StringBuffer msb, int actionDate) {
        if (mice != null) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), autocompletionTag, 0L, msb, actionDate);
            }
        }
    }

    public static void addTaskFinishsToComBuff(IDObject ido, String taskKey, String autocompletionTag, long additionalObjectID, StringBuffer msb, int actionDate) {
        Vector unfinishedStandardTasks = StandardTask.getUnfinishedStandardTasks(ido, taskKey, autocompletionTag, additionalObjectID);
        if (unfinishedStandardTasks != null && !unfinishedStandardTasks.isEmpty()) {
            Iterator iter = unfinishedStandardTasks.iterator();
            while (iter.hasNext()) {
                int knipsActionTageIfDifferent;
                TaskExtended task = (TaskExtended)iter.next();
                if (task.isFixedDayTask()) {
                    TaskExtended.addSingleTaskFinishsToComBuff(task, ido, msb, actionDate);
                    continue;
                }
                int knipsDate = PeriodTaskHelper.getKnipsDate(task, actionDate);
                if (knipsDate == Integer.MIN_VALUE) continue;
                int n = knipsActionTageIfDifferent = actionDate != knipsDate ? actionDate : Integer.MIN_VALUE;
                if (msb.length() != 0) {
                    msb.append("\n");
                }
                msb.append(CommandManagerExecutive.getServiceRoomTag(ido, ""));
                msb.append("MALTERTASK").append(" ");
                msb.append(ido.getID()).append(" ");
                msb.append(ido.getTyp()).append(" ");
                msb.append(Base64Manager.encodeBase64(task.getInitString(-1, null, null, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, knipsDate, knipsActionTageIfDifferent)));
            }
        }
    }

    private static void addSingleTaskFinishsToComBuff(TaskExtended task, IDObject ido, StringBuffer msb, int actionDate) {
        task.ivStatus = 3;
        task.ivErledigerID = UserManager.getUserIDWithoutDisguise();
        task.ivErledigerGroup = UserManager.getUserGroupWithoutDisguise();
        task.ivFinishMillis = TimeMachine.getCurrentMillis() % 86400000L + (long)actionDate * 86400000L;
        if (ido instanceof Mouse || ido instanceof Cage) {
            if (msb.length() != 0) {
                msb.append("\n");
            }
            msb.append(CommandManagerExecutive.getServiceRoomTag(ido, ""));
            msb.append("MALTERTASK").append(" ");
            msb.append(ido.getID()).append(" ");
            msb.append(ido.getTyp()).append(" ");
            msb.append(Base64Manager.encodeBase64(task.getInitString())).append("\n");
        }
    }

    public static Vector getTheImplicitlySelectedMice(Vector displayTasksObjects) {
        Vector<Mouse> mv = new Vector<Mouse>();
        if (displayTasksObjects == null) {
            return mv;
        }
        int i = 0;
        while (i < displayTasksObjects.size()) {
            Cage cage;
            DisplayTask displayTask = (DisplayTask)displayTasksObjects.elementAt(i);
            String group = displayTask.getGroup();
            if (displayTask.ivTask.ivObjectType == 1 || displayTask.ivTask.ivObjectType == 0) {
                Mouse mouse = (Mouse)ObjectStore.getClientObject(1, displayTask.ivTask.ivObjectID, group);
                if (mouse != null) {
                    mv.addElement(mouse);
                }
            } else if (displayTask.ivTask.ivObjectType == 2 && (cage = (Cage)ObjectStore.getClientObject(2, displayTask.ivTask.ivObjectID, group)) != null) {
                mv.addAll(cage.getActualMice());
            }
            ++i;
        }
        return mv;
    }

    public static boolean statusAllowed(Vector displayTasksObjects, int[] allowedStatus) {
        if (displayTasksObjects == null || displayTasksObjects.isEmpty() || allowedStatus == null || allowedStatus.length == 0) {
            return false;
        }
        int i = 0;
        while (i < displayTasksObjects.size()) {
            DisplayTask mt = (DisplayTask)displayTasksObjects.elementAt(i);
            if (!mt.ivTask.hasOneOfStatus(allowedStatus)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Vector collectIDObjects(Vector displayTasksObjects) {
        Vector<IDObject> erg = new Vector<IDObject>();
        if (displayTasksObjects != null && !displayTasksObjects.isEmpty()) {
            Iterator iter = displayTasksObjects.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                IDObject ido = ObjectStore.getClientObject(dt.ivTask.ivObjectType, dt.ivTask.ivObjectID, dt.getGroup());
                if (ido == null) continue;
                erg.add(ido);
            }
        }
        return erg;
    }

    public static boolean getFavoritChoices(Vector objectsForTask, Vector names, Vector ids, Vector groups, boolean mitNoChange) {
        names.clear();
        if (mitNoChange) {
            names.add(Babel.get("DONTCHANGE"));
            ids.add(new Long(-2L));
            groups.add("");
        }
        names.add(" " + Babel.get("NO_FAVORITE") + " ");
        ids.add(new Long(-1L));
        groups.add("");
        boolean esGabUser = false;
        Vector groupUsers = UserManager.getTouchyUsers(objectsForTask);
        int i = 0;
        while (i < groupUsers.size()) {
            User user = (User)groupUsers.elementAt(i);
            names.add(" " + user.getName() + " ");
            ids.add(new Long(user.getID()));
            groups.add(user.getGroup());
            esGabUser = true;
            ++i;
        }
        boolean controlledByService = true;
        Iterator iterator = objectsForTask.iterator();
        while (iterator.hasNext()) {
            Object ooo = iterator.next();
            Room room = null;
            if (ooo instanceof Mouse) {
                Mouse mouse = (Mouse)ooo;
                room = mouse.getRoom();
            } else if (ooo instanceof Cage) {
                Cage cage = (Cage)ooo;
                room = cage.getRoom();
            }
            if (room != null && room.isSharedWithOtherGroups()) continue;
            controlledByService = false;
        }
        if (controlledByService) {
            if (cvServiceCaretakerNames == null) {
                cvServiceCaretakerIDs = new Vector();
                cvServiceCaretakerNames = UserManager.getServiceCaretakerNames(cvServiceCaretakerIDs);
            }
            int i2 = 0;
            while (i2 < cvServiceCaretakerNames.size()) {
                names.add(" [S] " + cvServiceCaretakerNames.elementAt(i2) + " ");
                ids.add(cvServiceCaretakerIDs.elementAt(i2));
                groups.add("service");
                esGabUser = true;
                ++i2;
            }
        }
        return esGabUser;
    }

    public static void addOrReplaceTask(IDObject ido, String taskKey, TaskExtended newTask, Long svrrID, HashMap serviceRoomOverride) {
        if (ProcessDefinition.isServer() && taskKey != null) {
            TaskExtended[] tarr = (TaskExtended[])ido.get(taskKey);
            if (tarr == null) {
                tarr = new TaskExtended[]{newTask};
                ido.set(taskKey, tarr);
            } else {
                boolean replace = false;
                Vector<TaskExtended> v = new Vector<TaskExtended>(tarr.length + 1);
                int i = 0;
                while (i < tarr.length) {
                    if (tarr[i] != null) {
                        if (tarr[i].ivPseudoID == newTask.ivPseudoID) {
                            v.add(newTask);
                            replace = true;
                        } else {
                            v.add(tarr[i]);
                        }
                    }
                    ++i;
                }
                if (!replace) {
                    v.add(newTask);
                }
                TaskExtended[] narr = new TaskExtended[v.size()];
                int i2 = 0;
                while (i2 < v.size()) {
                    narr[i2] = (TaskExtended)v.elementAt(i2);
                    if (narr[i2].ivPredecessor != null && narr[i2].ivPredecessor.ivPredTaskID == newTask.ivPseudoID && newTask.ivStatus == 3 && narr[i2].ivStatus == 7) {
                        narr[i2].ivDatum = new MyDate(new GregorianCalendar()).getTage() + narr[i2].ivPredecessor.ivDaysAfter;
                        narr[i2].ivTime = narr[i2].ivPredecessor.ivTimePref;
                        narr[i2].ivStatus = 1;
                    }
                    ++i2;
                }
                ido.set(taskKey, narr);
                if (svrrID != null && serviceRoomOverride != null) {
                    serviceRoomOverride.put(ido.getIdentifierString(), svrrID);
                }
            }
        }
    }

    public static void removeTasks(HashMap displayTaskByGroup) {
        if (ProcessDefinition.isClient() && !displayTaskByGroup.isEmpty()) {
            Iterator iter = displayTaskByGroup.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                Vector displayTasks = (Vector)displayTaskByGroup.get(group);
                if (displayTasks == null || displayTasks.isEmpty()) continue;
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < displayTasks.size()) {
                    if (msb.length() != 0) {
                        msb.append("\n");
                    }
                    DisplayTask displayTask = (DisplayTask)displayTasks.elementAt(i);
                    IDObject ido = ObjectStore.getClientObject(displayTask.ivComeFromType, displayTask.ivComeFromID, group);
                    if (ido != null && ido.canSitInRoom()) {
                        msb.append(CommandManagerExecutive.getServiceRoomTag(ido, ""));
                    }
                    msb.append("MREMTASK").append(" ");
                    msb.append(displayTask.ivComeFromID).append(" ");
                    msb.append(displayTask.ivComeFromType).append(" ");
                    msb.append(Long.toString(displayTask.ivTask.ivPseudoID)).append(" ");
                    msb.append(displayTask.ivTask.ivIssuerID).append(" ");
                    msb.append(displayTask.ivTask.ivFavoritID).append(" ");
                    if (displayTask.ivTask.ivFavoritID != 0L && displayTask.ivTask.ivFavoritGroup != null && displayTask.ivTask.ivFavoritGroup.length() != 0) {
                        msb.append(Base64Manager.encodeBase64(displayTask.ivTask.ivFavoritGroup));
                    }
                    msb.append(" ");
                    if (displayTask.ivTask.ivIssuerID != 0L && displayTask.ivTask.ivIssuerGroup != null && displayTask.ivTask.ivIssuerGroup.length() != 0) {
                        msb.append(Base64Manager.encodeBase64(displayTask.ivTask.ivIssuerGroup));
                    }
                    ++i;
                }
                String com = msb.toString();
                RequestManager.sendCommandRequestAndGetAnswer(com, group);
            }
        }
    }

    public static void removeTask(IDObject ido, String taskKey, long pseudoID) {
        TaskExtended[] tarr;
        if (ProcessDefinition.isServer() && taskKey != null && (tarr = (TaskExtended[])ido.get(taskKey)) != null && tarr.length != 0) {
            Vector<TaskExtended> tasks = new Vector<TaskExtended>(tarr.length);
            int i = 0;
            while (i < tarr.length) {
                tasks.add(tarr[i]);
                ++i;
            }
            HashSet taskIDsToRemove = new HashSet();
            TaskExtended.removeTask(tasks, taskIDsToRemove, pseudoID);
            Vector<TaskExtended> tasksToRemain = new Vector<TaskExtended>();
            int i2 = 0;
            while (i2 < tarr.length) {
                if (tarr[i2] != null) {
                    if (!taskIDsToRemove.contains(new Long(tarr[i2].ivPseudoID))) {
                        tasksToRemain.add(tarr[i2]);
                    } else {
                        String path = GroupFileManager.getDeletedTaskPath(ido);
                        if (path != null) {
                            FileManager.appendStringToServerFile(path, "Deleted " + DatumFormat.getDateTimeString(new MyDate(new GregorianCalendar())) + ": " + tarr[i2].getInitString() + "\r\n");
                        } else {
                            String string = "No Path for deleted task of object : " + ido;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.mouse.TaskExtended");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz);
                        }
                    }
                }
                ++i2;
            }
            tasks.clear();
            tasks = null;
            taskIDsToRemove.clear();
            taskIDsToRemove = null;
            if (tasksToRemain.size() != tarr.length) {
                if (tasksToRemain.isEmpty()) {
                    ido.set(taskKey, null);
                } else {
                    tarr = new TaskExtended[tasksToRemain.size()];
                    i2 = 0;
                    while (i2 < tasksToRemain.size()) {
                        tarr[i2] = (TaskExtended)tasksToRemain.elementAt(i2);
                        ++i2;
                    }
                    ido.set(taskKey, tarr);
                }
            }
        }
    }

    public static void interpretDeletedTasks(String s, Vector target) {
        if (s != null && s.length() != 0) {
            Vector v = StringHelper.splitStringByAny(s, "\n");
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                int ind = line.indexOf(": ");
                if (ind == -1) continue;
                target.add(new TaskExtended(line.substring(ind + 1, line.length()).trim()));
            }
        }
    }

    public static String collectDeletedTasks(long mouseID, String group) {
        StringBuilder msb = new StringBuilder();
        String path = GroupFileManager.getDeletedTaskPath(group);
        if (path != null) {
            int[] zarr = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(path));
                String line = br.readLine();
                while (line != null) {
                    if (Zeile.getInt(line, zarr = Zeile.getTrenner(line, '|', '\u0000', zarr), '\u0000', 3, -1) == 1 && Zeile.getLong(line, zarr, '\u0000', 13, -1L) == mouseID) {
                        msb.append(line).append("\n");
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (Exception e) {
                String string = "Problem collecting tasks for mouse (ID:" + mouseID + ", Group: " + group + ")";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.TaskExtended");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return msb.toString();
    }

    private static void removeTask(Vector tasks, HashSet taskIDsToRemove, long pseudoID) {
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TaskExtended te = (TaskExtended)iterator.next();
            if (te.ivPseudoID == pseudoID) {
                taskIDsToRemove.add(new Long(te.ivPseudoID));
                continue;
            }
            if (te.ivPredecessor == null || te.ivPredecessor.ivPredTaskID != pseudoID || taskIDsToRemove.contains(new Long(te.ivPseudoID))) continue;
            TaskExtended.removeTask(tasks, taskIDsToRemove, te.ivPseudoID);
        }
    }

    public static void handleTasksOfRemovedObject(IDObject ido, String taskKey, Hashtable objectBag) {
        TaskExtended[] tarr = (TaskExtended[])ido.get(taskKey);
        if (tarr != null) {
            int anzSonderTasks = 0;
            int i = 0;
            while (i < tarr.length) {
                if (tarr[i].isPeriodTask() || tarr[i].ivPredecessor != null) {
                    ++anzSonderTasks;
                }
                ++i;
            }
            if (anzSonderTasks != tarr.length) {
                Date d;
                if (anzSonderTasks != 0) {
                    TaskExtended[] ntarr = new TaskExtended[tarr.length - anzSonderTasks];
                    int pos = 0;
                    int i2 = 0;
                    while (i2 < tarr.length) {
                        if (!tarr[i2].isPeriodTask() && tarr[i2].ivPredecessor == null) {
                            ntarr[pos++] = tarr[i2];
                        }
                        ++i2;
                    }
                    tarr = ntarr;
                }
                long finishMillis = (d = ido.getDate("IDO_END_DATE")) != null ? d.getTime() : System.currentTimeMillis();
                boolean unfinishedsPresent = false;
                int i3 = 0;
                while (i3 < tarr.length) {
                    if (!tarr[i3].isFinished()) {
                        tarr[i3].ivStatus = 6;
                        tarr[i3].ivFinishMillis = finishMillis;
                        unfinishedsPresent = true;
                    }
                    if (tarr[i3].ivIssuerID > 0L && tarr[i3].ivIssuerGroup != null) {
                        TaskExtended.haengeTaskAnUserAn(tarr[i3].ivIssuerID, tarr[i3].getIssuerGroup(ido.getGroup()), objectBag, tarr[i3], true, ido.getGroup());
                    }
                    if (tarr[i3].ivFavoritID > 0L && tarr[i3].ivFavoritGroup != null) {
                        TaskExtended.haengeTaskAnUserAn(tarr[i3].ivFavoritID, tarr[i3].ivFavoritGroup, objectBag, tarr[i3], false, ido.getGroup());
                    }
                    ++i3;
                }
                if (unfinishedsPresent) {
                    TaskExtended[] ntarr = new TaskExtended[tarr.length];
                    int j = 0;
                    while (j < tarr.length) {
                        ntarr[j] = tarr[j];
                        ++j;
                    }
                    ido.set(taskKey, ntarr);
                }
            }
        }
    }

    private static void haengeTaskAnUserAn(long userID, String group, Hashtable objectBag, TaskExtended task, boolean isForIssuer, String objectGroup) {
        User user;
        if (group != null && group.length() != 0 && (!group.equals("service") || isForIssuer) && (user = (User)ObjectStoreServer.getObjectDeadOrAlive(6, userID, group, objectBag, false, false)) != null) {
            if (user.getGroup().equals("service")) {
                if (isForIssuer && objectGroup != null && objectGroup.length() != 0 && user.getInt("USR_MODE", 0) == 500) {
                    TaskExtended phTask = new TaskExtended(task);
                    phTask.ivHoSIssuedGroup = objectGroup;
                    TaskExtended.addOrReplaceTask(user, user.getTaskKey(), phTask, null, null);
                }
            } else {
                TaskExtended.addOrReplaceTask(user, user.getTaskKey(), task, null, null);
            }
        }
    }

    public static void getRoomTransferTaskCommand(Vector mice, StringBuffer msb, int actionDate) {
        StringBuffer tmsb = new StringBuffer();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), "TASK_AC_ROOMTRANSFER", 0L, tmsb, actionDate);
        }
        String ran = tmsb.toString().trim();
        if (ran.length() != 0) {
            if (msb.length() != 0) {
                msb.append("\n");
            }
            msb.append(ran);
        }
    }

    public static String getToolTipStringTasks(Cage cage) {
        if (cage != null) {
            return TaskExtended.getToolTipStringTasks(cage.getActualMice(), null, true);
        }
        return null;
    }

    public static String getToolTipStringForTriangleButton(String titel, Vector triangleRestriktors) {
        StringBuilder taskSB = new StringBuilder();
        taskSB.append("<tr>\n");
        taskSB.append(HTMLHelper.getTDLine(titel, false, null, 1, 1, true));
        taskSB.append("</tr>\n");
        Iterator iterator = triangleRestriktors.iterator();
        while (iterator.hasNext()) {
            TriangleRestrictor tr = (TriangleRestrictor)iterator.next();
            taskSB.append("<tr>\n");
            taskSB.append(HTMLHelper.getTDLine(tr.toString(), true, tr.ivCol, 1, 1, true));
            taskSB.append("</tr>\n");
        }
        return HTMLHelper.makeToolTipTable(taskSB, null);
    }

    public static String getToolTipStringTasks(Vector mice, Mouse mouse, boolean detailliert) {
        Vector sortedTasks;
        if (mice != null | mouse != null && !(sortedTasks = TaskExtended.getSortedTaskList(mice, mouse, false, false)).isEmpty()) {
            int[] anzahlen = TaskExtended.entferneDoppler(sortedTasks, detailliert);
            StringBuilder taskSB = new StringBuilder();
            int i = 0;
            while (i < anzahlen.length) {
                TaskExtended te = (TaskExtended)sortedTasks.elementAt(i);
                taskSB.append("<tr>\n");
                taskSB.append(HTMLHelper.getTDLine(te.getDatumString(), true, TaskColor.getBackgroundByTaskDays(te.getMinimumDays(MyDate.HEUTE)), detailliert && te.ivDetails != null ? 2 : 1, 0, true));
                taskSB.append(HTMLHelper.getTDLine(StringHelper.breakIntoHTMLLines(te.getDescription(te.ivGroup), 50, new StringBuilder()), true, te.getColor(te.ivGroup), 0, 0, true));
                taskSB.append(HTMLHelper.getTDLine(te.getStatusString(), true, null, 0, 0, true));
                if (anzahlen[i] != 1) {
                    taskSB.append(HTMLHelper.getTDLine(String.valueOf(Integer.toString(anzahlen[i])) + " &times;", true, null, 0, 0, false));
                } else {
                    taskSB.append("<td></td>\n");
                }
                taskSB.append("</tr>\n");
                if (detailliert && te.ivDetails != null) {
                    taskSB.append("<tr>\n");
                    taskSB.append(HTMLHelper.getTDLine(te.ivDetails, false, null, 0, 3, true));
                    taskSB.append("</tr>\n");
                }
                ++i;
            }
            return HTMLHelper.makeToolTipTable(taskSB, null);
        }
        return null;
    }

    private static int[] entferneDoppler(Vector v, boolean detailliert) {
        Vector<int[]> ints = new Vector<int[]>(v.size());
        Vector<TaskExtended> w = new Vector<TaskExtended>(v.size());
        TaskExtended lastTask = null;
        int[] lastNumber = null;
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            TaskExtended ntask = (TaskExtended)iterator.next();
            if (TaskExtended.isSameForTT(lastTask, ntask, detailliert)) {
                lastNumber[0] = lastNumber[0] + 1;
                continue;
            }
            lastTask = ntask;
            lastNumber = new int[]{1};
            w.add(lastTask);
            ints.add(lastNumber);
        }
        v.clear();
        v.addAll(w);
        int[] res = new int[ints.size()];
        int i = 0;
        while (i < res.length) {
            int[] n = (int[])ints.elementAt(i);
            res[i] = n[0];
            ++i;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSameForTT(TaskExtended alt, TaskExtended neu, boolean detailliert) {
        if (alt == null) return false;
        if (alt.isFixedDayTask()) {
            if (!neu.isFixedDayTask()) return false;
            if (alt.ivDatum != neu.ivDatum) {
                return false;
            }
        } else if (alt.isPeriodTask()) {
            if (!neu.isPeriodTask()) return false;
            if (alt.ivDatum != neu.ivDatum || alt.ivPeriodEnd != neu.ivPeriodEnd || alt.ivPeriodFrequency != neu.ivPeriodFrequency) {
                return false;
            }
        }
        if (alt.ivProcType != neu.ivProcType) {
            return false;
        }
        if (alt.ivProcType > 0 && alt.ivProcType >= 1001 && alt.ivProcType < 5001 && !alt.ivGroup.equals(neu.ivGroup)) {
            return false;
        }
        if (!detailliert) return true;
        if (alt.ivDetails != null && neu.ivDetails != null) {
            if (alt.ivDetails.equals(neu.ivDetails)) return true;
            return false;
        }
        if (alt.ivDetails == null && neu.ivDetails != null) {
            return false;
        }
        if (alt.ivDetails == null || neu.ivDetails != null) return true;
        return false;
    }

    public static Vector getSortedTaskList(Vector mice, Mouse mouse, boolean neverUseFinished, boolean checkRestriction) {
        Vector tasks = new Vector();
        if (mouse != null) {
            TaskExtended.addMouseTasks(mouse, tasks, neverUseFinished, checkRestriction);
        }
        if (mice != null) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse maus = (Mouse)iterator.next();
                TaskExtended.addMouseTasks(maus, tasks, neverUseFinished, checkRestriction);
            }
        }
        if (tasks.size() > 1) {
            Collections.sort(tasks);
        }
        return tasks;
    }

    private static void addMouseTasks(Mouse mouse, Vector target, boolean neverUseFinished, boolean checkRestriction) {
        TaskExtended[] tarr;
        if (mouse != null && mouse.isTouchable() && (tarr = (TaskExtended[])mouse.get("MOS_TASKSEXT")) != null && tarr.length != 0) {
            int i = 0;
            while (i < tarr.length) {
                if (TaskExtended.useTaskForList(tarr[i], neverUseFinished, checkRestriction)) {
                    tarr[i].ivGroup = mouse.getGroup();
                    target.add(tarr[i]);
                }
                ++i;
            }
        }
    }

    private static boolean useTaskForList(TaskExtended task, boolean neverUseFinished, boolean checkRestriction) {
        boolean res;
        boolean bl = res = task != null && task.ivProcType != 0;
        if (res) {
            boolean bl2 = res = !task.isFinished() || !neverUseFinished && DefaultManager.getCageDisplayMode() == 10;
        }
        if (res && checkRestriction && !cvTaskRestrictors.isEmpty()) {
            res = TriangleRestrictor.isPresent(task, cvTaskRestrictors);
        }
        return res;
    }

    public TaskExtended() {
    }

    public TaskExtended(String initString) {
        this.initFromString(initString);
    }

    public TaskExtended(TaskExtended model) {
        this.ivDatum = model.ivDatum;
        this.ivPseudoID = model.ivPseudoID;
        this.ivDescription = model.ivDescription;
        this.ivObjectID = model.ivObjectID;
        this.ivObjectType = model.ivObjectType;
        this.ivStatus = model.ivStatus;
        this.ivProcType = model.ivProcType;
        this.ivIssueMillis = model.ivIssueMillis;
        this.ivIssuerID = model.ivIssuerID;
        this.ivIssuerGroup = model.ivIssuerGroup;
        this.ivComment = model.ivComment;
        this.ivErledigerGroup = model.ivErledigerGroup;
        this.ivErledigerID = model.ivErledigerID;
        this.ivFavoritGroup = model.ivFavoritGroup;
        this.ivFavoritID = model.ivFavoritID;
        this.ivFinishMillis = model.ivFinishMillis;
        this.ivTime = model.ivTime;
        this.ivDetails = model.ivDetails;
        this.ivPeriodEnd = model.ivPeriodEnd;
        this.ivPeriodFrequency = model.ivPeriodFrequency;
        this.ivKnipser = model.ivKnipser;
        this.ivExtraObject = model.ivExtraObject;
        this.ivPredecessor = model.ivPredecessor;
        this.ivActionDatesForKnipser = model.ivActionDatesForKnipser;
    }

    public void initFromString(String s) {
        String predString;
        String extraObjectString;
        Zeile z = new Zeile(s, '|');
        int col = 0;
        this.ivDatum = z.getInt(col++, Integer.MIN_VALUE);
        this.ivDescription = z.getString(col++, null);
        if (this.ivDescription != null) {
            this.ivDescription = Base64Manager.getDecodedString(this.ivDescription);
        }
        this.ivPseudoID = z.getLong(col++, 0L);
        this.ivObjectType = z.getInt(col++, 0);
        this.ivStatus = z.getInt(col++, 0);
        this.ivProcType = z.getInt(col++, 0);
        this.ivIssueMillis = z.getLong(col++, 0L);
        this.ivIssuerID = z.getLong(col++, 0L);
        this.ivComment = z.getString(col++, null);
        if (this.ivComment != null) {
            this.ivComment = Base64Manager.getDecodedString(this.ivComment);
        }
        this.ivErledigerGroup = z.getString(col++, null);
        this.ivErledigerID = z.getLong(col++, 0L);
        this.ivFavoritGroup = z.getString(col++, null);
        this.ivFavoritID = z.getLong(col++, 0L);
        this.ivObjectID = z.getLong(col++, 0L);
        this.ivFinishMillis = z.getLong(col++, 0L);
        this.ivTime = z.getInt(col++, 0);
        this.ivIssuerGroup = z.getStringNONEmpty(col++, null);
        this.ivDetails = z.getStringNONEmpty(col++, null);
        this.ivPeriodEnd = z.getInt(col++, Integer.MIN_VALUE);
        this.ivPeriodFrequency = z.getInt(col++, 0);
        this.ivKnipser = ArrayHelper.getIntArr(z.getStringNONEmpty(col++, null), ',');
        if ((extraObjectString = z.getStringNONEmpty(col++, null)) != null) {
            this.ivExtraObject = IDObjectXMLHandler.getObject(extraObjectString, null, true);
        }
        if ((predString = z.getStringNONEmpty(col++, null)) != null) {
            this.ivPredecessor = new TaskPredecessor(predString);
        }
        this.ivHoSIssuedGroup = z.getStringNONEmpty(col++, null);
        this.ivActionDatesForKnipser = ArrayHelper.getIntArr(z.getStringNONEmpty(col++, null), ',');
    }

    public String getInitString(int neuerStatus, String commentToAppend, Date newDate, int timePref, int startPeriod, int endPeriod, int frequency, int knipsDatumsTage, int knipsActionTageIfDifferent) {
        TaskExtended task = new TaskExtended(this.getInitString());
        if (commentToAppend != null) {
            task.ivComment = task.ivComment != null && task.ivComment.length() != 0 ? String.valueOf(task.ivComment) + "\n----------\n" + commentToAppend : commentToAppend;
        }
        if (newDate != null) {
            task.ivDatum = MyDate.getTage(newDate);
        } else if (startPeriod != Integer.MIN_VALUE && endPeriod != Integer.MIN_VALUE && frequency > 0) {
            task.ivDatum = startPeriod;
            task.ivPeriodEnd = endPeriod;
            task.ivPeriodFrequency = frequency;
        }
        if (neuerStatus != -1 && task.ivStatus != neuerStatus) {
            task.ivStatus = neuerStatus;
            if (task.isFinished()) {
                task.ivErledigerID = UserManager.getUserIDWithoutDisguise();
                task.ivErledigerGroup = UserManager.getUserGroupWithoutDisguise();
                task.ivFinishMillis = System.currentTimeMillis();
            }
        }
        if (timePref != Integer.MAX_VALUE) {
            task.ivTime = timePref;
        }
        boolean[] valueWasNew = new boolean[1];
        if (knipsDatumsTage != Integer.MIN_VALUE) {
            task.ivKnipser = ArrayHelper.enlargeIntArrIfValIsNew(task.ivKnipser, knipsDatumsTage, valueWasNew);
        }
        if (valueWasNew[0] && knipsActionTageIfDifferent != Integer.MIN_VALUE) {
            task.ivActionDatesForKnipser = ArrayHelper.enlargeIntArray(task.ivActionDatesForKnipser, knipsDatumsTage, knipsActionTageIfDifferent);
        }
        return task.getInitString();
    }

    public String getInitString() {
        StringBuilder msb = new StringBuilder(200);
        msb.append(this.ivDatum).append("|");
        if (this.ivDescription != null) {
            msb.append(Base64Manager.encodeBase64(this.ivDescription));
        }
        msb.append("|");
        msb.append(this.ivPseudoID).append("|");
        msb.append(this.ivObjectType).append("|");
        msb.append(this.ivStatus).append("|");
        msb.append(this.ivProcType).append("|");
        msb.append(this.ivIssueMillis).append("|");
        msb.append(this.ivIssuerID).append("|");
        if (this.ivComment != null) {
            msb.append(Base64Manager.encodeBase64(this.ivComment));
        }
        msb.append("|");
        msb.append(this.ivErledigerGroup != null ? this.ivErledigerGroup : "").append("|");
        msb.append(this.ivErledigerID).append("|");
        msb.append(this.ivFavoritGroup != null ? this.ivFavoritGroup : "").append("|");
        msb.append(this.ivFavoritID).append("|");
        msb.append(this.ivObjectID).append("|");
        msb.append(this.ivFinishMillis).append("|");
        msb.append(this.ivTime).append("|");
        msb.append(this.ivIssuerGroup != null ? this.ivIssuerGroup : "").append("|");
        msb.append(this.ivDetails != null ? this.ivDetails : "").append("|");
        msb.append(this.ivPeriodEnd != Integer.MIN_VALUE ? Integer.toString(this.ivPeriodEnd) : "").append("|");
        msb.append(this.ivPeriodFrequency > 0 ? Integer.toString(this.ivPeriodFrequency) : "").append("|");
        msb.append(ArrayHelper.getTransport(this.ivKnipser, ",")).append("|");
        if (this.ivExtraObject != null) {
            msb.append(IDObjectXMLHandler.getTransport(this.ivExtraObject, true, true));
        }
        msb.append("|");
        if (this.ivPredecessor != null) {
            msb.append(this.ivPredecessor.getInitString());
        }
        msb.append("|");
        msb.append(this.ivHoSIssuedGroup != null ? this.ivHoSIssuedGroup : "").append("|");
        msb.append(ArrayHelper.getTransport(this.ivActionDatesForKnipser, ",")).append("|");
        return msb.toString();
    }

    public boolean isFinished() {
        int i = 0;
        while (i < FINISHED_STATUS.length) {
            if (FINISHED_STATUS[i] == this.ivStatus) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskExtended) {
            TaskExtended t = (TaskExtended)obj;
            if (this.ivDatum != t.ivDatum) {
                return false;
            }
            if (this.ivPseudoID != t.ivPseudoID) {
                return false;
            }
            if (this.ivObjectID != t.ivObjectID) {
                return false;
            }
            if (this.ivObjectType != t.ivObjectType) {
                return false;
            }
            if (this.ivStatus != t.ivStatus) {
                return false;
            }
            if (this.ivProcType != t.ivProcType) {
                return false;
            }
            if (this.ivIssueMillis != t.ivIssueMillis) {
                return false;
            }
            if (this.ivIssuerID != t.ivIssuerID) {
                return false;
            }
            if (this.ivErledigerID != t.ivErledigerID) {
                return false;
            }
            if (this.ivFavoritID != t.ivFavoritID) {
                return false;
            }
            if (this.ivFinishMillis != t.ivFinishMillis) {
                return false;
            }
            if (this.ivTime != t.ivTime) {
                return false;
            }
            if (this.ivPeriodEnd != t.ivPeriodEnd) {
                return false;
            }
            if (this.ivPeriodFrequency != t.ivPeriodFrequency) {
                return false;
            }
            if (!StringHelper.checkForIdentity(this.ivDescription, t.ivDescription)) {
                return false;
            }
            if (!StringHelper.checkForIdentity(this.ivComment, t.ivComment)) {
                return false;
            }
            if (!StringHelper.checkForIdentity(this.ivErledigerGroup, t.ivErledigerGroup)) {
                return false;
            }
            if (!StringHelper.checkForIdentity(this.ivFavoritGroup, t.ivFavoritGroup)) {
                return false;
            }
            if (!StringHelper.checkForIdentity(this.ivIssuerGroup, t.ivIssuerGroup)) {
                return false;
            }
        }
        return false;
    }

    public String getDatumString() {
        StringBuilder msb = new StringBuilder(100);
        if (this.isFixedDayTask()) {
            msb.append(DatumFormat.getJustDateString(this.ivDatum));
        } else {
            if (this.ivNextExecDates == null) {
                this.ivNextExecDates = PeriodTaskHelper.getDates(this, MyDate.HEUTE);
            }
            if (!this.ivNextExecDates.isEmpty()) {
                Integer nextDate = (Integer)this.ivNextExecDates.first();
                msb.append(DatumFormat.getJustDateString(nextDate)).append(" // ");
            }
            MyDate md1 = new MyDate(this.ivDatum);
            int j1 = md1.ivJahr;
            int j2 = new MyDate((int)this.ivPeriodEnd).ivJahr;
            if (j1 == j2) {
                msb.append(DatumFormat.getVeryShortDateString(md1.ivTag, md1.ivMonat));
            } else {
                msb.append(DatumFormat.getVeryShortDateString(this.ivDatum));
            }
            msb.append(" - ");
            msb.append(DatumFormat.getVeryShortDateString(this.ivPeriodEnd));
            this.appendFreqString(msb);
        }
        return msb.toString();
    }

    public static int getWeekDayPatternIfRelevant(int frequenz) {
        if (frequenz >= 128 && frequenz <= 255) {
            return frequenz - 128;
        }
        return -1;
    }

    public static boolean isMoreWeekdaysFreq(int frequenz) {
        return frequenz >= 128 && frequenz <= 255;
    }

    private void appendFreqString(StringBuilder msb) {
        if (this.ivPeriodFrequency != 0) {
            int weekDayPattern = TaskExtended.getWeekDayPatternIfRelevant(this.ivPeriodFrequency);
            if (weekDayPattern != -1) {
                msb.append(" (");
                boolean first = true;
                int i = 0;
                while (i < WeekdayPanel.SUB_FREQS.length) {
                    if ((weekDayPattern & WeekdayPanel.SUB_FREQS[i]) != 0) {
                        if (!first) {
                            msb.append(",");
                        }
                        msb.append(DatumFormat.weekday(WeekdayPanel.SUB_FREQ_DAYS[i]));
                        first = false;
                    }
                    ++i;
                }
                msb.append(")");
            } else {
                String freq = StringHelper.getStringForInt(this.ivPeriodFrequency, FREQ_INTS, FREQ_SHORT_STRINGS, true, "");
                if (freq != null && freq.length() != 0) {
                    msb.append(" (").append(freq).append(")");
                }
            }
        }
    }

    public String getDateTime() {
        StringBuilder msb = new StringBuilder(100);
        msb.append(this.getDatumString());
        String time = StringHelper.getStringForInt(this.ivTime, TIME_INTS, TIME_STRINGS_SHORT, true, "");
        if (time.length() != 0) {
            msb.append(" [").append(time).append("]");
        }
        return msb.toString();
    }

    public String getFactSheetDesc(String group) {
        StringBuilder msb = new StringBuilder(300);
        msb.append("Date: ").append(this.getDateTime());
        msb.append(" / Status: ").append(this.getStatusString());
        msb.append(" /  Procedure: ").append(this.getDescription(group));
        if (this.ivIssueMillis != 0L) {
            msb.append(" / Issued: ").append(DatumFormat.getDateTimeString(this.ivIssueMillis));
        }
        if (this.ivFinishMillis != 0L) {
            msb.append(" / Finished: ").append(DatumFormat.getDateTimeString(this.ivFinishMillis));
        }
        if (this.ivComment != null && this.ivComment.length() != 0) {
            msb.append(" / Comment: ").append(this.ivComment);
        }
        return msb.toString();
    }

    public Color getColor(String group) {
        Color res = TaskColor.STANDARD_TASK_TRIANGLE_COLOR;
        if (this.ivProcType > 0) {
            StandardTask st = StandardTask.findTask(group, this.ivProcType);
            if (st != null && st.ivTriangleColor != null) {
                res = st.ivTriangleColor;
            }
        } else {
            res = TaskColor.NONSTANDARD_TASK_TRIANGLE_COLOR;
        }
        return res;
    }

    public String getDescription(IDObject ido) {
        return this.getDescription(ido.getGroup(""), true);
    }

    public String getDescription(String group) {
        return this.getDescription(group, true);
    }

    public String getDescriptionOhneKlammer(String group) {
        return this.getDescription(group, false);
    }

    public String getDescriptionFuerMultiDim(String group) {
        return String.valueOf(StandardTask.getMDPrefix(this.ivProcType)) + this.getDescription(group, false);
    }

    public String getDescription(String group, boolean mitKlammer) {
        return this.getDescription(group, mitKlammer, null);
    }

    public String getDescription(String group, boolean mitKlammer, Object taskExtraObject) {
        if (this.ivProcType != 0 && this.ivProcType != -1) {
            String defaultString = "? ID: " + this.ivProcType;
            if (mitKlammer) {
                return "[" + StandardTask.getDescription(group, this.ivProcType, defaultString, false, taskExtraObject) + "]";
            }
            return StandardTask.getDescription(group, this.ivProcType, defaultString, false, taskExtraObject);
        }
        return this.ivDescription;
    }

    public boolean isDependent() {
        return this.ivPredecessor != null;
    }

    public String getStatusString() {
        return StringHelper.getStringForInt(this.ivStatus, STATUS_INTS, STATUS_STRINGS, true, Babel.get("TASK_UNKNOWN"));
    }

    public String getIssuerGroup(String defVal) {
        String group = this.ivIssuerGroup;
        if (group == null || group.length() == 0) {
            group = defVal;
        }
        return group;
    }

    public void clientSafety(IDObject ido) {
        if (ido instanceof User && !this.isFinished()) {
            this.ivStatus = 6;
            this.ivFinishMillis = this.ivIssueMillis;
        }
    }

    public boolean isFixedDayTask() {
        return this.ivPeriodEnd == Integer.MIN_VALUE;
    }

    public boolean isPeriodTask() {
        return this.ivPeriodEnd != Integer.MIN_VALUE;
    }

    public LongPunkt getTaskGroupIdentifier() {
        return new LongPunkt(this.ivIssueMillis, this.ivIssuerID);
    }

    public boolean belongsToTaskGroup(LongPunkt taskGroupIdentifier) {
        return taskGroupIdentifier.ivX == this.ivIssueMillis && taskGroupIdentifier.ivY == this.ivIssuerID;
    }

    public int getLatestKnipsDate() {
        int latest = Integer.MIN_VALUE;
        if (this.ivKnipser != null) {
            int i = 0;
            while (i < this.ivKnipser.length) {
                if (latest == Integer.MIN_VALUE || this.ivKnipser[i] > latest) {
                    latest = this.ivKnipser[i];
                }
                ++i;
            }
        }
        return latest;
    }

    public int getMinimumDays(int jetzt) {
        if (this.isFixedDayTask()) {
            return this.ivDatum - jetzt;
        }
        if (this.ivNextExecDates == null) {
            this.ivNextExecDates = PeriodTaskHelper.getDates(this, MyDate.HEUTE);
        }
        if (!this.ivNextExecDates.isEmpty()) {
            Integer nextDate = (Integer)this.ivNextExecDates.first();
            return nextDate - jetzt;
        }
        return Integer.MAX_VALUE;
    }

    private boolean hasOneOfStatus(int[] starr) {
        int i = 0;
        while (i < starr.length) {
            if (this.ivStatus == starr[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initFromString((String)in.readObject());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getInitString());
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof TaskExtended) {
            int itDatum;
            TaskExtended te = (TaskExtended)arg0;
            int myDatum = this.getMinimumDays(0);
            if (myDatum < (itDatum = te.getMinimumDays(0))) {
                return -1;
            }
            if (myDatum > itDatum) {
                return 1;
            }
            if (this.ivProcType < te.ivProcType) {
                return -1;
            }
            if (this.ivProcType > te.ivProcType) {
                return 1;
            }
            if (this.ivTime < te.ivTime) {
                return 1;
            }
            if (this.ivTime > te.ivTime) {
                return -1;
            }
        }
        return 0;
    }
}

