/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.tools.Base64Manager;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import mausoleum.helper.Zeile;

public class TaskWorkFlow
implements TreeNode {
    public static final int ROOT_ID = -3;
    public TaskWorkFlow ivSuperNode = null;
    public Vector ivKids = null;
    public int ivStandardTaskID = 0;
    public String ivDescription = null;
    public String ivDetails = null;
    public int ivDayOffset = 0;
    public int ivTime = 0;
    public int ivDayOffsetEnd = Integer.MIN_VALUE;
    public int ivFrequency = 0;

    public TaskWorkFlow() {
    }

    public TaskWorkFlow(int stdID, String descr, String details, int dayOffset, int time) {
        this(stdID, descr, details, dayOffset, time, Integer.MIN_VALUE, 0);
    }

    public TaskWorkFlow(int stdID, String descr, String details, int dayOffset, int time, int dayOffsetEnd, int frequency) {
        this.ivStandardTaskID = stdID;
        this.ivDescription = descr;
        this.ivDetails = details;
        this.ivDayOffset = dayOffset;
        this.ivTime = time;
        this.ivDayOffsetEnd = dayOffsetEnd;
        this.ivFrequency = frequency;
    }

    public TaskWorkFlow(String initString) {
        Zeile z = new Zeile(initString, '|');
        int col = 0;
        this.ivStandardTaskID = z.getInt(col++, 0);
        this.ivDescription = z.getStringB64(col++, null);
        this.ivDetails = z.getStringB64(col++, null);
        this.ivDayOffset = z.getInt(col++, 0);
        this.ivTime = z.getInt(col++, 0);
        this.ivDayOffsetEnd = z.getInt(col++, Integer.MIN_VALUE);
        this.ivFrequency = z.getInt(col++, 0);
        String kidInit = z.getStringNONEmpty(col++, null);
        if (kidInit != null) {
            this.ivKids = new Vector();
            Zeile z2 = new Zeile(kidInit, ',');
            int i = 0;
            while (i < z2.size()) {
                String s = z2.getStringB64(i, null);
                if (s != null && s.length() != 0) {
                    this.ivKids.add(new TaskWorkFlow(s));
                }
                ++i;
            }
        }
    }

    public void add(TaskWorkFlow twf) {
        if (this.ivKids == null) {
            this.ivKids = new Vector();
        }
        this.ivKids.add(twf);
        twf.ivSuperNode = this;
    }

    public void remove(TaskWorkFlow twf) {
        if (this.ivKids != null) {
            this.ivKids.remove(twf);
            if (this.ivKids.isEmpty()) {
                this.ivKids = null;
            }
            twf.ivSuperNode = null;
        }
    }

    public String getInitString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.ivStandardTaskID).append("|");
        msb.append(this.ivDescription == null ? "" : Base64Manager.encodeBase64(this.ivDescription)).append("|");
        msb.append(this.ivDetails == null ? "" : Base64Manager.encodeBase64(this.ivDetails)).append("|");
        msb.append(this.ivDayOffset).append("|");
        msb.append(this.ivTime).append("|");
        if (this.ivDayOffsetEnd != Integer.MIN_VALUE) {
            msb.append(this.ivDayOffsetEnd);
        }
        msb.append("|");
        if (this.ivFrequency != 0) {
            msb.append(this.ivFrequency);
        }
        msb.append("|");
        if (this.ivKids != null && !this.ivKids.isEmpty()) {
            int i = 0;
            while (i < this.ivKids.size()) {
                TaskWorkFlow twf = (TaskWorkFlow)this.ivKids.elementAt(i);
                if (i != 0) {
                    msb.append(",");
                }
                msb.append(Base64Manager.encodeBase64(twf.getInitString()));
                ++i;
            }
        }
        msb.append("|");
        return msb.toString();
    }

    public TreeNode getChildAt(int childIndex) {
        return this.ivKids != null && this.ivKids.size() > childIndex ? (TaskWorkFlow)this.ivKids.elementAt(childIndex) : null;
    }

    public int getChildCount() {
        return this.ivKids != null ? this.ivKids.size() : 0;
    }

    public TreeNode getParent() {
        return this.ivSuperNode;
    }

    public int getIndex(TreeNode node) {
        return this.ivKids != null ? this.ivKids.indexOf(node) : -1;
    }

    public boolean getAllowsChildren() {
        return this.ivKids != null;
    }

    public boolean isLeaf() {
        return this.ivKids == null;
    }

    public Enumeration children() {
        return this.ivKids != null ? this.ivKids.elements() : null;
    }
}

