/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MilliSpender;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.mouse.Mouse;

public class TissueSample {
    public long ivMouseID = 0L;
    public String ivGroup = null;
    public String ivEartag = null;
    public long ivID = MilliSpender.getMillis();
    public int ivDatum = Integer.MIN_VALUE;
    public int ivTissueType = -1;
    public int ivPreparationType = -1;
    public int ivEmbeddingType = -1;
    public int ivFixationType = -1;
    public String ivLocation = null;
    public String ivSpecimenID = null;
    public String ivComment = null;

    public static void getTissueSamples(Vector mice, Vector target) {
        target.clear();
        if (mice != null) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                TissueSample.getTissueSamples((Mouse)iterator.next(), target);
            }
        }
    }

    public static void getTissueSamples(Mouse mouse, Vector target) {
        String tslines = mouse.getString("MOS_TISSUE", null);
        if (tslines != null) {
            Zeile z = new Zeile(tslines, '#');
            int i = 0;
            while (i < z.size()) {
                String line = z.getStringNONEmpty(i, null);
                if (line != null) {
                    target.add(new TissueSample(mouse, line));
                }
                ++i;
            }
        }
    }

    public static void getTissueSamplesWithoutSpecifiedIDs(Mouse mouse, Vector target, TreeSet unwantedIDs) {
        String tslines = mouse.getString("MOS_TISSUE", null);
        if (tslines != null) {
            Zeile z = new Zeile(tslines, '#');
            int i = 0;
            while (i < z.size()) {
                String line = z.getStringNONEmpty(i, null);
                if (line != null) {
                    TissueSample ts = new TissueSample(mouse, line);
                    if (!unwantedIDs.contains(new Long(ts.ivID))) {
                        target.add(ts);
                    }
                }
                ++i;
            }
        }
    }

    public static boolean matchesTissue(String tissueTransport, int tissueID) {
        Zeile z = new Zeile(tissueTransport, '#');
        int i = 0;
        while (i < z.size()) {
            Zeile z2;
            String line = z.getStringNONEmpty(i, null);
            if (line != null && (z2 = new Zeile(line, '|')).getInt(2, -1) == tissueID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getTransport(Vector samples) {
        StringBuilder msb = new StringBuilder();
        if (samples != null) {
            Iterator iterator = samples.iterator();
            while (iterator.hasNext()) {
                TissueSample ts = (TissueSample)iterator.next();
                if (msb.length() != 0) {
                    msb.append("#");
                }
                msb.append(ts.getTransport());
            }
        }
        return msb.toString();
    }

    public static String getCopyString(Vector samples) {
        StringBuilder msb = new StringBuilder();
        msb.append(Babel.get("TISSUE_SAMPLE_ID")).append("\t");
        msb.append(Babel.get("EARTAG")).append("\t");
        msb.append(Babel.get("DATE")).append("\t");
        msb.append(Babel.get("TISSUE")).append("\t");
        msb.append(Babel.get("TISSUE_PREP")).append("\t");
        msb.append(Babel.get("TISSUE_FIXATION")).append("\t");
        msb.append(Babel.get("TISSUE_EMBEDDING")).append("\t");
        msb.append(Babel.get("SAMPLE_LOCATION")).append("\t");
        msb.append(Babel.get("COMMENT")).append("\r\n");
        if (samples != null) {
            Iterator iterator = samples.iterator();
            while (iterator.hasNext()) {
                TissueSample ts = (TissueSample)iterator.next();
                msb.append(ts.getCopyString()).append("\r\n");
            }
        }
        return msb.toString();
    }

    private TissueSample(Mouse mouse) {
        this.ivMouseID = mouse.getID();
        this.ivGroup = mouse.getGroup();
        this.ivEartag = mouse.getCLLWEartagString();
    }

    private TissueSample(Mouse mouse, String line) {
        this(mouse);
        Zeile z = new Zeile(line, '|');
        int col = 0;
        this.ivID = z.getLong(col++, 0L);
        this.ivDatum = z.getInt(col++, Integer.MIN_VALUE);
        this.ivTissueType = z.getInt(col++, 0);
        this.ivPreparationType = z.getInt(col++, 0);
        this.ivEmbeddingType = z.getInt(col++, 0);
        this.ivFixationType = z.getInt(col++, 0);
        this.ivLocation = z.getStringB64(col++, null);
        this.ivSpecimenID = z.getStringB64(col++, null);
        this.ivComment = z.getStringB64(col++, null);
    }

    public TissueSample() {
    }

    public String getTransport() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivID).append("|");
        msb.append(this.ivDatum).append("|");
        msb.append(this.ivTissueType).append("|");
        msb.append(this.ivPreparationType).append("|");
        msb.append(this.ivEmbeddingType).append("|");
        msb.append(this.ivFixationType).append("|");
        msb.append(this.ivLocation == null ? "" : Base64Manager.encodeBase64(this.ivLocation)).append("|");
        msb.append(this.ivSpecimenID == null ? "" : Base64Manager.encodeBase64(this.ivSpecimenID)).append("|");
        msb.append(this.ivComment == null ? "" : Base64Manager.encodeBase64(this.ivComment)).append("|");
        return msb.toString();
    }

    public void takeEditableValues(TissueSample ts) {
        this.ivID = ts.ivID;
        this.ivDatum = ts.ivDatum;
        this.ivTissueType = ts.ivTissueType;
        this.ivPreparationType = ts.ivPreparationType;
        this.ivEmbeddingType = ts.ivEmbeddingType;
        this.ivFixationType = ts.ivFixationType;
        this.ivLocation = ts.ivLocation;
        this.ivSpecimenID = ts.ivSpecimenID;
        this.ivComment = ts.ivComment;
    }

    public String getCopyString() {
        StringBuilder msb = new StringBuilder();
        TissueSample.appendString(this.getSpecimenID(null), msb, true);
        TissueSample.appendString(this.getEartag(null), msb, true);
        msb.append(this.getDate("")).append("\t");
        msb.append(this.getTissue("")).append("\t");
        msb.append(this.getPreparation("")).append("\t");
        msb.append(this.getFixation("")).append("\t");
        msb.append(this.getEmbedding("")).append("\t");
        TissueSample.appendString(this.getLocation(null), msb, true);
        TissueSample.appendString(this.getComment(null), msb, true);
        return msb.toString();
    }

    public String getSpecimenID(String defVal) {
        return this.ivSpecimenID != null ? this.ivSpecimenID : defVal;
    }

    public String getEartag(String defVal) {
        return this.ivEartag != null ? this.ivEartag : defVal;
    }

    public String getLocation(String defVal) {
        return this.ivLocation != null ? this.ivLocation : defVal;
    }

    public String getComment(String defVal) {
        return this.ivComment != null ? this.ivComment : defVal;
    }

    public String getTissue(String defVal) {
        return ListDefinition.getName(this.ivGroup, 2, this.ivTissueType, defVal);
    }

    public String getPreparation(String defVal) {
        return ListDefinition.getName(this.ivGroup, 4, this.ivPreparationType, defVal);
    }

    public String getFixation(String defVal) {
        return ListDefinition.getName(this.ivGroup, 5, this.ivFixationType, defVal);
    }

    public String getEmbedding(String defVal) {
        return ListDefinition.getName(this.ivGroup, 3, this.ivEmbeddingType, defVal);
    }

    public String getDate(String defVal) {
        if (this.ivDatum != Integer.MIN_VALUE) {
            return DatumFormat.getJustDateString(this.ivDatum);
        }
        return defVal;
    }

    private static void appendString(String s, StringBuilder msb, boolean mitTab) {
        if (s != null) {
            msb.append("\"").append(StringHelper.gSub(s, "\"", "'")).append("\"");
        }
        if (mitTab) {
            msb.append("\t");
        }
    }

    public boolean changed(TissueSample ts) {
        String t2;
        String t1 = this.getTransport();
        return !t1.equals(t2 = ts.getTransport());
    }
}

