/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.experiment.Experiment;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.ZeileAbstr;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.requester.mouse.EartagRequester;
import mausoleum.result.MResult;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class XSObject
implements Serializable,
SearchObject {
    private static final long serialVersionUID = -4457905598656376870L;
    public static final int MODE_UNDEFINED = 0;
    public static final int MODE_ACTUAL = 1;
    public static final int MODE_ALL = 2;
    public static final int MODE_DEAD = 3;
    public static final int MODE_ACTUAL_CNT = 4;
    public static final int MODE_ALL_CNT = 5;
    public static final int MODE_DEAD_CNT = 6;
    public static final String TAG_SET = "XXX@set";
    public static final String TAG_NONE = "XXX@none";
    public String ivGroup;
    public Date ivBeforeDate = null;
    public int ivBeforeDays = Integer.MIN_VALUE;
    public Date ivAfter = null;
    public int ivAfterDays = Integer.MIN_VALUE;
    public Date ivDiedBeforeDate = null;
    public int ivDiedBeforeDays = Integer.MIN_VALUE;
    public Date ivDiedAfter = null;
    public int ivDiedAfterDays = Integer.MIN_VALUE;
    public int ivSex = 0;
    public EartagRequester.BigEarTagInfo ivBigEarTagInfo = null;
    public int ivEarTagObergrenze = -1;
    public long ivLineID = 0L;
    private String ivLineString = null;
    public long ivStrainID = 0L;
    private String ivStrainString = null;
    private String ivStrainVString = null;
    private String ivStrainHString = null;
    private String ivStrainMString = null;
    public long ivExperimentID = 0L;
    private String ivExpString = null;
    private String ivExpVString = null;
    private String ivExpMString = null;
    private String ivExpHString = null;
    public String ivGenotype = null;
    private LocusAndAlleles[] ivLocusAndAlleles = null;
    public long ivOwnerID = 0L;
    public int ivDeathMode = 0;
    public boolean ivBeforeFlag = false;
    public boolean ivAfterFlag = false;
    public boolean ivDiedBeforeFlag = false;
    public boolean ivDiedAfterFlag = false;
    public boolean ivSexFlag = false;
    public boolean ivEarTagFlag = false;
    public boolean ivStrainIDFlag = false;
    public boolean ivLineIDFlag = false;
    public boolean ivGenotypeFlag = false;
    public boolean ivExperimentFlag = false;
    public boolean ivOwnerFlag = false;
    public boolean ivDeathFlag = false;
    public boolean ivCommentFlag = false;
    public int ivMode = 1;
    public String ivComment = null;

    public void prepareForSearch(boolean onServer) {
        if (this.ivGenotype != null && !this.ivGenotype.equals(TAG_SET) && !this.ivGenotype.equals(TAG_NONE)) {
            this.ivLocusAndAlleles = LocusAndAlleles.decodeFromTransportString(this.ivGenotype);
        }
    }

    public void searchFinished(boolean onServer) {
    }

    public String toString() {
        return "XSObject\n   before:        " + this.ivBeforeDate + "\n" + "   after:         " + this.ivAfter + "\n" + "   sex:           " + this.ivSex + "\n" + "   earTag:        " + this.ivBigEarTagInfo + "\n" + "   strainID:      " + this.ivStrainID + "\n" + "   lineID:        " + this.ivLineID + "\n" + "   experimentID:  " + this.ivExperimentID + "\n" + "   genotype:      " + this.ivGenotype + "\n" + "   beforeFlag:    " + this.ivBeforeFlag + "\n" + "   afterFlag:     " + this.ivAfterFlag + "\n" + "   sexFlag:       " + this.ivSexFlag + "\n" + "   earTagFlag:    " + this.ivEarTagFlag + "\n" + "   strainIDFlag:  " + this.ivStrainIDFlag + "\n" + "   lineIDFlag:    " + this.ivLineIDFlag + "\n" + "   genotypeFlag:  " + this.ivGenotypeFlag + "\n" + "   experimentFlag:" + this.ivExperimentFlag;
    }

    public String getDescription() {
        StringBuilder msb = new StringBuilder("Search all ");
        if (this.ivMode == 1) {
            msb.append("living ");
        } else if (this.ivMode == 3) {
            msb.append("dead ");
        }
        String mice = "mice ";
        if (this.ivSex == -1) {
            mice = this.ivSexFlag ? "mice of undefined sex " : "mice of defined sex ";
        } else if (this.ivSex == 1) {
            mice = this.ivSexFlag ? "not male mice " : "male mice ";
        } else if (this.ivSex == 2) {
            mice = this.ivSexFlag ? "not female mice " : "female mice ";
        }
        msb.append(mice);
        if (this.ivBeforeDate != null) {
            if (this.ivBeforeFlag) {
                msb.append("not ");
            }
            msb.append("born before " + DatumFormat.getJustDateString(this.ivBeforeDate) + " ");
        }
        if (this.ivBeforeDate != null && this.ivAfter != null) {
            msb.append("and ");
        }
        if (this.ivAfter != null) {
            if (this.ivAfterFlag) {
                msb.append("not ");
            }
            msb.append("born after " + DatumFormat.getJustDateString(this.ivAfter) + " ");
        }
        if (this.ivDiedBeforeDate != null) {
            if (this.ivDiedBeforeFlag) {
                msb.append("not ");
            }
            msb.append("died/exported before " + DatumFormat.getJustDateString(this.ivDiedBeforeDate) + " ");
        }
        if (this.ivDiedBeforeDate != null && this.ivDiedAfter != null) {
            msb.append("and ");
        }
        if (this.ivDiedAfter != null) {
            if (this.ivDiedAfterFlag) {
                msb.append("not ");
            }
            msb.append("died/exported after " + DatumFormat.getJustDateString(this.ivDiedAfter) + " ");
        }
        if (this.ivBigEarTagInfo != null) {
            if (this.ivBigEarTagInfo.ivEarTag == -1) {
                if (this.ivEarTagFlag) {
                    msb.append("with eartag ");
                } else {
                    msb.append("without eartag ");
                }
            } else if (this.ivBigEarTagInfo.ivEarTag == -2) {
                if (this.ivEarTagFlag) {
                    msb.append("without eartag ");
                } else {
                    msb.append("with eartag ");
                }
            } else {
                if (this.ivEarTagFlag) {
                    msb.append("not ");
                }
                if (this.ivEarTagObergrenze == -1) {
                    msb.append("having the eartag ").append(this.ivBigEarTagInfo).append(" ");
                } else {
                    msb.append("having an eartag in the range from ").append(this.ivBigEarTagInfo.ivEarTag).append(" to ").append(this.ivEarTagObergrenze).append(" ");
                }
            }
        }
        if (this.ivStrainID != 0L) {
            if (this.ivStrainID == -1L) {
                if (!this.ivStrainIDFlag) {
                    msb.append("without specified strain ");
                } else {
                    msb.append("with specified strain ");
                }
            } else {
                if (this.ivStrainIDFlag) {
                    msb.append("not ");
                }
                String strainName = "";
                Strain strain = (Strain)ObjectStore.getClientObject(8, this.ivStrainID, this.ivGroup);
                if (strain != null) {
                    strainName = strain.getBrowseName();
                }
                msb.append("of strain ").append(strainName).append(" ");
            }
        }
        if (this.ivLineID != 0L) {
            if (this.ivLineID == -1L) {
                if (!this.ivLineIDFlag) {
                    msb.append("without specified line ");
                } else {
                    msb.append("with specified line ");
                }
            } else {
                if (this.ivLineIDFlag) {
                    msb.append("not ");
                }
                String lineName = "";
                Line line = (Line)ObjectStore.getClientObject(7, this.ivLineID, this.ivGroup);
                if (line != null) {
                    lineName = line.getBrowseName();
                }
                msb.append("of line ").append(lineName).append(" ");
            }
        }
        if (this.ivGenotype != null) {
            if (this.ivGenotype.equals(TAG_NONE)) {
                if (this.ivGenotypeFlag) {
                    msb.append("with specified genotype ");
                } else {
                    msb.append("with no specified genotype ");
                }
            } else if (this.ivGenotype.equals(TAG_SET)) {
                if (this.ivGenotypeFlag) {
                    msb.append("with no specified genotype ");
                } else {
                    msb.append("with specified genotype ");
                }
            } else {
                if (this.ivGenotypeFlag) {
                    msb.append("not ");
                }
                if (msb.toString().indexOf("having") == -1) {
                    msb.append("having ");
                }
                LocusAndAlleles[] lalArray = LocusAndAlleles.decodeFromTransportString(this.ivGenotype);
                msb.append("the genotype ").append(LocusAndAlleles.getGenotypeString(lalArray, this.ivGroup)).append(" ");
            }
        }
        if (this.ivExperimentID != 0L) {
            String expName = "";
            Experiment experiment = Experiment.getExperiment(this.ivExperimentID, this.ivGroup);
            if (experiment != null) {
                expName = experiment.getBrowseNameInclServicePrefix();
            }
            if (this.ivExperimentFlag) {
                msb.append(" without results for experiment >").append(expName).append("< ");
            } else {
                msb.append(" with results for experiment >").append(expName).append("< ");
            }
        }
        if (this.ivComment != null) {
            if (this.ivComment.equals("none")) {
                if (this.ivCommentFlag) {
                    msb.append("with specified comment ");
                } else {
                    msb.append("with no specified comment ");
                }
            } else if (this.ivComment.equals("set")) {
                if (this.ivCommentFlag) {
                    msb.append("with no specified comment ");
                } else {
                    msb.append("with specified comment ");
                }
            } else {
                if (this.ivCommentFlag) {
                    msb.append("not ");
                }
                if (msb.toString().indexOf("containing") == -1) {
                    msb.append("containing ");
                }
                msb.append("the comment >").append(this.ivComment).append("< ");
            }
        }
        if (this.ivOwnerID != 0L) {
            if (this.ivOwnerFlag) {
                msb.append(" not owned by >").append(UserManager.getNameOfUser(this.ivOwnerID, this.ivGroup)).append("< ");
            } else {
                msb.append(" owned by >").append(UserManager.getNameOfUser(this.ivOwnerID, this.ivGroup)).append("< ");
            }
        }
        if (this.ivDeathMode != 0) {
            if (this.ivDeathFlag) {
                msb.append(" not");
            }
            msb.append(" removed ").append(Visit.translateMode(this.ivDeathMode));
        }
        return msb.toString();
    }

    public boolean checkMouse(Mouse mausi) {
        if (mausi.existed()) {
            if (!this.checkBornBefore(mausi)) {
                return false;
            }
            if (!this.checkBornAfter(mausi)) {
                return false;
            }
            if (!this.checkDiedBefore(mausi)) {
                return false;
            }
            if (!this.checkDiedAfter(mausi)) {
                return false;
            }
            if (!this.checkSex(mausi)) {
                return false;
            }
            if (!this.checkEarTag(mausi)) {
                return false;
            }
            if (!this.checkStrain(mausi)) {
                return false;
            }
            if (!this.checkLine(mausi)) {
                return false;
            }
            if (!this.checkGenotype(mausi)) {
                return false;
            }
            if (!this.checkExperiment(mausi)) {
                return false;
            }
            if (!this.checkOwnership(mausi)) {
                return false;
            }
            if (!this.checkDeathMode(mausi)) {
                return false;
            }
            return this.checkComment(mausi);
        }
        return false;
    }

    public boolean checkWithIndex(String group, Long mouseID) {
        String index = IntermediaerHelfer.getIndex(group, mouseID);
        if (index != null) {
            if (!this.checkINDBornBefore(index)) {
                return false;
            }
            if (!this.checkINDBornAfter(index)) {
                return false;
            }
            if (!this.checkINDDiedBefore(index)) {
                return false;
            }
            if (!this.checkINDDiedAfter(index)) {
                return false;
            }
            if (!this.checkINDSex(index)) {
                return false;
            }
            if (!this.checkINDStrain(index)) {
                return false;
            }
            if (!this.checkINDLine(index)) {
                return false;
            }
            return this.checkINDExperiment(index);
        }
        return false;
    }

    public void addWheres(Vector wheres, Vector columns) {
        String gl;
        if (this.ivBeforeDate != null) {
            wheres.add("MOS_BIRTHDAY" + (this.ivBeforeFlag ? " >= " : " <= ") + this.ivBeforeDate.getTime());
        }
        if (this.ivAfter != null) {
            wheres.add("MOS_BIRTHDAY" + (this.ivAfterFlag ? " <= " : " >= ") + this.ivAfter.getTime());
        }
        if (this.ivDiedBeforeDate != null) {
            wheres.add("IDO_END_DATE" + (this.ivDiedBeforeFlag ? " >= " : " <= ") + this.ivDiedBeforeDate.getTime());
        }
        if (this.ivDiedAfter != null) {
            wheres.add("MOS_BIRTHDAY" + (this.ivDiedAfterFlag ? " <= " : " >= ") + this.ivDiedAfter.getTime());
        }
        if (this.ivSex != 0) {
            String string = gl = this.ivSexFlag ? "!=" : "=";
            if (this.ivSex == -1) {
                wheres.add("IDX_SEX " + gl + " \"\"");
            } else {
                wheres.add("IDX_SEX " + gl + " '" + this.ivSex + "'");
            }
        }
        if (this.ivStrainID != 0L) {
            if (this.ivStrainID == -1L) {
                gl = this.ivStrainIDFlag ? "!=" : "=";
                wheres.add("IDX_STRAINS " + gl + " \"\"");
            } else {
                gl = this.ivStrainIDFlag ? "NOT LIKE" : "LIKE";
                wheres.add("IDX_STRAINS " + gl + " '%|" + this.ivStrainID + "|%'");
            }
        }
        if (this.ivLineID != 0L) {
            String string = gl = this.ivSexFlag ? "!=" : "=";
            if (this.ivLineID == -1L) {
                wheres.add("MOS_LINEID " + gl + " \"\"");
            } else {
                wheres.add("MOS_LINEID " + gl + " '" + this.ivLineID + "'");
            }
        }
        if (this.ivExperimentID != 0L) {
            if (this.ivExperimentID == -1L) {
                gl = this.ivExperimentFlag ? "!=" : "=";
                wheres.add("IDX_RESULTS " + gl + " \"\"");
            } else {
                gl = this.ivExperimentFlag ? "NOT LIKE" : "LIKE";
                wheres.add("IDX_RESULTS " + gl + " '%|" + this.ivExperimentID + "|%'");
            }
        }
        if (this.ivDeathMode != 0) {
            gl = this.ivDeathFlag ? "!=" : "=";
            wheres.add("MOS_ENDMODE " + gl + " '" + this.ivDeathMode + "'");
        }
        if (this.ivComment != null) {
            if (this.ivComment.equals("none")) {
                gl = this.ivCommentFlag ? "!=" : "=";
                wheres.add("MOS_COMMENT " + gl + " \"\"");
            } else if (this.ivComment.equals("set")) {
                gl = this.ivCommentFlag ? "=" : "!=";
                wheres.add("MOS_COMMENT " + gl + " \"\"");
            } else {
                gl = this.ivCommentFlag ? "NOT LIKE" : "LIKE";
                wheres.add("MOS_COMMENT " + gl + " '%" + this.ivComment + "%'");
            }
        }
        if (this.ivOwnerID > 0L) {
            gl = this.ivOwnerFlag ? "NOT LIKE" : "LIKE";
            wheres.add("MOS_OWNER " + gl + " '%|" + this.ivOwnerID + "|%'");
        }
        if (this.ivBigEarTagInfo != null) {
            if (this.ivBigEarTagInfo.ivPrefix != null) {
                gl = this.ivOwnerFlag ? "!=" : "=";
                wheres.add("MOS_ETPF " + gl + " '" + this.ivBigEarTagInfo.ivPrefix + "'");
            }
            if (this.ivBigEarTagInfo.ivEarTag == -1) {
                gl = this.ivOwnerFlag ? "!=" : "=";
                wheres.add("MOS_EARTAG " + gl + " \"\"");
            } else if (this.ivBigEarTagInfo.ivEarTag == -2) {
                gl = this.ivOwnerFlag ? "=" : "!=";
                wheres.add("MOS_EARTAG " + gl + " \"\"");
            } else if (this.ivBigEarTagInfo.ivEarTag > 0) {
                if (this.ivEarTagObergrenze > 0) {
                    if (this.ivOwnerFlag) {
                        wheres.add("MOS_EARTAG <= " + this.ivBigEarTagInfo.ivEarTag + " OR " + "MOS_EARTAG" + " >= " + this.ivEarTagObergrenze);
                    } else {
                        wheres.add("MOS_EARTAG >= " + this.ivBigEarTagInfo.ivEarTag + " AND " + "MOS_EARTAG" + " <= " + this.ivEarTagObergrenze);
                    }
                } else {
                    gl = this.ivOwnerFlag ? "=" : "!=";
                    wheres.add("MOS_EARTAG " + gl + " " + this.ivBigEarTagInfo.ivEarTag);
                }
            }
        }
        if (this.ivGenotype != null) {
            if (this.ivGenotype.equals(TAG_NONE)) {
                gl = this.ivGenotypeFlag ? "!=" : "=";
                wheres.add("MOS_LOCUSGENOTYPES " + gl + " \"\"");
            } else if (this.ivGenotype.equals(TAG_SET)) {
                gl = this.ivGenotypeFlag ? "=" : "!=";
                wheres.add("MOS_LOCUSGENOTYPES " + gl + " \"\"");
            } else {
                columns.add("MOS_LOCUSGENOTYPES");
                columns.add("MOS_LINEID");
            }
        }
    }

    public boolean afterSelectCheckNecessary() {
        return this.ivGenotype != null;
    }

    public boolean afterIndexCheckNecessary() {
        if (DataLayer.USE_DB) {
            return this.ivGenotype != null && !this.ivGenotype.equals(TAG_NONE) && !this.ivGenotype.equals(TAG_SET);
        }
        return this.ivBigEarTagInfo != null || this.ivGenotype != null || this.ivOwnerID != 0L || this.ivDeathMode != 0 || this.ivComment != null;
    }

    public boolean checkAfterIndex(Object mouseOrHM) {
        Mouse mausi;
        if (DataLayer.USE_DB && mouseOrHM instanceof HashMap) {
            Long lineID;
            HashMap hm;
            LocusAndAlleles[] lalArr;
            return this.ivGenotype == null || this.checkGenotype(lalArr = (LocusAndAlleles[])(hm = (HashMap)mouseOrHM).get("MOS_LOCUSGENOTYPES"), null, lineID = (Long)hm.get("MOS_LINEID"));
        }
        if (mouseOrHM instanceof Mouse && (mausi = (Mouse)mouseOrHM).existed()) {
            if (!this.checkEarTag(mausi)) {
                return false;
            }
            if (!this.checkGenotype(mausi)) {
                return false;
            }
            if (!this.checkOwnership(mausi)) {
                return false;
            }
            if (!this.checkDeathMode(mausi)) {
                return false;
            }
            return this.checkComment(mausi);
        }
        return false;
    }

    private boolean checkOwnership(Mouse mausi) {
        if (this.ivOwnerID == 0L) {
            return true;
        }
        boolean hasit = false;
        long[] owners = (long[])mausi.get("MOS_OWNER");
        if (owners != null) {
            int i = 0;
            while (i < owners.length) {
                if (owners[i] == this.ivOwnerID) {
                    hasit = true;
                }
                ++i;
            }
        } else {
            hasit = true;
        }
        return this.iin(hasit, this.ivOwnerFlag);
    }

    private boolean checkBornBefore(Mouse mausi) {
        if (this.ivBeforeDate == null) {
            return true;
        }
        Date d = mausi.getDate("MOS_BIRTHDAY");
        if (d == null) {
            return this.iin(false, this.ivBeforeFlag);
        }
        return this.iin(d.getTime() <= this.ivBeforeDate.getTime(), this.ivBeforeFlag);
    }

    private boolean checkBornAfter(Mouse mausi) {
        if (this.ivAfter == null) {
            return true;
        }
        Date d = mausi.getDate("MOS_BIRTHDAY");
        if (d == null) {
            return this.iin(false, this.ivAfterFlag);
        }
        return this.iin(d.getTime() >= this.ivAfter.getTime(), this.ivAfterFlag);
    }

    private boolean checkDiedBefore(Mouse mausi) {
        if (this.ivDiedBeforeDate == null) {
            return true;
        }
        Date d = mausi.getDate("IDO_END_DATE");
        if (d == null) {
            return this.iin(false, this.ivDiedBeforeFlag);
        }
        return this.iin(d.getTime() <= this.ivDiedBeforeDate.getTime(), this.ivDiedBeforeFlag);
    }

    private boolean checkDiedAfter(Mouse mausi) {
        if (this.ivDiedAfter == null) {
            return true;
        }
        Date d = mausi.getDate("IDO_END_DATE");
        if (d == null) {
            return this.iin(false, this.ivDiedAfterFlag);
        }
        return this.iin(d.getTime() >= this.ivDiedAfter.getTime(), this.ivDiedAfterFlag);
    }

    private boolean checkSex(Mouse mausi) {
        switch (this.ivSex) {
            case 0: {
                return true;
            }
            case -1: {
                return this.iin(mausi.getSex() == 0, this.ivSexFlag);
            }
            case 2: {
                return this.iin(mausi.getSex() == 2, this.ivSexFlag);
            }
            case 1: {
                return this.iin(mausi.getSex() == 1, this.ivSexFlag);
            }
        }
        return true;
    }

    private boolean checkEarTag(Mouse mausi) {
        if (this.ivBigEarTagInfo == null) {
            return true;
        }
        int et = mausi.getInt("MOS_EARTAG", 0);
        if (this.ivBigEarTagInfo.ivEarTag == -2) {
            return this.iin(et != 0, this.ivEarTagFlag);
        }
        if (this.ivBigEarTagInfo.ivEarTag == -1) {
            return this.iin(et == 0, this.ivEarTagFlag);
        }
        if (this.ivEarTagObergrenze != -1) {
            String mPrefix;
            if (this.ivBigEarTagInfo.ivPrefix != null && !this.ivBigEarTagInfo.ivPrefix.equals(mPrefix = mausi.getString("MOS_ETPF", null))) {
                return false;
            }
            return this.iin(et >= this.ivBigEarTagInfo.ivEarTag && et <= this.ivEarTagObergrenze, this.ivEarTagFlag);
        }
        return this.iin(this.ivBigEarTagInfo.matches(mausi), this.ivEarTagFlag);
    }

    private boolean checkStrain(Mouse mausi) {
        if (this.ivStrainID == 0L) {
            return true;
        }
        if (this.ivStrainID == -1L) {
            return this.iin(mausi.get("MOS_STRAIN") == null, this.ivStrainIDFlag);
        }
        return this.iin(mausi.ofStrain(this.ivStrainID), this.ivStrainIDFlag);
    }

    private boolean checkLine(Mouse mausi) {
        if (this.ivLineID == 0L) {
            return true;
        }
        if (this.ivLineID == -1L) {
            return this.iin(mausi.get("MOS_LINEID") == null, this.ivLineIDFlag);
        }
        return this.iin(mausi.ofLine(this.ivLineID), this.ivLineIDFlag);
    }

    private boolean checkGenotype(Mouse mausi) {
        if (this.ivGenotype == null) {
            return true;
        }
        LocusAndAlleles[] lalArr = (LocusAndAlleles[])mausi.get("MOS_LOCUSGENOTYPES");
        return this.checkGenotype(lalArr, mausi, null);
    }

    private boolean checkGenotype(LocusAndAlleles[] lalArr, Mouse mausi, Long lineid) {
        if (this.ivGenotype.equals(TAG_NONE)) {
            return this.iin(lalArr == null, this.ivGenotypeFlag);
        }
        if (this.ivGenotype.equals(TAG_SET)) {
            return this.iin(lalArr != null, this.ivGenotypeFlag);
        }
        if (lalArr == null) {
            boolean frfrSuche = false;
            int i = 0;
            while (i < this.ivLocusAndAlleles.length) {
                if (this.ivLocusAndAlleles[i].ivAllele == null) {
                    frfrSuche = true;
                }
                ++i;
            }
            if (!frfrSuche) {
                return this.iin(false, this.ivGenotypeFlag);
            }
        }
        int i = 0;
        while (i < this.ivLocusAndAlleles.length) {
            if (!this.checkSingleGenotype(this.ivLocusAndAlleles[i], lalArr, mausi, lineid)) {
                return this.iin(false, this.ivGenotypeFlag);
            }
            ++i;
        }
        return this.iin(true, this.ivGenotypeFlag);
    }

    private boolean checkSingleGenotype(LocusAndAlleles aktSearchGT, LocusAndAlleles[] mausArray, Mouse mouse, Long lineid) {
        if (aktSearchGT.ivAllele == null) {
            LocusAndAlleles[] lv;
            Line line = null;
            line = mouse != null ? mouse.getLine() : (Line)ObjectStore.getObjectDeadOrAlive(7, lineid, this.ivGroup, null, false);
            if (line != null && (lv = (LocusAndAlleles[])line.get("LIN_LOCIALLELES")) != null) {
                int i = 0;
                while (i < lv.length) {
                    if (lv[i].ivLocusID == aktSearchGT.ivLocusID) {
                        boolean genotypeMissing = true;
                        if (mausArray != null) {
                            int j = 0;
                            while (j < mausArray.length && genotypeMissing) {
                                if (mausArray[j].ivLocusID == aktSearchGT.ivLocusID) {
                                    genotypeMissing = false;
                                }
                                ++j;
                            }
                        }
                        return genotypeMissing;
                    }
                    ++i;
                }
            }
            return false;
        }
        int i = 0;
        while (i < mausArray.length) {
            if (mausArray[i].ivLocusID == aktSearchGT.ivLocusID) {
                if (mausArray[i].ivAllele != null && mausArray[i].ivAllele.length == aktSearchGT.ivAllele.length) {
                    String[] tarr = new String[mausArray[i].ivAllele.length];
                    int j = 0;
                    while (j < tarr.length) {
                        tarr[j] = mausArray[i].ivAllele[j];
                        ++j;
                    }
                    j = 0;
                    while (j < aktSearchGT.ivAllele.length) {
                        if (!XSObject.isAllelContainedAndClearIfFound(tarr, aktSearchGT.ivAllele[j])) {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                return false;
            }
            ++i;
        }
        return false;
    }

    private static boolean isAllelContainedAndClearIfFound(String[] arr, String allel) {
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null && arr[i].equals(allel)) {
                    arr[i] = null;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkComment(Mouse mausi) {
        if (this.ivComment == null) {
            return true;
        }
        String comment = mausi.getString("MOS_COMMENT");
        if (this.ivComment.equals("none")) {
            return this.iin(comment == null, this.ivCommentFlag);
        }
        if (this.ivComment.equals("set")) {
            return this.iin(comment != null, this.ivCommentFlag);
        }
        if (comment == null) {
            return this.iin(false, this.ivCommentFlag);
        }
        return this.iin(comment.toLowerCase().indexOf(this.ivComment) != -1, this.ivCommentFlag);
    }

    private boolean checkExperiment(Mouse mausi) {
        if (this.ivExperimentID == 0L) {
            return true;
        }
        boolean hat = false;
        Vector v = (Vector)mausi.get("MOS_MRESULTS");
        if (v != null) {
            Iterator iterator = v.iterator();
            while (!hat && iterator.hasNext()) {
                MResult object = (MResult)iterator.next();
                if (object.getExperimentID() != this.ivExperimentID) continue;
                hat = true;
            }
        }
        return this.iin(hat, this.ivExperimentFlag);
    }

    private boolean checkDeathMode(Mouse mausi) {
        if (this.ivDeathMode == 0) {
            return true;
        }
        return this.iin(mausi.getInt("MOS_ENDMODE", 0) == this.ivDeathMode, this.ivDeathFlag);
    }

    private boolean iin(boolean orig, boolean inverter) {
        return inverter ? !orig : orig;
    }

    private boolean checkINDBornBefore(String index) {
        int bd;
        if (this.ivBeforeDate == null) {
            return true;
        }
        if (this.ivBeforeDays == Integer.MIN_VALUE) {
            this.ivBeforeDays = (int)(this.ivBeforeDate.getTime() / 86400000L);
        }
        if ((bd = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getBirthdayCol(), Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
            return this.iin(false, this.ivBeforeFlag);
        }
        return this.iin(bd <= this.ivBeforeDays, this.ivBeforeFlag);
    }

    private boolean checkINDBornAfter(String index) {
        int bd;
        if (this.ivAfter == null) {
            return true;
        }
        if (this.ivAfterDays == Integer.MIN_VALUE) {
            this.ivAfterDays = (int)(this.ivAfter.getTime() / 86400000L);
        }
        if ((bd = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getBirthdayCol(), Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
            return this.iin(false, this.ivAfterFlag);
        }
        return this.iin(bd >= this.ivAfterDays, this.ivAfterFlag);
    }

    private boolean checkINDDiedBefore(String index) {
        int bd;
        if (this.ivDiedBeforeDate == null) {
            return true;
        }
        if (this.ivDiedBeforeDays == Integer.MIN_VALUE) {
            this.ivDiedBeforeDays = (int)(this.ivDiedBeforeDate.getTime() / 86400000L);
        }
        if ((bd = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getEndCol(), Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
            return this.iin(false, this.ivDiedBeforeFlag);
        }
        return this.iin(bd <= this.ivDiedBeforeDays, this.ivBeforeFlag);
    }

    private boolean checkINDDiedAfter(String index) {
        int bd;
        if (this.ivDiedAfter == null) {
            return true;
        }
        if (this.ivDiedAfterDays == Integer.MIN_VALUE) {
            this.ivDiedAfterDays = (int)(this.ivDiedAfter.getTime() / 86400000L);
        }
        if ((bd = ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getEndCol(), Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
            return this.iin(false, this.ivDiedAfterFlag);
        }
        return this.iin(bd >= this.ivDiedAfterDays, this.ivBeforeFlag);
    }

    private boolean checkINDSex(String index) {
        switch (this.ivSex) {
            case 0: {
                return true;
            }
            case -1: {
                return this.iin(ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getSexCol(), 0) == 0, this.ivSexFlag);
            }
            case 2: {
                return this.iin(ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getSexCol(), 0) == 2, this.ivSexFlag);
            }
            case 1: {
                return this.iin(ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getSexCol(), 0) == 1, this.ivSexFlag);
            }
        }
        return true;
    }

    private boolean checkINDStrain(String index) {
        if (this.ivStrainID == 0L) {
            return true;
        }
        String cont = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getStrainsCol(), null);
        if (this.ivStrainID == -1L) {
            return this.iin(cont == null, this.ivStrainIDFlag);
        }
        if (this.ivStrainString == null) {
            this.ivStrainString = String.valueOf(this.ivStrainID);
            this.ivStrainVString = String.valueOf(this.ivStrainID) + "|";
            this.ivStrainMString = "|" + this.ivStrainID + "|";
            this.ivStrainHString = "|" + this.ivStrainID;
        }
        boolean res = false;
        if (cont != null) {
            res = cont.equals(this.ivStrainString) || cont.startsWith(this.ivStrainVString) || cont.endsWith(this.ivStrainHString) || cont.contains(this.ivStrainMString);
        }
        return this.iin(res, this.ivStrainIDFlag);
    }

    private boolean checkINDLine(String index) {
        if (this.ivLineID == 0L) {
            return true;
        }
        String cont = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getLineCol(), null);
        if (this.ivLineID == -1L) {
            return this.iin(cont == null, this.ivLineIDFlag);
        }
        if (this.ivLineString == null) {
            this.ivLineString = String.valueOf(this.ivLineID);
        }
        boolean res = this.ivLineString.equals(cont);
        return this.iin(res, this.ivLineIDFlag);
    }

    private boolean checkINDExperiment(String index) {
        if (this.ivExperimentID == 0L) {
            return true;
        }
        String cont = ZeileAbstr.getStringNONEmpty(index, IntermediaerHelfer.getIndexSeparator(), IntermediaerHelfer.getResultsCol(), null);
        if (this.ivExpString == null) {
            this.ivExpString = String.valueOf(this.ivExperimentID);
            this.ivExpVString = String.valueOf(this.ivExperimentID) + "|";
            this.ivExpMString = "|" + this.ivExperimentID + "|";
            this.ivExpHString = "|" + this.ivExperimentID;
        }
        boolean res = false;
        if (cont != null) {
            res = cont.equals(this.ivExpString) || cont.startsWith(this.ivExpVString) || cont.endsWith(this.ivExpHString) || cont.contains(this.ivExpMString);
        }
        return this.iin(res, this.ivExperimentFlag);
    }

    public int getType() {
        return 1;
    }

    public String getGroup() {
        return this.ivGroup;
    }

    public boolean wantsAllObjects() {
        return this.ivMode == 2 || this.ivMode == 5;
    }

    public boolean wantsOnlyActualObjects() {
        return this.ivMode == 1 || this.ivMode == 4;
    }

    public boolean wantsOnlyDeadObjects() {
        return this.ivMode == 3 || this.ivMode == 6;
    }

    public boolean wantsOnlyCount() {
        return this.ivMode == 5 || this.ivMode == 4 || this.ivMode == 6;
    }

    public boolean includeObject(IDObject ido) {
        if (!(ido instanceof Mouse)) {
            return false;
        }
        return this.checkMouse((Mouse)ido);
    }
}

