/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import mausoleum.license.License;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;

public abstract class Stress {
    public static final int MOUSE_STRESS_ARR_SIZE = 3;
    public static final int MOUSE_STRESS_ARR_POS_MOUSE_LIFE = 0;
    public static final int MOUSE_STRESS_ARR_POS_MOUSE_DEATH = 1;
    public static final int MOUSE_STRESS_ARR_POS_LINE = 2;
    public static final int STRESS_NOT_DEFINED = 0;
    public static final int STRESS_NONE = 10;
    public static final int STRESS_LIGHT = 20;
    public static final int STRESS_MEDIUM = 30;
    public static final int STRESS_SEVERE = 40;
    public static final int[] STRESS_INTS;
    public static final String[] STRESS_BABELS;
    public static final int[] STRESS_INTS_OHNE_NOT_DEF;
    public static final String[] STRESS_BABELS_OHNE_NOT_DEF;
    public static final String[] STRESS_TEXTS_OHNE_NOT_DEF;
    public static final Color[] STRESS_COLORS;
    private static final String REPORT_MUTEX;
    private static final HashMap CHOICES_LINE_BY_LANG;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 20;
        nArray[3] = 30;
        nArray[4] = 40;
        STRESS_INTS = nArray;
        STRESS_BABELS = new String[]{"STRESS_NOT_DEFINED", "STRESS_NONE", "STRESS_LIGHT", "STRESS_MEDIUM", "STRESS_SEVERE"};
        STRESS_INTS_OHNE_NOT_DEF = new int[]{10, 20, 30, 40};
        STRESS_BABELS_OHNE_NOT_DEF = new String[]{"STRESS_NONE", "STRESS_LIGHT", "STRESS_MEDIUM", "STRESS_SEVERE"};
        STRESS_TEXTS_OHNE_NOT_DEF = new String[]{Babel.get("STRESS_NONE"), Babel.get("STRESS_LIGHT"), Babel.get("STRESS_MEDIUM"), Babel.get("STRESS_SEVERE")};
        STRESS_COLORS = new Color[]{Color.gray, Color.green, Color.yellow, Color.orange, Color.red};
        REPORT_MUTEX = "MUTEX" + MilliSpender.getMillis();
        CHOICES_LINE_BY_LANG = new HashMap();
    }

    public static Color getColor(int stressLevel) {
        int ind = ArrayHelper.findIndexInArray(stressLevel, STRESS_INTS);
        return ind != -1 ? STRESS_COLORS[ind] : null;
    }

    public static String[] getLineStressChoices() {
        String lang = ProcessDefinition.isClient() ? UserManager.getUser().getString("USR_LANGUAGE", "en") : "en";
        String[] choices = (String[])CHOICES_LINE_BY_LANG.get(lang);
        if (choices == null) {
            int[] masterArray = STRESS_INTS_OHNE_NOT_DEF;
            choices = new String[masterArray.length];
            int i = 0;
            while (i < masterArray.length) {
                int ind = ArrayHelper.findIndexInArray(masterArray[i], STRESS_INTS);
                choices[i] = Babel.get(STRESS_BABELS[ind]);
                ++i;
            }
            CHOICES_LINE_BY_LANG.put(lang, choices);
        }
        return choices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMouseFromStressMissingListe(Mouse mouse) {
        String string = REPORT_MUTEX;
        synchronized (string) {
            String meins;
            int ind;
            String path = GroupFileManager.getKilledWithoutStressInputPath(mouse.getGroup());
            String rep = FileManager.getStringFromFile(path);
            if (rep != null && (ind = rep.indexOf(meins = String.valueOf(mouse.getID()) + "\n")) != -1) {
                FileManager.saveStringToFile(path, rep.substring(0, ind));
                FileManager.pureAppend(path, rep.substring(ind + meins.length(), rep.length()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handledKilledMouse(Mouse mouse, Hashtable objectBag) {
        if (TierSchutz.belastungNeeded() && Stress.isDeathStressInputNecessary(mouse, objectBag) && mouse.getMouseDeathStressLevel() == 0) {
            String path = GroupFileManager.getKilledWithoutStressInputPath(mouse.getGroup());
            String string = REPORT_MUTEX;
            synchronized (string) {
                FileManager.pureAppend(path, String.valueOf(mouse.getID()) + "\n");
            }
        }
    }

    public static boolean isDeathStressInputNecessary(Mouse mouse, Hashtable objectBag) {
        if (mouse.existed() && mouse.getMouseDeathStressLevel() == 0) {
            int licNummer = 1;
            while (licNummer <= 2) {
                License license;
                long licID = mouse.getLicenseID(licNummer, 0L);
                if (licID != 0L && (license = (License)ObjectStore.getObjectDeadOrAlive(16, licID, mouse.getGroup(), objectBag, false)) != null && license.needsMausBelastung()) {
                    return true;
                }
                ++licNummer;
            }
            License license = (License)ObjectStore.getObjectDeadOrAlive(16, mouse.getLong("MOS_LINLICID", 0L), mouse.getGroup(), objectBag, false);
            if (license != null && license.needsMausBelastung()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMiceWithMissingStressReport(String group) {
        boolean hadProblems = false;
        StringBuilder realMissingMiceIDs = new StringBuilder();
        String path = GroupFileManager.getKilledWithoutStressInputPath(group);
        String s = null;
        String string = REPORT_MUTEX;
        synchronized (string) {
            s = FileManager.getStringFromFile(path);
        }
        if (s != null && s.length() != 0) {
            Iterator iterator = StringHelper.splitStringByAny(s, "\n").iterator();
            while (iterator.hasNext()) {
                String mouseIDString = ((String)iterator.next()).trim();
                if (mouseIDString.length() == 0) continue;
                try {
                    Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, Long.parseLong(mouseIDString), group, null, false);
                    if (mouse != null) {
                        if (Stress.isDeathStressInputNecessary(mouse, null) && mouse.getMouseDeathStressLevel() == 0) {
                            realMissingMiceIDs.append(mouseIDString).append("\n");
                            continue;
                        }
                        hadProblems = true;
                        continue;
                    }
                    hadProblems = true;
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.usergroup.UserGroup");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problems while initializing missing stress mice", e, clazz);
                }
            }
        }
        String erg = realMissingMiceIDs.toString();
        if (hadProblems) {
            String string2 = REPORT_MUTEX;
            synchronized (string2) {
                FileManager.saveStringToFile(path, erg);
            }
        }
        return erg;
    }

    public static String getMiceIDsWithMissingStressClientSide(String group) {
        int[] arr = new int[]{2, 2};
        return (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, arr, group);
    }
}

