/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.line.KnubbelSelector;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.LAEvaluationReport;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierschutzReportD1Action;
import mausoleum.mouse.tierschutz.TierschutzReportD2Action;
import mausoleum.rack.Rack;
import mausoleum.requester.result.SpecialResultRequester;
import mausoleum.result.MResult;
import mausoleum.result.SpecialResultHelper;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.result.tierschutz.MResTSDWurfBeurteilung;
import mausoleum.room.Room;
import mausoleum.task.standards.StandardTask;
import mausoleum.util.SortablePoint;
import mausoleum.util.Standards;

public abstract class TierSchutzDeutsch1 {
    private static final int EVAL_TYPE_WURF_BEURTEILUNG = 1;
    private static final int EVAL_TYPE_ABSETZ_BEURTEILUNG = 2;
    private static final int EVAL_TYPE_EINZELTIER_BEURTEILUNG = 4;
    private static final int EVAL_TYPE_WURF_BEURTEILUNG_DONE = 32;
    private static final int EVAL_TYPE_ABSETZ_BEURTEILUNG_DONE = 64;
    private static final int EVAL_TYPE_EINZELTIER_BEURTEILUNG_DONE = 128;
    private static final int[] EVAL_TYPES = new int[]{1, 2, 4, 32, 64, 128};
    private static final String[] EVAL_BABELS = new String[]{"TS_EVAL_D1_WURFBEURTEILUNG", "TS_EVAL_D1_ABSETZBEURTEILUNG", "TS_EVAL_D1_BEURTEILUNG_EINZELTIER", "TS_EVAL_D1_WURFBEURTEILUNG_DONE", "TS_EVAL_D1_ABSETZBEURTEILUNG_DONE", "TS_EVAL_D1_BEURTEILUNG_EINZELTIER_DONE"};
    private static final int[] SELECTABLE_EVAL_TYPES = new int[]{1, 2};
    public static final String COM_VERSUCHSTIERMELDUNG_REPORT = "LICA_VERSUCHSTIERMELDUNG_REPORT";
    public static final String COM_BELASTUNGS_REPORT = "LINA_BELASTUNGS_REPORT";
    public static final String COM_LINE_EVAL_REPORT = "LINA_EVAL_REPORT";
    private static final String[] EVAL_STATUS = new String[]{"TS_EVAL_D1_UNDEFINED", "TS_EVAL_D1_ACTIVE", "TS_EVAL_D1_DONE"};
    private static final String[] SET_EVAL_TYPES = new String[]{"TS_EVAL_D1_WURFBEURTEILUNG", "TS_EVAL_D1_ABSETZBEURTEILUNG", "TS_EVAL_D1_BEURTEILUNG_EINZELTIER"};
    private static final int[] EVAL_TYPES_ACTIVE = new int[]{1, 2, 4};
    private static final int[] EVAL_TYPES_DONE = new int[]{32, 64, 128};

    public static boolean belastungNeeded() {
        return true;
    }

    public static Vector getMiceWithStressInputNeeded(Vector mice, Hashtable objectBag) {
        Vector<Mouse> res = new Vector<Mouse>();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            if (!Stress.isDeathStressInputNecessary(mouse, objectBag)) continue;
            res.add(mouse);
        }
        return res.isEmpty() ? null : res;
    }

    public static boolean isInputPflichtigerTodesModus(int modus) {
        return modus == 4 || modus == 5 || modus == 8;
    }

    public static boolean isLineEvaluationPossible() {
        return true;
    }

    public static boolean hasEmbryoTransfer() {
        return true;
    }

    public static String getEvaluationDescr(int type) {
        StringBuilder msb = new StringBuilder();
        int i = 0;
        while (i < EVAL_TYPES.length) {
            if ((type & EVAL_TYPES[i]) != 0) {
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                msb.append(Babel.get(EVAL_BABELS[i]));
            }
            ++i;
        }
        return msb.toString();
    }

    public static int[] getSelectableEvaluationTypes() {
        return SELECTABLE_EVAL_TYPES;
    }

    public static HashMap getPresetValuesForAllMice(Vector mice) {
        String commonGroup;
        if (mice != null && !mice.isEmpty() && (commonGroup = IDObject.commonGroup(mice)) != null) {
            String aktBes;
            Room room;
            Mouse mouse = (Mouse)mice.firstElement();
            HashMap<Integer, Object> res = new HashMap<Integer, Object>(2);
            Long lineID = (Long)mouse.get("MOS_LINEID");
            if (lineID != null) {
                Iterator iterator = mice.iterator();
                while (iterator.hasNext()) {
                    mouse = (Mouse)iterator.next();
                    if (lineID.equals(mouse.get("MOS_LINEID"))) continue;
                    return null;
                }
                Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, commonGroup, null, false);
                if (line != null) {
                    res.put(new Integer(9), line.get("LIN_EXPROPS", ""));
                }
            }
            if ((room = mouse.getRoom()) != null && (aktBes = room.getString("ROM_BBS", null)) != null) {
                res.put(new Integer(6), aktBes);
            }
            return res.isEmpty() ? null : res;
        }
        return null;
    }

    public static Vector getPresetValuesForEachMouse(Vector mice) {
        if (mice != null && !mice.isEmpty()) {
            Vector<HashMap> res = new Vector<HashMap>(mice.size());
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse maus = (Mouse)iterator.next();
                res.add(TierSchutzDeutsch1.getBelastungsResVorspann(maus));
            }
            return res;
        }
        return null;
    }

    private static boolean istUnterBeobachtung(Mouse weibchen, int beobachtungsType, MResult embryoTransferResult) {
        if (weibchen != null) {
            if (embryoTransferResult != null) {
                Line line;
                MResEmbryoTransfer embryoTransfer = null;
                if (embryoTransferResult != null && (embryoTransfer = new MResEmbryoTransfer((String)embryoTransferResult.ivResult)) != null && (line = (Line)ObjectStore.getObjectDeadOrAlive(7, embryoTransfer.ivLineID, weibchen.getGroup(), null, false)) != null) {
                    return TierSchutzDeutsch1.istUnterBeobachtung(line, beobachtungsType);
                }
            } else {
                return TierSchutzDeutsch1.istUnterBeobachtung(weibchen.getLine(), beobachtungsType);
            }
        }
        return false;
    }

    private static boolean istUnterBeobachtung(Line line, int beobachtungsType) {
        if (line != null) {
            return TierSchutzDeutsch1.istUnterBeobachtung(line.getInt("LIN_EVAL", 0), beobachtungsType);
        }
        return false;
    }

    private static boolean istUnterBeobachtung(int evalType, int beobachtungsType) {
        return (evalType & beobachtungsType) != 0;
    }

    public static int getLineEvaluationStatusToSet(int evalTypeSoFar, int defVal) {
        Vector<String> rowNames = new Vector<String>(3);
        int i = 0;
        while (i < SET_EVAL_TYPES.length) {
            rowNames.add(Babel.get(SET_EVAL_TYPES[i]));
            ++i;
        }
        Vector<String> colNames = new Vector<String>(3);
        int i2 = 0;
        while (i2 < EVAL_STATUS.length) {
            colNames.add(Babel.get(EVAL_STATUS[i2]));
            ++i2;
        }
        Vector selPoints = new Vector(3);
        TierSchutzDeutsch1.addSelPoint(evalTypeSoFar, 1, 32, 0, selPoints);
        TierSchutzDeutsch1.addSelPoint(evalTypeSoFar, 2, 64, 1, selPoints);
        TierSchutzDeutsch1.addSelPoint(evalTypeSoFar, 4, 128, 2, selPoints);
        KnubbelSelector sls = new KnubbelSelector("LINE_EVALUATION", colNames, rowNames, selPoints);
        KnubbelSelector.KnubbelSelectorDialog sld = new KnubbelSelector.KnubbelSelectorDialog(sls, "TS_LINE_SELECT_EVALUATION_REPORTS");
        if (sld.ivWarOK) {
            int sum = 0;
            int row = 0;
            while (row < rowNames.size()) {
                int col = sls.getSelectedCol(row, -1);
                if (col == 1) {
                    sum += EVAL_TYPES_ACTIVE[row];
                } else if (col == 2) {
                    sum += EVAL_TYPES_DONE[row];
                }
                ++row;
            }
            return sum;
        }
        return defVal;
    }

    private static void addSelPoint(int evalTypeSoFar, int typ1, int typ2, int row, Vector target) {
        if (TierSchutzDeutsch1.istUnterBeobachtung(evalTypeSoFar, typ1)) {
            target.add(new SortablePoint(1, row));
        } else if (TierSchutzDeutsch1.istUnterBeobachtung(evalTypeSoFar, typ2)) {
            target.add(new SortablePoint(2, row));
        } else {
            target.add(new SortablePoint(0, row));
        }
    }

    public static boolean makeLitterProcedure(Mouse weibchen, Mouse maennchen, int anzGeboren, long millis, MResult embryoTransferResult) {
        if (TierSchutzDeutsch1.istUnterBeobachtung(weibchen, 1, embryoTransferResult)) {
            Vector<Mouse> mice = new Vector<Mouse>(1);
            mice.add(weibchen);
            HashMap pv = TierSchutzDeutsch1.getBelastungsResVorspann(weibchen, weibchen, maennchen, millis, embryoTransferResult);
            Integer bornCount = new Integer(anzGeboren);
            pv.put(new Integer(22), bornCount);
            pv.put(new Integer(21), weibchen.getGenerationString(true));
            pv.put(SpecialResultHelper.MAX_COUNT_KEY, bornCount);
            String no1babel = "CANCEL";
            String no2babel = "PROCEED_WITHOUT_EVALUATION";
            SpecialResultRequester srr = new SpecialResultRequester(Inspector.getInspector(), MResTSDWurfBeurteilung.INSTANCE, null, mice, "TS_EVAL_D1_WURFBEURTEILUNG_LONG", MyDate.getTage(millis), pv, embryoTransferResult != null ? null : TierSchutzDeutsch1.getPresetValuesForEachMouse(mice), false, "USE_EVALUATION", no1babel, no2babel, FontManager.getFont("SSB16"));
            if (srr.ivWarOK) {
                if (srr.ivWarOK && srr.ivCommands != null) {
                    RequestManager.sendCommandRequestAndGetAnswer(srr.ivCommands, srr.ivGroups, srr.ivExtraObjects);
                }
            } else {
                if (no1babel.equals(srr.ivNoButtonBabelIfPressed)) {
                    return false;
                }
                return no2babel.equals(srr.ivNoButtonBabelIfPressed);
            }
        }
        return true;
    }

    public static void registerLicenseActions() {
        IAManager.register(COM_VERSUCHSTIERMELDUNG_REPORT, new TierschutzReportD1Action());
    }

    public static String[] enrichLicenseActions(String[] orig) {
        if (ProcessDefinition.isClient() && Privileges.hasPrivilege("LIC_SHOW_TS_REPORTS")) {
            return ArrayHelper.enlargeStringArray(orig, COM_VERSUCHSTIERMELDUNG_REPORT);
        }
        return orig;
    }

    public static void registerLineActions() {
        IAManager.register(COM_BELASTUNGS_REPORT, new TierschutzReportD2Action());
        IAManager.register(COM_LINE_EVAL_REPORT, new LAEvaluationReport());
    }

    public static String[] enrichLineActions(String[] orig) {
        if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) {
            if (Privileges.hasPrivilege("LIN_SHOW_TS_REPORTS")) {
                return ArrayHelper.enlargeStringArray(orig, new String[]{COM_LINE_EVAL_REPORT, COM_BELASTUNGS_REPORT});
            }
            return ArrayHelper.enlargeStringArray(orig, new String[]{COM_LINE_EVAL_REPORT});
        }
        return orig;
    }

    public static HashMap getBelastungsResVorspann(Mouse hauptMaus) {
        Date bd = hauptMaus.getDate("MOS_BIRTHDAY");
        return TierSchutzDeutsch1.getBelastungsResVorspann(hauptMaus, hauptMaus.getMother(), hauptMaus.getFather(), bd == null ? -1L : bd.getTime(), null);
    }

    public static HashMap getBelastungsResVorspann(Mouse hauptMaus, Mouse mutter, Mouse vater, long gebTagMillis, MResult embryoTransferResult) {
        String rackpos;
        String aktBes;
        Room room;
        Rack rack;
        HashMap<Integer, Object> pv = new HashMap<Integer, Object>();
        MResEmbryoTransfer embryoTransfer = null;
        if (embryoTransferResult != null) {
            embryoTransfer = new MResEmbryoTransfer((String)embryoTransferResult.ivResult);
            mutter = null;
            vater = null;
        }
        if (embryoTransfer == null) {
            pv.put(new Integer(4), hauptMaus.getPrimaryOwnerName("", null));
        }
        if ((rack = hauptMaus.getRack()) != null) {
            pv.put(new Integer(1), rack.getLongID());
        }
        Line line = null;
        line = embryoTransfer != null ? (Line)ObjectStore.getObjectDeadOrAlive(7, embryoTransfer.ivLineID, hauptMaus.getGroup(), null, false) : hauptMaus.getLine();
        if (line != null) {
            pv.put(new Integer(0), line.getLongID());
            pv.put(new Integer(9), line.getString("LIN_EXPROPS", ""));
        }
        if ((room = hauptMaus.getRoom()) != null && (aktBes = room.getString("ROM_BBS", null)) != null) {
            pv.put(new Integer(6), aktBes);
        }
        Building building = room != null ? room.getBuilding() : null;
        StringBuilder msb = new StringBuilder();
        if (building != null) {
            msb.append(building.getBrowseNameWITHOUTServicePrefix());
        }
        if (room != null) {
            if (msb.length() != 0) {
                msb.append(" / ");
            }
            msb.append(room.getBrowseNameWITHOUTServicePrefix());
        }
        if ((rackpos = hauptMaus.getRackAndPosName()) != null && rackpos.trim().length() != 0) {
            rackpos = StringHelper.gSub(rackpos, "[S] ", "", true);
            if (msb.length() != 0) {
                msb.append(" / ");
            }
            msb.append(rackpos);
        }
        pv.put(new Integer(2), msb.toString());
        if (embryoTransfer != null) {
            pv.put(new Integer(10), IndexObject.getDisplayString(embryoTransfer.ivStrains, hauptMaus.getGroup(), 8, false, false, true));
        } else {
            pv.put(new Integer(10), StringHelper.gSub(hauptMaus.getCLLWStrainString(), "[S] ", "", true));
        }
        if (mutter != null) {
            pv.put(new Integer(11), mutter.getIDStringForReports(false));
        }
        if (vater != null) {
            pv.put(new Integer(12), vater.getIDStringForReports(false));
        }
        if (gebTagMillis != -1L) {
            pv.put(new Integer(13), new Long(gebTagMillis));
        }
        return pv;
    }

    public static String[] getSpecialTaskDefLines() {
        return StandardTask.SYSTEM_TASK_DEF_TIERSCHUTZ_LINES_D;
    }

    public static void fillPeriodPrefsOfSystemTasks(HashMap perFreqs, HashMap perEnds) {
        Integer key = new Integer(101);
        perFreqs.put(key, new Integer(35));
        perEnds.put(key, new Integer(1825));
    }

    public static boolean isMultiInputAllowed(long expID) {
        return expID != -44L && expID != -45L && expID != -43L;
    }

    public static boolean isForcedStressReportInputPossible(License license) {
        return license.isTierversuchsLicense() || license.isLineLicense();
    }

    public static void makeAfterLitterProcedure(String group, Vector pupIDs, long litterMillis, long pupLineID) {
        Line line;
        Line line2 = line = pupLineID <= 0L ? null : (Line)ObjectStore.getObjectDeadOrAlive(7, pupLineID, group, null, false);
        if (line != null && TierSchutzDeutsch1.istUnterBeobachtung(line, 2)) {
            Date weanDate = new Date();
            weanDate.setTime(litterMillis + Standards.getWeanPeriodInMillis());
            TaskExtended.addNewTasks(group, 1, weanDate, Integer.MIN_VALUE, "", 100, 0, "", 0, 0L, "", null, pupIDs, false);
        }
    }
}

