/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.util.MilliSpender;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.objectstore.IndexChecker;
import mausoleum.search.profisearch.searcher.MausoSearcherObject;

public class TierSchutzReportD1
implements Runnable,
IndexChecker {
    public static final String BIN_UNVERSORGT = "UNV";
    public static final String HAUPT_SCHUBLADEN = "ABCDE";
    public static final String NEBEN_SCHUBLADEN = "123";
    public static final String PREFIX = "TSRD1_";
    public static final String BIN_1 = "TSRD1_1";
    public static final String BIN_2 = "TSRD1_2";
    public static final String BIN_3 = "TSRD1_3";
    public static final String BIN_4 = "TSRD1_4";
    public static final String LICID_SUFF = "_LICIDS";
    public static final String INTERMEDIATE = "INTERMEDIATE";
    private static final String MUTEX = "MUTEX" + MilliSpender.getMillis();
    private static final HashMap RESULTS = new HashMap();
    private static TierSchutzReportD1 cvInstance = null;
    public String ivGroup;
    public int ivStartDate;
    public int ivEndDate;
    public int[] ivZArr;
    private String ivTicket;
    private HashMap ivBins = new HashMap();
    private Vector ivTVLicenseKeys = new Vector();
    private Vector ivHALicenseKeys = new Vector();
    private Hashtable ivObjectBag = new Hashtable();
    private boolean ivInUse = false;
    private HashSet ivLicIDSammlerTV = new HashSet();
    private HashSet ivLicIDSammlerHA = new HashSet();

    public static boolean handleRequest(ObjectRequest or, int[] modes) {
        String ticket = (String)or.ivExtraObject;
        or.ivObject = ticket == null ? TierSchutzReportD1.startTierSchutzReportD1(modes[2], modes[3], or.ivGroup) : TierSchutzReportD1.getResult(ticket);
        return or.ivObject != null;
    }

    private static synchronized String startTierSchutzReportD1(int start, int end, String group) {
        if (ProcessDefinition.isServer()) {
            if (cvInstance == null) {
                cvInstance = new TierSchutzReportD1();
            }
            if (!TierSchutzReportD1.cvInstance.ivInUse) {
                cvInstance.setValues(start, end, group);
                Thread thread = new Thread(cvInstance);
                thread.setPriority(1);
                thread.start();
                return TierSchutzReportD1.cvInstance.ivTicket;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResult(String ticket) {
        String res = (String)RESULTS.get(ticket);
        if (res != null) {
            RESULTS.remove(ticket);
            return res;
        }
        if (cvInstance != null) {
            StringBuilder msb = new StringBuilder(INTERMEDIATE);
            String string = MUTEX;
            synchronized (string) {
                Iterator iterator = TierSchutzReportD1.cvInstance.ivBins.keySet().iterator();
                while (iterator.hasNext()) {
                    String bin = (String)iterator.next();
                    if (bin.endsWith(LICID_SUFF)) continue;
                    msb.append("|").append(bin).append(",");
                    HashSet hs = (HashSet)TierSchutzReportD1.cvInstance.ivBins.get(bin);
                    msb.append(hs.size());
                }
            }
            return msb.toString();
        }
        return null;
    }

    private void setValues(int start, int end, String group) {
        this.ivStartDate = start;
        this.ivEndDate = end;
        this.ivGroup = group;
        this.ivInUse = true;
        this.ivTicket = "TSRD1" + MilliSpender.getMillis();
        this.clear();
        Iterator iterator = ObjectStoreServer.getActualObjects(16, group).iterator();
        while (iterator.hasNext()) {
            License license = (License)iterator.next();
            Vector target = license.isHaltungsLicense() ? this.ivHALicenseKeys : this.ivTVLicenseKeys;
            String key = license.getLongID().toString();
            target.add(new String[]{key, String.valueOf(key) + "|", "|" + key, "|" + key + "|"});
        }
    }

    public void run() {
        IntermediaerHelfer.giveIndicesToChecker(this, this.ivGroup);
        RESULTS.put(this.ivTicket, IDObjectXMLHandler.getTransport(this.ivBins, true, true));
        this.clear();
        this.ivInUse = false;
    }

    private void clear() {
        this.ivHALicenseKeys.clear();
        this.ivTVLicenseKeys.clear();
        Iterator iterator = this.ivBins.values().iterator();
        while (iterator.hasNext()) {
            HashSet bin = (HashSet)iterator.next();
            bin.clear();
        }
        this.ivObjectBag.clear();
    }

    public void checkIndex(Long id, String index) {
        this.ivZArr = Zeile.getTrenner(index, IntermediaerHelfer.getIndexSeparator(), '\u0000', this.ivZArr);
        int todesDatum = Zeile.getInt(index, this.ivZArr, '\u0000', IntermediaerHelfer.getEndCol(), -1);
        if (todesDatum >= this.ivStartDate && todesDatum <= this.ivEndDate) {
            boolean versorgt = false;
            Mouse mouse = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, id, this.ivGroup, null, false, false);
            if (mouse != null) {
                this.ivLicIDSammlerTV.clear();
                this.ivLicIDSammlerHA.clear();
                String licenses = Zeile.getStringNonEmpty(index, IntermediaerHelfer.getLicenseCol(), null, this.ivZArr, '\u0000');
                if (licenses == null || licenses.trim().length() == 0) {
                    versorgt = this.distributeBin1(mouse);
                } else {
                    int tv = this.countLic(licenses, this.ivTVLicenseKeys, this.ivLicIDSammlerTV);
                    int ha = this.countLic(licenses, this.ivHALicenseKeys, this.ivLicIDSammlerHA);
                    if (ha == 1 && tv == 0) {
                        versorgt = this.distributeBin2(mouse, this.ivLicIDSammlerHA);
                    } else if (tv == 1) {
                        versorgt = this.distributeBin34b(mouse, this.ivLicIDSammlerTV);
                    } else if (tv > 1) {
                        versorgt = this.addToBin(BIN_4 + HAUPT_SCHUBLADEN.charAt(0), id, null);
                    }
                }
            }
            if (!versorgt) {
                this.addToBin(BIN_UNVERSORGT, id, null);
            }
        }
    }

    private int countLic(String lic, Vector possLic, HashSet licIDSammler) {
        int sum = 0;
        Iterator iterator = possLic.iterator();
        while (iterator.hasNext()) {
            String[] larr = (String[])iterator.next();
            if (!lic.equals(larr[0]) && !lic.startsWith(larr[1]) && !lic.endsWith(larr[2]) && !lic.contains(larr[3])) continue;
            licIDSammler.add(new Long(larr[0]));
            ++sum;
        }
        return sum;
    }

    private int get13HauptSchublade(Mouse mouse) {
        Line line = this.getLine(mouse);
        if (line != null) {
            if (line.isBreeder()) {
                return 0;
            }
            LocusAndAlleles[] lalArr = (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
            boolean pureWT = MausoSearcherObject.SearcherGenotype.isPureWildType(mouse, (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES"), line, (LocusAndAlleles[])line.get("LIN_LOCIALLELES"));
            if (pureWT) {
                return 1;
            }
            if (lalArr != null) {
                int stress = StressRule.getStress(line, mouse.getSex(), StressRule.getAge(mouse), lalArr);
                if (stress == 0) {
                    return 2;
                }
                return 3;
            }
        }
        return 4;
    }

    private boolean distributeBin1(Mouse mouse) {
        int deathMode = mouse.getInt("MOS_ENDMODE", 0);
        if (deathMode == 5) {
            return this.addToBin(BIN_1 + HAUPT_SCHUBLADEN.charAt(this.get13HauptSchublade(mouse)), mouse.getLongID(), null);
        }
        return false;
    }

    private int getNebenSchublade(int stress) {
        switch (stress) {
            case 0: 
            case 10: 
            case 20: {
                return 0;
            }
            case 30: {
                return 1;
            }
            case 40: {
                return 2;
            }
        }
        return 3;
    }

    private boolean distributeBin2(Mouse mouse, HashSet licidSammler) {
        int deathMode = mouse.getInt("MOS_ENDMODE", 0);
        if (deathMode == 5 || deathMode == 8) {
            Line line = this.getLine(mouse);
            if (line != null) {
                return this.addToBin(BIN_2 + HAUPT_SCHUBLADEN.charAt(this.getNebenSchublade(mouse.getMaxStoredStressLevel())), mouse.getLongID(), licidSammler);
            }
            return this.addToBin(BIN_2 + HAUPT_SCHUBLADEN.charAt(3), mouse.getLongID(), licidSammler);
        }
        return false;
    }

    private boolean distributeBin34b(Mouse mouse, HashSet licidSammler) {
        int deathMode = mouse.getInt("MOS_ENDMODE", 0);
        if (deathMode == 4) {
            return this.addToBin(BIN_4 + HAUPT_SCHUBLADEN.charAt(1), mouse.getLongID(), licidSammler);
        }
        if (deathMode == 5 || deathMode == 8) {
            int hauptschublade = this.get13HauptSchublade(mouse);
            int nebenSchublade = this.getNebenSchublade(mouse.getMaxStoredStressLevel());
            String bin = BIN_3 + HAUPT_SCHUBLADEN.charAt(hauptschublade);
            if (hauptschublade < 4) {
                bin = String.valueOf(bin) + NEBEN_SCHUBLADEN.charAt(nebenSchublade);
            }
            return this.addToBin(bin, mouse.getLongID(), licidSammler);
        }
        return false;
    }

    private Line getLine(Mouse mouse) {
        return (Line)ObjectStoreServer.getObjectDeadOrAlive(7, mouse.getLong("MOS_LINEID", 0L), this.ivGroup, this.ivObjectBag, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToBin(String key, Long id, HashSet licIDSammler) {
        HashSet<Long> hs = (HashSet<Long>)this.ivBins.get(key);
        if (hs == null) {
            String string = MUTEX;
            synchronized (string) {
                hs = new HashSet<Long>();
                this.ivBins.put(key, hs);
            }
        }
        hs.add(id);
        if (licIDSammler != null && licIDSammler.size() == 1) {
            String key2 = TierSchutzReportD1.getLicenseIDSTring(key);
            HashSet<String> hs2 = (HashSet<String>)this.ivBins.get(key2);
            if (hs2 == null) {
                String string = MUTEX;
                synchronized (string) {
                    hs2 = new HashSet<String>();
                    this.ivBins.put(key2, hs2);
                }
            }
            Iterator iterator = licIDSammler.iterator();
            while (iterator.hasNext()) {
                Long licid = (Long)iterator.next();
                hs2.add(id + "," + licid);
            }
        }
        return true;
    }

    public static String getLicenseIDSTring(String binKey) {
        return String.valueOf(binKey) + LICID_SUFF;
    }

    public static HashMap interpretLicIDString(String binKey, HashMap repHM) {
        HashSet hs = (HashSet)repHM.get(TierSchutzReportD1.getLicenseIDSTring(binKey));
        if (hs != null && !hs.isEmpty()) {
            HashMap<Long, HashSet<Long>> hm = new HashMap<Long, HashSet<Long>>();
            Iterator iterator = hs.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                int ind = s.indexOf(",");
                if (ind == -1) continue;
                try {
                    Long mouseID = new Long(s.substring(0, ind));
                    Long licID = new Long(s.substring(ind + 1, s.length()));
                    HashSet<Long> ths = (HashSet<Long>)hm.get(licID);
                    if (ths == null) {
                        ths = new HashSet<Long>();
                        hm.put(licID, ths);
                    }
                    ths.add(mouseID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hm;
        }
        return null;
    }
}

