/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.IndexChecker;
import mausoleum.result.MResult;
import mausoleum.result.SpecialResultHelper;

public class TierSchutzReportD2
implements Runnable,
IndexChecker {
    public static final String WAIT = "WAIT";
    public static final String[] SYMPTOM_ARR = TierSchutzReportD2.makeIDArray(-42L);
    public static final String[] WURF_ARR = TierSchutzReportD2.makeIDArray(-43L);
    public static final String[] ABSETZ_ARR = TierSchutzReportD2.makeIDArray(-44L);
    public static final String[] EINZELTIER_ARR = TierSchutzReportD2.makeIDArray(-45L);
    public static final String[] EMBRYO_TRANSFER_ARR = TierSchutzReportD2.makeIDArray(-46L);
    private static final HashMap RESULTS = new HashMap();
    private static final WritableCellFormat INT_FORMAT = new WritableCellFormat(new NumberFormat("0"));
    private static final WritableCellFormat DBL_FORMAT = new WritableCellFormat(new NumberFormat("0.0##"));
    private static final WritableCellFormat DATE_CELL_FRMT;
    private static TierSchutzReportD2 cvInstance;
    public String ivGroup;
    public String ivLineID;
    public String ivLang = "de";
    public int[] ivZArr;
    public int[] ivZArr2;
    private String ivTicket;
    private Hashtable ivObjectBag = new Hashtable();
    private boolean ivInUse = false;
    private ReportThemePack ivSymptomPack = new ReportThemePack();
    private ReportThemePack ivWurfPack = new ReportThemePack();
    private ReportThemePack ivAbsetzPack = new ReportThemePack();
    private ReportThemePack ivEinzeltierPack = new ReportThemePack();
    private final HashSet ivWurfExcludes = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        cvInstance = null;
        DateFormat df = new DateFormat("dd. MMM. yyyy");
        df.getDateFormat().setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_CELL_FRMT = new WritableCellFormat(df);
    }

    public static boolean handleRequest(ObjectRequest or, int[] modes) {
        String[] ticketAndLang = (String[])or.ivExtraObject;
        String ticket = ticketAndLang[0];
        or.ivObject = ticket == null ? TierSchutzReportD2.startTierSchutzReportD2(modes[2], or.ivGroup, ticketAndLang[1]) : TierSchutzReportD2.getResult(ticket);
        return or.ivObject != null;
    }

    private static synchronized String startTierSchutzReportD2(int lineID, String group, String lang) {
        if (ProcessDefinition.isServer()) {
            if (cvInstance == null) {
                cvInstance = new TierSchutzReportD2();
            }
            if (!TierSchutzReportD2.cvInstance.ivInUse) {
                cvInstance.setValues(lineID, group, lang);
                Thread thread = new Thread(cvInstance);
                thread.setPriority(1);
                thread.start();
                return TierSchutzReportD2.cvInstance.ivTicket;
            }
        }
        return null;
    }

    private static String getResult(String ticket) {
        String res = (String)RESULTS.get(ticket);
        if (res != null) {
            RESULTS.remove(ticket);
            return res;
        }
        if (cvInstance != null) {
            return WAIT;
        }
        return null;
    }

    private static String[] makeIDArray(long id) {
        return new String[]{String.valueOf(id), String.valueOf(id) + "|", "|" + id + "|", "|" + id};
    }

    private void setValues(int lineID, String group, String lang) {
        this.ivInUse = true;
        this.ivLineID = Integer.toString(lineID);
        this.ivGroup = group;
        this.ivTicket = "TSRD1" + MilliSpender.getMillis();
        this.ivLang = lang;
        this.prepareForNewRun();
    }

    public void run() {
        if (this.ivWurfExcludes.isEmpty()) {
            this.ivWurfExcludes.add(new Integer(11));
            this.ivWurfExcludes.add(new Integer(12));
            this.ivWurfExcludes.add(new Integer(13));
        }
        SpecialResultHelper.addOrderedTableKeys(SpecialResultHelper.getInstanceFor(-42L), this.ivLang, this.ivSymptomPack.ivCols, null);
        SpecialResultHelper.addOrderedTableKeys(SpecialResultHelper.getInstanceFor(-43L), this.ivLang, this.ivWurfPack.ivCols, this.ivWurfExcludes);
        SpecialResultHelper.addOrderedTableKeys(SpecialResultHelper.getInstanceFor(-44L), this.ivLang, this.ivAbsetzPack.ivCols, null);
        SpecialResultHelper.addOrderedTableKeys(SpecialResultHelper.getInstanceFor(-45L), this.ivLang, this.ivEinzeltierPack.ivCols, null);
        String repDir = String.valueOf(GroupFileManager.getReportsDir(this.ivGroup)) + "/tsd2";
        FileManager.prepareDirs(repDir);
        String filePath = String.valueOf(repDir) + "/Belastungsbeurteilung_" + new MyDate(new GregorianCalendar()).getDateTimeForFileName() + "_" + MilliSpender.getMillis() + ".xls";
        try {
            WritableWorkbook workbook = Workbook.createWorkbook(new File(filePath));
            this.createSheet(this.ivWurfPack, workbook, "TS_EVAL_D1_WURFBEURTEILUNG");
            this.createSheet(this.ivAbsetzPack, workbook, "TS_EVAL_D1_ABSETZBEURTEILUNG");
            this.createSheet(this.ivEinzeltierPack, workbook, "TS_EVAL_D1_BEURTEILUNG_EINZELTIER");
            this.createSheet(this.ivSymptomPack, workbook, "HR_TAB_TITLE");
            IntermediaerHelfer.giveIndicesToChecker(this, this.ivGroup);
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.mouse.tierschutz.TierSchutzReportD2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem writing TierschutzReportD2", e, clazz);
        }
        RESULTS.put(this.ivTicket, filePath);
        this.prepareForNewRun();
        this.ivInUse = false;
    }

    private void createSheet(ReportThemePack pack, WritableWorkbook workbook, String babel) throws Exception {
        WritableSheet sheet = workbook.createSheet(Babel.get(babel, this.ivLang), workbook.getNumberOfSheets());
        int col = 0;
        if (pack == this.ivWurfPack) {
            sheet.addCell(new Label(col++, 0, Babel.get("MOTHER", this.ivLang)));
            sheet.addCell(new Label(col++, 0, String.valueOf(Babel.get("GENOTYPE", this.ivLang)) + " " + Babel.get("MOTHER", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("FATHER", this.ivLang)));
            sheet.addCell(new Label(col++, 0, String.valueOf(Babel.get("GENOTYPE", this.ivLang)) + " " + Babel.get("FATHER", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("BIRTHDAY", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("HAD_14_DAYS", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("WITH_ABSETZ_REPORT", this.ivLang)));
        } else if (pack == this.ivSymptomPack) {
            sheet.addCell(new Label(col++, 0, Babel.get("SEXSHORT", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("MOUSE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("BIRTHDAY", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("GENOTYPE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("EVALUATION_DATE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, String.valueOf(Babel.get("AGE", this.ivLang)) + "[d]"));
        } else {
            sheet.addCell(new Label(col++, 0, Babel.get("SEXSHORT", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("MOUSE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("GENOTYPE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, Babel.get("EVALUATION_DATE", this.ivLang)));
            sheet.addCell(new Label(col++, 0, String.valueOf(Babel.get("AGE", this.ivLang)) + "[d]"));
        }
        int i = 0;
        while (i < pack.ivCols.size()) {
            sheet.addCell(new Label(col++, 0, (String)pack.ivCols.elementAt(i)));
            ++i;
        }
        pack.ivPerformerCol = col;
        sheet.addCell(new Label(col++, 0, Babel.get("PERFORMEDBY", this.ivLang)));
        pack.ivSheet = sheet;
    }

    private void prepareForNewRun() {
        this.ivSymptomPack.prepareForNewRun();
        this.ivWurfPack.prepareForNewRun();
        this.ivAbsetzPack.prepareForNewRun();
        this.ivEinzeltierPack.prepareForNewRun();
        this.ivObjectBag.clear();
    }

    public void checkIndex(Long id, String index) {
        try {
            this.ivZArr = Zeile.getTrenner(index, IntermediaerHelfer.getIndexSeparator(), '\u0000', this.ivZArr);
            String indexResultContent = Zeile.getString(index, IntermediaerHelfer.getResultsCol(), null, this.ivZArr, '\u0000');
            if (indexResultContent != null && indexResultContent.trim().length() != 0) {
                Mouse mouse = null;
                boolean hatEmbryoTransfer = TierSchutzReportD2.checkResultForSpec(indexResultContent, EMBRYO_TRANSFER_ARR);
                boolean resWurf = TierSchutzReportD2.checkResultForSpec(indexResultContent, WURF_ARR);
                boolean wurfAlreadyDone = false;
                if (hatEmbryoTransfer && resWurf) {
                    Vector v;
                    mouse = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, id, this.ivGroup, this.ivObjectBag, false, false);
                    if (mouse != null && (v = (Vector)mouse.get("MOS_MRESULTS")) != null) {
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            MResult mresult = (MResult)iter.next();
                            long expID = mresult.getExperimentID();
                            if (-43L != expID) continue;
                            String resRep = (String)mresult.ivResult;
                            this.ivZArr2 = Zeile.getTrenner(resRep, '|', '\u0000', this.ivZArr2);
                            if (!this.ivLineID.equals(Zeile.getString(resRep, 0, "", this.ivZArr2, '\u0000'))) continue;
                            this.handleDetails(this.ivWurfPack, mouse, mresult);
                        }
                    }
                    wurfAlreadyDone = true;
                } else {
                    wurfAlreadyDone = false;
                }
                if (this.ivLineID.equals(Zeile.getString(index, IntermediaerHelfer.getLineCol(), "", this.ivZArr, '\u0000'))) {
                    boolean resSymptom = TierSchutzReportD2.checkResultForSpec(indexResultContent, SYMPTOM_ARR);
                    boolean resAbsetz = TierSchutzReportD2.checkResultForSpec(indexResultContent, ABSETZ_ARR);
                    boolean resEinzeltier = TierSchutzReportD2.checkResultForSpec(indexResultContent, EINZELTIER_ARR);
                    if (resSymptom || resWurf || resAbsetz || resEinzeltier) {
                        Vector v;
                        if (mouse == null) {
                            mouse = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, id, this.ivGroup, this.ivObjectBag, false, false);
                        }
                        if (mouse != null && (v = (Vector)mouse.get("MOS_MRESULTS")) != null) {
                            Iterator iter = v.iterator();
                            while (iter.hasNext()) {
                                MResult mresult = (MResult)iter.next();
                                long expID = mresult.getExperimentID();
                                if (-42L == expID) {
                                    this.handleDetails(this.ivSymptomPack, mouse, mresult);
                                    continue;
                                }
                                if (!wurfAlreadyDone && -43L == expID) {
                                    this.handleDetails(this.ivWurfPack, mouse, mresult);
                                    continue;
                                }
                                if (-44L == expID) {
                                    this.handleDetails(this.ivAbsetzPack, mouse, mresult);
                                    continue;
                                }
                                if (-45L != expID) continue;
                                this.handleDetails(this.ivEinzeltierPack, mouse, mresult);
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            String string = "Problem checking index " + index + " for ID " + id;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.mouse.tierschutz.TierSchutzReportD2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    public static boolean checkResultForSpec(String cont, String[] arr) {
        return cont.equals(arr[0]) || cont.startsWith(arr[1]) || cont.endsWith(arr[2]) || cont.contains(arr[3]);
    }

    private void handleDetails(ReportThemePack pack, Mouse mouse, MResult mresult) {
        Object[] res = SpecialResultHelper.getTableRepresentation(mresult.ivResult.toString(), null, SpecialResultHelper.getInstanceFor(mresult.getExperimentID()), this.ivGroup, this.ivLang, false, false);
        try {
            int pcol = 0;
            if (pack == this.ivWurfPack) {
                boolean isIndirectByEmbryoTransfer = false;
                String resRep = (String)mresult.ivResult;
                int[] zarr = Zeile.getTrenner(resRep, '|', '\u0000', null);
                String mutterTag = Zeile.getString(resRep, 11, null, zarr, '\u0000');
                if (mutterTag == null || mutterTag.trim().length() == 0) {
                    isIndirectByEmbryoTransfer = true;
                }
                String na = Babel.get("BEL_BEURT_NA_ET", this.ivLang);
                Mouse father = null;
                int anz14Tage = -1;
                int anzAbsatzbeurteilt = -1;
                if (!isIndirectByEmbryoTransfer) {
                    anz14Tage = 0;
                    anzAbsatzbeurteilt = 0;
                    int[] bdarr = (int[])mouse.get("MOS_KID_BD");
                    long[] oparr = (long[])mouse.get("MOS_KID_OP");
                    long[] kids = (long[])mouse.get("MOS_KID");
                    if (bdarr != null && oparr != null && bdarr.length == oparr.length) {
                        int i = 0;
                        while (i < bdarr.length) {
                            if (bdarr[i] == mresult.ivDate) {
                                Mouse kid;
                                if (father == null) {
                                    father = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, oparr[i], this.ivGroup, this.ivObjectBag, false, false);
                                }
                                if ((kid = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, kids[i], this.ivGroup, this.ivObjectBag, false, false)) != null) {
                                    Vector v2;
                                    if (kid.getAgeInDays(-1) > 14) {
                                        ++anz14Tage;
                                    }
                                    if ((v2 = (Vector)kid.get("MOS_MRESULTS")) != null) {
                                        boolean had = false;
                                        Iterator iterator = v2.iterator();
                                        while (iterator.hasNext() && !had) {
                                            MResult mres = (MResult)iterator.next();
                                            if (mres.getExperimentID() != -44L) continue;
                                            had = true;
                                            ++anzAbsatzbeurteilt;
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (isIndirectByEmbryoTransfer) {
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                } else {
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, mouse.getIDStringForReports(false)));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, mouse.getGenotype("")));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, father == null ? "" : father.getIDStringForReports(false)));
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, father == null ? "" : father.getGenotype("")));
                }
                TierSchutzReportD2.addDate(pack.ivSheet, pcol++, pack.ivRow, mresult.ivDate);
                if (anz14Tage >= 0) {
                    TierSchutzReportD2.addInteger(pack.ivSheet, pcol++, pack.ivRow, new Integer(anz14Tage));
                } else {
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                }
                if (anzAbsatzbeurteilt >= 0) {
                    TierSchutzReportD2.addInteger(pack.ivSheet, pcol++, pack.ivRow, new Integer(anzAbsatzbeurteilt));
                } else {
                    pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, na));
                }
            } else {
                pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, mouse.getCLLWSexString("?")));
                pack.ivSheet.addCell(new Label(pcol++, pack.ivRow, mouse.getIDStringForReports(false)));
                Date birthday = mouse.getDate("MOS_BIRTHDAY");
                if (pack == this.ivSymptomPack && birthday != null) {
                    TierSchutzReportD2.addDate(pack.ivSheet, pcol++, pack.ivRow, (int)(birthday.getTime() / 86400000L));
                }
                int n = ++pcol;
                pack.ivSheet.addCell(new Label(n, pack.ivRow, mouse.getGenotype("")));
                int n2 = ++pcol;
                ++pcol;
                TierSchutzReportD2.addDate(pack.ivSheet, n2, pack.ivRow, mresult.ivDate);
                int diff = -1;
                if (birthday != null) {
                    diff = mresult.ivDate - (int)(birthday.getTime() / 86400000L);
                }
                if (diff > 0) {
                    pack.ivSheet.addCell(new Number(pcol++, pack.ivRow, (double)diff));
                } else {
                    ++pcol;
                }
            }
            if (res != null) {
                int i = 0;
                while (i < res.length) {
                    Object col = res[i];
                    int ind = pack.ivCols.indexOf(col);
                    if (ind != -1) {
                        if (res[i + 1] instanceof String) {
                            TierSchutzReportD2.addString(pack.ivSheet, ind + pcol, pack.ivRow, (String)res[i + 1]);
                        } else if (res[i + 1] instanceof Integer) {
                            TierSchutzReportD2.addInteger(pack.ivSheet, ind + pcol, pack.ivRow, (Integer)res[i + 1]);
                        } else if (res[i + 1] instanceof Double) {
                            TierSchutzReportD2.addDouble(pack.ivSheet, ind + pcol, pack.ivRow, (Double)res[i + 1]);
                        } else if (res[i + 1] instanceof MyDate) {
                            TierSchutzReportD2.addDate(pack.ivSheet, ind + pcol, pack.ivRow, (MyDate)res[i + 1]);
                        }
                    }
                    i += 2;
                }
            }
            if (pack.ivPerformerCol != -1 && mresult.ivPerformer != null) {
                TierSchutzReportD2.addString(pack.ivSheet, pack.ivPerformerCol, pack.ivRow, mresult.ivPerformer);
            }
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.mouse.tierschutz.TierSchutzReportD2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem handling details", e, clazz);
        }
        ReportThemePack reportThemePack = pack;
        reportThemePack.ivRow = reportThemePack.ivRow + 1;
    }

    private static void addString(WritableSheet sheet, int col, int row, String s) throws Exception {
        sheet.addCell(new Label(col, row, s));
    }

    private static void addInteger(WritableSheet sheet, int col, int row, Integer i) throws Exception {
        sheet.addCell(new Number(col, row, i.doubleValue(), (CellFormat)INT_FORMAT));
    }

    private static void addDouble(WritableSheet sheet, int col, int row, Double d) throws Exception {
        sheet.addCell(new Number(col, row, d, (CellFormat)DBL_FORMAT));
    }

    private static void addDate(WritableSheet sheet, int col, int row, MyDate md) throws Exception {
        sheet.addCell(new DateTime(col, row, new Date(md.getTime()), (CellFormat)DATE_CELL_FRMT));
    }

    private static void addDate(WritableSheet sheet, int col, int row, int tage) throws Exception {
        sheet.addCell(new DateTime(col, row, new Date((long)tage * 86400000L), (CellFormat)DATE_CELL_FRMT));
    }

    public static class ReportThemePack {
        private Vector ivCols = new Vector();
        private WritableSheet ivSheet = null;
        private int ivRow = 1;
        private int ivPerformerCol = -1;

        public void prepareForNewRun() {
            this.ivCols.clear();
            this.ivSheet = null;
            this.ivRow = 1;
            this.ivPerformerCol = -1;
        }
    }
}

