/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.util.HashMap;
import java.util.Iterator;
import mausoleum.helper.Zeile;
import mausoleum.objectstore.CommandManagerRack;
import mausoleum.objectstore.DocMoveManager;
import mausoleum.objectstore.ObjectExtractor;
import mausoleum.objectstore.QuotableIDObject;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public class CommandManagerAllgemein
extends CommandManagerExecutive {
    public static final String COM_ALLG_ADD_DOC = "ALLG_ADD_DOC";
    public static final String COM_ALLG_GET_DOC = "ALLG_GET_DOC";
    public static final String COM_ALLG_REM_DOC = "ALLG_REM_DOC";
    public static final String COM_ALLG_SET_FOREIGN_ID = "SET_FOREIGN_ID";
    public static final String COM_ALLG_IMPORT_TO_SERVICE = "ALLG_IMPORT_TO_SERVICE";
    public static final String COM_ALLG_DETACH_FROM_SERVICE = "ALLG_DETACH_FROM_SERVICE";
    public static final String COM_ALLG_ATTACH_TO_SERVICE = "ALLG_ATTACH_TO_SERVICE";
    static /* synthetic */ Class class$0;

    public CommandManagerAllgemein() {
        super(-1);
        this.addMeth(COM_ALLG_ADD_DOC, "handleAddDoc", 5, false);
        this.addMeth(COM_ALLG_GET_DOC, "handleGetDoc", 2, false);
        this.addMeth(COM_ALLG_REM_DOC, "handleRemDoc", 4, false);
        this.addMeth(COM_ALLG_SET_FOREIGN_ID, "handleSetFID", 4, false);
        this.addMeth(COM_ALLG_IMPORT_TO_SERVICE, "handleImportObjectToService", 4, false);
        this.addMeth(COM_ALLG_DETACH_FROM_SERVICE, "handleDetachFromService", 5, false);
        this.addMeth(COM_ALLG_ATTACH_TO_SERVICE, "handleAttachToService", 4, false);
    }

    public boolean wantsBroadcastOfObjects(String com) {
        return !com.equals(COM_ALLG_GET_DOC);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_ALLG_ADD_DOC)) {
            String ids;
            if (typ == 0 && id == 0L) {
                String ids2 = z.getString(1, null);
                if (ids2 != null) {
                    Zeile z2 = new Zeile(ids2, '|');
                    StringBuffer msb = new StringBuffer();
                    int i = 0;
                    while (i < z2.size()) {
                        if (msb.length() != 0) {
                            msb.append(", ");
                        }
                        msb.append(this.getIDObjectRef(group, z.getInt(2, 0), z2.getLong(i, 0L), objectGroup));
                        ++i;
                    }
                    return "Attached document: " + Base64Manager.getDecodedString(z.getString(3, "")) + " to " + msb.toString();
                }
            } else if (typ == z.getInt(2, 0) && (ids = z.getString(1, null)) != null) {
                Zeile z2 = new Zeile(ids, '|');
                int i = 0;
                while (i < z2.size()) {
                    if (id == z2.getLong(i, 0L)) {
                        return "Attached document: " + Base64Manager.getDecodedString(z.getString(3, ""));
                    }
                    ++i;
                }
            }
            return null;
        }
        if (command.equals(COM_ALLG_GET_DOC)) {
            return null;
        }
        if (command.equals(COM_ALLG_REM_DOC)) {
            String ids;
            if (typ == 0 && id == 0L) {
                String ids3 = z.getString(1, null);
                if (ids3 != null) {
                    Zeile z2 = new Zeile(ids3, '|');
                    StringBuffer msb = new StringBuffer();
                    int i = 0;
                    while (i < z2.size()) {
                        if (msb.length() != 0) {
                            msb.append(", ");
                        }
                        msb.append(this.getIDObjectRef(group, z.getInt(2, 0), z2.getLong(i, 0L), objectGroup));
                        ++i;
                    }
                    return "Removed document from " + msb.toString();
                }
            } else if (typ == z.getInt(2, 0) && (ids = z.getString(1, null)) != null) {
                Zeile z2 = new Zeile(ids, '|');
                int i = 0;
                while (i < z2.size()) {
                    if (z.getLong(1, 0L) == z2.getLong(i, 0L)) {
                        return "Removed document";
                    }
                    ++i;
                }
            }
            return null;
        }
        if (command.equals(COM_ALLG_SET_FOREIGN_ID)) {
            if (typ == 0 && id == 0L) {
                String kennung = z.getStringB64(3, "");
                if (kennung.length() == 0) {
                    return "Cleared foreign ID of: " + this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(1, 0L), objectGroup);
                }
                return "Set foreign ID of: " + this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(1, 0L), objectGroup) + " to: " + kennung;
            }
            if (typ == z.getInt(2, 0) && id == z.getLong(1, 0L)) {
                String kennung = z.getStringB64(3, "");
                if (kennung.length() == 0) {
                    return "Cleared foreign ID";
                }
                return "Set foreign ID to: " + kennung;
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleAddDoc() {
        if (this.ivObjectRequest.ivExtraObject != null) {
            String internFilename = Long.toString(MilliSpender.getMillis());
            byte[] data = (byte[])this.ivExtraObject;
            if (data != null && data.length > 0 && FileManager.saveBytesToFile(String.valueOf(GroupFileManager.getDocsPath(this.ivGroupname)) + "/" + internFilename, data)) {
                String combi = Base64Manager.encodeBase64(String.valueOf(internFilename) + "|" + Base64Manager.getDecodedString(this.ivLine[3]) + "|" + Long.parseLong(this.ivLine[4]) + "|" + System.currentTimeMillis() + "|" + data.length);
                Zeile z = new Zeile(this.ivLine[1], '|');
                int objectTyp = Integer.parseInt(this.ivLine[2]);
                int col = 0;
                while (col < z.size()) {
                    IDObject obi = ObjectStoreServer.getObjectToUpdate(objectTyp, z.getLong(col, 0L), this.ivGroupname, this.ivObjectBag);
                    if (obi != null) {
                        String altdok = obi.getString("IDO_DOK", null);
                        obi.set("IDO_DOK", altdok == null ? combi : String.valueOf(altdok) + "|" + combi);
                    }
                    obi.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
                    ++col;
                }
                return true;
            }
        }
        return false;
    }

    public boolean handleGetDoc() {
        String dirname = GroupFileManager.getDocsPath(this.ivGroupname);
        byte[] datei = FileManager.getBytesFromFile(String.valueOf(dirname) + "/" + this.ivLine[1]);
        if (datei == null || datei.length == 0) {
            return false;
        }
        this.ivObjectRequest.ivObject = datei;
        return true;
    }

    public boolean handleRemDoc() {
        String kennung = this.ivLine[3];
        int objectTyp = Integer.parseInt(this.ivLine[2]);
        Zeile z = new Zeile(this.ivLine[1], '|');
        int col = 0;
        while (col < z.size()) {
            String altdok;
            long objectID = z.getLong(col, 0L);
            IDObject obi = ObjectStoreServer.getObjectToUpdate(objectTyp, objectID, this.ivGroupname, this.ivObjectBag);
            if (obi != null && (altdok = obi.getString("IDO_DOK", null)) != null) {
                StringBuffer msb = new StringBuffer();
                boolean changed = false;
                Zeile adz = new Zeile(altdok, '|');
                int i = 0;
                while (i < adz.size()) {
                    String entb64;
                    String eintrag = adz.getTrimmedString(i, null);
                    if (eintrag != null && (entb64 = Base64Manager.getDecodedString(eintrag, null)) != null) {
                        Zeile z2 = new Zeile(entb64, '|');
                        if (!z2.getString(0, "").equals(kennung)) {
                            if (msb.length() != 0) {
                                msb.append("|");
                            }
                            msb.append(eintrag);
                        } else {
                            changed = true;
                        }
                    }
                    ++i;
                }
                if (changed) {
                    if (msb.length() != 0) {
                        obi.set("IDO_DOK", msb.toString());
                    } else {
                        obi.set("IDO_DOK", null);
                    }
                    obi.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
                }
            }
            ++col;
        }
        return true;
    }

    public static boolean hasDocument(IDObject obi, String kennung) {
        String altdok;
        if (obi != null && kennung != null && kennung.trim().length() != 0 && (altdok = obi.getString("IDO_DOK", null)) != null) {
            Zeile adz = new Zeile(altdok, '|');
            int i = 0;
            while (i < adz.size()) {
                Zeile z2;
                String entb64;
                String eintrag = adz.getTrimmedString(i, null);
                if (eintrag != null && (entb64 = Base64Manager.getDecodedString(eintrag, null)) != null && (z2 = new Zeile(entb64, '|')).getString(0, "").equals(kennung)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean handleSetFID() {
        long objectID = Long.parseLong(this.ivLine[1]);
        int objectTyp = Integer.parseInt(this.ivLine[2]);
        IDObject obi = ObjectStoreServer.getObjectToUpdate(objectTyp, objectID, this.ivGroupname, this.ivObjectBag);
        if (obi != null) {
            String kennung = Base64Manager.getDecodedString(this.ivLine[3]).trim();
            obi.set("IDO_FKEY", kennung.length() == 0 ? null : kennung);
            obi.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
            return true;
        }
        this.ivBugString = "Could not find object type: " + objectTyp + " ID: " + objectID;
        return false;
    }

    public boolean handleDetachFromService() {
        boolean res = false;
        IDObject[] objArr = this.detachFromService();
        if (objArr != null) {
            if (objArr[0] instanceof Rack) {
                Rack gruppenRack = (Rack)objArr[0];
                Rack serviceRack = (Rack)objArr[1];
                gruppenRack.set("RCK_OCC", null);
                Rack.propagateCageOccupation(serviceRack, this.ivObjectBag, this.ivServiceRoomOverride);
            }
            res = true;
        } else {
            this.ivBugString = "Object could not be detached from Group";
        }
        return res;
    }

    private IDObject[] detachFromService() {
        if (this.isServiceGroup()) {
            Log.debug("start handleDetachFromService ", this);
            long serviceID = Long.parseLong(this.ivLine[1]);
            String gruppe = Base64Manager.getDecodedString(this.ivLine[2]);
            long gruppenID = Long.parseLong(this.ivLine[3]);
            int objectType = Integer.parseInt(this.ivLine[4]);
            IDObject gruppenObject = ObjectStoreServer.getObjectToUpdate(objectType, gruppenID, gruppe, this.ivObjectBag);
            Log.debug("hdfs gruppe [" + gruppe + "] gruppenRackID [" + gruppenID + "] gruppenRack: " + gruppenObject, this);
            IDObject serviceObject = ObjectStoreServer.getObjectToUpdate(objectType, serviceID, "service", this.ivObjectBag);
            Log.debug("hrrfs serviceObjectID [" + serviceID + "] serviceRack: " + serviceObject, this);
            if (gruppenObject != null && serviceObject != null) {
                gruppenObject.set("IDO_SERVID", null);
                if (!DocMoveManager.copyDocsFromServiceObjectToGroup(serviceObject, gruppenObject)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerAllgemein");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem while moving documents to group", null, clazz);
                    return null;
                }
                if (gruppenObject instanceof Rack) {
                    Rack gruppenRack = (Rack)gruppenObject;
                    gruppenRack.set("RCK_OCC", null);
                }
                Log.debug("hdfs gruppenObject neu [" + gruppenObject.getPropertymaskString() + "]", this);
                String[] srGruppenNamen = (String[])serviceObject.get("IDO_UGROUPS");
                long[] srGruppenIDs = (long[])serviceObject.get("IDO_UGROUPIDS");
                Log.debug("hrrfs srGruppenNamen [" + srGruppenNamen + "] srGruppenIDs [" + srGruppenIDs + "]", this);
                if (srGruppenNamen != null && srGruppenIDs != null) {
                    Log.debug("hdfs srGruppenNamen.length [" + srGruppenNamen.length + "]", this);
                    HashMap<String, Long> hm = new HashMap<String, Long>();
                    int i = 0;
                    while (i < srGruppenNamen.length) {
                        String tgr = srGruppenNamen[i];
                        if (!gruppe.equals(tgr) && i < srGruppenIDs.length) {
                            hm.put(tgr, new Long(srGruppenIDs[i]));
                        }
                        ++i;
                    }
                    Log.debug("hdfs neue Hashmap [" + hm + "]", this);
                    if (hm.isEmpty()) {
                        serviceObject.set("IDO_UGROUPS", null);
                        serviceObject.set("IDO_UGROUPIDS", null);
                    } else {
                        String[] ng = new String[hm.size()];
                        long[] ni = new long[hm.size()];
                        int pos = 0;
                        Iterator iter = hm.keySet().iterator();
                        while (iter.hasNext()) {
                            ng[pos] = (String)iter.next();
                            ni[pos] = (Long)hm.get(ng[pos]);
                            ++pos;
                        }
                        serviceObject.set("IDO_UGROUPS", ng);
                        serviceObject.set("IDO_UGROUPIDS", ni);
                    }
                }
                if (serviceObject instanceof QuotableIDObject) {
                    QuotableIDObject serviceQuotableObject = (QuotableIDObject)serviceObject;
                    String[] srQuotaGruppenNamen = (String[])serviceQuotableObject.get("QIO_GNAMES");
                    int[] srQuota = (int[])serviceQuotableObject.get("QIO_QUOTA");
                    if (srQuotaGruppenNamen != null && srQuota != null && srQuotaGruppenNamen.length != 0) {
                        Log.debug("hdfs QUOTA.length [" + srQuotaGruppenNamen.length + "]", this);
                        HashMap<String, Integer> hm = new HashMap<String, Integer>();
                        int i = 0;
                        while (i < srQuotaGruppenNamen.length) {
                            String tgr = srQuotaGruppenNamen[i];
                            if (!gruppe.equals(tgr) && i < srQuota.length) {
                                hm.put(tgr, new Integer(srQuota[i]));
                            }
                            ++i;
                        }
                        if (hm.size() != srQuotaGruppenNamen.length) {
                            Log.debug("hdfs neue Quota-Hashmap [" + hm + "]", this);
                            String[] ng = new String[hm.size()];
                            int[] ni = new int[hm.size()];
                            int pos = 0;
                            Iterator iter = hm.keySet().iterator();
                            while (iter.hasNext()) {
                                ng[pos] = (String)iter.next();
                                ni[pos] = (Integer)hm.get(ng[pos]);
                                ++pos;
                            }
                            serviceQuotableObject.set("QIO_GNAMES", ng);
                            serviceQuotableObject.set("QIO_QUOTA", ni);
                        }
                    }
                }
                if (serviceObject instanceof Rack) {
                    Rack serviceRack = (Rack)serviceObject;
                    Rack.propagateCageOccupation(serviceRack, this.ivObjectBag, this.ivServiceRoomOverride);
                }
                return new IDObject[]{gruppenObject, serviceObject};
            }
        }
        return null;
    }

    public boolean handleAttachToService() {
        if (this.isServiceGroup()) {
            block5: {
                Room gruppenRaum;
                Rack gruppenRack;
                block6: {
                    String[] bugString;
                    long serviceID = Long.parseLong(this.ivLine[1]);
                    String zielGruppe = Base64Manager.getDecodedString(this.ivLine[2]);
                    int objectType = Integer.parseInt(this.ivLine[3]);
                    IDObject serviceObject = ObjectStoreServer.getObjectToUpdate(objectType, serviceID, "service", this.ivObjectBag);
                    IDObject gruppenObject = this.giveGroupAccessToServiceObject(serviceObject, zielGruppe);
                    if (gruppenObject == null) break block5;
                    this.ivObjectBag.put(gruppenObject.getIdentifierString(), gruppenObject);
                    this.ivObjectBag.put(serviceObject.getIdentifierString(), serviceObject);
                    if (!(gruppenObject instanceof Rack)) break block5;
                    gruppenRack = (Rack)gruppenObject;
                    Rack serviceRack = (Rack)serviceObject;
                    gruppenRack.makeCageVector();
                    Room serviceRaum = (Room)ObjectStore.getObjectDeadOrAlive(10, serviceRack.getLong("RCK_ROOM", 0L), "service", this.ivObjectBag, false);
                    if (serviceRaum == null) break block5;
                    HashMap roomHM = new HashMap();
                    roomHM = serviceRaum.getSubObjectsByGroupOnServer(this.ivObjectBag);
                    gruppenRaum = CommandManagerRack.createRoomCopyAndEnterIDIfNecessary(serviceRaum, roomHM, zielGruppe, this.ivObjectBag, this.ivNewObjectsTarget, bugString = new String[1]);
                    if (gruppenRaum != null) break block6;
                    if (bugString[0] != null) {
                        this.ivBugString = String.valueOf(this.ivBugString) + bugString[0];
                    }
                    return false;
                }
                try {
                    gruppenRack.set("RCK_ROOM", new Long(gruppenRaum.getID()));
                }
                catch (IllegalArgumentException e) {
                    this.ivBugString = e.getMessage();
                }
            }
            return true;
        }
        return false;
    }

    private IDObject giveGroupAccessToServiceObject(IDObject serviceObject, String zielGruppe) {
        if (this.isServiceGroup() && serviceObject != null) {
            if (zielGruppe != null) {
                IDObject existingObject = null;
                HashMap hm = serviceObject.getSubObjectsByGroupOnServer(this.ivObjectBag);
                if (hm != null) {
                    existingObject = (IDObject)hm.get(zielGruppe);
                }
                if (existingObject == null) {
                    return ObjectExtractor.manageExportFROMServiceGroup(serviceObject, zielGruppe, this.ivObjectBag, this.ivNewObjectsTarget);
                }
                return null;
            }
            throw new IllegalArgumentException("Group could not be found");
        }
        throw new IllegalArgumentException("Object could not be found");
    }

    public boolean handleImportObjectToService() {
        IDObject gruppenObject;
        boolean finished = false;
        if (this.isServiceGroup() && (gruppenObject = ObjectStoreServer.getObjectToUpdate(Integer.parseInt(this.ivLine[2]), Long.parseLong(this.ivLine[3]), Base64Manager.getDecodedString(this.ivLine[1]), this.ivObjectBag)) != null) {
            finished = ObjectExtractor.manageImportTOServiceGroup(gruppenObject, this.ivObjectBag, this.ivNewObjectsTarget, this) != null;
        }
        return finished;
    }
}

