/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.objectstore.InterCrossHandler;

public class CommandManagerLine
extends CommandManagerExecutive {
    private static final String PREFIX = "LIN";
    public static final String COM_LIN_NEW = "LINNEW";
    public static final String COM_LIN_RM = "LINRM";
    public static final String COM_LIN_REVIT = "LINREVIT";
    public static final String COM_LIN_CHNAME = "LINCHNAME";
    public static final String COM_LIN_CHCOMMENT = "LINCHCOMMENT";
    public static final String COM_LIN_CHCOLOR = "LINCHCOLOR";
    public static final String COM_LIN_CHLOCORDER = "LINCHLOCORDER";
    public static final String COM_LIN_ADDALLEL = "LINADDALLEL";
    public static final String COM_LIN_REMOVEALLEL = "LINREMOVEALLEL";
    public static final String COM_LIN_STARTINTERCROSSREP = "LINSICR";
    public static final String COM_LIN_GETIONTERCROSSREP = "LINGICR";
    public static final String COM_LIN_SETMATLIM = "LINSETMATLIM";
    public static final String COM_LIN_SET_ANTAG = "LINSETANTAG";
    public static final String COM_LIN_SET_PREFIX = "LINSETPREFIX";
    public static final String COM_LIN_CHAUTOGENOTYPE = "LINCHAUTOGENOTYPE";
    public static final String COM_LIN_CH_ALWAYS_PRALINE = "LINCHALWAYSPRLAINE";
    public static final String COM_LIN_CH_STRESS_LEVEL = "LINCHSTRESSLEVEL";
    public static final String COM_LIN_CH_STRESS_RULES = "LINCHSTRESSRULES";
    public static final String COM_LIN_SET_LICENSE = "LINSET_LICENSE";
    public static final String COM_LIN_KILL_FINAL = "LIN_KILL_FINAL";
    public static final String COM_LIN_SET_EVALUATION = "LINSET_EVALUATION";
    public static final String COM_LIN_CH_EXP_PROPS = "LINCHEXPPROPS";

    public CommandManagerLine() {
        super(7);
        this.addMeth(COM_LIN_NEW, "handleLINNEW", 6, false);
        this.addMeth(COM_LIN_RM, "setInvisible", 2, true);
        this.addMeth(COM_LIN_REVIT, "setVisible", 2, true);
        this.addMeth(COM_LIN_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_LIN_CHNAME, "handleLINCHNAME", 3, true);
        this.addMeth(COM_LIN_CHCOMMENT, "handleLINCHCOMMENT", 3, true);
        this.addMeth(COM_LIN_CHCOLOR, "handleLINCHCOLOR", 3, true);
        this.addMeth(COM_LIN_CHLOCORDER, "handleLINCHLOCORDER", 3, true);
        this.addMeth(COM_LIN_ADDALLEL, "handleLINADDALLEL", 4, true);
        this.addMeth(COM_LIN_REMOVEALLEL, "handleLINREMOVEALLEL", 4, true);
        this.addMeth(COM_LIN_STARTINTERCROSSREP, "handleSTARTINTERCROSSREP", 9, false);
        this.addMeth(COM_LIN_GETIONTERCROSSREP, "handleGETINTERCROSSREP", 2, false);
        this.addMeth(COM_LIN_SETMATLIM, "handleLINSETMATLIM", 3, true);
        this.addMeth(COM_LIN_SET_ANTAG, "handleLIN_SET_ANTAG", 3, true);
        this.addMeth(COM_LIN_SET_PREFIX, "handleLIN_SET_PREFIX", 3, true);
        this.addMeth(COM_LIN_CHAUTOGENOTYPE, "handleLINCHAUTOGENOTYPE", 3, true);
        this.addMeth(COM_LIN_CH_ALWAYS_PRALINE, "handleLINCHALWAYSPRLAINE", 3, true);
        this.addMeth(COM_LIN_CH_STRESS_LEVEL, "handleLINCHStressLevel", 3, true);
        this.addMeth(COM_LIN_CH_STRESS_RULES, "handleLINCHStressRules", 3, true);
        this.addMeth(COM_LIN_SET_LICENSE, "handleLINSetLicense", 4, true);
        this.addMeth(COM_LIN_SET_EVALUATION, "handleLINSetEvaluation", 3, true);
        this.addMeth(COM_LIN_CH_EXP_PROPS, "handleLINChExpProps", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_LIN_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new line";
            }
            return null;
        }
        if (command.equals(COM_LIN_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed line " + this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Removed Line";
            }
            return null;
        }
        if (command.equals(COM_LIN_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized line " + this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Revitalized Line";
            }
            return null;
        }
        if (command.equals(COM_LIN_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return CommandManagerLine.getPB64String("Changed name of line " + linRef + " to: ", z, 2);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return CommandManagerLine.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIN_CH_EXP_PROPS)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return CommandManagerLine.getPB64String("Changed expected properties of line " + linRef + " to: ", z, 2);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return CommandManagerLine.getPB64String("Changed expected properties to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIN_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return CommandManagerLine.getPB64String("Set comment of line " + linRef + " to: ", z, 2);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return CommandManagerLine.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIN_CHCOLOR)) {
            Color col;
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                Color col2 = CommandManagerLine.convertToColor(z.getString(2, ""));
                if (col2 != null) {
                    return "Changed color of line " + linRef + " to: (" + CommandManagerLine.getDescr(col2) + ")";
                }
            } else if (typ == 7 && z.getLong(1, 0L) == id && (col = CommandManagerLine.convertToColor(z.getString(2, ""))) != null) {
                return "Changed color to: (" + CommandManagerLine.getDescr(col) + ")";
            }
            return null;
        }
        if (command.equals(COM_LIN_CHLOCORDER)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return "changed locus order of line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "changed locus order";
            }
            return null;
        }
        if (command.equals(COM_LIN_ADDALLEL)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return "Added allel " + Base64Manager.getDecodedString(z.getString(3, "")) + " for Locus (ID = " + z.getString(2, "") + ") for line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Added allel " + Base64Manager.getDecodedString(z.getString(3, "")) + " for Locus (ID = " + z.getString(2, "") + ")";
            }
            return null;
        }
        if (command.equals(COM_LIN_REMOVEALLEL)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return "Removed allel " + Base64Manager.getDecodedString(z.getString(3, "")) + " for Locus (ID = " + z.getString(2, "") + ") from line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Removed allel " + Base64Manager.getDecodedString(z.getString(3, "")) + " for Locus (ID = " + z.getString(2, "") + ")";
            }
            return null;
        }
        if (command.equals(COM_LIN_STARTINTERCROSSREP)) {
            return null;
        }
        if (command.equals(COM_LIN_GETIONTERCROSSREP)) {
            return null;
        }
        if (command.equals(COM_LIN_SETMATLIM)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                int matlim = z.getInt(2, -1);
                if (matlim == -1) {
                    return "Removed maturity limit of line " + linRef;
                }
                return "Set maturity limit  of line " + linRef + " to " + matlim + " days";
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                int matlim = z.getInt(2, -1);
                if (matlim == -1) {
                    return "Removed maturity limit";
                }
                return "Set maturity limit to " + matlim + " days";
            }
            return null;
        }
        if (command.equals(COM_LIN_SET_ANTAG)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return CommandManagerLine.getPB64String("Set alphanumeric tag of line " + linRef + " to: ", z, 2);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return CommandManagerLine.getPB64String("Set alphanumeric tag to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIN_SET_PREFIX)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return CommandManagerLine.getPB64String("Set eartag prefix of line " + linRef + " to: ", z, 2);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return CommandManagerLine.getPB64String("Set eartag prefix to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIN_CHAUTOGENOTYPE)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("1")) {
                    return "Enabled auomated genotyping for line " + linRef;
                }
                return "Disabled auomated genotyping for line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("1")) {
                    return "enabled auomated genotyping";
                }
                return "disabled auomated genotyping";
            }
            return null;
        }
        if (command.equals(COM_LIN_CH_ALWAYS_PRALINE)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("1")) {
                    return "Set line/strain color mode for line " + linRef;
                }
                return "Set normal color mode for line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("1")) {
                    return "Set line/strain color mode";
                }
                return "Set normal color mode";
            }
            return null;
        }
        if (command.equals(COM_LIN_CH_STRESS_LEVEL)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return "Changed default stress levels of line " + linRef + " to " + StringHelper.getStringForInt(z.getInt(2, 0), Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "");
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Changed default stress level to " + StringHelper.getStringForInt(z.getInt(2, 0), Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "");
            }
            return null;
        }
        if (command.equals(COM_LIN_CH_STRESS_RULES)) {
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return "Changed default stress rules of line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Changed default stress rules";
            }
            return null;
        }
        if (command.equals(COM_LIN_SET_EVALUATION)) {
            String info = null;
            int type = z.getInt(2, 0);
            info = type == 0 ? "Cleared Evaluation rules" : "Set Evaluation rules to " + TierSchutz.getEvaluationDescr(type);
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return String.valueOf(info) + " for line " + linRef;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return info;
            }
            return null;
        }
        if (command.equals(COM_LIN_SET_LICENSE)) {
            long licenseID = z.getLong(2, 0L);
            String licenseText = null;
            if (licenseID != 0L) {
                licenseText = this.getIDObjectRef(group, 16, licenseID, objectGroup);
            }
            if (typ == 0 && id == 0L) {
                String linRef = this.getIDObjectRef(group, 7, z.getLong(1, 0L), objectGroup);
                return licenseText == null ? "Removed license from line " + linRef : "Changed license of line " + linRef + " to " + licenseText;
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return licenseText == null ? "Removed license" : "Changed license to " + licenseText;
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleLINNEW() {
        Line line = new Line();
        line.setBoolean("LIN_CHANGE", true);
        line.set("LIN_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        line.set("LIN_COLOR", CommandManagerLine.convertToColor(this.ivLine[2]));
        line.set("LIN_LOCIALLELES", LocusAndAlleles.decodeFromTransportString(Base64Manager.getDecodedString(this.ivLine[3])));
        line.setLong("LIN_ENTERER", this.ivLine[4]);
        line.setLong("IDO_UNIQUELONG", this.ivLine[5]);
        return this.finishNewObject(line, null);
    }

    public boolean handleLINCHNAME() {
        return this.setStringAndPropagate(2, "LIN_NAME", true);
    }

    public boolean handleLINChExpProps() {
        return this.setStringAndPropagate(2, "LIN_EXPROPS", true);
    }

    public boolean handleLINCHCOMMENT() {
        return this.setStringAndPropagate(2, "LIN_DESCRIPTION", true);
    }

    public boolean handleLINCHCOLOR() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_COLOR", CommandManagerLine.convertToColor(this.ivLine[2]));
        return true;
    }

    public boolean handleLINCHLOCORDER() {
        String decOrder = Base64Manager.getDecodedString(this.ivLine[2]);
        Vector v = StringHelper.splitStringByAny(decOrder, ",");
        int[] newPos = new int[v.size()];
        int i = 0;
        while (i < v.size()) {
            newPos[i] = Integer.parseInt((String)v.elementAt(i));
            ++i;
        }
        LocusAndAlleles[] oldArr = (LocusAndAlleles[])this.ivObjectForCommand.get("LIN_LOCIALLELES");
        if (oldArr != null) {
            LocusAndAlleles[] newArr = new LocusAndAlleles[oldArr.length];
            int i2 = 0;
            while (i2 < newPos.length) {
                newArr[i2] = oldArr[newPos[i2]];
                ++i2;
            }
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_LOCIALLELES", newArr);
        }
        return true;
    }

    public boolean handleLINADDALLEL() {
        Line line = (Line)this.ivObjectForCommand;
        LocusAndAlleles[] oldArr = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
        if (oldArr != null) {
            LocusAndAlleles[] newArr = new LocusAndAlleles[oldArr.length];
            int i = 0;
            while (i < oldArr.length) {
                newArr[i] = new LocusAndAlleles(oldArr[i].ivLocusID, oldArr[i].ivAllele);
                ++i;
            }
            long locusID = Long.parseLong(this.ivLine[2]);
            String allel = Base64Manager.getDecodedString(this.ivLine[3]);
            LocusAndAlleles lal = LocusAndAlleles.findLocusAndAlleles(newArr, locusID);
            if (lal != null && !lal.isAllelContained(allel)) {
                lal.addAllel(allel);
                this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_LOCIALLELES", newArr);
                return true;
            }
        }
        return true;
    }

    public boolean handleLINREMOVEALLEL() {
        Line line = (Line)this.ivObjectForCommand;
        LocusAndAlleles[] oldArr = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
        if (oldArr != null) {
            LocusAndAlleles[] newArr = new LocusAndAlleles[oldArr.length];
            int i = 0;
            while (i < oldArr.length) {
                newArr[i] = new LocusAndAlleles(oldArr[i].ivLocusID, oldArr[i].ivAllele);
                ++i;
            }
            long locusID = Long.parseLong(this.ivLine[2]);
            String allel = Base64Manager.getDecodedString(this.ivLine[3]);
            LocusAndAlleles lal = LocusAndAlleles.findLocusAndAlleles(newArr, locusID);
            if (lal != null && lal.isAllelContained(allel)) {
                lal.removeAllel(allel);
                line.set("LIN_LOCIALLELES", newArr);
                this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
                return true;
            }
        }
        return true;
    }

    public boolean handleSTARTINTERCROSSREP() {
        String momLalString = this.ivLine[2];
        LocusAndAlleles[] momLalArr = null;
        if (momLalString.length() > 1) {
            momLalArr = LocusAndAlleles.decodeFromTransportString(momLalString);
        }
        String dadLalString = this.ivLine[6];
        LocusAndAlleles[] dadLalArr = null;
        if (dadLalString.length() > 1) {
            dadLalArr = LocusAndAlleles.decodeFromTransportString(dadLalString);
        }
        String ticket = InterCrossHandler.startHandler(this.ivGroupname, Long.parseLong(this.ivLine[1]), momLalArr, this.ivLine[3].equals("1"), this.ivLine[4].equals("1"), Long.parseLong(this.ivLine[5]), dadLalArr, this.ivLine[7].equals("1"), this.ivLine[8].equals("1"));
        this.ivObjectRequest.ivExtraObject = ticket;
        return true;
    }

    public boolean handleGETINTERCROSSREP() {
        this.ivObjectRequest.ivExtraObject = InterCrossHandler.getResForTicket(this.ivLine[1]);
        return true;
    }

    public boolean handleLINSETMATLIM() {
        return this.setIntAttributeAndPropagate(2, "LIN_MATLIM", -1);
    }

    public boolean handleLIN_SET_ANTAG() {
        return this.setStringAndPropagate(2, "LIN_TAG", true);
    }

    public boolean handleLIN_SET_PREFIX() {
        return this.setStringAndPropagate(2, "LIN_ETPREFIX", true);
    }

    public boolean handleLINCHAUTOGENOTYPE() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_AUTOGTOK", new Boolean(this.ivLine[2].equals("1")));
        return true;
    }

    public boolean handleLINCHALWAYSPRLAINE() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_ALPRAL", this.ivLine[2].equals("1") ? JAWOLL : null);
        return true;
    }

    public boolean handleLINCHStressLevel() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_DEFSTR", new Integer(this.ivLine[2]));
        return true;
    }

    public boolean handleLINCHStressRules() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_STRRUL", IDObjectXMLHandler.getObject(this.ivLine[2], this.ivGroupname, true));
        return true;
    }

    public boolean handleLINSetEvaluation() {
        Integer evaluationType = new Integer(this.ivLine[2]);
        if (evaluationType == 0) {
            evaluationType = null;
        }
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIN_EVAL", evaluationType);
        return true;
    }

    public boolean handleLINSetLicense() {
        if (!this.ivObjectForCommand.isServiceGroupObject()) {
            Long licenseID = new Long(this.ivLine[2]);
            if (licenseID <= 0L) {
                licenseID = null;
            }
            this.ivObjectForCommand.set("LIN_LIC", licenseID);
            if ("1".equals(this.ivLine[3])) {
                Long lineID = this.ivObjectForCommand.getLongID();
                Vector mice = ObjectStore.getActualObjects(1, this.ivGroupname);
                Iterator iterator = mice.iterator();
                while (iterator.hasNext()) {
                    Mouse mouse = (Mouse)iterator.next();
                    if (!lineID.equals(mouse.get("MOS_LINEID")) || licenseID != null && mouse.getLong("MOS_LINLICID", 0L) != 0L) continue;
                    mouse.set("MOS_LINLICID", licenseID);
                    this.ivObjectBag.put(mouse.getIdentifierString(), mouse);
                }
            }
        }
        return true;
    }
}

