/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.datalayer.MiscHandler;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.LitterHelper;
import mausoleum.helper.Zeile;
import mausoleum.idobjectgroup.OwnerGroup;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.WeaningControl;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.objectstore.CommanManUtil;
import mausoleum.result.MResult;
import mausoleum.result.ResultObjectImage;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.room.Room;
import mausoleum.util.InstallationType;
import mausoleum.visit.Visit;

public class CommandManagerMouse
extends CommandManagerExecutive {
    public static final String COM_MOS_NEW = "MI";
    public static final String COM_MOS_NEW_ROOMID = "MIRID";
    public static final String COM_MOS_REMOVE = "MR";
    public static final String COM_MOS_FULL_LITTER = "MFULI";
    public static final String COM_MOS_FULL_LITTER_EMBRYO = "MFULIET";
    private static final String COM_MOS_TRANSFER = "MT";
    public static final String COM_MOS_SET_SEX = "MCX";
    public static final String COM_MOS_SET_LINE = "MCL";
    public static final String COM_MOS_SET_STRAIN = "MCS";
    public static final String COM_MOS_SET_LOCUSGENOTYPE = "MCLocG";
    public static final String COM_MOS_SET_EARTAG = "MCT";
    public static final String COM_MOS_ADD_COMMENT = "MADDC";
    public static final String COM_MOS_SET_COMMENT = "MSETC";
    public static final String COM_MOS_SET_TAG = "MSTG";
    public static final String COM_MOS_SET_BIRTHDAY = "MSBD";
    public static final String COM_MOS_SET_PRIMARAY_OWNER = "MSETPRIMOWN";
    public static final String COM_MOS_CLEAR_OWNER = "MCLEAROWN";
    public static final String COM_MOS_SET_OWNER = "MSETOWN";
    public static final String COM_MOS_ADD_OWNER = "MADDOWN";
    public static final String COM_MOS_SET_OWNER_GROUP = "MSETOWNGROUP";
    public static final String COM_MOS_ADD_OWNER_GROUP = "MADDOWNGROUP";
    public static final String COM_MOS_TAKE_MICE = "MTAKEMICE";
    public static final String COM_MOS_SET_PLUGDAY = "MSPLUGD";
    public static final String COM_MOS_SET_ANTAG = "MADDANTAG";
    public static final String COM_MOS_SET_MATLIM = "MSETMATLIM";
    public static final String COM_MOS_ADD_PLUGDATE = "MSADDPLUGDATE";
    public static final String COM_MOS_REM_PLUGDATE = "MSREMPLUGDATE";
    public static final String COM_MOS_SET_SPECIALDATE = "MSSETSPECDATE";
    public static final String COM_MOS_MARK_ABGESETZT = "MMARKABGESETZT";
    public static final String COM_MOS_REVIT = "MREVIT";
    public static final String COM_MOS_SET_COAT_COLOR = "MSETCOATCOLOR";
    public static final String COM_MOS_SET_TISSUE_SAMPLE = "MSETTISSUESSAMPLE";
    public static final String COM_MOS_RES_NEW = "MRES_NEW";
    public static final String COM_MOS_RES_REMOVE = "MRES_REMOVE";
    public static final String COM_MOS_SET_PARENT = "MOSSETPARENT";
    public static final String COM_MOS_PREGNANT = "MOSSETPREGNANT";
    public static final String COM_MOS_STERILE = "MOSSETSTERILE";
    public static final String COM_MOS_SET_STRESS_LEVEL = "MOSStressLevel";
    public static final String COM_MOS_REM_OWNER_OR_GROUP = "MREMOWN";
    public static final String COM_MOS_CLEAR_COMMENT = "MCLEARCOMMENT";
    public static final String COM_MOS_SET_LIEFERSCHEIN = "MSTLIEFERSCHEIN";
    public static final String COM_MOS_GENEALOGY = "MGENEALOGY";
    public static final String COM_MOS_SET_GENERATION = "MSETGEN";
    public static final String COM_MOS_ALT_ZUGANG = "MI";
    public static final String COM_MOS_ALT_ML = "ML";
    public static final String COM_MOS_ALT_MLOS = "MLOS";
    public static final String COM_MOS_ALT_MI = "MI";
    public static final String COM_MOS_ALT_MIOS = "MIOS";

    public CommandManagerMouse() {
        super(1);
        this.addMeth("MI", "handleCOM_MOS_NEW", 6, false);
        this.addMeth(COM_MOS_NEW_ROOMID, "handleCOM_MOS_NEW_ROOMID", 7, false);
        this.addMeth(COM_MOS_REMOVE, "handleCOM_MOS_REMOVE", 7, true);
        this.addMeth(COM_MOS_FULL_LITTER, "handleCOM_MOS_FULL_LITTER", 9, false);
        this.addMeth(COM_MOS_FULL_LITTER_EMBRYO, "handleCOM_MOS_FULL_LITTER_FROM_EMBRYO_TRANSFER", 5, false);
        this.addMeth(COM_MOS_TRANSFER, "handleCOM_MOS_TRANSFER", 5, true);
        this.addMeth(COM_MOS_SET_SEX, "handleCOM_MOS_SET_SEX", 3, true);
        this.addMeth(COM_MOS_SET_LINE, "handleCOM_MOS_SET_LINE", 3, true);
        this.addMeth(COM_MOS_SET_STRAIN, "handleCOM_MOS_SET_STRAIN", 3, true);
        this.addMeth(COM_MOS_SET_LOCUSGENOTYPE, "handleCOM_MOS_SET_LOCUSGENOTYPE", 3, true);
        this.addMeth(COM_MOS_SET_EARTAG, "handleCOM_MOS_SET_EARTAG", 4, true);
        this.addMeth(COM_MOS_ADD_COMMENT, "handleCOM_MOS_ADD_COMMENT", 3, true);
        this.addMeth(COM_MOS_SET_COMMENT, "handleCOM_MOS_SET_COMMENT", 3, true);
        this.addMeth(COM_MOS_SET_TAG, "handleCOM_MOS_SET_TAG", 3, true);
        this.addMeth(COM_MOS_SET_LIEFERSCHEIN, "handleCOM_MOS_SET_LIEFERSCHEIN", 3, true);
        this.addMeth(COM_MOS_SET_BIRTHDAY, "handleCOM_MOS_SET_BIRTHDAY", 3, true);
        this.addMeth(COM_MOS_SET_PLUGDAY, "handleCOM_MOS_SET_PLUGDAY", 4, true);
        this.addMeth(COM_MOS_SET_OWNER, "handleCOM_MOS_SET_OWNER", 3, true);
        this.addMeth(COM_MOS_SET_OWNER_GROUP, "handleCOM_MOS_SET_OWNER_GROUP", 3, true);
        this.addMeth(COM_MOS_SET_PRIMARAY_OWNER, "handleCOM_MOS_SET_PRIMARAY_OWNER", 3, true);
        this.addMeth(COM_MOS_ADD_OWNER, "handleCOM_MOS_ADD_OWNER", 4, true);
        this.addMeth(COM_MOS_ADD_OWNER_GROUP, "handleCOM_MOS_ADD_OWNER_GROUP", 4, true);
        this.addMeth(COM_MOS_CLEAR_OWNER, "handleCOM_MOS_CLEAR_OWNER", 2, true);
        this.addMeth(COM_MOS_TAKE_MICE, "handleCOM_MOS_TAKE_MICE", 2, false);
        this.addMeth(COM_MOS_SET_ANTAG, "handleCOM_MOS_SET_ANTAG", 3, true);
        this.addMeth(COM_MOS_SET_MATLIM, "handleCOM_MOS_SET_MATLIM", 3, true);
        this.addMeth(COM_MOS_ADD_PLUGDATE, "handleCOM_MOS_ADD_PLUG_DATE", 3, true);
        this.addMeth(COM_MOS_REM_PLUGDATE, "handleCOM_MOS_REM_PLUG_DATE", 3, true);
        this.addMeth(COM_MOS_SET_GENERATION, "handleCOM_MOS_SET_GENERATION", 3, true);
        this.addMeth(COM_MOS_MARK_ABGESETZT, "handleCOM_MOS_MARK_ABGESETZT", 2, true);
        this.addMeth(COM_MOS_REVIT, "setVisible", 2, true);
        this.addMeth(COM_MOS_SET_COAT_COLOR, "handleCOM_MOS_SET_COAT_COLOR", 3, true);
        this.addMeth(COM_MOS_SET_TISSUE_SAMPLE, "handleCOM_MOS_SET_TISSUE_SAMPLE", 3, true);
        this.addMeth(COM_MOS_SET_STRESS_LEVEL, "handleCOM_COM_MOS_STRESS_LEVEL", 4, true);
        this.addMeth(COM_MOS_RES_NEW, "handleRES_NEW", 2, true);
        this.addMeth(COM_MOS_RES_REMOVE, "handleRES_REMOVE", 3, true);
        this.addMeth(COM_MOS_SET_PARENT, "handleCOM_MOSSETPARENT", 4, true);
        this.addMeth(COM_MOS_PREGNANT, "handleCOM_MOS_SET_PREGNANT", 3, true);
        this.addMeth(COM_MOS_STERILE, "handleCOM_MOS_SET_SEX_VARIANT", 3, true);
        this.addMeth(COM_MOS_SET_SPECIALDATE, "handleCOM_MOS_SET_SPECIALDATE", 3, true);
        this.addMeth(COM_MOS_REM_OWNER_OR_GROUP, "handleCOM_MOS_REM_OWNER_OR_GROUP", 4, true);
        this.addMeth(COM_MOS_CLEAR_COMMENT, "handleCOM_MOS_CLEAR_COMMENT", 2, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals("MI") || command.equals(COM_MOS_NEW_ROOMID)) {
            if (typ == 0 && id == 0L) {
                return "Created " + z.getInt(1, 0) + " new mice";
            }
            return null;
        }
        if (command.equals(COM_MOS_REMOVE)) {
            Visit vis;
            Mouse mouse;
            if (typ == 0 && id == 0L) {
                String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                String mode = Visit.translateMode(z.getInt(2, 0));
                return "Removed mouse " + mosRef + " at " + DatumFormat.getJustDateString(z.getLong(3, 0L)) + " mode: " + mode;
            }
            if (typ == 1 && z.getLong(1, 0L) == id) {
                String mode = Visit.translateMode(z.getInt(2, 0));
                return "Removed at " + DatumFormat.getJustDateString(z.getLong(3, 0L)) + " mode: " + mode;
            }
            if (typ == 2 && (mouse = (Mouse)this.getIDObject(group, 1, z.getLong(1, 0L))) != null && (vis = Visit.findEndingVisitInMouse((Visit[])mouse.get("MOS_VISIT"), id, z.getLong(3, 0L))) != null) {
                String mode = Visit.translateMode(z.getInt(2, 0));
                return "Removed mouse " + mouse.getIDStringForReports(false) + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "") + " mode: " + mode;
            }
            return null;
        }
        if (command.equals(COM_MOS_FULL_LITTER_EMBRYO)) {
            if (typ == 0 && id == 0L) {
                String mumRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                return "Created litter resulting from embryo transfer of " + z.getInt(2, 0) + " pups. Mother: " + mumRef + " Birthday: " + DatumFormat.getJustDateString(z.getString(3, ""), "");
            }
            if (typ == 1 && z.getLong(1, 0L) == id) {
                return "Created litter resulting from embryo transfer of " + z.getInt(2, 0) + " pups. Birthday: " + DatumFormat.getJustDateString(z.getString(3, ""), "");
            }
        } else {
            if (command.equals(COM_MOS_FULL_LITTER)) {
                Vector visits;
                Cage cage;
                if (typ == 0 && id == 0L) {
                    String mumRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String dadRef = this.getIDObjectRef(group, 1, z.getLong(2, 0L), objectGroup);
                    return "Created litter of " + z.getInt(3, 0) + " pups. Mother: " + mumRef + " Father: " + dadRef + " Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                }
                if (typ == 1) {
                    Vector visits2;
                    if (z.getLong(1, 0L) == id || z.getLong(2, 0L) == id) {
                        return "Created litter of " + z.getInt(3, 0) + " pups. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                    }
                    Mouse mouse = (Mouse)this.getIDObject(group, 1, id);
                    if (mouse != null && (visits2 = Visit.findStartingVisits((Visit[])mouse.get("MOS_VISIT"), z.getLong(4, 0L))) != null && visits2.size() == 1) {
                        Visit visit = (Visit)visits2.elementAt(0);
                        Cage cage2 = (Cage)this.getIDObject(group, 2, visit.ivCageID);
                        if (cage2 != null) {
                            return "Imported to cage " + cage2.getBrowseName() + " by birth. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                        }
                    }
                } else if (typ == 2 && (cage = (Cage)this.getIDObject(group, 2, id)) != null && (visits = Visit.findStartingVisits((Visit[])cage.get("CAG_VISIT"), z.getLong(4, 0L))) != null && !visits.isEmpty()) {
                    StringBuffer msb = new StringBuffer();
                    Iterator iter = visits.iterator();
                    while (iter.hasNext()) {
                        Visit visit = (Visit)iter.next();
                        Mouse mouse = (Mouse)this.getIDObject(group, 1, visit.ivMouseID);
                        if (mouse == null) continue;
                        if (msb.length() != 0) {
                            msb.append("\n");
                        }
                        msb.append("Imported mouse " + mouse.getIDStringForReports(false) + " by birth. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), ""));
                    }
                    if (msb.length() != 0) {
                        return msb.toString();
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_TRANSFER)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String cagRef = this.getIDObjectRef(group, 2, z.getLong(2, 0L), objectGroup);
                    return "Transfered mouse " + mosRef + " to cage " + cagRef + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    Cage cage = (Cage)this.getIDObject(group, 2, z.getLong(2, 0L));
                    if (cage != null) {
                        return "Transfered to cage " + cage.getBrowseName() + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                    }
                } else if (typ == 2) {
                    if (z.getLong(2, 0L) == id) {
                        Mouse mouse = (Mouse)this.getIDObject(group, 1, z.getLong(1, 0L));
                        if (mouse != null) {
                            return "Imported mouse " + mouse.getIDStringForReports(false) + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                        }
                    } else {
                        Visit vis;
                        Mouse mouse = (Mouse)this.getIDObject(group, 1, z.getLong(1, 0L));
                        if (mouse != null && (vis = Visit.findEndingVisitInMouse((Visit[])mouse.get("MOS_VISIT"), id, z.getLong(3, 0L))) != null) {
                            String mode = Visit.translateMode(vis.ivEndMode);
                            return "Removed mouse " + mouse.getIDStringForReports(false) + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "") + " mode: " + mode;
                        }
                    }
                }
                return null;
            }
            if (command.equals("MTR")) {
                Mouse mouse;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String roomRef = this.getIDObjectRef(group, 10, z.getLong(2, 0L), objectGroup);
                    return "Transfered mouse " + mosRef + " to room " + roomRef + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    Room room = (Room)this.getIDObject(group, 10, z.getLong(2, 0L));
                    if (room != null) {
                        return "Transfered to room " + room.getBrowseName() + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                    }
                } else if (typ == 10 && z.getLong(2, 0L) == id && (mouse = (Mouse)this.getIDObject(group, 1, z.getLong(1, 0L))) != null) {
                    return "Imported mouse " + mouse.getIDStringForReports(false) + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_SEX)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int sex = z.getInt(2, 0);
                    if (sex == 1) {
                        return "Marked mouse " + mosRef + " as male";
                    }
                    if (sex == 2) {
                        return "Marked mouse " + mosRef + " as female";
                    }
                    return "Cleared sex information of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    int sex = z.getInt(2, 0);
                    if (sex == 1) {
                        return "Set male";
                    }
                    if (sex == 2) {
                        return "Set female";
                    }
                    return "Cleared sex information";
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_LINE)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    long lineID = z.getLong(2, 0L);
                    if (lineID == 0L) {
                        return "Cleared line information of mouse " + mosRef;
                    }
                    Line line = (Line)this.getIDObject(group, 7, lineID);
                    if (line != null) {
                        return "Set line: " + line.getString("LIN_NAME", "") + " of mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id) {
                    long lineID = z.getLong(2, 0L);
                    if (lineID == 0L) {
                        return "Cleared line information";
                    }
                    Line line = (Line)this.getIDObject(group, 7, lineID);
                    if (line != null) {
                        return "Set line: " + line.getString("LIN_NAME", "");
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_STRAIN)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String info = IndexObject.getDisplayString(z.getString(2), group, 8);
                    if (info == null) {
                        return "Cleared strain information of mouse " + mosRef;
                    }
                    return "Set strain: " + info + " of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    String info = IndexObject.getDisplayString(z.getString(2), group, 8);
                    if (info == null) {
                        return "Cleared strain information.";
                    }
                    return "Set strain: " + info;
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_LOCUSGENOTYPE)) {
                String lalb64;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String lalb642 = z.getString(2, null);
                    if (lalb642 != null) {
                        LocusAndAlleles lal = new LocusAndAlleles(Base64Manager.getDecodedString(lalb642));
                        Locus locus = (Locus)this.getIDObject(group, 14, lal.ivLocusID);
                        if (locus != null) {
                            return "Set genotype of mouse " + mosRef + " for Locus: " + locus.getFactSheetName(false) + " to: " + lal.getAlleleString(locus);
                        }
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (lalb64 = z.getString(2, null)) != null) {
                    LocusAndAlleles lal = new LocusAndAlleles(Base64Manager.getDecodedString(lalb64));
                    Locus locus = (Locus)this.getIDObject(group, 14, lal.ivLocusID);
                    if (locus != null) {
                        return "Set genotype for Locus: " + locus.getFactSheetName(false) + " to: " + lal.getAlleleString(locus);
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_EARTAG)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Set eartag: " + z.getInt(2, 0) + " of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Set eartag: " + z.getInt(2, 0);
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_GENERATION)) {
                if (typ == 0 && id == 0L) {
                    int generation = z.getInt(2, 0);
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    if (generation == -1) {
                        return "Cleared appearance of generation markers of mouse " + mosRef;
                    }
                    if (generation == -2) {
                        return "Cleared manual generation marker of mouse " + mosRef;
                    }
                    return "Set generation: " + generation + " of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    int generation = z.getInt(2, 0);
                    if (generation == -1) {
                        return "Cleared appearance of generation markers";
                    }
                    if (generation == -2) {
                        return "Cleared manual generation marker";
                    }
                    return "Set generation: " + generation;
                }
                return null;
            }
            if (command.equals(COM_MOS_ADD_COMMENT)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return CommandManagerMouse.getPB64String("Added to comment of mouse " + mosRef + ": ", z, 2);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return CommandManagerMouse.getPB64String("Added to comment: ", z, 2);
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_LIEFERSCHEIN)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return CommandManagerMouse.getPB64String("Set shipment-ID of mouse " + mosRef + " to: ", z, 2);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return CommandManagerMouse.getPB64String("Set shipment-ID to: ", z, 2);
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_COMMENT)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return CommandManagerMouse.getPB64String("Set comment of mouse " + mosRef + " to: ", z, 2);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return CommandManagerMouse.getPB64String("Set comment to: ", z, 2);
                }
                return null;
            }
            if (command.equals(COM_MOS_CLEAR_COMMENT)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Cleared comment of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Cleared comment";
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_TAG)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String mark = z.getString(2, "");
                    if (mark.equals("f")) {
                        return "Cleared mark of mouse " + mosRef;
                    }
                    if (mark.equals("t")) {
                        return "Set standard mark for mouse " + mosRef;
                    }
                    return "Set mark: " + mark + " for mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    String mark = z.getString(2, "");
                    if (mark.equals("f")) {
                        return "Cleared mark";
                    }
                    if (mark.equals("t")) {
                        return "Set standard mark";
                    }
                    return "Set mark: " + mark;
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_BIRTHDAY)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    long bd = z.getLong(2, 0L);
                    if (bd == 0L) {
                        return "Remove birthday information for mouse " + mosRef;
                    }
                    return "Set birthday " + DatumFormat.getJustDateString(bd) + " for mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    long bd = z.getLong(2, 0L);
                    if (bd == 0L) {
                        return "Remove birthday information";
                    }
                    return "Set birthday " + DatumFormat.getJustDateString(bd);
                }
                return null;
            }
            if (command.equals(COM_MOS_PREGNANT)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int tage = z.getInt(2, 0);
                    if (tage == 0) {
                        return "Removed pregnancy information for mouse " + mosRef;
                    }
                    return "Marked mouse " + mosRef + " as pregant at " + DatumFormat.getJustDateString(tage);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    int tage = z.getInt(2, 0);
                    if (tage == 0) {
                        return "Remove pregnancy information";
                    }
                    return "Marked as pregnant at " + DatumFormat.getJustDateString(tage);
                }
                return null;
            }
            if (command.equals(COM_MOS_STERILE)) {
                String mosRef = null;
                if (typ == 0 && id == 0L) {
                    mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                } else if (typ == 1 && z.getLong(1, 0L) != id) {
                    return null;
                }
                return "Marked" + (mosRef != null ? " mouse " + mosRef : "") + (z.getInt(2, 0) == 1 ? " sterile" : " fertile");
            }
            if (command.equals(COM_MOS_SET_OWNER)) {
                User owner;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    User owner2 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    if (owner2 != null) {
                        return "Set owner: " + owner2.getBrowseName() + " for mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (owner = (User)this.getIDObject(group, 6, z.getLong(2, 0L))) != null) {
                    return "Set owner: " + owner.getBrowseName();
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_PRIMARAY_OWNER)) {
                User owner;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    User owner3 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    if (owner3 != null) {
                        return "Set primary owner: " + owner3.getBrowseName() + " for mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (owner = (User)this.getIDObject(group, 6, z.getLong(2, 0L))) != null) {
                    return "Set primary owner: " + owner.getBrowseName();
                }
                return null;
            }
            if (command.equals(COM_MOS_ADD_OWNER)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    User owner1 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    User owner2 = (User)this.getIDObject(group, 6, z.getLong(3, 0L));
                    if (owner1 != null && owner2 != null) {
                        return "Share mouse " + mosRef + " between owners: " + owner1.getBrowseName() + " and " + owner2.getBrowseName();
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id) {
                    User owner1 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    User owner2 = (User)this.getIDObject(group, 6, z.getLong(3, 0L));
                    if (owner1 != null && owner2 != null) {
                        return "Share mouse between owners: " + owner1.getBrowseName() + " and " + owner2.getBrowseName();
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_ADD_OWNER_GROUP)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    User owner1 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    OwnerGroup ownergroup = (OwnerGroup)this.getIDObject(group, 20, z.getLong(3, 0L));
                    if (owner1 != null && ownergroup != null) {
                        return "Share mouse " + mosRef + " between owners: " + owner1.getBrowseName() + " and group " + ownergroup.getBrowseName();
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id) {
                    User owner1 = (User)this.getIDObject(group, 6, z.getLong(2, 0L));
                    OwnerGroup ownergroup = (OwnerGroup)this.getIDObject(group, 20, z.getLong(3, 0L));
                    if (owner1 != null && ownergroup != null) {
                        return "Share mouse between owners: " + owner1.getBrowseName() + " and group " + ownergroup.getBrowseName();
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_CLEAR_OWNER)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "made mouse " + mosRef + " publically available";
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "made mouse publically available";
                }
                return null;
            }
            if (command.equals(COM_MOS_TAKE_MICE)) {
                return null;
            }
            if (command.equals(COM_MOS_SET_PLUGDAY)) {
                long millis;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    long millis2 = z.getLong(2, Long.MIN_VALUE);
                    if (millis2 != Long.MIN_VALUE) {
                        if (millis2 == 0L) {
                            return "Cleared plug information of mouse " + mosRef;
                        }
                        return "Set plug date: " + DatumFormat.getJustDateString(millis2) + " for mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (millis = z.getLong(2, Long.MIN_VALUE)) != Long.MIN_VALUE) {
                    if (millis == 0L) {
                        return "Cleared plug information";
                    }
                    return "Set plug date: " + DatumFormat.getJustDateString(millis);
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_ANTAG)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return CommandManagerMouse.getPB64String("Set alphanumeric tag of mouse " + mosRef + " to: ", z, 2);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return CommandManagerMouse.getPB64String("Set alphanumeric tag to: ", z, 2);
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_MATLIM)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int matlim = z.getInt(2, -1);
                    if (matlim == -1) {
                        return "Removed maturity limit of mouse " + mosRef;
                    }
                    return "Set maturity limit  of mouse " + mosRef + " to " + matlim + " days";
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    int matlim = z.getInt(2, -1);
                    if (matlim == -1) {
                        return "Removed maturity limit";
                    }
                    return "Set maturity limit to " + matlim + " days";
                }
                return null;
            }
            if (command.equals(COM_MOS_ADD_PLUGDATE)) {
                int datum;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int datum2 = z.getInt(2, Integer.MIN_VALUE);
                    if (datum2 != Integer.MIN_VALUE) {
                        return "Added plug date: " + DatumFormat.getJustDateString(datum2) + " to mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (datum = z.getInt(2, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    return "Added plug date: " + DatumFormat.getJustDateString(datum);
                }
                return null;
            }
            if (command.equals(COM_MOS_REM_PLUGDATE)) {
                int datum;
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int datum3 = z.getInt(2, Integer.MIN_VALUE);
                    if (datum3 != Integer.MIN_VALUE) {
                        return "Removed plug date: " + DatumFormat.getJustDateString(datum3) + " from mouse " + mosRef;
                    }
                } else if (typ == 1 && z.getLong(1, 0L) == id && (datum = z.getInt(2, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    return "Removed plug date: " + DatumFormat.getJustDateString(datum);
                }
                return null;
            }
            if (COM_MOS_SET_SPECIALDATE.equals(command)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    int datum = z.getInt(2, Integer.MIN_VALUE);
                    if (datum != Integer.MIN_VALUE) {
                        return "Set special date: " + DatumFormat.getJustDateString(datum) + " to mouse " + mosRef;
                    }
                    return "Cleared special date of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    int datum = z.getInt(2, Integer.MIN_VALUE);
                    if (datum != Integer.MIN_VALUE) {
                        return "Set special date: " + DatumFormat.getJustDateString(datum);
                    }
                    if (datum != Integer.MIN_VALUE) {
                        return "Cleared special date";
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_GENEALOGY)) {
                return "CME_NP";
            }
            if (command.equals(COM_MOS_SET_COAT_COLOR)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    if (z.getString(2, "").equals("0")) {
                        return "Defined coat colour of mouse " + mosRef;
                    }
                    return "Cleared coat colour information of mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    if (z.getString(2, "").equals("0")) {
                        return "Defined coat colour";
                    }
                    return "Cleared coat colour information";
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_STRESS_LEVEL)) {
                int stressLevel = z.getInt(2, 0);
                String stress = StringHelper.getStringForInt(stressLevel, Stress.STRESS_INTS, Stress.STRESS_BABELS, false, "?");
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Defined stress level of mouse " + mosRef + " as: " + stress;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Defined stress level as: " + stress;
                }
                return null;
            }
            if (command.equals(COM_MOS_SET_TISSUE_SAMPLE)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Changed tissue sample informations for mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Changed tissue sample informations";
                }
                return null;
            }
            if (command.equals(COM_MOS_REM_OWNER_OR_GROUP)) {
                IDObject ido = null;
                ido = z.getInt(2, -1) == 0 ? this.getIDObject(group, 6, z.getLong(3, 0L)) : this.getIDObject(group, 19, z.getLong(3, 0L));
                String objectName = ido.getBrowseName();
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Removed owner " + objectName + " for mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Removed owner " + objectName;
                }
                return null;
            }
            if (command.equals(COM_MOS_ALT_ML) || command.equals(COM_MOS_ALT_MLOS)) {
                Vector visits;
                Cage cage;
                if (typ == 0 && id == 0L) {
                    String mumRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    String dadRef = this.getIDObjectRef(group, 1, z.getLong(2, 0L), objectGroup);
                    return "Created litter of " + z.getInt(3, 0) + " pups. Mother: " + mumRef + " Father: " + dadRef + "  Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                }
                if (typ == 1) {
                    Vector visits3;
                    if (z.getLong(1, 0L) == id || z.getLong(2, 0L) == id) {
                        return "Created litter of " + z.getInt(3, 0) + " pups. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                    }
                    Mouse mouse = (Mouse)this.getIDObject(group, 1, id);
                    if (mouse != null && (visits3 = Visit.findStartingVisits((Visit[])mouse.get("MOS_VISIT"), z.getLong(4, 0L))) != null && visits3.size() == 1) {
                        Visit visit = (Visit)visits3.elementAt(0);
                        Cage cage3 = (Cage)this.getIDObject(group, 2, visit.ivCageID);
                        if (cage3 != null) {
                            return "Imported to cage " + cage3.getBrowseName() + " by birth. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), "");
                        }
                    }
                } else if (typ == 2 && (cage = (Cage)this.getIDObject(group, 2, id)) != null && (visits = Visit.findStartingVisits((Visit[])cage.get("CAG_VISIT"), z.getLong(4, 0L))) != null && !visits.isEmpty()) {
                    StringBuffer msb = new StringBuffer();
                    Iterator iter = visits.iterator();
                    while (iter.hasNext()) {
                        Visit visit = (Visit)iter.next();
                        Mouse mouse = (Mouse)this.getIDObject(group, 1, visit.ivMouseID);
                        if (mouse == null) continue;
                        if (msb.length() != 0) {
                            msb.append("\n");
                        }
                        msb.append("Imported mouse " + mouse.getIDStringForReports(false) + " by birth. Birthday: " + DatumFormat.getJustDateString(z.getString(4, ""), ""));
                    }
                    if (msb.length() != 0) {
                        return msb.toString();
                    }
                }
                return null;
            }
            if (command.equals(COM_MOS_MARK_ABGESETZT)) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Marked mouse " + mosRef + " as weaned";
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Marked as weaned";
                }
                return null;
            }
            if (command.equals(COM_MOS_REVIT)) {
                if (typ == 0 && id == 0L) {
                    return "Revitalized mouse " + this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Revitalized mouse";
                }
                return null;
            }
            if (command.equals(COM_MOS_RES_NEW)) {
                if (typ == 0 && id == 0L) {
                    return "Added result or special result like symptomlist, embryo transfer etc. for mouse " + this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Added result or special result like symptomlist, embryo transfer etc.";
                }
                return null;
            }
            if (command.equals(COM_MOS_RES_REMOVE)) {
                if (typ == 0 && id == 0L) {
                    return "Removed result or special result like symptomlist, embryo transfer etc. from mouse " + this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Removed result or special result like symptomlist, embryo transfer etc.";
                }
                return null;
            }
            if (command.equals("MI")) {
                return null;
            }
            if (command.equals(COM_MOS_ALT_MIOS)) {
                return null;
            }
        }
        return "CME_NP";
    }

    public boolean handleCOM_MOS_NEW() {
        int anz = Integer.parseInt(this.ivLine[1]);
        long[] ownerIDs = CommandManagerMouse.extractIDs(this.ivLine[3]);
        String herkunft = this.ivLine[4].length() == 0 ? null : Base64Manager.getDecodedString(this.ivLine[4]);
        String shipmentID = this.ivLine[5].length() == 0 ? null : Base64Manager.getDecodedString(this.ivLine[5]);
        int i = 0;
        while (i < anz) {
            Mouse maus = new Mouse();
            maus.setInt("MOS_STARTMODE", 3);
            if (herkunft != null) {
                maus.set("MOS_CAME", herkunft);
            }
            if (shipmentID != null) {
                maus.set("MOS_SHIPID", shipmentID);
            }
            CommandManagerMouse.setIDArray(maus, ownerIDs, "MOS_OWNER");
            if (!this.finishNewObject(maus, this.ivLine[2])) {
                this.ivBugString = String.valueOf(this.getClass().getName()) + ": couldn't get ID for new Object";
                Log.info(this.ivBugString, this);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleCOM_MOS_NEW_ROOMID() {
        int anz = Integer.parseInt(this.ivLine[1]);
        long[] ownerIDs = CommandManagerMouse.extractIDs(this.ivLine[3]);
        String herkunft = this.ivLine[4].length() == 0 ? null : Base64Manager.getDecodedString(this.ivLine[4]);
        long raumID = Long.parseLong(this.ivLine[5]);
        String shipmentID = this.ivLine[6].length() == 0 ? null : Base64Manager.getDecodedString(this.ivLine[6]);
        int i = 0;
        while (i < anz) {
            Mouse maus = new Mouse();
            maus.setInt("MOS_STARTMODE", 3);
            CommandManagerMouse.setIDArray(maus, ownerIDs, "MOS_OWNER");
            maus.setLong("MOS_ROOM", raumID);
            if (herkunft != null) {
                maus.set("MOS_CAME", herkunft);
            }
            if (shipmentID != null) {
                maus.set("MOS_SHIPID", shipmentID);
            }
            if (!this.finishNewObject(maus, this.ivLine[2])) {
                this.ivBugString = String.valueOf(this.getClass().getName()) + ": couldn't get ID for new Object";
                Log.info(this.ivBugString, this);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleCOM_MOS_REMOVE() {
        TreeSet ts;
        String zielAdresse;
        Mouse mouse = (Mouse)this.ivObjectForCommand;
        int endMode = Integer.parseInt(this.ivLine[2]);
        long endMillis = Long.parseLong(this.ivLine[3]);
        MiscHandler.handleMouseToRemove(mouse, endMillis, endMode, this.ivObjectBag);
        if (!this.mouseLeavesCage(mouse, new Date(endMillis), endMode)) {
            return false;
        }
        mouse.setDate("IDO_END_DATE", endMillis);
        mouse.setInt("MOS_ENDMODE", endMode);
        if (endMode == 10) {
            mouse.set("IDO_NEVER_EXISTED", new Boolean(true));
        }
        mouse.set("MOS_PLUGDATE", null);
        mouse.set("MOS_PLUGALERT", null);
        String string = zielAdresse = this.ivLine[6].length() == 0 ? null : Base64Manager.getDecodedString(this.ivLine[6]);
        if (zielAdresse != null) {
            mouse.set("MOS_WENT", zielAdresse);
        }
        TaskExtended.handleTasksOfRemovedObject(mouse, mouse.getTaskKey(), this.ivObjectBag);
        Stress.handledKilledMouse(mouse, this.ivObjectBag);
        if (this.ivLine[4].length() != 0 && !(ts = IDObjectXMLHandler.getSessionTreset(this.ivLine[4])).isEmpty()) {
            String line = String.valueOf(Base64Manager.getDecodedString(this.ivLine[5])) + "\n";
            Iterator iter = ts.iterator();
            while (iter.hasNext()) {
                Long id = (Long)iter.next();
                FileManager.appendStringToServerFile(GroupFileManager.getKilledThirdPartyFilename(this.ivGroupname, id), line);
            }
        }
        return true;
    }

    public boolean handleCOM_MOS_FULL_LITTER() {
        Mouse mutter;
        long mumID = Long.parseLong(this.ivLine[1]);
        long dadID = Long.parseLong(this.ivLine[2]);
        int anzahl = Integer.parseInt(this.ivLine[3]);
        long millis = Long.parseLong(this.ivLine[4]);
        long lineID = Long.parseLong(this.ivLine[5]);
        long[] ownerIDs = CommandManagerMouse.extractIDs(this.ivLine[6]);
        long[] ownerGroupIDs = CommandManagerMouse.extractIDs(this.ivLine[7]);
        String gtInfo = this.ivLine[8];
        LocusAndAlleles[] lalArr = null;
        if (gtInfo.length() != 0 && !gtInfo.equals("-")) {
            Vector v = StringHelper.splitStringByAny(gtInfo, "|");
            lalArr = new LocusAndAlleles[v.size()];
            int i = 0;
            while (i < v.size()) {
                String lals = (String)v.elementAt(i);
                lalArr[i] = new LocusAndAlleles(Base64Manager.getDecodedString(lals));
                ++i;
            }
        }
        if ((mutter = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, mumID, this.ivGroupname, this.ivObjectBag, false, false)) == null) {
            this.ivBugString = "CommandManagerMouse commonLitterHandler: no mum for ID: " + mumID;
            Log.info(this.ivBugString, this);
            return false;
        }
        this.ivObjectBag.put(mutter.getIdentifierString(), mutter);
        Mouse vater = null;
        if (dadID != 0L) {
            vater = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, dadID, this.ivGroupname, this.ivObjectBag, false, false);
            if (vater == null) {
                this.ivBugString = "CommandManagerMouse commonLitterHandler: no dad for ID: " + dadID;
                Log.info(this.ivBugString, this);
                return false;
            }
            this.ivObjectBag.put(vater.getIdentifierString(), vater);
        }
        Cage kaefig = null;
        if (!InstallationType.isFish()) {
            kaefig = this.getCageToUpdate(mutter.getActCageID(0L), this.ivObjectBag, this.ivGroupname);
            if (kaefig == null) {
                this.ivBugString = "The mouse is not sitting in a cage!";
                Log.info(this.ivBugString, this);
                return false;
            }
            this.ivObjectBag.put(kaefig.getIdentifierString(), kaefig);
        }
        Date datum = new Date(millis);
        Mouse model = LitterHelper.makeModel(datum, mutter, vater, lineID, lalArr, null, this.ivObjectBag);
        long[] kidIDs = new long[anzahl];
        int i = 0;
        while (i < anzahl) {
            Mouse kid = new Mouse();
            if (!this.finishNewObject(kid, null)) {
                this.ivBugString = "CommandManagerMouse commonLitterHandler: couldn't get new ID";
                Log.info(this.ivBugString, this);
                return false;
            }
            LitterHelper.fillInLitterMouse(kid, model, this.ivObjectBag);
            CommandManagerMouse.setIDArray(kid, ownerIDs, "MOS_OWNER");
            CommandManagerMouse.setIDArray(kid, ownerGroupIDs, "MOS_OWNERGROUPS");
            kidIDs[i] = kid.getID();
            if (kaefig != null) {
                CommandManagerMouse.mouseEntersCage(kid, kaefig, datum, model.getInt("MOS_STARTMODE"), this.ivObjectBag);
            }
            ++i;
        }
        LitterHelper.incKidArrays(mutter, kidIDs, MyDate.getTage(millis), model);
        if (vater != null) {
            LitterHelper.incKidArrays(vater, kidIDs, MyDate.getTage(millis), model);
        }
        mutter.set("MOS_PREGNANT", null);
        return true;
    }

    public boolean handleCOM_MOS_FULL_LITTER_FROM_EMBRYO_TRANSFER() {
        long mumID = Long.parseLong(this.ivLine[1]);
        int anzahl = Integer.parseInt(this.ivLine[2]);
        long millis = Long.parseLong(this.ivLine[3]);
        MResEmbryoTransfer embryoTransfer = new MResEmbryoTransfer(Base64Manager.getDecodedString(this.ivLine[4]));
        Mouse mutter = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, mumID, this.ivGroupname, this.ivObjectBag, false, false);
        if (mutter == null) {
            this.ivBugString = "CommandManagerMouse commonLitterHandler: no mum for ID: " + mumID;
            Log.info(this.ivBugString, this);
            return false;
        }
        this.ivObjectBag.put(mutter.getIdentifierString(), mutter);
        Cage kaefig = null;
        if (!InstallationType.isFish()) {
            kaefig = this.getCageToUpdate(mutter.getActCageID(0L), this.ivObjectBag, this.ivGroupname);
            if (kaefig == null) {
                this.ivBugString = "The mouse is not sitting in a cage!";
                Log.info(this.ivBugString, this);
                return false;
            }
            this.ivObjectBag.put(kaefig.getIdentifierString(), kaefig);
        }
        Date datum = new Date(millis);
        Mouse model = LitterHelper.makeModel(datum, mutter, null, -1L, null, embryoTransfer, this.ivObjectBag);
        int i = 0;
        while (i < anzahl) {
            Mouse kid = new Mouse();
            if (!this.finishNewObject(kid, null)) {
                this.ivBugString = "CommandManagerMouse commonLitterHandler: couldn't get new ID";
                Log.info(this.ivBugString, this);
                return false;
            }
            LitterHelper.fillInLitterMouse(kid, model, this.ivObjectBag);
            if (kaefig != null) {
                CommandManagerMouse.mouseEntersCage(kid, kaefig, datum, model.getInt("MOS_STARTMODE"), this.ivObjectBag);
            }
            ++i;
        }
        mutter.set("MOS_PREGNANT", null);
        return true;
    }

    private static void setIDArray(Mouse maus, long[] idArray, String tag) {
        long[] nArray = null;
        if (idArray != null && idArray.length != 0) {
            nArray = new long[idArray.length];
            int j = 0;
            while (j < nArray.length) {
                nArray[j] = idArray[j];
                ++j;
            }
        }
        maus.set(tag, nArray);
    }

    public boolean handleCOM_MOS_TRANSFER() {
        boolean res = false;
        Mouse mouse = (Mouse)this.ivObjectForCommand;
        if (mouse != null) {
            long cageID = Long.parseLong(this.ivLine[2]);
            if (cageID <= 0L) {
                this.ivBugString = "CommandManagerMouse handle Mouse transfer: invalid target cage Id " + this.ivLine[2];
                Log.info(this.ivBugString, this);
            } else if (mouse.getActCageID(0L) == cageID) {
                res = true;
            } else {
                Date transferDate = new Date(Long.parseLong(this.ivLine[3]));
                int transferMode = Integer.parseInt(this.ivLine[4]);
                Cage targetCage = this.getCageToUpdate(cageID, this.ivObjectBag, this.ivGroupname);
                if (targetCage == null) {
                    this.ivBugString = "CommandManagerMouse handle Mouse transfer: couldn't get cage with ID " + cageID;
                    Log.info(this.ivBugString, this);
                } else if (!targetCage.isAliveAndVisible()) {
                    this.ivBugString = "CommandManagerMouse handle Mouse transfer: cage with ID " + cageID + " was removed.";
                    Log.info(this.ivBugString, this);
                } else {
                    this.ivObjectBag.put(targetCage.getIdentifierString(), targetCage);
                    if (!this.mouseLeavesCage(mouse, transferDate, transferMode)) {
                        return false;
                    }
                    CommandManagerMouse.mouseEntersCage(mouse, targetCage, transferDate, transferMode, this.ivObjectBag);
                    this.ivObjectBag.put(mouse.getIdentifierString(), mouse);
                    res = true;
                }
            }
        } else {
            this.ivBugString = "CommandManagerMouse handle Mouse transfer: mouse not found. ID: " + this.ivLine[1];
            Log.info(this.ivBugString, this);
        }
        return res;
    }

    private boolean mouseLeavesCage(Mouse mouse, Date transferDate, int transferMode) {
        Visit visitToEnd = Visit.findLatestUnfinishedVisit((Visit[])mouse.get("MOS_VISIT"));
        if (visitToEnd != null) {
            long oldCageID = visitToEnd.ivCageID;
            Cage oldCage = this.getCageToUpdate(oldCageID, this.ivObjectBag, this.ivGroupname);
            if (oldCage != null) {
                Visit[] visits;
                if (this.ivGeneralSRId != null && this.ivServiceRoomOverride != null) {
                    this.ivServiceRoomOverride.put(oldCage.getIdentifierString(), this.ivGeneralSRId);
                }
                if ((visits = (Visit[])oldCage.get("CAG_VISIT")) != null && visits.length > 1) {
                    int vi = 0;
                    while (vi < visits.length) {
                        String mouseIdentifier;
                        Mouse pcmaus;
                        if (visits[vi].ivEndDate == null && (pcmaus = (Mouse)ObjectStoreServer.getObjectToUpdate(1, visits[vi].ivMouseID, this.ivGroupname, this.ivObjectBag)) != null && !this.ivWeanedMiceIdentifiers.contains(mouseIdentifier = mouse.getIdentifierString()) && WeaningControl.istNochNichtAbgesetzt(pcmaus, oldCage)) {
                            this.ivWeanedMiceIdentifiers.add(mouseIdentifier);
                        }
                        ++vi;
                    }
                }
                Visit[] newCageVisits = Visit.enlargeVisitArray((Visit[])oldCage.get("CAG_VISIT"), 0);
                Visit[] newMouseVisits = Visit.enlargeVisitArray((Visit[])mouse.get("MOS_VISIT"), 0);
                Visit newCageVisit = Visit.findExtactlyThisVisit(newCageVisits, visitToEnd);
                if (newCageVisit == null) {
                    this.ivBugString = "CommandManagerMouse handle mouse transfer: cage visit to end not found. ID: " + oldCageID + " in group " + this.ivGroupname;
                    Log.info(this.ivBugString, this);
                    return false;
                }
                Visit newMouseVisit = Visit.findExtactlyThisVisit(newMouseVisits, visitToEnd);
                if (newMouseVisit == null) {
                    this.ivBugString = "CommandManagerMouse handle mouse transfer: mouse visit to end not found. ID: " + mouse.getID() + " in group " + this.ivGroupname;
                    Log.info(this.ivBugString, this);
                    return false;
                }
                newCageVisit.ivEndDate = transferDate;
                newCageVisit.ivEndMode = transferMode;
                newMouseVisit.ivEndDate = transferDate;
                newMouseVisit.ivEndMode = transferMode;
                mouse.set("MOS_VISIT", newMouseVisits);
                mouse.set("MOS_ROOM", null);
                this.ivObjectBag.put(mouse.getIdentifierString(), mouse);
                oldCage.set("CAG_VISIT", newCageVisits);
                this.ivObjectBag.put(oldCage.getIdentifierString(), oldCage);
                return true;
            }
            this.ivBugString = "CommandManagerMouse handle Mouse transfer: cage to leave not found. ID: " + oldCageID + " in group " + this.ivGroupname;
            Log.info(this.ivBugString, this);
            return false;
        }
        return true;
    }

    public static void mouseEntersCage(Mouse mouse, Cage cage, Date transferDate, int transferMode, Hashtable objectBag) {
        if (cage.getID() != mouse.getActCageID(0L)) {
            Visit enterVisit = new Visit(cage.getID(), mouse.getID(), transferDate, transferMode);
            mouse.set("MOS_VISIT", Visit.addVisitToArray((Visit[])mouse.get("MOS_VISIT"), enterVisit));
            mouse.set("MOS_ROOM", null);
            cage.set("CAG_VISIT", Visit.addVisitToArray((Visit[])cage.get("CAG_VISIT"), new Visit(enterVisit)));
            objectBag.put(cage.getIdentifierString(), cage);
        }
    }

    public static void appendTransferCommand(Mouse maus, long cageID, long millis, StringBuffer msb, boolean mitCR) {
        String csrt;
        String msrt = CommandManagerExecutive.getServiceRoomTag(maus, "");
        if (msrt.equals(csrt = CommandManagerExecutive.getServiceRoomTag(ObjectStore.getClientObject(2, cageID, maus.getGroup()), ""))) {
            msb.append(msrt);
        }
        msb.append(COM_MOS_TRANSFER);
        msb.append(" ").append(maus.getID());
        msb.append(" ").append(cageID);
        msb.append(" ").append(millis);
        msb.append(" ").append(maus.isActiveInMating() ? 7 : 2);
        if (mitCR) {
            msb.append("\n");
        }
    }

    public boolean handleCOM_MOS_TRANSFER_TO_ROOM() {
        Mouse mouse = (Mouse)this.ivObjectForCommand;
        long roomID = Long.parseLong(this.ivLine[2]);
        Room toRoom = (Room)ObjectStore.getObjectDeadOrAlive(10, roomID, this.ivGroupname, this.ivObjectBag, false);
        if (toRoom != null && toRoom.isSharedWithOtherGroups()) {
            int transferMode;
            Date efd = new Date(Long.parseLong(this.ivLine[3]));
            if (!this.mouseLeavesCage(mouse, efd, transferMode = Integer.parseInt(this.ivLine[4]))) {
                return false;
            }
            mouse.set("MOS_ROOM", new Long(roomID));
            this.ivObjectBag.put(mouse.getIdentifierString(), mouse);
            return true;
        }
        return false;
    }

    public boolean handleCOM_MOS_SET_SEX() {
        Mouse maus = (Mouse)this.ivObjectForCommand;
        int sex = Integer.parseInt(this.ivLine[2]);
        maus.setNormalSex(sex);
        this.propagateKidIntInformation(maus, "MOS_KID_SX", sex);
        return true;
    }

    private void propagateKidIntInformation(Mouse maus, String arrKey, int value) {
        long mausID = maus.getID();
        this.propagateKidIntInformation(maus, mausID, "MOS_FATHER", arrKey, value);
        this.propagateKidIntInformation(maus, mausID, "MOS_MOTHER", arrKey, value);
    }

    private void propagateKidIntInformation(Mouse maus, long mausID, String parentKey, String arrKey, int value) {
        Mouse parent;
        long pid = maus.getLong(parentKey, -1L);
        if (pid != -1L && (parent = (Mouse)ObjectStore.getObjectDeadOrAlive(1, pid, this.ivGroupname, this.ivObjectBag, false)) != null) {
            boolean changedSomething = false;
            long[] kids = (long[])parent.get("MOS_KID");
            int[] oldIntArr = (int[])parent.get(arrKey);
            if (kids != null && oldIntArr != null && kids.length == oldIntArr.length) {
                int[] newIntArr = new int[oldIntArr.length];
                int i = 0;
                while (i < kids.length) {
                    if (kids[i] == mausID) {
                        if (oldIntArr[i] != value) {
                            newIntArr[i] = value;
                            changedSomething = true;
                        }
                    } else {
                        newIntArr[i] = oldIntArr[i];
                    }
                    ++i;
                }
                if (changedSomething) {
                    parent.set(arrKey, newIntArr);
                    this.ivObjectBag.put(parent.getIdentifierString(), parent);
                }
            }
        }
    }

    public boolean handleCOM_MOS_SET_LINE() {
        Line line;
        Mouse maus = (Mouse)this.ivObjectForCommand;
        long newLineID = Long.parseLong(this.ivLine[2]);
        Line line2 = line = newLineID <= 0L ? null : (Line)ObjectStore.getObjectDeadOrAlive(7, newLineID, maus.getGroup(), this.ivObjectBag, false);
        if (line == null) {
            maus.set("MOS_LINEID", null);
            maus.set("MOS_LOCUSGENOTYPES", null);
        } else {
            maus.setLong("MOS_LINEID", newLineID);
            maus.set("MOS_LINLICID", line.get("LIN_LIC"));
            LocusAndAlleles[] lineArr = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            LocusAndAlleles[] mouseArr = (LocusAndAlleles[])maus.get("MOS_LOCUSGENOTYPES");
            LocusAndAlleles[] mouseNewArr = null;
            if (lineArr != null && mouseArr != null) {
                Vector<LocusAndAlleles> v = new Vector<LocusAndAlleles>();
                int i = 0;
                while (i < mouseArr.length) {
                    LocusAndAlleles lineMatch;
                    if (mouseArr[i].ivAllele != null && mouseArr[i].ivAllele.length != 0 && (lineMatch = LocusAndAlleles.findElement(mouseArr[i], lineArr)) != null) {
                        boolean takeit = true;
                        int allelPos = 0;
                        while (allelPos < mouseArr[i].ivAllele.length && takeit) {
                            if (ArrayHelper.findStringInArray(mouseArr[i].ivAllele[allelPos], lineMatch.ivAllele) == -1) {
                                takeit = false;
                            }
                            ++allelPos;
                        }
                        if (takeit) {
                            v.add(mouseArr[i]);
                        }
                    }
                    ++i;
                }
                if (!v.isEmpty()) {
                    mouseNewArr = new LocusAndAlleles[v.size()];
                    i = 0;
                    while (i < mouseNewArr.length) {
                        mouseNewArr[i] = (LocusAndAlleles)v.elementAt(i);
                        ++i;
                    }
                }
            }
            maus.set("MOS_LOCUSGENOTYPES", mouseNewArr);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_STRAIN() {
        Mouse mouse = (Mouse)this.ivObjectForCommand;
        if (this.ivLine[2].length() == 0) {
            mouse.set("MOS_STRAIN", null);
        } else {
            IndexObject[] res = IndexObject.getArray(this.ivLine[2], 8);
            if (res == null) {
                return false;
            }
            mouse.set("MOS_STRAIN", res);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_LOCUSGENOTYPE() {
        LocusAndAlleles laa = new LocusAndAlleles(Base64Manager.getDecodedString(this.ivLine[2]));
        LocusAndAlleles[] laaArrayInMouse = (LocusAndAlleles[])this.ivObjectForCommand.get("MOS_LOCUSGENOTYPES");
        if (laa.ivAllele == null) {
            LocusAndAlleles laaInMouse;
            if (laaArrayInMouse != null && (laaInMouse = LocusAndAlleles.findElement(laa, laaArrayInMouse)) != null) {
                Vector<LocusAndAlleles> nlgtv = new Vector<LocusAndAlleles>();
                int i = 0;
                while (i < laaArrayInMouse.length) {
                    if (laaArrayInMouse[i].ivLocusID != laa.ivLocusID) {
                        nlgtv.addElement(laaArrayInMouse[i]);
                    }
                    ++i;
                }
                if (nlgtv.isEmpty()) {
                    this.ivObjectForCommand.set("MOS_LOCUSGENOTYPES", null);
                } else {
                    LocusAndAlleles[] neuGenotypes = new LocusAndAlleles[nlgtv.size()];
                    int i2 = 0;
                    while (i2 < nlgtv.size()) {
                        neuGenotypes[i2] = (LocusAndAlleles)nlgtv.elementAt(i2);
                        ++i2;
                    }
                    this.ivObjectForCommand.set("MOS_LOCUSGENOTYPES", neuGenotypes);
                }
            }
        } else if (laaArrayInMouse == null) {
            this.ivObjectForCommand.set("MOS_LOCUSGENOTYPES", new LocusAndAlleles[]{laa});
        } else {
            LocusAndAlleles laaInMouse = LocusAndAlleles.findElement(laa, laaArrayInMouse);
            LocusAndAlleles[] newGenotypes = null;
            if (laaInMouse != null) {
                newGenotypes = new LocusAndAlleles[laaArrayInMouse.length];
                int i = 0;
                while (i < laaArrayInMouse.length) {
                    LocusAndAlleles orig = laaArrayInMouse[i];
                    newGenotypes[i] = orig.ivLocusID == laa.ivLocusID ? new LocusAndAlleles(orig.ivLocusID, laa.ivAllele) : new LocusAndAlleles(orig.ivLocusID, orig.ivAllele);
                    ++i;
                }
            } else {
                newGenotypes = new LocusAndAlleles[laaArrayInMouse.length + 1];
                newGenotypes[0] = laa;
                int i = 0;
                while (i < laaArrayInMouse.length) {
                    newGenotypes[i + 1] = laaArrayInMouse[i];
                    ++i;
                }
            }
            this.ivObjectForCommand.set("MOS_LOCUSGENOTYPES", newGenotypes);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_EARTAG() {
        this.ivObjectForCommand.setInt("MOS_EARTAG", this.ivLine[2]);
        String prefix = this.ivLine[3];
        if (prefix.length() == 0) {
            this.ivObjectForCommand.set("MOS_ETPF", null);
        } else {
            this.ivObjectForCommand.set("MOS_ETPF", Base64Manager.getDecodedString(prefix));
        }
        MiscHandler.handleLastEartag((Mouse)this.ivObjectForCommand);
        return true;
    }

    public boolean handleCOM_MOS_SET_GENERATION() {
        int generation = Integer.parseInt(this.ivLine[2]);
        if (generation == -2) {
            this.ivObjectForCommand.set("MOS_GENMAN", null);
        } else {
            this.ivObjectForCommand.setInt("MOS_GENMAN", generation);
        }
        this.reicheGenerationDurch((Mouse)this.ivObjectForCommand);
        return true;
    }

    private void reicheGenerationDurch(Mouse parentMouse) {
        long[] kidIDs = (long[])parentMouse.get("MOS_KID");
        if (kidIDs != null) {
            int parentMouseGeneration = parentMouse.getGeneration(0, true);
            long parentMouseID = parentMouse.getID();
            if (parentMouseID != 0L) {
                Mouse kid;
                Vector<Mouse> kids = new Vector<Mouse>();
                int i = 0;
                while (i < kidIDs.length) {
                    kid = (Mouse)ObjectStore.getObjectDeadOrAlive(1, kidIDs[i], this.ivGroupname, this.ivObjectBag, false);
                    if (kid != null) {
                        String tag = null;
                        if (parentMouseID == kid.getLong("MOS_FATHER", 0L)) {
                            tag = "MOS_GENFA";
                        } else if (parentMouseID == kid.getLong("MOS_MOTHER", 0L)) {
                            tag = "MOS_GENMO";
                        }
                        if (tag != null) {
                            kids.add(kid);
                            kid.setInt(tag, parentMouseGeneration, 0);
                        }
                    }
                    ++i;
                }
                Iterator iter = kids.iterator();
                while (iter.hasNext()) {
                    kid = (Mouse)iter.next();
                    this.reicheGenerationDurch(kid);
                }
            }
        }
    }

    public boolean handleCOM_MOS_ADD_COMMENT() {
        String comment = this.ivObjectForCommand.getString("MOS_COMMENT");
        String commentAdd = Base64Manager.getDecodedString(this.ivLine[2]);
        comment = comment == null ? commentAdd : String.valueOf(comment) + "\n" + commentAdd;
        this.ivObjectForCommand.set("MOS_COMMENT", comment);
        return true;
    }

    public boolean handleCOM_MOS_CLEAR_COMMENT() {
        if (this.ivObjectForCommand.get("MOS_COMMENT", null) != null) {
            this.ivObjectForCommand.set("MOS_COMMENT", null);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_COMMENT() {
        this.ivObjectForCommand.set("MOS_COMMENT", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleCOM_MOS_SET_TAG() {
        return CommanManUtil.setMark(this.ivObjectForCommand, "MOS_FLAG", this.ivLine[2]);
    }

    public boolean handleCOM_MOS_SET_BIRTHDAY() {
        Mouse maus = (Mouse)this.ivObjectForCommand;
        long bd = Long.parseLong(this.ivLine[2]);
        maus.set("MOS_BIRTHDAY", bd != 0L ? new Date(bd) : null);
        this.propagateKidIntInformation(maus, "MOS_KID_BD", bd != 0L ? MyDate.getTage(bd) : Integer.MIN_VALUE);
        return true;
    }

    public boolean handleCOM_MOS_SET_PLUGDAY() {
        long plugDateMillis = Long.parseLong(this.ivLine[2]);
        int plugAlertTage = Integer.parseInt(this.ivLine[3]);
        if (plugDateMillis != 0L) {
            this.storePlugday((Mouse)this.ivObjectForCommand, plugDateMillis);
            this.ivObjectForCommand.setDate("MOS_PLUGDATE", plugDateMillis);
            this.ivObjectForCommand.setInt("MOS_PLUGALERT", plugAlertTage);
        } else {
            this.ivObjectForCommand.set("MOS_PLUGDATE", null);
            this.ivObjectForCommand.set("MOS_PLUGALERT", null);
        }
        return true;
    }

    public boolean handleCOM_MOS_ADD_PLUG_DATE() {
        int plugTage = Integer.parseInt(this.ivLine[2]);
        int[] allPlugDatesAlt = (int[])this.ivObjectForCommand.get("MOS_ALLPLUGDATES");
        int[] allPlugDatesNeu = null;
        if (allPlugDatesAlt == null) {
            allPlugDatesNeu = new int[]{plugTage};
        } else {
            boolean datumDa = false;
            int i = 0;
            while (i < allPlugDatesAlt.length) {
                if (allPlugDatesAlt[i] == plugTage) {
                    datumDa = true;
                }
                ++i;
            }
            if (datumDa) {
                return true;
            }
            allPlugDatesNeu = new int[allPlugDatesAlt.length + 1];
            i = 0;
            while (i < allPlugDatesAlt.length) {
                allPlugDatesNeu[i] = allPlugDatesAlt[i];
                ++i;
            }
            allPlugDatesNeu[allPlugDatesNeu.length - 1] = plugTage;
        }
        this.ivObjectForCommand.set("MOS_ALLPLUGDATES", allPlugDatesNeu);
        return true;
    }

    public boolean handleCOM_MOS_REM_PLUG_DATE() {
        int plugTage = Integer.parseInt(this.ivLine[2]);
        int[] allPlugDatesAlt = (int[])this.ivObjectForCommand.get("MOS_ALLPLUGDATES");
        if (allPlugDatesAlt == null) {
            return true;
        }
        int anzGefunden = 0;
        int i = 0;
        while (i < allPlugDatesAlt.length) {
            if (allPlugDatesAlt[i] == plugTage) {
                ++anzGefunden;
            }
            ++i;
        }
        if (anzGefunden == 0) {
            return true;
        }
        int[] allPlugDatesNeu = null;
        if (anzGefunden != allPlugDatesAlt.length) {
            allPlugDatesNeu = new int[allPlugDatesAlt.length - anzGefunden];
            int pos = 0;
            int i2 = 0;
            while (i2 < allPlugDatesAlt.length) {
                if (allPlugDatesAlt[i2] != plugTage) {
                    allPlugDatesNeu[pos++] = allPlugDatesAlt[i2];
                }
                ++i2;
            }
        }
        this.ivObjectForCommand.set("MOS_ALLPLUGDATES", allPlugDatesNeu);
        return true;
    }

    public boolean handleCOM_MOS_SET_SPECIALDATE() {
        Integer plugTage = this.ivLine[2].length() == 0 ? null : new Integer(this.ivLine[2]);
        this.ivObjectForCommand.set("MOS_SPDAT", plugTage);
        return true;
    }

    private void storePlugday(Mouse maus, long millis) {
        int tage = MyDate.getTage(millis);
        int[] arr = (int[])maus.get("MOS_ALLPLUGDATES");
        if (arr != null) {
            boolean schonda = false;
            int i = 0;
            while (i < arr.length) {
                if (arr[i] == tage) {
                    schonda = true;
                }
                ++i;
            }
            if (!schonda) {
                int[] narr = new int[arr.length + 1];
                int i2 = 0;
                while (i2 < arr.length) {
                    narr[i2] = arr[i2];
                    ++i2;
                }
                narr[narr.length - 1] = tage;
                maus.set("MOS_ALLPLUGDATES", narr);
            }
        } else {
            arr = new int[]{tage};
            maus.set("MOS_ALLPLUGDATES", arr);
        }
    }

    public boolean handleCOM_MOS_SET_PREGNANT() {
        this.ivObjectForCommand.setInt("MOS_PREGNANT", Integer.parseInt(this.ivLine[2]), 0);
        return true;
    }

    public boolean handleCOM_MOS_SET_SEX_VARIANT() {
        ((Mouse)this.ivObjectForCommand).setSexVariant(Integer.parseInt(this.ivLine[2]));
        return true;
    }

    public boolean handleCOM_MOS_SET_OWNER() {
        this.ivObjectForCommand.set("MOS_OWNER", new long[]{Long.parseLong(this.ivLine[2])});
        this.ivObjectForCommand.set("MOS_OWNERGROUPS", null);
        return true;
    }

    public boolean handleCOM_MOS_SET_OWNER_GROUP() {
        this.ivObjectForCommand.set("MOS_OWNER", null);
        this.ivObjectForCommand.set("MOS_OWNERGROUPS", new long[]{Long.parseLong(this.ivLine[2])});
        return true;
    }

    public boolean handleCOM_MOS_SET_PRIMARAY_OWNER() {
        long primaryOwnerID = Long.parseLong(this.ivLine[2]);
        long[] owners = (long[])this.ivObjectForCommand.get("MOS_OWNER");
        if (owners == null) {
            this.ivObjectForCommand.set("MOS_OWNER", new long[]{primaryOwnerID});
        } else {
            boolean found = false;
            int i = 0;
            while (i < owners.length) {
                if (owners[i] == primaryOwnerID) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                long[] newOwnerArray = new long[owners.length];
                newOwnerArray[0] = primaryOwnerID;
                int ind = 1;
                int i2 = 0;
                while (i2 < owners.length) {
                    if (owners[i2] != primaryOwnerID) {
                        newOwnerArray[ind] = owners[i2];
                        ++ind;
                    }
                    ++i2;
                }
                this.ivObjectForCommand.set("MOS_OWNER", newOwnerArray);
            }
        }
        return true;
    }

    public boolean handleCOM_MOS_ADD_OWNER() {
        long auftraggeberID = Long.parseLong(this.ivLine[2]);
        long shareUserID = Long.parseLong(this.ivLine[3]);
        long[] owners = (long[])this.ivObjectForCommand.get("MOS_OWNER");
        owners = ArrayHelper.addLongToArraySingulaer(owners, auftraggeberID);
        owners = ArrayHelper.addLongToArraySingulaer(owners, shareUserID);
        this.ivObjectForCommand.set("MOS_OWNER", owners);
        return true;
    }

    public boolean handleCOM_MOS_ADD_OWNER_GROUP() {
        long auftraggeberID = Long.parseLong(this.ivLine[2]);
        long ownerGroupUD = Long.parseLong(this.ivLine[3]);
        long[] owners = (long[])this.ivObjectForCommand.get("MOS_OWNER");
        owners = ArrayHelper.addLongToArraySingulaer(owners, auftraggeberID);
        this.ivObjectForCommand.set("MOS_OWNER", owners);
        long[] ownerGroups = (long[])this.ivObjectForCommand.get("MOS_OWNERGROUPS");
        owners = ArrayHelper.addLongToArraySingulaer(ownerGroups, ownerGroupUD);
        this.ivObjectForCommand.set("MOS_OWNERGROUPS", owners);
        return true;
    }

    public boolean handleCOM_MOS_REM_OWNER_OR_GROUP() {
        long[] newArr;
        boolean isUser = "0".equals(this.ivLine[2]);
        String tag = isUser ? "MOS_OWNER" : "MOS_OWNERGROUPS";
        long objectID = Long.parseLong(this.ivLine[3]);
        long[] owners = (long[])this.ivObjectForCommand.get(tag);
        if (owners != null && (newArr = ArrayHelper.getArrayWithout(owners, objectID, null)) != null) {
            this.ivObjectForCommand.set(tag, newArr.length == 0 ? null : newArr);
            return true;
        }
        this.ivBugString = "CommandManagerMouse handleCOM_MOS_REM_OWNER_OR_GROUP could not remove owner with ID " + objectID;
        return false;
    }

    public boolean handleCOM_MOS_CLEAR_OWNER() {
        this.ivObjectForCommand.set("MOS_OWNER", null);
        this.ivObjectForCommand.set("MOS_OWNERGROUPS", null);
        return true;
    }

    public boolean handleCOM_MOS_SET_ANTAG() {
        return this.setStringVal("MOS_ANTAG");
    }

    public boolean handleCOM_MOS_SET_LIEFERSCHEIN() {
        return this.setStringVal("MOS_SHIPID");
    }

    private boolean setStringVal(String objetTag) {
        String anTag = Base64Manager.getDecodedString(this.ivLine[2]);
        if ((anTag = anTag.trim()).length() != 0) {
            this.ivObjectForCommand.set(objetTag, anTag);
        } else {
            this.ivObjectForCommand.set(objetTag, null);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_MATLIM() {
        return CommanManUtil.handleSetInt(this.ivObjectForCommand, "MOS_MATLIM", this.ivLine, 2, -1, "handleCOM_MOS_SET_MATLIM", this.ivObjectBag);
    }

    public boolean handleCOM_MOS_SET_COAT_COLOR() {
        return CommanManUtil.handleSetInt(this.ivObjectForCommand, "MOS_COAT_COLOR", this.ivLine, 2, 0, "handleCOM_MOS_SET_COAT_COLOR", this.ivObjectBag);
    }

    public boolean handleCOM_COM_MOS_STRESS_LEVEL() {
        if (TierSchutz.belastungNeeded()) {
            int origVal = 0;
            int stressLevel = Integer.parseInt(this.ivLine[2]);
            int arrPos = Integer.parseInt(this.ivLine[3]);
            int[] stressArrayVorher = (int[])this.ivObjectForCommand.get("MOS_STRLEV");
            if (stressArrayVorher != null) {
                origVal = stressArrayVorher[arrPos];
            }
            int[] stressArrayNachher = new int[3];
            int i = 0;
            while (i < stressArrayNachher.length) {
                stressArrayNachher[i] = stressArrayVorher != null ? stressArrayVorher[i] : 0;
                ++i;
            }
            stressArrayNachher[arrPos] = stressLevel;
            if (arrPos == 1 && stressLevel != 0 && origVal == 0 && this.ivObjectForCommand.isDead()) {
                Stress.removeMouseFromStressMissingListe((Mouse)this.ivObjectForCommand);
            }
            i = 0;
            while (i < stressArrayNachher.length) {
                if (stressArrayNachher[i] != 0) {
                    this.ivObjectForCommand.set("MOS_STRLEV", stressArrayNachher);
                    return true;
                }
                ++i;
            }
            this.ivObjectForCommand.set("MOS_STRLEV", null);
        }
        return true;
    }

    public boolean handleCOM_MOS_SET_TISSUE_SAMPLE() {
        String val = Base64Manager.getDecodedString(this.ivLine[2]);
        this.ivObjectForCommand.set("MOS_TISSUE", val.length() == 0 ? null : val);
        return true;
    }

    public boolean handleCOM_MOS_TAKE_MICE() {
        String ttms = this.ivLine[1];
        ttms = StringHelper.gSub(ttms, "@S@", " ");
        ttms = StringHelper.gSub(ttms, "@R@", "\n");
        Vector tmv = StringHelper.splitStringByAny(ttms, "\n");
        Vector oad = new Vector();
        IDObject.splitInObjectDumps(tmv, oad);
        Date jetzt = new Date();
        int i = 0;
        while (i < oad.size()) {
            Mouse obi = new Mouse();
            obi.setInt("MOS_STARTMODE", 3);
            if (!this.finishNewObject(obi, Long.toString(jetzt.getTime()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleCOM_MOS_MARK_ABGESETZT() {
        Mouse mouse = (Mouse)this.ivObjectForCommand;
        mouse.setBoolean("MOS_ABGES", true);
        mouse.setBoolean("MOS_ABGESMAN", true);
        long cid = mouse.getActCageIDAlsoDead(0L);
        if (cid > 0L) {
            this.getCageToUpdate(cid, this.ivObjectBag, this.ivGroupname);
        }
        return true;
    }

    public boolean handleRES_NEW() {
        if (this.ivExtraObject == null) {
            Log.info("CommandManagerResult handleRESNEW: no result transmitted", this);
            return false;
        }
        if (!(this.ivExtraObject instanceof MResult)) {
            Log.info("CommandManagerResult handleRESNEW: no valid result transmitted", this);
            return false;
        }
        MResult mres = (MResult)this.ivExtraObject;
        mres.ivPseudoID = MilliSpender.getMillis();
        if (mres.ivResult instanceof ResultObjectImage) {
            ResultObjectImage roi = (ResultObjectImage)mres.ivResult;
            try {
                DataLayer.cvDataLayer.storeImage(this.ivGroupname, roi.ivOrigFilename, roi.ivOrigData, roi.ivOrigDim, Long.toString(mres.ivPseudoID));
                DataLayer.cvDataLayer.storeThumbImage(this.ivGroupname, roi.ivThumbData, roi.ivThumbDim, Long.toString(mres.ivPseudoID));
            }
            catch (Exception e) {
                Log.info("CommandManagerMouse handleCOM_MOS_ADD_RESULT: image storage impossible", this);
                return false;
            }
            roi.ivOrigData = null;
        }
        ((Mouse)this.ivObjectForCommand).addMresult(mres);
        return true;
    }

    public boolean handleRES_REMOVE() {
        ((Mouse)this.ivObjectForCommand).remMresult(Long.parseLong(this.ivLine[2]));
        return true;
    }

    public boolean handleCOM_MOSSETPARENT() {
        Mouse kid = (Mouse)this.ivObjectForCommand;
        Mouse parent = (Mouse)ObjectStore.getObjectDeadOrAlive(1, Long.parseLong(this.ivLine[2]), this.ivGroupname, this.ivObjectBag, false);
        boolean father = "1".equals(this.ivLine[3]);
        if (parent != null) {
            int pSex = parent.getSex();
            if (father && pSex != 1 || !father && pSex != 2) {
                this.ivBugString = "CommandManagerMouse handleCOM_MOSSETPARENT: parent has wrong sex";
                Log.info(this.ivBugString, this);
                return false;
            }
        } else {
            this.ivBugString = "CommandManagerMouse handleCOM_MOSSETPARENT: parent missing";
            Log.info(this.ivBugString, this);
            return false;
        }
        kid.set(father ? "MOS_FATHER" : "MOS_MOTHER", parent.get("IDO_ID"));
        Date bD = kid.getDate("MOS_BIRTHDAY");
        LitterHelper.incKidArrays(parent, new long[]{kid.getID()}, bD == null ? Integer.MIN_VALUE : MyDate.getTage(bD), kid);
        return true;
    }

    private Cage getCageToUpdate(long id, Hashtable objectBag, String groupName) {
        return (Cage)ObjectStoreServer.getObjectToUpdate(2, id, groupName, objectBag);
    }
}

