/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.User;
import mausoleum.helper.Zeile;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.mouse.Mouse;

public class CommandManagerObjectGroup
extends CommandManagerExecutive {
    private static final String PREFIX = "IOG";
    public static final String COM_IOG_NEW = "IOGNEW";
    public static final String COM_IOG_RM = "IOGRM";
    public static final String COM_IOG_REVIT = "IOGREVIT";
    public static final String COM_IOG_CHNAME = "IOGCHNAME";
    public static final String COM_IOG_CHCOMMENT = "IOGCHCOMMENT";
    public static final String COM_IOG_CHCOLOR = "IOGCHCOLOR";
    public static final String COM_IOG_CHINHERITABLE = "IOGCHINHERIT";
    public static final String COM_IOG_ADD_ID = "IOGADDID";
    public static final String COM_IOG_REM_ID = "IOGREMID";
    public static final String COM_IOG_SET_PRIMARAY_OWNER = "IOGSETPRIMOWN";
    public static final String COM_IOG_KILL_FINAL = "IOG_KILL_FINAL";

    public CommandManagerObjectGroup() {
        super(19);
        this.addMeth(COM_IOG_NEW, "handleNew", 3, false);
        this.addMeth(COM_IOG_RM, "setInvisible", 2, true);
        this.addMeth(COM_IOG_REVIT, "setVisible", 2, true);
        this.addMeth(COM_IOG_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_IOG_CHNAME, "changeName", 3, true);
        this.addMeth(COM_IOG_CHCOMMENT, "changeComment", 3, true);
        this.addMeth(COM_IOG_CHCOLOR, "changeColor", 3, true);
        this.addMeth(COM_IOG_CHINHERITABLE, "changeInheritability", 3, true);
        this.addMeth(COM_IOG_ADD_ID, "addID", 4, true);
        this.addMeth(COM_IOG_REM_ID, "removeID", 4, true);
        this.addMeth(COM_IOG_SET_PRIMARAY_OWNER, "setPrimaryOwner", 4, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_IOG_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new object-group";
            }
            return null;
        }
        if (command.equals(COM_IOG_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed object-group " + this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 7 && z.getLong(1, 0L) == id) {
                return "Removed object-group";
            }
            return null;
        }
        if (command.equals(COM_IOG_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized object-group " + this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return "Revitalized object-group";
            }
            return null;
        }
        if (command.equals(COM_IOG_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return CommandManagerObjectGroup.getPB64String("Changed name of object-group " + romRef + " to: ", z, 2);
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return CommandManagerObjectGroup.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_IOG_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return CommandManagerObjectGroup.getPB64String("Set comment of object-group " + romRef + " to: ", z, 2);
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return CommandManagerObjectGroup.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_IOG_CHINHERITABLE)) {
            String inh = "not inheritable";
            if (z.getString(2).equals("1")) {
                inh = "inheritable";
            }
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return "Set inheritability of object-group " + romRef + " to: " + inh;
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return "Set inheritability to: " + inh;
            }
            return null;
        }
        if (command.equals(COM_IOG_ADD_ID)) {
            String objRef = this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(3, 0L), objectGroup);
            if (typ == 0 && id == 0L) {
                String grRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return "Added object: " + objRef + " to object-group " + grRef;
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return "Added object: " + objRef;
            }
        } else if (command.equals(COM_IOG_REM_ID)) {
            String objRef = this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(3, 0L), objectGroup);
            if (typ == 0 && id == 0L) {
                String grRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return "Removed object: " + objRef + " from object-group " + grRef;
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return "Removed object: " + objRef;
            }
        } else if (COM_IOG_SET_PRIMARAY_OWNER.equals(command)) {
            String objRef = this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(3, 0L), objectGroup);
            if (typ == 0 && id == 0L) {
                String grRef = this.getIDObjectRef(group, 19, z.getLong(1, 0L), objectGroup);
                return "Set primary owner: " + objRef + " from object-group " + grRef;
            }
            if (typ == 19 && z.getLong(1, 0L) == id) {
                return "Set primary owner: " + objRef;
            }
        }
        return "CME_NP";
    }

    public boolean handleNew() {
        IDObjectGroup iog = new IDObjectGroup();
        iog.set("IOG_N", Base64Manager.getDecodedString(this.ivLine[1]));
        iog.set("IDO_SUBTYP", new Integer(this.ivLine[2]));
        return this.finishNewObject(iog, null);
    }

    public boolean changeName() {
        this.ivObjectForCommand.set("IOG_N", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean changeComment() {
        this.ivObjectForCommand.set("IOG_COM", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean changeColor() {
        this.ivObjectForCommand.set("IOG_COL", CommandManagerObjectGroup.convertToColor(this.ivLine[2]));
        return true;
    }

    public boolean changeInheritability() {
        IDObjectGroup iog;
        if (this.ivObjectForCommand instanceof IDObjectGroup && (iog = (IDObjectGroup)this.ivObjectForCommand).getInt("IDO_SUBTYP", 0) == 2) {
            iog.setBoolean("IOG_INHERITABLE", this.ivLine[2].equals("1"));
            return true;
        }
        return false;
    }

    public boolean addID() {
        return this.doIDCOMB(true);
    }

    public boolean removeID() {
        return this.doIDCOMB(false);
    }

    public boolean doIDCOMB(boolean addIt) {
        long groupID = Long.parseLong(this.ivLine[1]);
        long objectID = Long.parseLong(this.ivLine[3]);
        IDObject theGroup = ObjectStoreServer.getObjectDeadOrAlive(Integer.parseInt(this.ivLine[2]), objectID, this.ivGroupname, this.ivObjectBag, false, false);
        if (theGroup != null) {
            long[] arr = (long[])this.ivObjectForCommand.get("IOG_IDS");
            long primaryOwnerID = arr != null && arr.length > 0 ? arr[0] : -1L;
            IDObject.handleLongToArr(this.ivObjectForCommand, "IOG_IDS", objectID, addIt);
            if (primaryOwnerID != -1L) {
                this.setPrimaryID(this.ivObjectForCommand, primaryOwnerID);
            }
            if (theGroup instanceof Mouse) {
                IDObject.handleLongToArr(theGroup, "MOS_COHORTS", groupID, addIt);
                return true;
            }
            if (theGroup instanceof User) {
                IDObject.handleLongToArr(theGroup, "USR_OWNER_GROUPS", groupID, addIt);
                return true;
            }
        }
        return false;
    }

    public boolean setPrimaryOwner() {
        long primaryOwnerID = Long.parseLong(this.ivLine[3]);
        return this.setPrimaryID(this.ivObjectForCommand, primaryOwnerID);
    }

    private boolean setPrimaryID(IDObject ido, long primaryOwnerID) {
        long[] owners = (long[])ido.get("IOG_IDS");
        long[] newOwnerArray = null;
        if (owners == null) {
            newOwnerArray = new long[]{primaryOwnerID};
        } else {
            boolean found = false;
            int i = 0;
            while (i < owners.length) {
                if (owners[i] == primaryOwnerID) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                newOwnerArray = new long[owners.length];
                newOwnerArray[0] = primaryOwnerID;
                int ind = 1;
                int i2 = 0;
                while (i2 < owners.length) {
                    if (owners[i2] != primaryOwnerID) {
                        newOwnerArray[ind] = owners[i2];
                        ++ind;
                    }
                    ++i2;
                }
            }
        }
        if (newOwnerArray != null) {
            ido.set("IOG_IDS", newOwnerArray);
        }
        return newOwnerArray != null;
    }
}

