/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.objectstore.requesthandler.OBRHS_Service_Manager;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.Zeile;
import mausoleum.objectstore.CommandManagerCage;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public class CommandManagerRoom
extends CommandManagerExecutive {
    public static final String COM_ROM_NEW = "ROMNEW";
    public static final String COM_ROM_RM = "ROMRM";
    public static final String COM_ROM_CHNAME = "ROMCHNAME";
    public static final String COM_ROM_CHCOMMENT = "ROMCHCOMMENT";
    public static final String COM_ROM_CHBAUBESONDERHEITEN = "ROMCHBAUBESONDERHEITEN";
    public static final String COM_ROM_CHSECURITY = "ROMCHSECURITY";
    public static final String COM_ROM_SET_BUILDING = "ROMSET_BUILDING";
    public static final String COM_ROM_SET_ACCESSIBLE = "ROMSET_ACCESSIBLE";
    public static final String COM_ROM_REMOVE_EMPTY_CAGES = "ROM_REM_EMPTY_CAGES";

    public CommandManagerRoom() {
        super(10);
        this.addMeth(COM_ROM_NEW, "handleROMNEW", 2, false);
        this.addMeth(COM_ROM_RM, "handleROMREMOVE", 2, true);
        this.addMeth(COM_ROM_CHNAME, "handleROMCHNAME", 3, true);
        this.addMeth(COM_ROM_CHCOMMENT, "handleROMCHCOMMENT", 3, true);
        this.addMeth(COM_ROM_CHSECURITY, "handleROMCHSECURITY", 3, true);
        this.addMeth(COM_ROM_SET_BUILDING, "handleROMSETBUILDING", 3, true);
        this.addMeth(COM_ROM_SET_ACCESSIBLE, "handleROMSETACCESIBLE", 3, true);
        this.addMeth(COM_ROM_REMOVE_EMPTY_CAGES, "handleCOMROMREMOVEEMPTYCAGES", 2, true);
        this.addMeth(COM_ROM_CHBAUBESONDERHEITEN, "handleROMCHBAUBESONDERHEITEN", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_ROM_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new room";
            }
            return null;
        }
        if (command.equals(COM_ROM_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed room " + this.getIDObjectRef(group, 10, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 10 && z.getLong(1, 0L) == id) {
                return "Removed room";
            }
            return null;
        }
        if (command.equals(COM_ROM_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 10, z.getLong(1, 0L), objectGroup);
                return CommandManagerRoom.getPB64String("Changed name of room " + romRef + " to: ", z, 2);
            }
            if (typ == 10 && z.getLong(1, 0L) == id) {
                return CommandManagerRoom.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_ROM_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 10, z.getLong(1, 0L), objectGroup);
                return CommandManagerRoom.getPB64String("Set comment of room " + romRef + " to: ", z, 2);
            }
            if (typ == 10 && z.getLong(1, 0L) == id) {
                return CommandManagerRoom.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_ROM_CHBAUBESONDERHEITEN)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 10, z.getLong(1, 0L), objectGroup);
                return CommandManagerRoom.getPB64String("Set actual keeping anomalies of room " + romRef + " to: ", z, 2);
            }
            if (typ == 10 && z.getLong(1, 0L) == id) {
                return CommandManagerRoom.getPB64String("Set actual keeping anomalies to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_ROM_CHSECURITY)) {
            if (typ == 0 && id == 0L) {
                String romRef = this.getIDObjectRef(group, 10, z.getLong(1, 0L), objectGroup);
                String secLevel = "Unknown";
                try {
                    secLevel = StringHelper.getStringForInt(z.getInt(2, 0), Room.SECURITY_INTS, Room.SECURITY_STRINGS, false, "SECURITY_UNKNOWN");
                    secLevel = Babel.get(secLevel, "en");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Changed security level of room " + romRef + " to: >" + secLevel + "<";
            }
            if (typ == 10 && z.getLong(1, 0L) == id) {
                String secLevel = "Unknown";
                try {
                    secLevel = StringHelper.getStringForInt(z.getInt(2, 0), Room.SECURITY_INTS, Room.SECURITY_STRINGS, false, "SECURITY_UNKNOWN");
                    secLevel = Babel.get(secLevel, "en");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Changed security level to: >" + secLevel + "<";
            }
            if (command.equals(COM_ROM_SET_BUILDING)) {
                if (typ == 0 && id == 0L) {
                    long roomID = z.getLong(1, 0L);
                    long buildingID = z.getLong(2, 0L);
                    String roomRef = this.getIDObjectRef(group, 10, roomID, objectGroup);
                    if (buildingID == -1L) {
                        return "Cleared building information of room: " + roomRef;
                    }
                    String buildingRef = this.getIDObjectRef(group, 22, buildingID, objectGroup);
                    return "Defined location of room " + roomRef + " in building " + buildingRef;
                }
                if (typ == 10 && z.getLong(1, 0L) == id) {
                    long buildingID = z.getLong(2, 0L);
                    if (buildingID == -1L) {
                        return "Cleared building information";
                    }
                    String buildingRef = this.getIDObjectRef(group, 22, buildingID, objectGroup);
                    return "Defined location of room in building " + buildingRef;
                }
                if (typ == 22 && z.getLong(2, 0L) == id) {
                    long roomID = z.getLong(1, 0L);
                    String roomRef = this.getIDObjectRef(group, 10, roomID, objectGroup);
                    return "Defined location of room " + roomRef + " in this building";
                }
                return null;
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleROMNEW() {
        Room room = new Room();
        room.set("ROM_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        return this.finishNewObject(room, null);
    }

    public boolean handleROMCHNAME() {
        return this.setStringAndPropagate(2, "ROM_NAME", true);
    }

    public boolean handleROMCHCOMMENT() {
        return this.setStringAndPropagate(2, "ROM_DESC", true);
    }

    public boolean handleROMCHBAUBESONDERHEITEN() {
        return this.setStringAndPropagate(2, "ROM_BBS", true);
    }

    public boolean handleROMREMOVE() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "IDO_END_DATE", new Date());
        return true;
    }

    public boolean handleROMCHSECURITY() {
        return this.setIntAttributeAndPropagate(2, "ROM_SECURITY", -1);
    }

    public boolean handleROMSETBUILDING() {
        if ("service".equals(this.ivGroupname)) {
            long buildingID = Long.parseLong(this.ivLine[2]);
            if (buildingID == -1L) {
                this.ivObjectForCommand.set("ROM_BUILDING", null);
            } else {
                this.ivObjectForCommand.setLong("ROM_BUILDING", buildingID);
                IDObject building = ObjectStoreServer.getObjectToUpdate(22, buildingID, this.ivGroupname, this.ivObjectBag);
                building.setInt("IDO_VERSION", building.getInt("IDO_VERSION", 0) + 1);
            }
            return true;
        }
        return false;
    }

    public boolean handleROMSETACCESIBLE() {
        if ("service".equals(this.ivGroupname)) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "ROM_ACCESSIBLE", "1".equals(this.ivLine[2]) ? null : new Boolean(false));
            return true;
        }
        return false;
    }

    public boolean handleCOMROMREMOVEEMPTYCAGES() {
        if ("service".equals(this.ivGroupname)) {
            Vector cages = new Vector();
            Vector serviceRacks = new Vector();
            OBRHS_Service_Manager.collectEmptyCagesInRoom((Room)this.ivObjectForCommand, cages, serviceRacks, this.ivObjectBag);
            if (!cages.isEmpty()) {
                long jetzt = System.currentTimeMillis();
                String[] bruddel = new String[1];
                Iterator iterator = cages.iterator();
                while (iterator.hasNext()) {
                    Cage cage = (Cage)iterator.next();
                    if (CommandManagerCage.removeCage(cage, this.ivObjectBag, jetzt, bruddel, this.ivServiceRoomOverride, false)) continue;
                    this.ivBugString = bruddel[0];
                    return false;
                }
            }
            Iterator iterator = serviceRacks.iterator();
            while (iterator.hasNext()) {
                Rack serviceRack = (Rack)iterator.next();
                Rack.propagateCageOccupation(serviceRack, this.ivObjectBag, this.ivServiceRoomOverride);
            }
            return true;
        }
        return false;
    }
}

