/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Log;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.mouse.TaskExtended;

public class CommandManagerTask
extends CommandManagerExecutive {
    public static final String COM_MOS_ALTERTASK = "MALTERTASK";
    public static final String COM_MOS_REMTASK = "MREMTASK";

    public CommandManagerTask() {
        super(-1);
        this.addMeth(COM_MOS_ALTERTASK, "handleCOM_MOS_ADDTASK", 4, false);
        this.addMeth(COM_MOS_REMTASK, "handleCOM_MOS_REMTASK", 8, false);
        this.addMeth("MADDTASK", "handleCOM_MOS_ADDTASK", 4, false);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_MOS_ALTERTASK) || command.equals("MADDTASK")) {
            String texb64;
            if (z.size() == 5) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Added task for mouse " + mosRef + " for " + DatumFormat.getJustDateString(z.getInt(3, 0)) + " description: " + Base64Manager.getDecodedString(z.getString(4, ""));
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Added task for " + DatumFormat.getJustDateString(z.getInt(3, 0)) + " description: " + Base64Manager.getDecodedString(z.getString(4, ""));
                }
                return null;
            }
            if (typ == 0 && id == 0L) {
                String texb642 = z.getString(3, null);
                if (texb642 != null) {
                    String objRef = this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(1, 0L), objectGroup);
                    TaskExtended tex = new TaskExtended(Base64Manager.getDecodedString(texb642));
                    return "Added or changed task " + tex.getFactSheetDesc(group) + " for " + objRef;
                }
            } else if (typ == z.getInt(2, 0) && z.getLong(1, 0L) == id && (texb64 = z.getString(3, null)) != null) {
                TaskExtended tex = new TaskExtended(Base64Manager.getDecodedString(texb64));
                return "Added or changed task " + tex.getFactSheetDesc(group);
            }
            return null;
        }
        if (command.equals(COM_MOS_REMTASK)) {
            if (z.size() == 3) {
                if (typ == 0 && id == 0L) {
                    String mosRef = this.getIDObjectRef(group, 1, z.getLong(1, 0L), objectGroup);
                    return "Removed task from mouse " + mosRef;
                }
                if (typ == 1 && z.getLong(1, 0L) == id) {
                    return "Removed old task";
                }
                return null;
            }
            if (typ == 0 && id == 0L) {
                String objRef = this.getIDObjectRef(group, z.getInt(2, 0), z.getLong(1, 0L), objectGroup);
                return "Removed task from " + objRef;
            }
            if (typ == z.getInt(2, 0) && z.getLong(1, 0L) == id) {
                return "Removed old task";
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleCOM_MOS_ADDTASK() {
        long objID = Long.parseLong(this.ivLine[1]);
        int objType = Integer.parseInt(this.ivLine[2]);
        IDObject obj = ObjectStoreServer.getObjectToUpdate(objType, objID, this.ivGroupname, this.ivObjectBag);
        if (obj != null) {
            boolean addit = true;
            if (objType == 6) {
                boolean bl = addit = !this.ivGroupname.equals("service");
            }
            if (addit) {
                TaskExtended.addOrReplaceTask(obj, obj.getTaskKey(), new TaskExtended(Base64Manager.getDecodedString(this.ivLine[3])), this.ivGeneralSRId, this.ivServiceRoomOverride);
            }
            return true;
        }
        Log.error("Object not found ID: " + objID + " Type " + objType, null, this);
        return false;
    }

    public boolean handleCOM_MOS_REMTASK() {
        long taskID = Long.parseLong(this.ivLine[3]);
        long objID = Long.parseLong(this.ivLine[1]);
        int objType = Integer.parseInt(this.ivLine[2]);
        IDObject obj = ObjectStoreServer.getObjectToUpdate(objType, objID, this.ivGroupname, this.ivObjectBag);
        if (obj != null) {
            long favoritID;
            if (obj.canSitInRoom() && this.ivGeneralSRId != null && this.ivServiceRoomOverride != null) {
                this.ivServiceRoomOverride.put(obj.getIdentifierString(), this.ivGeneralSRId);
            }
            TaskExtended.removeTask(obj, obj.getTaskKey(), taskID);
            long issuerID = Long.parseLong(this.ivLine[4]);
            if (issuerID > 0L) {
                String issuerGroupname = this.ivGroupname;
                if (this.ivLine[7].length() != 0) {
                    issuerGroupname = Base64Manager.getDecodedString(this.ivLine[7]);
                }
                if ((obj = ObjectStoreServer.getObjectToUpdate(6, issuerID, issuerGroupname, this.ivObjectBag)) != null) {
                    TaskExtended.removeTask(obj, obj.getTaskKey(), taskID);
                }
            }
            if ((favoritID = Long.parseLong(this.ivLine[5])) > 0L) {
                String favGroupname = this.ivGroupname;
                if (this.ivLine[6].length() != 0) {
                    favGroupname = Base64Manager.getDecodedString(this.ivLine[6]);
                }
                if ((obj = ObjectStoreServer.getObjectToUpdate(6, favoritID, favGroupname, this.ivObjectBag)) != null) {
                    TaskExtended.removeTask(obj, obj.getTaskKey(), taskID);
                }
            }
            return true;
        }
        Log.error("Object not found ID: " + objID + " Type " + objType, null, this);
        return false;
    }
}

