/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.Vector;
import mausoleum.helper.Zeile;

public class CommandManagerUser
extends CommandManagerExecutive {
    private static final String PREFIX = "USR";
    public static final String COM_USR_NEW = "USRNEW";
    public static final String COM_USR_REMOVE = "USRRM";
    public static final String COM_USR_CHNAME = "USRCHNAME";
    public static final String COM_USR_CHEMAIL = "USRCHEMAIL";
    public static final String COM_USR_CHFULLNAME = "USRCHFULLNAME";
    public static final String COM_USR_CHSTATUS = "USRCHSTATUS";
    public static final String COM_USR_CHPASSWORD = "USRCHPWD";
    public static final String COM_USR_CHLANGUAGE = "USRCHLANGUAGE";
    public static final String COM_USR_CHCOLOR = "USRCHCOLOR";
    public static final String COM_USR_REVIT = "USRREVIT";
    public static final String COM_USR_REM_PRIV = "USRREMPRIV";
    public static final String COM_USR_GRANT_PRIV = "USRGRANTPRIV";
    public static final String COM_USR_SET_RESTR_ROOMIDS = "USR_SET_RESTR_ROOM_IDS";
    public static final String COM_USR_CH_TELNR = "USRCHTELNR";
    public static final String COM_USR_CH_VETERINARY = "USRCHVET";
    public static final String COM_USR_KILL_FINAL = "USR_KILL_FINAL";

    public CommandManagerUser() {
        super(6);
        this.addMeth(COM_USR_NEW, "handleUSRNEW", 4, false);
        this.addMeth(COM_USR_REMOVE, "setInvisible", 2, true);
        this.addMeth(COM_USR_REVIT, "setVisible", 2, true);
        this.addMeth(COM_USR_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_USR_CHNAME, "handleUSRCHNAME", 3, true);
        this.addMeth(COM_USR_CHEMAIL, "handleUSRCHEMAIL", 3, true);
        this.addMeth(COM_USR_CHSTATUS, "handleUSRCHSTATUS", 3, true);
        this.addMeth(COM_USR_CHPASSWORD, "handleUSRCHPWD", 3, true);
        this.addMeth(COM_USR_CHLANGUAGE, "handleUSRCHLANGUAGE", 3, true);
        this.addMeth(COM_USR_CHCOLOR, "handleUSRCHCOLOR", 3, true);
        this.addMeth(COM_USR_REM_PRIV, "handleUSRREMPRIV", 3, true);
        this.addMeth(COM_USR_GRANT_PRIV, "handleUSRGRANTPRIV", 3, true);
        this.addMeth(COM_USR_SET_RESTR_ROOMIDS, "handleUSR_SET_RESTR_ROOM_IDS", 3, true);
        this.addMeth(COM_USR_CH_TELNR, "handleUSRCHTELNR", 3, true);
        this.addMeth(COM_USR_CHFULLNAME, "handleUSRCHFULLNAME", 3, true);
        this.addMeth(COM_USR_CH_VETERINARY, "handleUSRCHVET", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_USR_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new user";
            }
            return null;
        }
        if (command.equals(COM_USR_REMOVE)) {
            if (typ == 0 && id == 0L) {
                return "Removed user " + this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Removed user";
            }
            return null;
        }
        if (command.equals(COM_USR_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized user " + this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Revitalized user";
            }
            return null;
        }
        if (command.equals(COM_USR_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed name of user " + usrRef + " to: " + z.getString(2, "[???]");
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed name to: " + z.getString(2, "[???]");
            }
            return null;
        }
        if (command.equals(COM_USR_CHFULLNAME)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed full name of user " + usrRef + " to: " + Base64Manager.getDecodedString(z.getString(2, null), "");
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed full name to: " + Base64Manager.getDecodedString(z.getString(2, null), "");
            }
            return null;
        }
        if (command.equals(COM_USR_CHEMAIL)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed email of user " + usrRef + " to: " + z.getString(2, "[???]");
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed email to: " + z.getString(2, "[???]");
            }
            return null;
        }
        if (command.equals(COM_USR_CH_TELNR)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed phone number of user " + usrRef + " to: " + z.getString(2, "[???]");
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed phone number to: " + z.getString(2, "[???]");
            }
            return null;
        }
        if (command.equals(COM_USR_CHSTATUS)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed status of user " + usrRef + " to: " + User.getStringForStatus(z.getInt(2, 0));
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed status to: " + User.getStringForStatus(z.getInt(2, 0));
            }
            return null;
        }
        if (command.equals(COM_USR_CHPASSWORD)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed password of user " + usrRef;
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed password";
            }
            return null;
        }
        if (command.equals(COM_USR_CHLANGUAGE)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed language of user " + usrRef + " to: " + Babel.getStringForLang(z.getString(2, ""));
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed language to: " + Babel.getStringForLang(z.getString(2, ""));
            }
            return null;
        }
        if (command.equals(COM_USR_CH_VETERINARY)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed veterinary status of user " + usrRef + " to: " + "1".equals(z.getString(2, ""));
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed veterinary status to: " + "1".equals(z.getString(2, ""));
            }
            return null;
        }
        if (command.equals(COM_USR_CHCOLOR)) {
            Color col;
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                Color col2 = CommandManagerUser.convertToColor(z.getString(2, ""));
                if (col2 != null) {
                    return "Changed color of user " + usrRef + " to: (" + CommandManagerUser.getDescr(col2) + ")";
                }
            } else if (typ == 6 && z.getLong(1, 0L) == id && (col = CommandManagerUser.convertToColor(z.getString(2, ""))) != null) {
                return "Changed color to: (" + CommandManagerUser.getDescr(col) + ")";
            }
            return null;
        }
        if (command.equals(COM_USR_REM_PRIV)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Disbared user " + usrRef + " privilege: " + Babel.get(z.getString(2, ""), "en");
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Disbared privilege: " + Babel.get(z.getString(2, ""), "en");
            }
            return null;
        }
        if (command.equals(COM_USR_GRANT_PRIV)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Granted privilege: " + Babel.get(z.getString(2, ""), "en") + " to user " + usrRef;
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Granted privilege: " + Babel.get(z.getString(2, ""), "en");
            }
            return null;
        }
        if (command.equals(COM_USR_SET_RESTR_ROOMIDS)) {
            if (typ == 0 && id == 0L) {
                String usrRef = this.getIDObjectRef(group, 6, z.getLong(1, 0L), objectGroup);
                return "Changed accsessible rooms for user " + usrRef;
            }
            if (typ == 6 && z.getLong(1, 0L) == id) {
                return "Changed accsessible rooms";
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleUSRNEW() {
        User usi = new User();
        usi.set("USR_NAME", this.ivLine[1]);
        usi.set("USR_PASSWORD", this.ivLine[2]);
        usi.setInt("USR_MODE", this.ivLine[3]);
        return this.finishNewObject(usi, null);
    }

    public boolean handleUSRCHNAME() {
        ((User)this.ivObjectForCommand).set("USR_NAME", this.ivLine[2]);
        return true;
    }

    public boolean handleUSRCHEMAIL() {
        ((User)this.ivObjectForCommand).set("USR_EMAIL", this.ivLine[2]);
        return true;
    }

    public boolean handleUSRCHFULLNAME() {
        ((User)this.ivObjectForCommand).set("USR_FUNA", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleUSRCHVET() {
        ((User)this.ivObjectForCommand).setBoolean("USR_VET", "1".equals(this.ivLine[2]));
        return true;
    }

    public boolean handleUSRCHTELNR() {
        ((User)this.ivObjectForCommand).set("USR_TELNR", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleUSRCHSTATUS() {
        this.ivObjectForCommand.setInt("USR_MODE", this.ivLine[2]);
        return true;
    }

    public boolean handleUSRCHLANGUAGE() {
        this.ivObjectForCommand.set("USR_LANGUAGE", this.ivLine[2]);
        return true;
    }

    public boolean handleUSRCHPWD() {
        this.ivObjectForCommand.set("USR_PASSWORD", this.ivLine[2]);
        return true;
    }

    public boolean handleUSRCHCOLOR() {
        this.ivObjectForCommand.set("USR_COLOR", CommandManagerUser.convertToColor(this.ivLine[2]));
        return true;
    }

    public boolean handleUSRREMPRIV() {
        Vector alteVerbotene = (Vector)this.ivObjectForCommand.get("USR_SUBPRIV", new Vector());
        if (!alteVerbotene.contains(this.ivLine[2])) {
            Vector<String> neueVerbotene = new Vector<String>(alteVerbotene.size() + 1);
            neueVerbotene.addAll(alteVerbotene);
            neueVerbotene.add(this.ivLine[2]);
            this.ivObjectForCommand.set("USR_SUBPRIV", neueVerbotene);
        }
        return true;
    }

    public boolean handleUSRGRANTPRIV() {
        Vector alteVerbotene = (Vector)this.ivObjectForCommand.get("USR_SUBPRIV", new Vector());
        if (alteVerbotene.contains(this.ivLine[2])) {
            Vector neueVerbotene = new Vector(alteVerbotene.size());
            neueVerbotene.addAll(alteVerbotene);
            neueVerbotene.remove(this.ivLine[2]);
            if (neueVerbotene.isEmpty()) {
                this.ivObjectForCommand.set("USR_SUBPRIV", null);
            } else {
                this.ivObjectForCommand.set("USR_SUBPRIV", neueVerbotene);
            }
        }
        return true;
    }

    public boolean handleUSR_SET_RESTR_ROOM_IDS() {
        long[] arr = null;
        String ids = this.ivLine[2].trim();
        if (ids.length() != 0) {
            Zeile z = new Zeile(ids, '|');
            arr = new long[z.size()];
            int i = 0;
            while (i < arr.length) {
                arr[i] = z.getLong(i, 0L);
                ++i;
            }
        }
        this.ivObjectForCommand.set("USR_R_ROOMS", arr);
        return true;
    }
}

