/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.User;
import java.awt.Color;
import java.util.Hashtable;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.license.License;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;

public class CommandmanagerLicense
extends CommandManagerExecutive {
    private static final String PREFIX = "LIC_";
    public static final String COM_LIC_NEW = "LIC_NEW";
    public static final String COM_LIC_RM = "LIC_RM";
    public static final String COM_LIC_REVIT = "LIC_REVIT";
    public static final String COM_LIC_CH_NAME = "LIC_CH_NAME";
    public static final String COM_LIC_CH_HOLDER = "LIC_CH_HOLDER";
    public static final String COM_LIC_CH_COMMENT = "LIC_CH_COMMENT";
    public static final String COM_LIC_CH_COLOR = "LIC_CH_COLOR";
    public static final String COM_LIC_CH_STARTDATE = "LIC_CH_STARTDATE";
    public static final String COM_LIC_CH_ENDDATE = "LIC_CH_ENDDATE";
    public static final String COM_LIC_CH_MOUSECOUNT = "LIC_CH_MOUSECOUNT";
    public static final String COM_LIC_ADD_USER = "LIC_ADD_USER";
    public static final String COM_LIC_REM_USER = "LIC_REM_USER";
    public static final String COM_LIC_ADD_MOUSE = "LIC_ADD_MOUSE";
    public static final String COM_LIC_REM_MOUSE = "LIC_REM_MOUSE";
    public static final String COM_LIC_KILL_FINAL = "LIC__KILL_FINAL";
    public static final String COM_LIC_SET_STRESS_INPUT = "LIC_STRESS_INPUT";
    public static final String COM_LIC_CH_SUBTYPE = "LIC_CHSUBTYPE";

    public CommandmanagerLicense() {
        super(16);
        this.addMeth(COM_LIC_NEW, "handle_LIC_NEW", 10, false);
        this.addMeth(COM_LIC_RM, "setInvisible", 2, true);
        this.addMeth(COM_LIC_REVIT, "setVisible", 2, true);
        this.addMeth(COM_LIC_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_LIC_CH_NAME, "handle_LIC_CH_NAME", 3, true);
        this.addMeth(COM_LIC_CH_HOLDER, "handle_LIC_CH_HOLDER", 3, true);
        this.addMeth(COM_LIC_CH_COMMENT, "handle_LIC_CH_COMMENT", 3, true);
        this.addMeth(COM_LIC_CH_COLOR, "handle_LIC_CH_COLOR", 3, true);
        this.addMeth(COM_LIC_CH_STARTDATE, "handle_LIC_CH_STARTDATE", 3, true);
        this.addMeth(COM_LIC_CH_ENDDATE, "handle_LIC_CH_ENDDATE", 3, true);
        this.addMeth(COM_LIC_CH_MOUSECOUNT, "handle_LIC_CH_MOUSECOUNT", 3, true);
        this.addMeth(COM_LIC_ADD_USER, "handle_LIC_ADD_USER", 3, true);
        this.addMeth(COM_LIC_REM_USER, "handle_LIC_REM_USER", 3, true);
        this.addMeth(COM_LIC_ADD_MOUSE, "handle_LIC_ADD_MOUSE", 4, false);
        this.addMeth(COM_LIC_REM_MOUSE, "handle_LIC_REM_MOUSE", 3, false);
        this.addMeth(COM_LIC_SET_STRESS_INPUT, "handle_LIC_SET_STRESS_INPUT", 3, true);
        this.addMeth(COM_LIC_CH_SUBTYPE, "handle_LICCHSubType", 3, true);
    }

    public static void appendRemoveCommand(Mouse mouse, StringBuffer msb, int lizenzNummer) {
        long licid;
        if (mouse != null && (licid = mouse.getLong(Mouse.getLicenseTag(lizenzNummer), -1L)) != -1L) {
            if (msb.length() != 0) {
                msb.append("\n");
            }
            msb.append(COM_LIC_REM_MOUSE).append(" ");
            msb.append(licid).append(" ");
            msb.append(mouse.getID());
        }
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_LIC_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new license";
            }
            return null;
        }
        if (command.equals(COM_LIC_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed license " + this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return "Removed License";
            }
            return null;
        }
        if (command.equals(COM_LIC_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized license " + this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return "Revitalized License";
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_HOLDER)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                return CommandmanagerLicense.getPB64String("Changed name of license holder for license " + licRef + " to: ", z, 2);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return CommandmanagerLicense.getPB64String("Changed name of license holder to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_NAME)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                return CommandmanagerLicense.getPB64String("Changed name of license " + licRef + " to: ", z, 2);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return CommandmanagerLicense.getPB64String("Changed name of license to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_COMMENT)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                return CommandmanagerLicense.getPB64String("Changed comment of license " + licRef + " to: ", z, 2);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return CommandmanagerLicense.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_COLOR)) {
            Color col;
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                Color col2 = CommandmanagerLicense.convertToColor(z.getString(2, ""));
                if (col2 != null) {
                    return "Changed color of license " + licRef + " to: (" + CommandmanagerLicense.getDescr(col2) + ")";
                }
            } else if (typ == 16 && z.getLong(1, 0L) == id && (col = CommandmanagerLicense.convertToColor(z.getString(2, ""))) != null) {
                return "Changed color to: (" + CommandmanagerLicense.getDescr(col) + ")";
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_STARTDATE)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                if (z.getInt(2, 0) == -1) {
                    return "Deleted start date of validity of license " + licRef;
                }
                return "Changed start date of validity of license " + licRef + " to: " + DatumFormat.getJustDateString(z.getInt(2, 0));
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                if (z.getInt(2, 0) == -1) {
                    return "Deleted start date of validity";
                }
                return "Changed start date of validity to: " + DatumFormat.getJustDateString(z.getInt(2, 0));
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_ENDDATE)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                if (z.getInt(2, 0) == -1) {
                    return "Deleted expiry date of license " + licRef;
                }
                return "Changed expiry date of license " + licRef + " to: " + DatumFormat.getJustDateString(z.getInt(2, 0));
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                if (z.getInt(2, 0) == -1) {
                    return "Deleted expiry date";
                }
                return "Changed expiry date to: " + DatumFormat.getJustDateString(z.getInt(2, 0));
            }
            return null;
        }
        if (command.equals(COM_LIC_CH_MOUSECOUNT)) {
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                return "Changed maximum number of mice of license " + licRef + " to " + z.getInt(2, 0);
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                return "Changed maximum number of mice to " + z.getInt(2, 0);
            }
            return null;
        }
        if (command.equals(COM_LIC_ADD_USER)) {
            User user;
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                String usiRef = this.getIDObjectRef(group, 6, z.getLong(2, 0L), objectGroup);
                return "Grant license " + licRef + " to user: " + usiRef;
            }
            if (typ == 16 && z.getLong(1, 0L) == id && (user = (User)this.getIDObject(group, 6, z.getLong(2, 0L))) != null) {
                return "Grant license to user: " + user.getBrowseName();
            }
            return null;
        }
        if (command.equals(COM_LIC_REM_USER)) {
            User user;
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                String usiRef = this.getIDObjectRef(group, 6, z.getLong(2, 0L), objectGroup);
                return "Disbar user " + usiRef + " for license " + licRef;
            }
            if (typ == 16 && z.getLong(1, 0L) == id && (user = (User)this.getIDObject(group, 6, z.getLong(2, 0L))) != null) {
                return "Disbar user: " + user.getBrowseName();
            }
            return null;
        }
        if (command.equals(COM_LIC_ADD_MOUSE)) {
            License license;
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                String mosRef = this.getIDObjectRef(group, 1, z.getLong(2, 0L), objectGroup);
                return "Set license: " + licRef + " for mouse " + mosRef;
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                Mouse mouse = (Mouse)this.getIDObject(group, 1, z.getLong(2, 0L));
                if (mouse != null) {
                    return "Added mouse " + mouse.getIDStringForReports(false);
                }
            } else if (typ == 1 && z.getLong(2, 0L) == id && (license = (License)this.getIDObject(group, 16, z.getLong(1, 0L))) != null) {
                return "Set license: " + license.getBrowseName();
            }
            return null;
        }
        if (command.equals(COM_LIC_REM_MOUSE)) {
            License license;
            if (typ == 0 && id == 0L) {
                String licRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                String mosRef = this.getIDObjectRef(group, 1, z.getLong(2, 0L), objectGroup);
                return "Removed license: " + licRef + " for mouse " + mosRef;
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                Mouse mouse = (Mouse)this.getIDObject(group, 1, z.getLong(2, 0L));
                if (mouse != null) {
                    return "Removed mouse " + mouse.getIDStringForReports(false);
                }
            } else if (typ == 1 && z.getLong(2, 0L) == id && (license = (License)this.getIDObject(group, 16, z.getLong(1, 0L))) != null) {
                return "Removed from license: " + license.getBrowseName();
            }
        } else if (command.equals(COM_LIC_SET_STRESS_INPUT)) {
            if (typ == 0 && id == 0L) {
                String licenseRef = this.getIDObjectRef(group, 16, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("1")) {
                    return "Set stress input for killed mice is necessary for license " + licenseRef;
                }
                return "Set stress input for killed mice is not necessary for license " + licenseRef;
            }
            if (typ == 16 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("1")) {
                    return "Set stress input for killed mice is necessary";
                }
                return "Set stress input for killed mice is not necessary";
            }
            return null;
        }
        return null;
    }

    public boolean handle_LIC_NEW() {
        License license = new License();
        license.set("LIC_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        license.set("LIC_LH", Base64Manager.getDecodedString(this.ivLine[2], null));
        license.setInt("LIC_SD", this.ivLine[3], -1);
        license.setInt("LIC_ED", this.ivLine[4], -1);
        license.setInt("LIC_MMC", this.ivLine[5], -1);
        license.set("LIC_UI", CommandmanagerLicense.extractIDs(this.ivLine[6]));
        license.set("LIC_CO", Base64Manager.getDecodedString(this.ivLine[7], null));
        license.set("LIC_COL", CommandmanagerLicense.convertToColor(this.ivLine[8]));
        if ("1".equals(this.ivLine[9])) {
            license.set("LIC_ILL", new Boolean(true));
        }
        return this.finishNewObject(license, null);
    }

    public boolean handle_LIC_CH_HOLDER() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIC_LH", Base64Manager.getDecodedString(this.ivLine[2]));
            return true;
        }
        return false;
    }

    public boolean handle_LIC_CH_NAME() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            return this.setStringAndPropagate(2, "LIC_NAME", true);
        }
        return false;
    }

    public boolean handle_LIC_CH_COMMENT() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            return this.setStringAndPropagate(2, "LIC_CO", true);
        }
        return false;
    }

    public boolean handle_LIC_CH_COLOR() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIC_COL", CommandmanagerLicense.convertToColor(this.ivLine[2]));
            return true;
        }
        return false;
    }

    public boolean handle_LIC_CH_STARTDATE() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            return this.setIntAttributeAndPropagate(2, "LIC_SD", -1);
        }
        return false;
    }

    public boolean handle_LIC_CH_ENDDATE() {
        if (this.ivGroupname.equals(this.ivObjectForCommand.getGroup())) {
            return this.setIntAttributeAndPropagate(2, "LIC_ED", -1);
        }
        return false;
    }

    public boolean handle_LIC_CH_MOUSECOUNT() {
        return this.setIntAttributeAndPropagate(2, "LIC_MMC", -1);
    }

    public boolean handle_LIC_ADD_USER() {
        if (!this.isServiceGroup()) {
            ((License)this.ivObjectForCommand).addUserID(Long.parseLong(this.ivLine[2]));
            return true;
        }
        return false;
    }

    public boolean handle_LIC_REM_USER() {
        if (!this.isServiceGroup()) {
            ((License)this.ivObjectForCommand).removeUserID(Long.parseLong(this.ivLine[2]));
        }
        return true;
    }

    public boolean handle_LIC_ADD_MOUSE() {
        boolean res = false;
        Mouse mouse = (Mouse)ObjectStoreServer.getObjectToUpdate(1, Long.parseLong(this.ivLine[3]), this.ivGroupname, this.ivObjectBag);
        if (mouse != null) {
            long licenseID = Long.parseLong(this.ivLine[1]);
            String licenseTag = Mouse.getLicenseTag(Integer.parseInt(this.ivLine[2]));
            if (licenseTag != null) {
                long mouseLicenseID = mouse.getLong(licenseTag, -1L);
                if (licenseID != mouseLicenseID) {
                    License relevantLicense = CommandmanagerLicense.getRelevantLicense(licenseID, this.ivGroupname, this.ivObjectBag);
                    if (relevantLicense != null) {
                        mouse.setLong(licenseTag, licenseID);
                        res = true;
                    }
                } else {
                    res = true;
                }
            }
        }
        return res;
    }

    public boolean handle_LIC_REM_MOUSE() {
        long licenseID;
        boolean removed = false;
        Mouse mouse = (Mouse)ObjectStoreServer.getObjectToUpdate(1, Long.parseLong(this.ivLine[2]), this.ivGroupname, this.ivObjectBag);
        if (mouse != null && !(removed = this.handleRemoveLicense(licenseID = Long.parseLong(this.ivLine[1]), Mouse.getLicenseTag(1), mouse))) {
            removed = this.handleRemoveLicense(licenseID, Mouse.getLicenseTag(2), mouse);
        }
        return removed;
    }

    public boolean handle_LIC_SET_STRESS_INPUT() {
        License license;
        if (TierSchutz.belastungNeeded() && this.ivObjectForCommand instanceof License && TierSchutz.isForcedStressReportInputPossible(license = (License)this.ivObjectForCommand)) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIC_NMB", this.ivLine[2].equals("1") ? JAWOLL : null);
            return true;
        }
        return false;
    }

    public boolean handle_LICCHSubType() {
        if (this.ivObjectForCommand instanceof License) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LIC_LIC_SUBTYPE", new Integer(this.ivLine[2]));
        }
        return true;
    }

    private boolean handleRemoveLicense(long licenseID, String tag, Mouse mouse) {
        boolean removed = false;
        long mouseLicenseID = mouse.getLong(tag, -1L);
        if (mouseLicenseID == licenseID) {
            License relevantLicense = CommandmanagerLicense.getRelevantLicense(licenseID, this.ivGroupname, this.ivObjectBag);
            if (relevantLicense != null) {
                relevantLicense.decMouseCount();
                relevantLicense.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
            }
            mouse.set(tag, null);
            removed = true;
        }
        return removed;
    }

    public static License getRelevantLicense(long licenseIDInMyGroup, String group, Hashtable objectBag) {
        License relevantLicense = null;
        if (ProcessDefinition.isServer() && (relevantLicense = (License)ObjectStoreServer.getObjectToUpdate(16, licenseIDInMyGroup, group, objectBag)) != null && relevantLicense.isSharedWithOtherGroups()) {
            relevantLicense = (License)ObjectStoreServer.getObjectToUpdate(16, relevantLicense.getLong("IDO_SERVID", -1L), "service", objectBag);
        }
        return relevantLicense;
    }
}

