/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.session.ShortSessionInfo;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetComponentScreen;
import mausoleum.factsheets.FactSheetPanel;
import mausoleum.factsheets.SessionInfoHoler;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;

public class SessionsCard
extends JFrame
implements LayoutManager,
ListCellRenderer {
    private static final long serialVersionUID = 11681351353L;
    private static final int RAND = UIDef.getScaled(5);
    private final FactSheetComponentScreen ivComponent = new FactSheetComponentScreen(true);
    private final JList ivSessionsList = new JList();
    private final JSplitPane ivSplitPane;
    private final JLabel ivLabel = new JLabel();
    private final MGButton ivPrintButton = new MGButton(Babel.get("PRINT"));
    private final Vector ivSessionInfos;
    private final Vector ivSessionObjects = new Vector();

    public static void getUserSessionsCard(User usi) {
        Vector sessionInfos = (Vector)RequestManager.createSendAndGetObjectIfFinished((byte)17, new Long(usi.getID()), usi.getString("IDO_GROUP", ""), null);
        if (sessionInfos == null) {
            Alert.showAlert(Babel.get("NO_SESSION_INFO"), true);
        } else if (sessionInfos.isEmpty()) {
            Alert.showAlert(Babel.get("NO_SESSIONS_FOUND"), true);
        } else {
            new SessionsCard(sessionInfos, String.valueOf(Babel.get("SESSION_INFO_FOR_USER")) + ": " + usi.get("USR_NAME"));
        }
    }

    private SessionsCard(Vector sessionInfos, String title) {
        this.setContentPane(new RequesterPane(this));
        this.setTitle(title);
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivSessionInfos = sessionInfos;
        this.ivLabel.setForeground(Color.black);
        this.ivLabel.setHorizontalAlignment(2);
        this.ivSessionsList.setModel(new ListModel(){

            public void addListDataListener(ListDataListener l) {
            }

            public Object getElementAt(int index) {
                if (SessionsCard.this.ivSessionInfos != null && index >= 0 && index < SessionsCard.this.ivSessionInfos.size()) {
                    return SessionsCard.this.ivSessionInfos.elementAt(index);
                }
                return null;
            }

            public int getSize() {
                if (SessionsCard.this.ivSessionInfos != null) {
                    return SessionsCard.this.ivSessionInfos.size();
                }
                return 0;
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.ivSessionsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SessionsCard.this.ivSessionsList.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        SessionsCard.this.ivSessionObjects.clear();
                        ShortSessionInfo ssi = (ShortSessionInfo)SessionsCard.this.ivSessionsList.getSelectedValue();
                        if (ssi != null) {
                            SessionInfoHoler sih = new SessionInfoHoler(ssi.ivSessionID);
                            sih.loadSessionInfo();
                            SessionsCard.this.ivSessionObjects.add(sih);
                        }
                        Vector elements = new Vector();
                        int y = FactSheet.fillElements(null, SessionsCard.this.ivSessionObjects, 600, elements, null, null);
                        SessionsCard.this.ivComponent.setElements(elements, y);
                        SessionsCard.this.ivComponent.revalidate();
                        SessionsCard.this.ivComponent.repaint();
                    }
                    catch (Exception exc) {
                        Log.error("Problem mit Session data " + SessionsCard.this.ivSessionsList.getSelectedValue(), exc, this);
                    }
                    SessionsCard.this.ivSessionsList.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.ivSessionsList.setSelectionMode(0);
        this.ivSessionsList.setCellRenderer(this);
        this.ivSessionsList.setFocusable(false);
        this.ivComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isMetaDown()) {
                    JPopupMenu erg = new JPopupMenu();
                    SessionsCard.this.ivComponent.addPopupItems(erg);
                    if (erg.getComponentCount() != 0) {
                        erg.show(SessionsCard.this.ivComponent, e.getX(), e.getY());
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.ivComponent);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                SessionsCard.this.ivComponent.manageResize();
                if (e.getSource() instanceof JScrollPane) {
                    JScrollPane jsp = (JScrollPane)e.getSource();
                    jsp.repaint();
                }
            }
        });
        this.ivPrintButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FactSheetPanel.printFactSheet(false, SessionsCard.this.ivSessionObjects, null, Babel.get("FS_SESSION_PROT"), WindowUtils.getJFrame(SessionsCard.this.ivPrintButton), null);
            }
        });
        this.ivPrintButton.setFocusable(false);
        JPanel jp = new JPanel(new BorderLayout(RAND, RAND));
        jp.add("Center", scrollPane);
        jp.add("South", this.ivPrintButton);
        jp.setOpaque(false);
        this.ivSplitPane = new JSplitPane(1, new JScrollPane(this.ivSessionsList), jp);
        this.ivSplitPane.setDividerLocation(UIDef.getScaled(200));
        this.ivSplitPane.setOpaque(false);
        this.getContentPane().add(this.ivSplitPane);
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(800), UIDef.getScaled(500));
        this.setVisible(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ShortSessionInfo ssi = (ShortSessionInfo)value;
        Color bg = null;
        if (ssi.ivNumCommands == 0) {
            this.ivLabel.setText(" " + DatumFormat.getDurationString(ssi.ivStartMillis, ssi.ivEndMillis) + " ");
            this.ivLabel.setFont(FontManager.getFont("SSI12"));
            if (isSelected) {
                bg = UIDef.OLD_BACKGROUND;
            }
        } else {
            this.ivLabel.setText(" " + DatumFormat.getDurationString(ssi.ivStartMillis, ssi.ivEndMillis) + " [" + ssi.ivNumCommands + "]");
            this.ivLabel.setFont(FontManager.getFont("SSB12"));
            if (isSelected) {
                bg = UIDef.SELECTED_BACKGROUND;
            }
        }
        if (bg != null) {
            this.ivLabel.setOpaque(true);
            this.ivLabel.setBackground(bg);
        } else {
            this.ivLabel.setOpaque(false);
            this.ivLabel.setBackground(null);
        }
        return this.ivLabel;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        this.ivSplitPane.setBounds(RAND, RAND, d.width - 2 * RAND, d.height - 2 * RAND);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return null;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

