/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Vector;
import mausoleum.printing.PreviewFrame;
import mausoleum.printing.PrintElement;
import mausoleum.printing.PrintTask;

public abstract class MausoleumPrinter
implements Pageable,
Printable {
    public final Vector ivDocument = new Vector();
    protected PageFormat ivPageFormat;

    public void printIt() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPageable(this);
        pj.setPrintable(this, this.ivPageFormat);
        if (pj.printDialog()) {
            new PrintTask(pj, this.getClass());
        }
    }

    public void previewIt() {
        PreviewFrame.showPreviewFrame(this);
    }

    public int getNumberOfPages() {
        return this.ivDocument.size();
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.ivPageFormat;
    }

    public boolean isRotated() {
        return false;
    }

    public Printable getPrintable(int pageIndex) {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        Vector page = (Vector)this.ivDocument.elementAt(pageIndex);
        if (this.isRotated()) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate((int)this.ivPageFormat.getHeight(), 0);
            g2d.rotate(1.5707963267948966);
        }
        int i = 0;
        while (i < page.size()) {
            PrintElement tpe = (PrintElement)page.elementAt(i);
            tpe.print(graphics);
            ++i;
        }
        if (this.isRotated()) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.rotate(-1.5707963267948966);
            g2d.translate((int)(-this.ivPageFormat.getHeight()), 0);
        }
        return 0;
    }
}

