/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import javax.swing.JComponent;
import mausoleum.printing.MausoleumPrinter;

public class PreviewComponent
extends JComponent {
    private static final long serialVersionUID = 148564861L;
    private MausoleumPrinter ivTablePrinter;
    private PageFormat ivPageFormat;
    private int ivPageNumber = 0;

    public PreviewComponent(MausoleumPrinter tp, PageFormat pf) {
        this.ivTablePrinter = tp;
        this.ivPageFormat = pf;
    }

    public Dimension getPreferredSize() {
        if (this.ivTablePrinter.isRotated()) {
            return new Dimension((int)this.ivPageFormat.getHeight(), (int)this.ivPageFormat.getWidth());
        }
        return new Dimension((int)this.ivPageFormat.getWidth(), (int)this.ivPageFormat.getHeight());
    }

    public Dimension getMinimumSize() {
        if (this.ivTablePrinter.isRotated()) {
            return new Dimension((int)this.ivPageFormat.getHeight(), (int)this.ivPageFormat.getWidth());
        }
        return new Dimension((int)this.ivPageFormat.getWidth(), (int)this.ivPageFormat.getHeight());
    }

    public void setPageNumber(int pn) {
        this.ivPageNumber = pn;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.ivTablePrinter.isRotated()) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.white);
            g.fillRect(0, 0, (int)this.ivPageFormat.getHeight(), (int)this.ivPageFormat.getWidth());
            g2d.translate(0, (int)this.ivPageFormat.getWidth());
            g2d.rotate(-1.5707963267948966);
            this.ivTablePrinter.print(g, this.ivPageFormat, this.ivPageNumber);
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -((int)this.ivPageFormat.getWidth()));
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, (int)this.ivPageFormat.getWidth(), (int)this.ivPageFormat.getHeight());
            this.ivTablePrinter.print(g, this.ivPageFormat, this.ivPageNumber);
        }
    }
}

