/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManagerUS;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.RackGraphicsManager;

public class PrintElement
implements Serializable {
    private static final long serialVersionUID = 148643513L;
    public static final int TYP_UNDEF = 0;
    public static final int TYP_LINE = 1;
    public static final int TYP_BOX = 2;
    public static final int TYP_TEXT = 3;
    public static final int TYP_IMAGE = 4;
    public static final int TYP_VECTOR = 5;
    public static final int TYP_FILLEDBOX = 6;
    public static final int TYP_CAGEPOLYGON = 7;
    public static final int TYP_FILLEDTEXTBOX = 8;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public int ivX = -1;
    public int ivY = -1;
    public int ivX2 = -1;
    public int ivY2 = -1;
    public float ivLineWidth = 0.1f;
    public int ivOrientation = 1;
    public Color ivColor = Color.black;
    public Font ivFont;
    public String ivText;
    public Image ivImage;
    public Vector ivVector = null;
    public Cage ivCage = null;
    public int ivType = 0;
    public int ivOverrideCageColorMode = -1;

    public static PrintElement getVectorElement(Vector v, int x, int y, int w, int h) {
        PrintElement tpe = new PrintElement(v, x, y, w, h);
        tpe.ivType = 5;
        return tpe;
    }

    public static PrintElement getPolygonElement(int x, int y, Cage c, boolean scaled) {
        PrintElement tpe = new PrintElement(null, x, y);
        tpe.ivType = 7;
        tpe.ivCage = c;
        tpe.ivX2 = scaled ? RackGraphicsManager.CAGELABEL_CAGE_WIDTH : 36;
        tpe.ivY2 = scaled ? RackGraphicsManager.CAGELABEL_CAGE_HEIGHT : 18;
        return tpe;
    }

    public static PrintElement getTextElement(int x, int y, String s, Font f) {
        PrintElement tpe = new PrintElement(s, x, y);
        tpe.ivFont = f;
        tpe.ivType = 3;
        return tpe;
    }

    public static PrintElement getTextElement(int x, int y, String s, Font f, int orientation) {
        PrintElement tpe = new PrintElement(s, x, y);
        tpe.ivFont = f;
        tpe.ivType = 3;
        tpe.ivOrientation = orientation;
        return tpe;
    }

    public static PrintElement getTextElement(int x, int y, String s, Font f, Color col) {
        PrintElement tpe = new PrintElement(s, x, y);
        tpe.ivFont = f;
        tpe.ivType = 3;
        tpe.ivColor = col;
        return tpe;
    }

    public static PrintElement getFilledTextBox(int x, int y, int x2, int y2, String s, Font f, Color col) {
        PrintElement tpe = new PrintElement(x, y, x2, y2);
        tpe.ivText = s;
        tpe.ivFont = f;
        tpe.ivType = 8;
        tpe.ivColor = col;
        return tpe;
    }

    public static PrintElement getBoxElement(int x, int y, int x2, int y2, float linewidth) {
        PrintElement tpe = new PrintElement(x, y, x2, y2);
        tpe.ivLineWidth = linewidth;
        tpe.ivType = 2;
        return tpe;
    }

    public static PrintElement getBoxElement(int x, int y, int x2, int y2) {
        PrintElement tpe = new PrintElement(x, y, x2, y2);
        tpe.ivType = 2;
        return tpe;
    }

    public static PrintElement getFilledBoxElement(int x, int y, int x2, int y2, Color c) {
        PrintElement tpe = new PrintElement(x, y, x2, y2);
        tpe.ivType = 6;
        tpe.ivColor = c;
        return tpe;
    }

    public static PrintElement getLineElement(int x, int y, int x2, int y2) {
        PrintElement tpe = new PrintElement(x, y, x2, y2);
        tpe.ivType = 1;
        return tpe;
    }

    public static PrintElement getHeadLineElement(String s, int x, int y) {
        PrintElement tpe = new PrintElement(s, x, y);
        tpe.ivFont = FontManagerUS.SSB12;
        tpe.ivOrientation = 2;
        tpe.ivType = 3;
        return tpe;
    }

    public static PrintElement getHeaderFooterElement(String s, int x, int y) {
        PrintElement tpe = new PrintElement(s, x, y);
        tpe.ivFont = FontManagerUS.SP10;
        tpe.ivOrientation = 2;
        tpe.ivType = 3;
        return tpe;
    }

    public static PrintElement getPrintElement(Component c, int x, int y) {
        PrintElement tpe = new PrintElement(c, x, y);
        return tpe;
    }

    private PrintElement(Vector v, int x, int y, int x2, int y2) {
        this.ivVector = v;
        this.ivX = x;
        this.ivY = y;
        this.ivX2 = x2;
        this.ivY2 = y2;
    }

    private PrintElement(int x, int y, int x2, int y2) {
        this.ivX = x;
        this.ivY = y;
        this.ivX2 = x2;
        this.ivY2 = y2;
    }

    private PrintElement(String s, int x, int y) {
        this.ivX = x;
        this.ivY = y;
        this.ivText = s;
    }

    private PrintElement(Component c, int x, int y) {
        this.ivX = x;
        this.ivY = y;
        if (c instanceof JLabel) {
            JLabel lab = (JLabel)c;
            if (lab.getIcon() == null) {
                this.ivFont = lab.getFont().deriveFont(10.0f);
                this.ivText = lab.getText();
                this.ivColor = lab.getForeground();
                this.ivType = 3;
            } else {
                ImageIcon ic = (ImageIcon)lab.getIcon();
                this.ivImage = ic.getImage();
                this.ivType = 4;
            }
        } else if (c instanceof JPanel) {
            JPanel panel = (JPanel)c;
            this.ivText = "";
            Component[] comps = panel.getComponents();
            int i = 0;
            while (i < comps.length) {
                Component cc = comps[i];
                if (cc instanceof JLabel) {
                    JLabel sublab = (JLabel)cc;
                    if (this.ivFont != null) {
                        this.ivColor = sublab.getForeground();
                        this.ivFont = sublab.getFont().deriveFont(10.0f);
                    }
                    this.ivText = String.valueOf(this.ivText) + " " + sublab.getText();
                }
                ++i;
            }
            this.ivType = 3;
        } else {
            this.ivText = "Cannot parse " + c.getClass();
            this.ivFont = FontManagerUS.SP10;
            this.ivColor = Color.black;
            this.ivType = 3;
        }
    }

    public void print(Graphics g) {
        if (this.ivType == 4) {
            g.drawImage(this.ivImage, this.ivX + 4, this.ivY, null);
        } else if (this.ivType == 3) {
            if (this.ivText != null) {
                g.setFont(this.ivFont);
                g.setColor(this.ivColor);
                if (this.ivOrientation == 1) {
                    g.drawString(this.ivText, this.ivX + 4, this.ivY + 9);
                } else if (this.ivOrientation == 2) {
                    FontMetrics fm = g.getFontMetrics();
                    int w = fm.stringWidth(this.ivText);
                    g.drawString(this.ivText, this.ivX - w / 2, this.ivY + 9);
                } else {
                    FontMetrics fm = g.getFontMetrics();
                    int w = fm.stringWidth(this.ivText);
                    g.drawString(this.ivText, this.ivX - w, this.ivY + 9);
                }
            }
        } else if (this.ivType == 1) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke stroke = g2d.getStroke();
                g.setColor(this.ivColor);
                g2d.setStroke(new BasicStroke(this.ivLineWidth));
                g2d.drawLine(this.ivX, this.ivY, this.ivX2, this.ivY2);
                g2d.setStroke(stroke);
            }
        } else if (this.ivType == 2) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke stroke = g2d.getStroke();
                g.setColor(this.ivColor);
                g2d.setStroke(new BasicStroke(this.ivLineWidth));
                g2d.drawRect(this.ivX, this.ivY, this.ivX2, this.ivY2);
                g2d.setStroke(stroke);
            }
        } else if (this.ivType == 6) {
            g.setColor(this.ivColor);
            g.fillRect(this.ivX, this.ivY, this.ivX2, this.ivY2);
        } else if (this.ivType == 8) {
            if (this.ivColor != null) {
                g.setColor(this.ivColor);
                g.fillRect(this.ivX, this.ivY, this.ivX2, this.ivY2);
            }
            if (this.ivText != null) {
                g.setFont(this.ivFont);
                g.setColor(Color.black);
                if (this.ivOrientation == 1) {
                    g.drawString(this.ivText, this.ivX + 4, this.ivY + 9);
                } else if (this.ivOrientation == 2) {
                    FontMetrics fm = g.getFontMetrics();
                    int w = fm.stringWidth(this.ivText);
                    g.drawString(this.ivText, this.ivX + (this.ivX2 - w) / 2, this.ivY + 9);
                } else {
                    FontMetrics fm = g.getFontMetrics();
                    int w = fm.stringWidth(this.ivText);
                    g.drawString(this.ivText, this.ivX + (this.ivX2 - w), this.ivY + 9);
                }
            }
        } else if (this.ivType == 7) {
            CageDisplayManager.fillCage(this.ivCage, g, this.ivX, this.ivY, this.ivX2, this.ivY2, null, this.ivOverrideCageColorMode);
            CageDisplayManager.drawFilledCagePolygon(g, this.ivX, this.ivY, this.ivX2, this.ivY2);
        } else if (this.ivType == 5) {
            Shape s = g.getClip();
            if (s != null) {
                Rectangle sr = s.getBounds();
                Rectangle cr = new Rectangle(this.ivX, this.ivY, this.ivX2, this.ivY2);
                g.setClip(sr.createIntersection(cr));
            } else {
                g.setClip(this.ivX, this.ivY, this.ivX2, this.ivY2);
            }
            if (this.ivVector != null && !this.ivVector.isEmpty()) {
                int i = 0;
                while (i < this.ivVector.size()) {
                    PrintElement pe = (PrintElement)this.ivVector.elementAt(i);
                    pe.print(g);
                    ++i;
                }
            }
            g.setClip(s);
        }
    }
}

