/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.printing.MausoleumPrinter;
import mausoleum.printing.PrintElement;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.util.InstallationType;

public class TablePrinter
extends MausoleumPrinter {
    private static final int HEAD_SPACE = 14;
    private static final int FOOT_SPACE = 14;
    private static final int INTER_SPACE = 20;
    private static final int ABOVE_SPACE = 34;
    private static final int BELOW_SPACE = 34;
    private static final int HEADLINE_SPACE = 18;
    private static final int LINE_SPACE = 14;
    private static final int LINEOFFSET = 5;
    private static final int XOFFSET = 3;

    public TablePrinter(MausoleumTableModel model, boolean onlySelection, CPPageFormat pageFormat) {
        Vector objects = new Vector();
        if (onlySelection) {
            objects.addAll(model.getSelectedObjects());
        } else {
            objects.addAll(model.ivObjects);
        }
        this.ivPageFormat = pageFormat;
        model.ivUseDefaultFontSize = true;
        this.ivDocument.clear();
        this.ivDocument.addAll(this.distribute(objects, model, this.ivPageFormat));
        model.ivUseDefaultFontSize = false;
        objects = null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        TablePrintPage page = (TablePrintPage)this.ivDocument.elementAt(pageIndex);
        int i = 0;
        while (i < page.ivHeaders.size()) {
            PrintElement tpe = (PrintElement)page.ivHeaders.elementAt(i);
            tpe.print(graphics);
            ++i;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(page.ivTableStartX, page.ivTableStartY);
        if (page.ivTableScale != 1.0) {
            g2d.scale(page.ivTableScale, page.ivTableScale);
        }
        int i2 = 0;
        while (i2 < page.ivTableElements.size()) {
            PrintElement tpe = (PrintElement)page.ivTableElements.elementAt(i2);
            tpe.print(graphics);
            ++i2;
        }
        if (page.ivTableScale != 1.0) {
            g2d.scale(1.0 / page.ivTableScale, 1.0 / page.ivTableScale);
        }
        g2d.translate(0, -page.ivTableStartY);
        return 0;
    }

    private Vector distribute(Vector objects, MausoleumTableModel model, PageFormat pageFormat) {
        int i;
        String datum = DatumFormat.getDateTimeString(System.currentTimeMillis());
        int startX = (int)pageFormat.getImageableX() - 1;
        int startY = (int)pageFormat.getImageableY();
        int totWidth = (int)pageFormat.getImageableWidth() - 2;
        int totalHeight = (int)pageFormat.getImageableHeight();
        int maxY = startY + totalHeight;
        int tableHeight = totalHeight - 34 - 34;
        int headLineStart = startY + 34;
        int[] spaltenBreiten = model.getcolWidths(3);
        int colTotWidth = 0;
        int i2 = 0;
        while (i2 < spaltenBreiten.length) {
            colTotWidth += spaltenBreiten[i2];
            ++i2;
        }
        double faktor = 1.0;
        if (totWidth != colTotWidth) {
            if (totWidth > colTotWidth) {
                int restPlatz = totWidth - colTotWidth;
                int normExtra = restPlatz / spaltenBreiten.length;
                int lastExtra = restPlatz - normExtra * (spaltenBreiten.length - 1);
                i = 0;
                while (i < spaltenBreiten.length - 1) {
                    int n = i++;
                    spaltenBreiten[n] = spaltenBreiten[n] + normExtra;
                }
                int n = spaltenBreiten.length - 1;
                spaltenBreiten[n] = spaltenBreiten[n] + lastExtra;
                colTotWidth = totWidth;
            } else {
                faktor = (double)totWidth / (double)colTotWidth;
            }
        }
        int anzTableRows = (int)(((double)tableHeight - 18.0 * faktor) / (14.0 * faktor));
        Vector prePages = new Vector();
        Vector aktPrePage = null;
        i = 0;
        while (i < objects.size()) {
            if (i % anzTableRows == 0) {
                aktPrePage = new Vector();
                prePages.addElement(aktPrePage);
            }
            if (aktPrePage != null) {
                aktPrePage.addElement(objects.elementAt(i));
            }
            ++i;
        }
        int anzPages = prePages.size();
        Vector<TablePrintPage> document = new Vector<TablePrintPage>(anzPages);
        int i3 = 0;
        while (i3 < anzPages) {
            TablePrintPage tpp = new TablePrintPage(startX, headLineStart, faktor);
            document.addElement(tpp);
            tpp.ivHeaders.add(PrintElement.getHeaderFooterElement(String.valueOf(InstallationType.getNormalProgramName()) + " Printout " + datum, startX + totWidth / 2, startY));
            tpp.ivHeaders.add(PrintElement.getHeaderFooterElement("- Page " + (i3 + 1) + " / " + anzPages + " -", startX + totWidth / 2, maxY - 14));
            int y = 0;
            Vector aktObjects = (Vector)prePages.elementAt(i3);
            tpp.ivTableElements.add(PrintElement.getLineElement(0, y, 0 + colTotWidth, y));
            int aktx = 0;
            int j = 0;
            while (j < model.getColumnCount()) {
                tpp.ivTableElements.add(PrintElement.getHeadLineElement(model.getColumnName(j), aktx + spaltenBreiten[j] / 2, y + 5));
                aktx += spaltenBreiten[j];
                ++j;
            }
            tpp.ivTableElements.add(PrintElement.getLineElement(0, y += 18, 0 + colTotWidth, y));
            Iterator iter = aktObjects.iterator();
            while (iter.hasNext()) {
                Object obi = iter.next();
                aktx = 0;
                int j2 = 0;
                while (j2 < model.getColumnCount()) {
                    int row = model.ivObjects.indexOf(obi);
                    PrintElement pe = PrintElement.getPrintElement(model.getTableCellRendererComponent(model.getJTable(), null, false, false, row, j2), aktx + 3, y);
                    pe.ivColor = Color.black;
                    tpp.ivTableElements.add(pe);
                    aktx += spaltenBreiten[j2];
                    ++j2;
                }
                tpp.ivTableElements.add(PrintElement.getLineElement(0, y += 14, colTotWidth, y));
            }
            aktx = 0;
            tpp.ivTableElements.add(PrintElement.getLineElement(aktx, 0, aktx, y));
            j = 0;
            while (j < model.getColumnCount()) {
                tpp.ivTableElements.add(PrintElement.getLineElement(aktx += spaltenBreiten[j], 0, aktx, y));
                ++j;
            }
            ++i3;
        }
        return document;
    }

    class TablePrintPage {
        public final Vector ivHeaders = new Vector();
        public final Vector ivTableElements = new Vector();
        public final int ivTableStartY;
        public final int ivTableStartX;
        public final double ivTableScale;

        public TablePrintPage(int startx, int starty, double scale) {
            this.ivTableStartX = startx;
            this.ivTableStartY = starty;
            this.ivTableScale = scale;
        }
    }
}

