/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.GroupColorManager;
import mausoleum.cage.colors.SexColor;
import mausoleum.experiment.Experiment;
import mausoleum.gui.MusterColor;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManagerUS;
import mausoleum.license.License;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.result.MResult;
import mausoleum.visit.Visit;

public class DMBRA6Printer
extends LabelPrinter {
    public static final int MODE_NORMAL = 1;
    public static final int MODE_VAS_STUD = 2;
    public static final int MODE_FOSTER = 3;
    public static final int MODE_TEST_BREEDING = 4;
    private static final int CAGE_NUMBER_FIELD_WIDTH = DMBRA6Printer.mm(25.0);
    private static final int CAGE_NUMBER_FIELD_HEIGHT = DMBRA6Printer.mm(12.0);
    private static final Font VERY_BIG_FONT = FontManagerUS.SSB13;
    private static final Font BIG_FONT = FontManagerUS.SSB11;
    private static final int BIG_SIZE = 11;
    private static final Font MEDIUM_FONT = FontManagerUS.SSB10;
    private static final int MEDIUM_SIZE = 10;
    private static final Font SMALL_FONT_B = FontManagerUS.SSB09;
    private static final int SMALL_SIZE_B = 9;
    private static final Font SMALL_FONT = FontManagerUS.SSP8;
    private static final int SMALL_SIZE = 8;
    private static final Stroke DUENN_STROKE = new BasicStroke(0.1f);
    private static final Stroke DICK_STROKE = new BasicStroke(1.5f);
    private final String MALE = DefaultManager.getMale();
    private final String FEMALE = DefaultManager.getFemale();
    private static final int MIN_RAND = DMBRA6Printer.mm(2.0);
    private static final int RAND = DMBRA6Printer.mm(6.0);
    private static final int BREITE = DMBRA6Printer.mm(105.0);
    private static final int HOEHE = DMBRA6Printer.mm(148.0);
    private static final Comparator MOUSE_EARTAG_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                int i2;
                Mouse m1 = (Mouse)o1;
                Mouse m2 = (Mouse)o2;
                int i1 = m1.getInt("MOS_EARTAG", Integer.MAX_VALUE);
                if (i1 < (i2 = m2.getInt("MOS_EARTAG", Integer.MAX_VALUE))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private final int ivMode;
    private final int ivLinks = RAND;
    private final int ivRechts = BREITE - RAND;
    private final int ivOben = RAND;
    private final int ivUnten = HOEHE - RAND;

    public DMBRA6Printer(int mode) {
        this.ivMode = mode;
        this.ivLatePageGeneration = true;
        switch (this.ivMode) {
            case 2: {
                this.ivName = "DRBM A6 Vas Stud";
                break;
            }
            case 3: {
                this.ivName = "DRBM A6 Foster";
                break;
            }
            case 4: {
                this.ivName = "DRBM A6 Testbreeding";
                break;
            }
            default: {
                this.ivName = "DRBM A6";
            }
        }
        this.ivWidth = BREITE;
        this.ivHeight = HOEHE;
        this.ivTop = 0.0;
        this.ivLeft = 0.0;
        this.ivBottom = 0.0;
        this.ivRight = 0.0;
        this.ivBackground = false;
        this.ivRotated = false;
        PageFormatGenerator.createPageformatForLabelPrinter(this);
    }

    public LabelPrinter getClone() {
        DMBRA6Printer clone = new DMBRA6Printer(this.ivMode);
        this.copyValues(clone);
        return clone;
    }

    public void simplePrint(Cage cage, Graphics g) {
        if (cage != null && !(cage instanceof BlockingCage)) {
            switch (this.ivMode) {
                case 1: {
                    this.simplePrintNormal(cage, g);
                    break;
                }
                case 2: {
                    this.simplePrintVasStud(cage, g);
                    break;
                }
                case 3: {
                    this.simplePrintFoster(cage, g);
                    break;
                }
                case 4: {
                    this.simplePrintTestBreeding(cage, g);
                    break;
                }
            }
        }
    }

    private void simplePrintNormal(Cage cage, Graphics g) {
        String comment;
        boolean isMating = false;
        Vector mice = null;
        if (cage.isMatingCage()) {
            isMating = true;
            Vector males = new Vector();
            Vector females = new Vector();
            mice = DMBRA6Printer.collectSexActiveMice(cage, males, females);
        } else {
            mice = cage.getActualMice();
            Collections.sort(mice, MOUSE_EARTAG_SORTER);
        }
        int y = this.ivOben;
        int x = this.ivLinks;
        DMBRA6Printer.drawPolygon(cage, g, x, y);
        int rechtsPlatz = this.ivRechts - (x + CAGE_NUMBER_FIELD_WIDTH);
        g.setFont(BIG_FONT);
        g.setColor(Color.black);
        FontMetrics bigFM = g.getFontMetrics(BIG_FONT);
        FontMetrics mediumFM = g.getFontMetrics(MEDIUM_FONT);
        int bigascent = bigFM.getAscent();
        int mediumascent = mediumFM.getAscent();
        this.drawBigUR(cage.getRackPosString(""), g, x, y, BIG_FONT);
        int ty = y + 11 + MIN_RAND;
        String gruppenDings = "";
        String tag = cage.getString("CAG_ANTAG", null);
        if (tag != null) {
            gruppenDings = String.valueOf(gruppenDings) + "[" + tag + "] ";
        }
        gruppenDings = String.valueOf(gruppenDings) + cage.getOwnerStringOnlySingleNamePreferred() + " " + cage.getGroup();
        this.paintGruppe(g, cage, gruppenDings.trim(), rechtsPlatz, x, ty);
        g.setFont(BIG_FONT);
        g.setColor(Color.black);
        String line = "Line: " + cage.getPureMouseObjectString("", "", 7);
        g.drawString(line, x, (y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND) + bigascent);
        y += 11 + MIN_RAND;
        g.setFont(MEDIUM_FONT);
        int halbe = (this.ivRechts + this.ivLinks) / 2;
        int mitte = this.ivLinks + halbe;
        String license = "EC: " + cage.getPureMouseObjectString("", "", 16);
        while (mediumFM.stringWidth(license) > halbe - MIN_RAND) {
            license = license.substring(0, license.length() - 1);
        }
        g.drawString(license, x, y + mediumascent);
        String experiments = "Exp: " + this.getExperiments(cage);
        while (mediumFM.stringWidth(experiments) > halbe) {
            experiments = experiments.substring(0, experiments.length() - 1);
        }
        g.drawString(experiments, mitte, y + mediumascent);
        y += 10 + MIN_RAND;
        FontMetrics smallFM = g.getFontMetrics(SMALL_FONT);
        if (!mice.isEmpty()) {
            g.setFont(SMALL_FONT);
            int smallascent = smallFM.getAscent();
            int lineH = 10;
            smallFM.getMaxAdvance();
            String[][] values = new String[4][mice.size()];
            Color[] backs = new Color[mice.size()];
            int i = 0;
            while (i < mice.size()) {
                Mouse mouse = (Mouse)mice.elementAt(i);
                int sex = mouse.getSex();
                if (sex == 1) {
                    backs[i] = SexColor.MALE_VERY_LIGHT;
                    values[0][i] = this.MALE;
                } else if (sex == 2) {
                    backs[i] = SexColor.FEMALE_VERY_LIGHT;
                    values[0][i] = this.FEMALE;
                }
                values[1][i] = mouse.getCLLWEartagString();
                values[2][i] = mouse.getCLLWBirthDayString(true);
                values[3][i] = mouse.getGenotype(null);
                ++i;
            }
            int[] w = new int[4];
            int rl = 3;
            int col = 0;
            while (col < 4) {
                w[col] = 0;
                int i2 = 0;
                while (i2 < mice.size()) {
                    int sw;
                    if (values[col][i2] != null && (sw = smallFM.stringWidth(values[col][i2]) + 2 * rl) > w[col]) {
                        w[col] = sw;
                    }
                    ++i2;
                }
                ++col;
            }
            int i3 = 0;
            while (i3 < mice.size()) {
                x = this.ivLinks;
                if (backs[i3] != null) {
                    g.setColor(backs[i3]);
                    g.fillRect(x, y, this.ivRechts - this.ivLinks, lineH);
                    g.setColor(Color.black);
                }
                int col2 = 0;
                while (col2 < 4) {
                    if (values[col2][i3] != null) {
                        g.drawString(values[col2][i3], x + rl, y + smallascent);
                    }
                    x += w[col2];
                    ++col2;
                }
                y += lineH + 1;
                ++i3;
            }
        }
        y += MIN_RAND;
        if (isMating) {
            y += 2 * MIN_RAND;
            y = this.macheStriche(g, y);
            y += MIN_RAND;
        }
        if ((comment = cage.getString("CAG_COMMENT", null)) != null) {
            comment = "Comment: " + comment;
            g.setFont(SMALL_FONT);
            g.setColor(Color.black);
            TextWrapComponent twc = new TextWrapComponent(comment, SMALL_FONT, this.ivRechts - this.ivLinks, 1112);
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                if (y >= this.ivUnten) continue;
                g.drawString(twe.ivText, twe.ivX + this.ivLinks, y + twe.ivY);
            }
        }
    }

    private void simplePrintVasStud(Cage cage, Graphics g) {
        int y = this.ivOben;
        int x = this.ivLinks;
        int ty = y;
        DMBRA6Printer.drawPolygon(cage, g, x, ty);
        this.drawBigUR("VAS-STUD", g, x, ty, VERY_BIG_FONT);
        this.drawBigUR(cage.getRackPosString(""), g, x, ty += VERY_BIG_FONT.getSize() + 2, BIG_FONT);
        Vector males = new Vector();
        Vector females = new Vector();
        DMBRA6Printer.collectSexActiveMice(cage, males, females);
        if (males.size() != 1 || !females.isEmpty()) {
            g.setFont(BIG_FONT);
            g.setColor(Color.black);
            DMBRA6Printer.showCentered(g, Babel.get("NOTAPPLIC", "en"), (int)this.ivLeft, this.ivRechts, y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND);
        } else {
            ty += VERY_BIG_FONT.getSize() + 2;
            Mouse stud = (Mouse)males.firstElement();
            int halbe = (this.ivRechts + this.ivLinks) / 2;
            int mitte = this.ivLinks + halbe;
            int tx = this.ivRechts - 3 * CAGE_NUMBER_FIELD_WIDTH / 2;
            g.setFont(MEDIUM_FONT);
            DMBRA6Printer.showAtPos(g, "Eartag: " + stud.getCLLWEartagString(), tx, ty);
            DMBRA6Printer.showAtPos(g, "Vas date:", tx, ty += 12);
            ty += 12;
            DMBRA6Printer.showAtPos(g, "EC: " + DMBRA6Printer.getLic1FromOldest(males, ""), x, ty -= 12);
            DMBRA6Printer.showAtPos(g, "Line: " + stud.getCLLWLineString(), x, ty += 12);
            ty += 12;
            String bd = "";
            Mouse oldest = DMBRA6Printer.findOldest(males);
            if (oldest != null) {
                bd = oldest.getCLLWBirthDayString(true);
            }
            DMBRA6Printer.showAtPos(g, "birth date: " + bd, x, ty);
            DMBRA6Printer.showAtPos(g, "setup with test female:", mitte - DMBRA6Printer.mm(15.0), ty);
            ty += 12;
            ty += 8;
            int x0 = this.ivLinks;
            int x4 = this.ivRechts;
            int x2 = (x0 + x4) / 2;
            int x1 = (x0 + x2) / 2;
            int x3 = (x2 + x4) / 2;
            int x0a = (2 * x0 + 3 * x1) / 5;
            int x1a = (2 * x1 + 3 * x2) / 5;
            int x2a = (2 * x2 + 3 * x3) / 5;
            int x3a = (2 * x3 + 3 * x4) / 5;
            g.setFont(SMALL_FONT);
            DMBRA6Printer.showCentered(g, "date", x0, x0a, ty + 2);
            DMBRA6Printer.showCentered(g, "date", x1, x1a, ty + 2);
            DMBRA6Printer.showCentered(g, "date", x2, x2a, ty + 2);
            DMBRA6Printer.showCentered(g, "date", x3, x3a, ty + 2);
            DMBRA6Printer.showCentered(g, "plug", x0a, x1, ty + 2);
            DMBRA6Printer.showCentered(g, "plug", x1a, x2, ty + 2);
            DMBRA6Printer.showCentered(g, "plug", x2a, x3, ty + 2);
            DMBRA6Printer.showCentered(g, "plug", x3a, x4, ty + 2);
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            int sty = ty;
            g2d.setStroke(DICK_STROKE);
            g.drawLine(x0, ty, x4, ty);
            g.drawLine(x0, ty + 11 + 2, x4, ty + 11 + 2);
            g2d.setStroke(DUENN_STROKE);
            while (ty < this.ivUnten) {
                g.drawLine(x0, ty, x4, ty);
                ty += 13;
            }
            g2d.setStroke(DICK_STROKE);
            g.drawLine(x0, ty -= 13, x4, ty);
            g2d.setStroke(DUENN_STROKE);
            g.drawLine(x0a, ty, x0a, sty);
            g.drawLine(x1a, ty, x1a, sty);
            g.drawLine(x2a, ty, x2a, sty);
            g.drawLine(x3a, ty, x3a, sty);
            g2d.setStroke(DICK_STROKE);
            g.drawLine(x0, ty, x0, sty);
            g.drawLine(x1, ty, x1, sty);
            g.drawLine(x2, ty, x2, sty);
            g.drawLine(x3, ty, x3, sty);
            g.drawLine(x4, ty, x4, sty);
            g2d.setStroke(stroke);
        }
    }

    private void simplePrintFoster(Cage cage, Graphics g) {
        int y = this.ivOben;
        int x = this.ivLinks;
        DMBRA6Printer.drawPolygon(cage, g, x, y);
        this.drawBigUR("FOSTER", g, x, y, VERY_BIG_FONT);
        this.drawBigUR(cage.getRackPosString(""), g, x, y += VERY_BIG_FONT.getSize() + 2, BIG_FONT);
        Vector males = new Vector();
        Vector females = new Vector();
        DMBRA6Printer.collectSexActiveMice(cage, males, females);
        if (!males.isEmpty() || females.size() != 1) {
            g.setFont(BIG_FONT);
            g.setColor(Color.black);
            DMBRA6Printer.showCentered(g, Babel.get("NOTAPPLIC", "en"), (int)this.ivLeft, this.ivRechts, y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND);
        } else {
            Mouse foster = (Mouse)females.firstElement();
            int halbe = (this.ivRechts + this.ivLinks) / 2;
            int mitte = this.ivLinks + halbe;
            int tx = this.ivRechts - 3 * CAGE_NUMBER_FIELD_WIDTH / 2;
            int ty = y + VERY_BIG_FONT.getSize() + 2;
            g.setFont(MEDIUM_FONT);
            DMBRA6Printer.showAtPos(g, "Eartag: " + foster.getCLLWEartagString(), tx, ty);
            DMBRA6Printer.showAtPos(g, "Weight:", tx, ty += 12);
            DMBRA6Printer.showAtPos(g, "Ethicom:", tx, ty += 12);
            ty += 12;
            y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND + 11 + 2;
            DMBRA6Printer.showAtPos(g, "EC: " + DMBRA6Printer.getLic1FromOldest(females, ""), x, y -= 12);
            DMBRA6Printer.showAtPos(g, "Line: " + foster.getCLLWLineString(), x, y += 12);
            DMBRA6Printer.showAtPos(g, "Embryo stage:", x, y += 12);
            DMBRA6Printer.showAtPos(g, "# embryos:", tx, y);
            DMBRA6Printer.showAtPos(g, "Transfer date:", x, y += 12);
            DMBRA6Printer.showAtPos(g, "EDOB:", tx, y);
            y += 12;
            g.drawLine(this.ivLinks, y += 4, this.ivRechts, y);
            y += 4;
            int drittel = (int)((double)(this.ivRechts - this.ivLinks) / 3.0);
            int circSize = 10;
            int cSize = 6;
            int ctx = x;
            g.setFont(SMALL_FONT);
            g.drawArc(ctx, y + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "aggregation", ctx + circSize, y);
            g.drawArc(ctx += drittel, y + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "zygote injection", ctx + circSize, y);
            g.drawArc(ctx += drittel, y + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "IVF", ctx + circSize, y);
            ctx += drittel;
            ctx = x;
            g.drawArc(ctx, (y += 12) + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "blastocyst injection", ctx + circSize, y);
            g.drawArc(ctx += drittel, y + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "rederivation", ctx + circSize, y);
            g.drawArc(ctx += drittel, y + 2, cSize, cSize, 0, 360);
            DMBRA6Printer.showAtPos(g, "cryo_IVF", ctx + circSize, y);
            ctx += drittel;
            y += 12;
            g.drawLine(this.ivLinks, y += 4, this.ivRechts, y);
            g.setFont(MEDIUM_FONT);
            DMBRA6Printer.showAtPos(g, "# pups:", x, y += 4);
            DMBRA6Printer.showAtPos(g, "# chimaeras:", mitte, y);
            DMBRA6Printer.showAtPos(g, "DOB:", x, y += 12);
            DMBRA6Printer.showAtPos(g, "Investigator:", x, y += 12);
            DMBRA6Printer.showAtPos(g, "Unit:", tx, y);
            y += 12;
            String comment = cage.getString("CAG_COMMENT", null);
            if (comment != null) {
                TextWrapComponent twc = new TextWrapComponent("Comment: " + comment, MEDIUM_FONT, this.ivRechts - this.ivLinks, 1112);
                g.translate(x, y += 12);
                twc.paint(g);
                g.translate(-x, -y);
            }
        }
    }

    private void simplePrintTestBreeding(Cage cage, Graphics g) {
        int y = this.ivOben - 6;
        int x = this.ivLinks;
        g.drawLine(0, HOEHE / 2, BREITE, HOEHE / 2);
        DMBRA6Printer.drawPolygon(cage, g, x, y);
        this.drawBigUR("TESTBREEDING", g, x, y, VERY_BIG_FONT);
        this.drawBigUR(cage.getRackPosString(""), g, x, y += VERY_BIG_FONT.getSize() + 2, BIG_FONT);
        Vector males = new Vector();
        Vector females = new Vector();
        DMBRA6Printer.collectSexActiveMice(cage, males, females);
        if (males.size() != 1 || females.size() != 1 && females.size() != 2) {
            g.setFont(BIG_FONT);
            g.setColor(Color.black);
            DMBRA6Printer.showCentered(g, Babel.get("NOTAPPLIC", "en"), (int)this.ivLeft, this.ivRechts, y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND);
        } else {
            Mouse female2;
            Vector lastVisits;
            Mouse stud = (Mouse)males.firstElement();
            int tx = this.ivRechts - 4 * CAGE_NUMBER_FIELD_WIDTH / 2 - 12;
            int ty = y + VERY_BIG_FONT.getSize() + 2;
            g.setFont(MEDIUM_FONT);
            String date = "";
            String cageBefore = "";
            Visit[] visits = (Visit[])stud.get("MOS_VISIT");
            if (visits != null && visits.length != 0) {
                date = DatumFormat.getJustDateString(visits[visits.length - 1].ivStartDate);
                if (visits.length > 1) {
                    Visit prev = visits[visits.length - 2];
                    Cage pcage = CageManager.getCage(new Long(prev.ivCageID), stud.getGroup());
                    cageBefore = pcage.getNumber();
                }
            }
            if ((lastVisits = Mouse.getLastVisits(males)) != null && lastVisits.size() == 1) {
                Visit v = (Visit)lastVisits.firstElement();
                date = DatumFormat.getJustDateString(v.ivStartDate);
            }
            DMBRA6Printer.showAtPos(g, "Start breeding: " + date, tx, ty);
            DMBRA6Printer.showAtPos(g, "% chimera:", tx + 80, ty += 12);
            ty += 12;
            y += CAGE_NUMBER_FIELD_HEIGHT + MIN_RAND;
            DMBRA6Printer.showAtPos(g, "EC: " + DMBRA6Printer.getLic1FromOldest(males, ""), x, y -= 12);
            DMBRA6Printer.showAtPos(g, "Line chimera: " + stud.getCLLWLineString(), x, y += 12);
            int drittel = (int)((double)this.ivLinks + (double)(this.ivRechts - this.ivLinks) / 3.0);
            int x1 = x;
            int x2 = x1 + drittel + 12;
            int x3 = x2 + drittel - 28;
            DMBRA6Printer.showAtPos(g, "ET chimera: " + stud.getCLLWEartagString(), x1, y += 12);
            DMBRA6Printer.showAtPos(g, "born: " + stud.getCLLWBirthDayString(true), x2, y);
            DMBRA6Printer.showAtPos(g, "orig. cage:" + cageBefore, x3, y);
            y += 12;
            g.drawLine(this.ivLinks, ++y, this.ivRechts, y);
            g.setFont(SMALL_FONT_B);
            Mouse female1 = (Mouse)females.firstElement();
            DMBRA6Printer.showAtPos(g, "Female 1: " + female1.getCLLWStrainString(), x1, ++y);
            DMBRA6Printer.showAtPos(g, "born: " + female1.getCLLWBirthDayString(true), x2, y += 10);
            DMBRA6Printer.showAtPos(g, "eartag: " + female1.getCLLWEartagString(), x3, y);
            y += 10;
            g.drawLine(this.ivLinks, ++y, this.ivRechts, y);
            ++y;
            Mouse mouse = female2 = females.size() > 1 ? (Mouse)females.elementAt(1) : null;
            if (female2 != null) {
                DMBRA6Printer.showAtPos(g, "Female 2: " + female2.getCLLWStrainString(), x1, y);
                DMBRA6Printer.showAtPos(g, "born: " + female2.getCLLWBirthDayString(true), x2, y += 11);
                DMBRA6Printer.showAtPos(g, "eartag: " + female2.getCLLWEartagString(), x3, y);
                y += 10;
                g.drawLine(this.ivLinks, ++y, this.ivRechts, y);
                ++y;
            }
            DMBRA6Printer.showAtPos(g, "Investigator: ", x1, y);
            DMBRA6Printer.showAtPos(g, "Unit: ", x3, y);
            y += 12;
            int ir = 6;
            int gw = this.ivRechts - this.ivLinks - 4 * ir;
            int w1 = (int)((double)gw * 0.2);
            int w2 = (int)((double)gw * 0.1);
            int w3 = (int)((double)gw * 0.2);
            int w4 = (int)((double)gw * 0.2);
            int w5 = (int)((double)gw * 0.3);
            int ux1 = x;
            int ux2 = ux1 + w1 + ir;
            int ux3 = ux2 + w2 + ir;
            int ux4 = ux3 + w3 + ir;
            int ux5 = ux4 + w4 + ir;
            int ux3a = (ux3 + ux4) / 2;
            g.setFont(SMALL_FONT);
            DMBRA6Printer.showAtPos(g, "Birth date", ux1, y);
            DMBRA6Printer.showAtPos(g, "#", ux2, y);
            DMBRA6Printer.showAtPos(g, "#\u2640", ux3, y);
            DMBRA6Printer.showAtPos(g, "#\u2642", ux3a, y);
            DMBRA6Printer.showAtPos(g, "DOW", ux4, y);
            DMBRA6Printer.showAtPos(g, "Weaned to cages", ux5, y);
            int fw = g.getFontMetrics().stringWidth("\u2640");
            int mw = g.getFontMetrics().stringWidth("\u2642");
            y += 2;
            int i = 1;
            while (i <= 3) {
                g.drawLine(ux1, y += 18, ux1 + w1, y);
                g.drawLine(ux2, y, ux2 + w2, y);
                g.drawString("\u2640", ux3, y);
                g.drawLine(ux3 + fw, y, ux3a - 4, y);
                g.drawString("\u2642", ux3a, y);
                g.drawLine(ux3a + mw, y, ux4 - ir, y);
                g.drawLine(ux4, y, ux4 + w4, y);
                g.drawLine(ux5, y, ux5 + w5, y);
                ++i;
            }
            String comment = cage.getString("CAG_COMMENT", null);
            if (comment != null) {
                TextWrapComponent twc = new TextWrapComponent("Comment: " + comment, SMALL_FONT, this.ivRechts - this.ivLinks, 1112);
                g.translate(x, y += 8);
                twc.paint(g);
                g.translate(-x, -y);
            }
        }
    }

    private static void showCentered(Graphics g, String s, int lx, int rx, int y) {
        int sw = g.getFontMetrics().stringWidth(s);
        int x = (lx + rx - sw) / 2;
        g.drawString(s, x, y + g.getFontMetrics().getAscent());
    }

    private static void showAtPos(Graphics g, String s, int x, int y) {
        g.drawString(s, x, y + g.getFontMetrics().getAscent());
    }

    private static void drawPolygon(Cage cage, Graphics g, int x, int y) {
        CageDisplayManager.fillCage(cage, g, x, y, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, null, 0);
        CageDisplayManager.drawFilledCagePolygon(g, x, y, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT);
    }

    private static Vector collectSexActiveMice(Cage cage, Vector males, Vector females) {
        Wurf.findSexActiveMice(cage, null, males, females, null);
        Vector mice = new Vector();
        Collections.sort(males, MOUSE_EARTAG_SORTER);
        Collections.sort(females, MOUSE_EARTAG_SORTER);
        mice.addAll(males);
        mice.addAll(females);
        return mice;
    }

    private static Mouse findOldest(Vector mice) {
        Mouse res = null;
        if (mice != null && !mice.isEmpty()) {
            int max = -1;
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                int age = mouse.getAgeInDays(-1);
                if (age <= max) continue;
                max = age;
                res = mouse;
            }
        }
        return res;
    }

    private static String getLic1FromOldest(Vector mice, String defVal) {
        License license;
        Long licid;
        String lic = defVal;
        Mouse oldest = DMBRA6Printer.findOldest(mice);
        if (oldest != null && (licid = (Long)oldest.get("MOS_LICID")) != null && (license = (License)ObjectStore.getClientObject(16, licid, oldest.getGroup())) != null) {
            lic = license.getBrowseNameWITHOUTServicePrefix();
        }
        return lic;
    }

    private void drawBigUR(String rackbezeichner, Graphics g, int x, int y, Font font) {
        if (rackbezeichner != null) {
            g.setFont(font);
            g.setColor(Color.black);
            FontMetrics fm = g.getFontMetrics();
            int rechtsPlatz = this.ivRechts - (x + CAGE_NUMBER_FIELD_WIDTH);
            int sw = fm.stringWidth(rackbezeichner);
            if (sw < rechtsPlatz) {
                g.drawString(rackbezeichner, this.ivRechts - sw, y + fm.getAscent());
            } else {
                g.drawString(rackbezeichner, x + CAGE_NUMBER_FIELD_WIDTH, y + fm.getAscent());
            }
        }
    }

    private void paintGruppe(Graphics g, Cage cage, String gruppenDings, int rechtsPlatz, int x, int ty) {
        Color gcol;
        g.setFont(BIG_FONT);
        int sw = g.getFontMetrics().stringWidth(gruppenDings);
        int fx = this.ivRechts - sw - 2 * MIN_RAND;
        int fw = this.ivRechts - fx;
        int fh = BIG_FONT.getSize() + 2 * MIN_RAND;
        if (fx < this.ivLinks + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND) {
            fx = this.ivLinks + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND;
            fw = this.ivRechts - fx;
        }
        if ((gcol = GroupColorManager.getColor(cage.getGroup())) != null) {
            if (gcol instanceof MusterColor) {
                MusterColor mc = (MusterColor)gcol;
                mc.fill(fx, ty, fw, fh, g);
                g.setColor(Color.black);
            } else {
                g.setColor(gcol);
                g.fillRect(fx, ty, fw, fh);
                g.setColor(Color.black);
            }
        }
        int xx = fx + MIN_RAND;
        int yy = ty + MIN_RAND + g.getFontMetrics().getAscent();
        g.setColor(Color.white);
        g.drawString(gruppenDings, xx - 1, yy - 1);
        g.drawString(gruppenDings, xx - 1, yy + 1);
        g.drawString(gruppenDings, xx + 1, yy - 1);
        g.drawString(gruppenDings, xx + 1, yy + 1);
        g.setColor(Color.black);
        g.drawString(gruppenDings, xx, yy);
    }

    private int macheStriche(Graphics g, int y) {
        g.setFont(SMALL_FONT);
        FontMetrics fm = g.getFontMetrics();
        int lh = 15;
        int grosseLuecke = 4 * MIN_RAND;
        int pw = (this.ivRechts - this.ivLinks - grosseLuecke) / 2;
        int fsw = fm.stringWidth(this.FEMALE);
        int msw = fm.stringWidth(this.MALE);
        int ssw = (pw - fsw - msw - 2 * MIN_RAND) / 6;
        int osw = 6 * ssw + 2 * MIN_RAND + fsw + msw;
        int lx = this.ivLinks;
        int rx = this.ivRechts - osw;
        int ey = fm.getMaxAscent();
        int i = 0;
        while (i < 5) {
            int xo = 0;
            g.drawLine(lx + xo, y + ey, lx + xo + 3 * ssw, y + ey);
            g.drawLine(rx + xo, y + ey, rx + xo + 3 * ssw, y + ey);
            g.drawLine(lx + (xo += 3 * ssw + MIN_RAND), y + ey, lx + xo + 1 * ssw, y + ey);
            g.drawLine(rx + xo, y + ey, rx + xo + 1 * ssw, y + ey);
            g.drawString(this.MALE, lx + (xo += 1 * ssw + MIN_RAND), y + ey);
            g.drawString(this.MALE, rx + xo, y + ey);
            g.drawLine(lx + (xo += fsw), y + ey, lx + xo + 1 * ssw, y + ey);
            g.drawLine(rx + xo, y + ey, rx + xo + 1 * ssw, y + ey);
            g.drawString(this.FEMALE, lx + (xo += 1 * ssw), y + ey);
            g.drawString(this.FEMALE, rx + xo, y + ey);
            g.drawLine(lx + (xo += msw), y + ey, lx + xo + 1 * ssw, y + ey);
            g.drawLine(rx + xo, y + ey, rx + xo + 1 * ssw, y + ey);
            y += lh;
            ++i;
        }
        return y;
    }

    private String getExperiments(Cage cage) {
        TreeSet<String> ts = new TreeSet<String>();
        Vector mice = cage.getActualMice();
        if (mice != null) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                Vector rfm = (Vector)mouse.get("MOS_MRESULTS");
                if (rfm == null) continue;
                Iterator iterator = rfm.iterator();
                while (iterator.hasNext()) {
                    MResult mres = (MResult)iterator.next();
                    Experiment exp = mres.getExperiment(mouse.getGroup());
                    if (exp == null) continue;
                    ts.add(exp.getName());
                }
            }
            ts.remove("");
            if (!ts.isEmpty()) {
                StringBuffer licsb = new StringBuffer();
                Iterator iter2 = ts.iterator();
                while (iter2.hasNext()) {
                    licsb.append((String)iter2.next());
                    if (!iter2.hasNext()) continue;
                    licsb.append(", ");
                }
                return licsb.toString();
            }
        }
        return "";
    }
}

