/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.gui.TextWrapComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class DZNEMatingPrinter
extends LabelPrinter {
    private static final int EARTAG_WIDTH_DZNE = 42;
    private static final int EARTAG_WIDTH_2 = 48;
    private static final int LINE_HEIGHT = 14;
    private static final int LINE_HEIGHT_STOCK_DZNE = 14;
    private static final int S2_NUMBER_FIELD_WIDTH = DZNEMatingPrinter.mm(10.0);
    private static final int CAGE_NUMBER_FIELD_WIDTH = DZNEMatingPrinter.mm(23.0);
    private static final int CAGE_NUMBER_FIELD_HEIGHT = DZNEMatingPrinter.mm(10.0);
    private static final int MIN_RAND = DZNEMatingPrinter.mm(2.0);
    private static final int MIKRO_RAND = DZNEMatingPrinter.mm(0.5);
    private static final double RAND = 4.0;
    private int ivLinks = 0;
    private int ivRechts = 0;
    private int ivOben = 0;
    private int ivUnten = 0;
    private boolean ivExtraMating = false;
    private boolean ivBackCross = false;
    private boolean ivBackCross2 = false;
    private boolean ivHarem = false;
    private boolean ivDidoModus = false;
    private boolean ivShowParents = false;
    private boolean ivWithS2 = false;

    public DZNEMatingPrinter(boolean showParents, boolean extraMatingModus, boolean harem, boolean backcross, boolean backcross2, boolean withS2) {
        super("XXXX", 212.59842519685043, 368.5039370078741);
        String namePrefix = showParents ? "DZNE-C " : "DZNE ";
        this.ivShowParents = showParents;
        if (extraMatingModus) {
            this.ivName = String.valueOf(namePrefix) + "Mating Extra";
            this.ivExtraMating = true;
            this.ivDidoModus = true;
        } else if (harem) {
            this.ivName = String.valueOf(namePrefix) + "Harem";
            this.ivHarem = true;
        } else if (backcross) {
            this.ivName = String.valueOf(namePrefix) + "Mating Backcross";
            this.ivBackCross = true;
        } else if (backcross2) {
            this.ivName = String.valueOf(namePrefix) + "Mating Backcross 2";
            this.ivBackCross2 = true;
        } else {
            this.ivName = String.valueOf(namePrefix) + "Mating";
        }
        this.ivWithS2 = withS2;
        if (this.ivWithS2) {
            this.ivName = String.valueOf(this.ivName) + " S2";
        }
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivLinks = 11;
        this.ivRechts = (int)(this.ivWidth - 11.338582677165356);
        this.ivOben = 11;
        this.ivUnten = (int)(this.ivHeight - 11.338582677165356);
    }

    public LabelPrinter getClone() {
        DZNEMatingPrinter clone = new DZNEMatingPrinter(this.ivShowParents, this.ivExtraMating, this.ivHarem, this.ivBackCross, this.ivBackCross2, this.ivWithS2);
        this.copyValues(clone);
        clone.ivDidoModus = this.ivDidoModus;
        return clone;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        if (cage.isMatingCage() || this.ivExtraMating) {
            this.printMatingCage((Graphics2D)graphics, cage);
        } else {
            this.printStockCage((Graphics2D)graphics, cage);
        }
    }

    private void printMatingCage(Graphics2D g, Cage c) {
        int x5;
        int datw;
        int iay;
        int earTagWidth;
        Vector males = new Vector();
        Vector females = new Vector();
        HashMap sepDatesByMaleID = new HashMap();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, this.ivExtraMating, 1, 2, sepDatesByMaleID, false, false, false, false, true, false, false, this.ivDidoModus, false, false);
        if (wuerfe == null || females.isEmpty()) {
            this.printStockCage(g, c);
            return;
        }
        int orLineHeight = DZNEMatingPrinter.mm(3.5);
        int platzFuerLines = 0;
        TextWrapComponent twc = null;
        String typs = AllgUtils.getTypeString(c, c.getActualMice(), 0, true);
        if (typs.trim().length() != 0) {
            twc = new TextWrapComponent(typs, FontManagerUS.SSB10);
            twc.setSize(this.ivRechts - this.ivLinks - 2 * MIN_RAND, 100);
            twc.generateElements();
            platzFuerLines = twc.getAnzElements() * orLineHeight + 2 * MIN_RAND;
        }
        int yObenNormal = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        int you = yObenNormal + platzFuerLines;
        DZNEMatingPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        DZNEMatingPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, DZNEMatingPrinter.mm(0.8));
        int orXStart = this.ivLinks + MIN_RAND;
        int cfw = CAGE_NUMBER_FIELD_WIDTH;
        if (this.ivWithS2) {
            LabelMaker.make(g, "S2", FontManagerUS.SSB16, orXStart, this.ivOben + MIN_RAND, S2_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, DZNEMatingPrinter.mm(0.8), 0, Color.white, Color.red);
            orXStart += S2_NUMBER_FIELD_WIDTH + MIKRO_RAND;
            cfw -= S2_NUMBER_FIELD_WIDTH / 2;
        }
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, orXStart, this.ivOben + MIN_RAND, cfw, CAGE_NUMBER_FIELD_HEIGHT, DZNEMatingPrinter.mm(0.8), 0, Color.white);
        int orBreite = (int)(this.ivWidth - 11.338582677165356) - (orXStart += cfw + MIN_RAND);
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB10, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + DZNEMatingPrinter.mm(0.2);
        int anzLineHeight = DZNEMatingPrinter.mm(4.2);
        String css = String.valueOf(c.getNumberOfMice()) + " M / " + c.getOwnerStringOnlySingleEmailPreferred();
        if (css != null && css.length() != 0) {
            LabelMaker.makeMitRandDrumrum(g, css, FontManagerUS.SSB14, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += anzLineHeight + DZNEMatingPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        ay = yObenNormal;
        if (twc != null) {
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                LabelMaker.makeMitRandDrumrum(g, twe.ivText, FontManagerUS.SSB10, this.ivLinks + MIN_RAND, ay + 1, this.ivRechts - this.ivLinks - 2 * MIN_RAND, orLineHeight, 0, 0, null);
                ay += orLineHeight;
            }
        }
        int akty = you;
        if (this.ivBackCross) {
            int bzLabelHeight = DZNEMatingPrinter.mm(5.0);
            int shh = 14;
            LabelMaker.make(g, "BACKCROSSING", FontManagerUS.SSB10, this.ivLinks, akty, this.ivRechts - this.ivLinks, shh, 0, 0, null);
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + bzLabelHeight, DZNEMatingPrinter.mm(1.0));
            akty += bzLabelHeight;
        }
        int signWith = earTagWidth = 42;
        int restWidth = this.ivRechts - this.ivLinks - signWith;
        int restStart = this.ivLinks + earTagWidth;
        int i = 0;
        while (i < males.size()) {
            Mouse father = (Mouse)males.elementAt(i);
            if (!c.isMouseInside(father.getLong("IDO_ID"))) {
                DZNEMatingPrinter.fillRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, Color.lightGray);
            }
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB14, this.ivLinks, akty, earTagWidth, 28, 0, 0, null);
            LabelMaker.make(g, DZNEMatingPrinter.getEartag(father), FontManagerUS.SSB10, this.ivLinks, akty + 28, earTagWidth, 14, 0, 0, Wurf.FATHER_COLORS[i % Wurf.FATHER_COLORS.length]);
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 28, DZNEMatingPrinter.mm(0.1));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 42, DZNEMatingPrinter.mm(0.1));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, DZNEMatingPrinter.mm(0.8));
            iay = akty;
            LabelMaker.make(g, " " + DZNEMatingPrinter.getGenotype(father) + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            DZNEMatingPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            LabelMaker.make(g, "DoB: " + LabelMaker.getVeryShortDateString(DZNEMatingPrinter.getBirthday(father)), FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            DZNEMatingPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, DZNEMatingPrinter.mm(0.1));
            Date separationDate = (Date)sepDatesByMaleID.get(father.get("IDO_ID"));
            if (separationDate != null) {
                LabelMaker.make(g, "Sep: " + LabelMaker.getVeryShortDateString(separationDate), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
                DZNEMatingPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            } else {
                LabelMaker.make(g, "Din: " + LabelMaker.getVeryShortDateString(DZNEMatingPrinter.getInDate(father, c)), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
                DZNEMatingPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            }
            int ulx = restStart;
            int uly = iay += 14;
            int lrx = ulx + restWidth;
            int lry = uly + 14;
            if (this.ivBackCross) {
                LabelMaker.make(g, " " + father.getCLLWStrainString(true, true, true) + " ", FontManagerUS.SSB10, ulx, uly, restWidth, 14, 0, 2, null);
                DZNEMatingPrinter.drawRect(g, ulx, uly, lrx, lry, DZNEMatingPrinter.mm(0.1));
            } else if (this.ivBackCross2) {
                Vector list = IndexObject.getSorteds((IndexObject[])father.get("MOS_STRAIN"));
                if (list != null) {
                    int bx = ulx;
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        IndexObject io = (IndexObject)iter.next();
                        Strain strain = (Strain)ObjectStore.getClientObject(io.ivObjectType, io.ivObjectID, father.getGroup());
                        if (strain == null) continue;
                        int bw = (int)(io.ivNumber * (double)restWidth);
                        Color col = (Color)strain.get("STR_COLOR");
                        DZNEMatingPrinter.fillRect(g, bx, uly, bx + bw, lry, col);
                        bx += bw;
                    }
                    String rein = String.valueOf(IndexObject.getDisplayString(new IndexObject[]{(IndexObject)list.get(0)}, father.getGroup(), 8, true, true, true)) + (list.size() > 1 ? " ..." : "");
                    LabelMaker.makeMitRandDrumrum(g, " " + rein + " ", FontManagerUS.SSB10, ulx, uly, restWidth, 14, 0, 2, null);
                }
                DZNEMatingPrinter.drawRect(g, ulx, uly, lrx, lry, DZNEMatingPrinter.mm(0.1));
            } else {
                LabelMaker.make(g, " " + father.getCLLWLineString() + "/" + father.getCLLWStrainString() + " ", FontManagerUS.SSB10, ulx, uly, restWidth, 14, 0, 2, null);
                DZNEMatingPrinter.drawRect(g, ulx, uly, lrx, lry, DZNEMatingPrinter.mm(0.1));
            }
            akty += 42;
            ++i;
        }
        i = 0;
        while (i < females.size()) {
            Mouse mother = (Mouse)females.elementAt(i);
            if (!c.isMouseInside(mother.getLong("IDO_ID"))) {
                DZNEMatingPrinter.fillRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, Color.lightGray);
            }
            LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB14, this.ivLinks, akty, earTagWidth, 28, 0, 0, null);
            LabelMaker.make(g, DZNEMatingPrinter.getEartag(mother), FontManagerUS.SSB10, this.ivLinks, akty + 28, earTagWidth, 14, 0, 0, Wurf.MOTHER_COLORS[i % Wurf.MOTHER_COLORS.length]);
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 28, DZNEMatingPrinter.mm(0.1));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + earTagWidth, akty + 42, DZNEMatingPrinter.mm(0.1));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, DZNEMatingPrinter.mm(0.8));
            iay = akty;
            LabelMaker.make(g, " " + DZNEMatingPrinter.getGenotype(mother) + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            DZNEMatingPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            LabelMaker.make(g, "DoB: " + LabelMaker.getVeryShortDateString(DZNEMatingPrinter.getBirthday(mother)), FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            DZNEMatingPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, DZNEMatingPrinter.mm(0.1));
            LabelMaker.make(g, "Din: " + LabelMaker.getVeryShortDateString(DZNEMatingPrinter.getInDate(mother, c)), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            DZNEMatingPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            int ulx = restStart;
            int uly = iay += 14;
            int lrx = ulx + restWidth;
            int lry = uly + 14;
            if (this.ivBackCross) {
                LabelMaker.make(g, " " + mother.getCLLWStrainString(true, true, true) + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
                DZNEMatingPrinter.drawRect(g, ulx, uly, lrx, lry, DZNEMatingPrinter.mm(0.1));
            } else if (this.ivBackCross2) {
                Vector list = IndexObject.getSorteds((IndexObject[])mother.get("MOS_STRAIN"));
                if (list != null) {
                    int bx = ulx;
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        IndexObject io = (IndexObject)iter.next();
                        Strain strain = (Strain)ObjectStore.getClientObject(io.ivObjectType, io.ivObjectID, mother.getGroup());
                        if (strain == null) continue;
                        int bw = (int)(io.ivNumber * (double)restWidth);
                        Color col = (Color)strain.get("STR_COLOR");
                        DZNEMatingPrinter.fillRect(g, bx, uly, bx + bw, lry, col);
                        bx += bw;
                    }
                    String rein = String.valueOf(IndexObject.getDisplayString(new IndexObject[]{(IndexObject)list.get(0)}, mother.getGroup(), 8, true, true, true)) + (list.size() > 1 ? " ..." : "");
                    LabelMaker.makeMitRandDrumrum(g, " " + rein + " ", FontManagerUS.SSB10, ulx, uly, restWidth, 14, 0, 2, null);
                }
                DZNEMatingPrinter.drawRect(g, ulx, uly, lrx, lry, DZNEMatingPrinter.mm(0.1));
            } else {
                LabelMaker.make(g, " " + mother.getCLLWLineString() + "/" + mother.getCLLWStrainString() + " ", FontManagerUS.SSB10, restStart, iay, restWidth / 2, 14, 0, 2, null);
                DZNEMatingPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, DZNEMatingPrinter.mm(0.1));
                Date pd = DZNEMatingPrinter.getPlugday(mother);
                if (pd != null) {
                    LabelMaker.make(g, "PD: " + LabelMaker.getVeryShortDateString(pd), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
                }
                DZNEMatingPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, DZNEMatingPrinter.mm(0.1));
            }
            akty += 42;
            ++i;
        }
        int yStartWurfTabelleHeader = akty;
        int totwidth = this.ivRechts - this.ivLinks;
        if (this.ivHarem) {
            datw = 51;
            int plugw = totwidth / 2 - datw;
            int x3 = this.ivLinks + plugw;
            int x4 = x3 + datw;
            x5 = x4 + plugw;
            int shh = 14;
            int yHeader1 = yStartWurfTabelleHeader;
            int yHeader2 = yHeader1 + shh;
            int yBody = yHeader2 + shh;
            if (!females.isEmpty()) {
                int halbe = totwidth / 2;
                int i2 = 0;
                while (i2 < females.size() && i2 < 2) {
                    Mouse mother = (Mouse)females.elementAt(i2);
                    LabelMaker.make(g, DZNEMatingPrinter.getEartag(mother), FontManagerUS.SSB10, this.ivLinks + i2 * halbe, yHeader1, halbe, shh, 0, 0, Wurf.MOTHER_COLORS[i2 % Wurf.MOTHER_COLORS.length]);
                    ++i2;
                }
            }
            LabelMaker.make(g, "Date", FontManagerUS.SSB10, this.ivLinks, yHeader2, datw, shh, 0, 0, null);
            LabelMaker.make(g, "Plug", FontManagerUS.SSB10, x3, yHeader2, plugw, shh, 0, 0, null);
            LabelMaker.make(g, "Date", FontManagerUS.SSB10, x4, yHeader2, datw, shh, 0, 0, null);
            LabelMaker.make(g, "Plug", FontManagerUS.SSB10, x5, yHeader2, plugw, shh, 0, 0, null);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x3, this.ivUnten, x3, yBody);
            g.drawLine(x4, this.ivUnten, x4, yBody);
            g.drawLine(x5, this.ivUnten, x5, yBody);
            int ly = yBody;
            while (ly <= this.ivUnten) {
                g.drawLine(this.ivLinks, ly, this.ivRechts, ly);
                ly += 14;
            }
            DZNEMatingPrinter.drawRect(g, this.ivLinks, yHeader1, x4, yHeader2, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x4, yHeader1, this.ivRechts, yHeader2, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, yHeader1, x4, this.ivUnten, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x4, yHeader1, this.ivRechts, this.ivUnten, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, this.ivLinks, yHeader2, x3, yBody, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x3, yHeader2, x4, yBody, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x4, yHeader2, x5, yBody, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x5, yHeader2, this.ivRechts, yBody, DZNEMatingPrinter.mm(0.8));
        } else {
            datw = 51;
            int nbw1 = (totwidth - datw - 96) / 2;
            int nbw2 = totwidth - datw - 96 - nbw1;
            int x3 = this.ivLinks + datw;
            x5 = x3 + nbw1 + nbw2;
            int x5a = x5 + 48;
            int x6 = this.ivRechts;
            int yStartWurfZeilen = yStartWurfTabelleHeader + 28;
            int y8 = yStartWurfTabelleHeader + 14;
            LabelMaker.make(g, "DOB", FontManagerUS.SSB10, this.ivLinks, yStartWurfTabelleHeader, datw, yStartWurfZeilen - yStartWurfTabelleHeader, 0, 0, null);
            LabelMaker.make(g, "Born /", FontManagerUS.SSB10, x3, yStartWurfTabelleHeader, nbw1 + nbw2, y8 - yStartWurfTabelleHeader, 0, 0, null);
            LabelMaker.make(g, "Alive", FontManagerUS.SSB10, x3, y8, nbw1 + nbw2, yStartWurfZeilen - y8, 0, 0, null);
            if (this.ivShowParents) {
                String parentsString = "Parents";
                LabelMaker.make(g, parentsString, FontManagerUS.SSB10, x5, yStartWurfTabelleHeader, 96, y8 - yStartWurfTabelleHeader, 0, 0, null);
            }
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB10, x5, y8, 48, yStartWurfZeilen - y8, 0, 0, null);
            LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB10, x5a, y8, 48, yStartWurfZeilen - y8, 0, 0, null);
            int y = yStartWurfZeilen;
            int i3 = 0;
            while (i3 < wuerfe.size()) {
                Wurf wurf = (Wurf)wuerfe.elementAt(i3);
                LabelMaker.makeWithDate(g, wurf.ivDay, FontManagerUS.SSP10, this.ivLinks, y, x3 - this.ivLinks, 14, 0, 0, null);
                if (wurf.ivNumbersDeadAliveOK) {
                    LabelMaker.make(g, String.valueOf(wurf.ivNumBornTotal) + "/" + wurf.ivNumNotKilled, FontManagerUS.SSP10, x3, y, x5 - x3, 14, 0, 0, null);
                } else {
                    LabelMaker.make(g, String.valueOf(wurf.ivNumBornTotal) + "/?", FontManagerUS.SSP10, x3, y, x5 - x3, 14, 0, 0, null);
                }
                if (this.ivShowParents) {
                    Color back = null;
                    if (males.size() > 0 && wurf.ivFatherID == ((Mouse)males.elementAt(0)).getLong("IDO_ID")) {
                        back = Wurf.FATHER_COLORS[0];
                    } else if (males.size() > 1 && wurf.ivFatherID == ((Mouse)males.elementAt(1)).getLong("IDO_ID")) {
                        back = Wurf.FATHER_COLORS[1];
                    }
                    LabelMaker.make(g, DZNEMatingPrinter.getJustEartag(wurf.ivFatherID, c.getGroup()), FontManagerUS.SSP10, x5, y, x5a - x5, 14, 0, 0, back);
                    back = null;
                    if (females.size() > 0 && wurf.ivMotherID == ((Mouse)females.elementAt(0)).getLong("IDO_ID")) {
                        back = Wurf.MOTHER_COLORS[0];
                    } else if (females.size() > 1 && wurf.ivMotherID == ((Mouse)females.elementAt(1)).getLong("IDO_ID")) {
                        back = Wurf.MOTHER_COLORS[1];
                    }
                    LabelMaker.make(g, DZNEMatingPrinter.getJustEartag(wurf.ivMotherID, c.getGroup()), FontManagerUS.SSP10, x5a, y, x6 - x5a, 14, 0, 0, back);
                } else {
                    LabelMaker.make(g, wurf.ivNumMaleBorn, FontManagerUS.SSP10, x5, y, x5a - x5, 14, 0, 0, null);
                    LabelMaker.make(g, wurf.ivNumFemaleBorn, FontManagerUS.SSP10, x5a, y, x6 - x5a, 14, 0, 0, null);
                }
                y += 14;
                ++i3;
            }
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x3, this.ivUnten, x3, yStartWurfZeilen);
            g.drawLine(x5, this.ivUnten, x5, yStartWurfZeilen);
            g.drawLine(x5a, this.ivUnten, x5a, yStartWurfZeilen);
            g.drawLine(x6, this.ivUnten, x6, yStartWurfZeilen);
            int ly = yStartWurfZeilen;
            while (ly <= this.ivUnten) {
                g.drawLine(this.ivLinks, ly, this.ivRechts, ly);
                ly += 14;
            }
            DZNEMatingPrinter.drawRect(g, this.ivLinks, yStartWurfTabelleHeader, x3, yStartWurfZeilen, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x3, yStartWurfTabelleHeader, x5, yStartWurfZeilen, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x5, yStartWurfTabelleHeader, x6, yStartWurfZeilen, DZNEMatingPrinter.mm(0.8));
            DZNEMatingPrinter.drawRect(g, x6, yStartWurfTabelleHeader, this.ivRechts, yStartWurfZeilen, DZNEMatingPrinter.mm(0.8));
        }
        DZNEMatingPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DZNEMatingPrinter.mm(0.8));
    }

    private static void drawRect(Graphics2D g, int ulx, int uly, int lrx, int lry, float width) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(width));
        g.drawRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private static void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        if (col instanceof MusterColor) {
            MusterColor mc = (MusterColor)col;
            mc.fill(ulx, uly, lrx - ulx, lry - uly, g);
        } else {
            g.fillRect(ulx, uly, lrx - ulx, lry - uly);
        }
    }

    private void printStockCage(Graphics2D g, Cage c) {
        int orLineHeight = DZNEMatingPrinter.mm(3.5);
        int platzFuerLines = 0;
        TextWrapComponent twc = null;
        String typs = AllgUtils.getTypeString(c, c.getActualMice(), 0, true);
        if (typs.trim().length() != 0) {
            twc = new TextWrapComponent(typs, FontManagerUS.SSB10);
            twc.setSize(this.ivRechts - this.ivLinks - 2 * MIN_RAND, 100);
            twc.generateElements();
            platzFuerLines = twc.getAnzElements() * orLineHeight + 2 * MIN_RAND;
        }
        int yObenNormal = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        int you = yObenNormal + platzFuerLines;
        DZNEMatingPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        DZNEMatingPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, DZNEMatingPrinter.mm(0.8));
        int orXStart = this.ivLinks + MIN_RAND;
        int cfw = CAGE_NUMBER_FIELD_WIDTH;
        if (this.ivWithS2) {
            LabelMaker.make(g, "S2", FontManagerUS.SSB16, orXStart, this.ivOben + MIN_RAND, S2_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, DZNEMatingPrinter.mm(0.8), 0, Color.white, Color.red);
            orXStart += S2_NUMBER_FIELD_WIDTH + MIKRO_RAND;
            cfw -= S2_NUMBER_FIELD_WIDTH / 2;
        }
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, orXStart, this.ivOben + MIN_RAND, cfw, CAGE_NUMBER_FIELD_HEIGHT, DZNEMatingPrinter.mm(0.8), 0, Color.white);
        int orBreite = (int)(this.ivWidth - 11.338582677165356) - (orXStart += cfw + MIN_RAND);
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB10, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + DZNEMatingPrinter.mm(0.2);
        int anzLineHeight = DZNEMatingPrinter.mm(4.2);
        String css = String.valueOf(c.getNumberOfMice()) + " M / " + c.getOwnerStringOnlySingleEmailPreferred();
        if (css != null && css.length() != 0) {
            LabelMaker.makeMitRandDrumrum(g, css, FontManagerUS.SSB14, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += anzLineHeight + DZNEMatingPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        ay = yObenNormal;
        if (twc != null) {
            Enumeration en = twc.getElements();
            while (en.hasMoreElements()) {
                TextWrapElement twe = (TextWrapElement)en.nextElement();
                LabelMaker.makeMitRandDrumrum(g, twe.ivText, FontManagerUS.SSB10, this.ivLinks + MIN_RAND, ay + 1, this.ivRechts - this.ivLinks - 2 * MIN_RAND, orLineHeight, 0, 0, null);
                ay += orLineHeight;
            }
        }
        int akty = you;
        if (this.ivBackCross) {
            int bzLabelHeight = DZNEMatingPrinter.mm(5.0);
            int shh = 14;
            LabelMaker.make(g, "BACKCROSSING", FontManagerUS.SSB10, this.ivLinks, akty, this.ivRechts - this.ivLinks, shh, 0, 0, null);
            DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + bzLabelHeight, DZNEMatingPrinter.mm(1.0));
            akty += bzLabelHeight;
        }
        int hlh = DZNEMatingPrinter.mm(6.0);
        int signWidth = DZNEMatingPrinter.mm(4.0);
        int datw = 51;
        int totwidth = this.ivRechts - this.ivLinks;
        int gtWidth = totwidth - signWidth - datw - 48;
        int pos1 = this.ivLinks;
        int pos2 = pos1 + signWidth;
        int pos3 = pos2 + 48;
        int pos4 = pos3 + datw;
        LabelMaker.make(g, "", FontManagerUS.SSB11, pos1, akty, signWidth, hlh, 0, 0, null);
        LabelMaker.make(g, "ID", FontManagerUS.SSB11, pos2, akty, 48, hlh, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB11, pos3, akty, datw, hlh, 0, 0, null);
        LabelMaker.make(g, "Genotype", FontManagerUS.SSB11, pos4, akty, gtWidth, hlh, 0, 0, null);
        DZNEMatingPrinter.drawRect(g, this.ivLinks, akty, pos1, akty + hlh, DZNEMatingPrinter.mm(0.8));
        DZNEMatingPrinter.drawRect(g, pos1, akty, pos2, akty + hlh, DZNEMatingPrinter.mm(0.8));
        DZNEMatingPrinter.drawRect(g, pos2, akty, pos3, akty + hlh, DZNEMatingPrinter.mm(0.8));
        DZNEMatingPrinter.drawRect(g, pos3, akty, pos4, akty + hlh, DZNEMatingPrinter.mm(0.8));
        DZNEMatingPrinter.drawRect(g, pos4, akty, this.ivRechts, akty + hlh, DZNEMatingPrinter.mm(0.8));
        int lineHeight = 14;
        int yVorMaeusen = akty += hlh;
        int yd = akty;
        Vector v = c.getActualMice();
        Collections.sort(v, AllgUtils.MOUSE_ET_SORTER);
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            String ets = mausi.getCLLWEartagString("?", true, true);
            Date bds = DZNEMatingPrinter.getBirthday(mausi);
            int sex = mausi.getSex();
            if (sex == 1) {
                LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSP10, pos1, yd, signWidth, lineHeight, 0, 0, null);
            } else if (sex == 2) {
                LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSP10, pos1, yd, signWidth, lineHeight, 0, 0, null);
            }
            LabelMaker.make(g, ets, FontManagerUS.SSP10, pos2, yd, 48, lineHeight, 0, 0, null);
            LabelMaker.makeWithDate(g, bds, FontManagerUS.SSP10, pos3, yd, datw, lineHeight, 0, 0, null);
            LabelMaker.make(g, gts, FontManagerUS.SSP10, pos4, yd, gtWidth, lineHeight, 0, 2, null);
            yd += lineHeight;
            ++i;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(this.ivLinks, yd, this.ivRechts, yd);
        g.drawLine(pos1, yd, pos1, yVorMaeusen);
        g.drawLine(pos2, yd, pos2, yVorMaeusen);
        g.drawLine(pos3, yd, pos3, yVorMaeusen);
        g.drawLine(pos4, yd, pos4, yVorMaeusen);
        DZNEMatingPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, DZNEMatingPrinter.mm(0.8));
    }

    private static String getGenotype(Mouse mausi) {
        if (mausi != null) {
            return mausi.getGenotype();
        }
        return "";
    }

    private static String getEartag(Mouse mausi) {
        if (mausi != null) {
            return mausi.getCLLWEartagString("?", true, true);
        }
        return "";
    }

    private static String getJustEartag(long mausid, String group) {
        int et;
        Mouse mausi;
        if (mausid != 0L && (mausi = MouseManager.getMouse(mausid, group)) != null && (et = mausi.getInt("MOS_EARTAG", -1)) > 0) {
            return Integer.toString(et);
        }
        return "";
    }

    private static Date getBirthday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_BIRTHDAY");
        }
        return null;
    }

    private static Date getPlugday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_PLUGDATE");
        }
        return null;
    }

    private static Date getInDate(Mouse mausi, Cage cagi) {
        Visit vis;
        Visit[] varr;
        if (mausi != null && cagi != null && (varr = (Visit[])mausi.get("MOS_VISIT")) != null && (vis = Visit.findLatestUnfinishedVisit(varr, mausi.getLong("IDO_ID"), cagi.getLong("IDO_ID"))) != null) {
            return vis.ivStartDate;
        }
        return null;
    }

    private static void makeFill(Cage c, Graphics2D g, int links, int oben, int rechts, int unten) {
        Color[] ccol = c.getColor(0);
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR && !(ccol[0] instanceof MusterColor)) {
                DZNEMatingPrinter.fillRect(g, links, oben, rechts, unten, ccol[0]);
            } else {
                Graphics2D g2d = g;
                g2d.setPaint(CageDisplayManager.getTexture(links, 0, ccol, rechts - links, true));
                DZNEMatingPrinter.fillRect(g, links, oben, rechts, unten, null);
            }
        }
    }
}

