/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;

public class KoelnPrinter
extends LabelPrinter {
    protected static final String XML = "\t<LabelPrinter name=\"Koeln\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"LicenseWithOwners\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    protected boolean ivExtraMating = false;
    protected boolean ivDidoModus = false;

    public static KoelnPrinter createPrinter(boolean matingExtra) {
        KoelnPrinter kp = new KoelnPrinter(XMLParser.parseXMLString(XML));
        if (matingExtra) {
            kp.ivName = "Koeln Mating Extra";
            kp.ivExtraMating = true;
        }
        return kp;
    }

    public KoelnPrinter(XMLNode xn) {
        super(xn);
    }

    public KoelnPrinter() {
    }

    public LabelPrinter getClone() {
        KoelnPrinter clone = new KoelnPrinter();
        this.copyValues(clone);
        clone.ivExtraMating = this.ivExtraMating;
        clone.ivDidoModus = this.ivDidoModus;
        return clone;
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage() || this.ivExtraMating) {
            return this.handleMatingCage(c);
        }
        return super.handleCage(c);
    }

    public Vector handleMatingCage(Cage c) {
        return this.handleMatingCage(c, null);
    }

    public Vector handleMatingCage(Cage c, int[] yNachParents) {
        Vector page = new Vector(100);
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, this.ivExtraMating, 1, 2, null, false, false, false, false, true, true, true, this.ivDidoModus, false, false);
        return this.handleMatingCage(c, yNachParents, page, males, females, wuerfe);
    }

    public Vector handleMatingCage(Cage c, int[] yNachParents, Vector page, Vector males, Vector females, Vector wuerfe) {
        Mouse mouse;
        if (wuerfe == null) {
            return super.handleCage(c);
        }
        int anzAdults = 0;
        Iterator iter = males.iterator();
        while (iter.hasNext()) {
            mouse = (Mouse)iter.next();
            if (!c.isMouseInside(mouse.getLong("IDO_ID"))) continue;
            ++anzAdults;
        }
        iter = females.iterator();
        while (iter.hasNext()) {
            mouse = (Mouse)iter.next();
            if (!c.isMouseInside(mouse.getLong("IDO_ID"))) continue;
            ++anzAdults;
        }
        String mouseCount = "(" + anzAdults + " adults)";
        if (anzAdults == 1) {
            mouseCount = "(" + anzAdults + " adult)";
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            String ltyp = ll.getType();
            if (!(ltyp.equalsIgnoreCase("Line") || ltyp.equalsIgnoreCase("Strain") || ltyp.equalsIgnoreCase("Comment"))) {
                ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this);
            }
            ++i;
        }
        ay = this.showParentMice(males, ax, ay, Wurf.FATHER_COLORS, DefaultManager.getMale(), page, c);
        ay += 3;
        ay = this.showParentMice(females, ax, ay, Wurf.MOTHER_COLORS, DefaultManager.getFemale(), page, c);
        if (yNachParents != null) {
            yNachParents[0] = ay + 3;
        }
        ay += 5;
        ay = this.showWuerfe(wuerfe, ax, ay, page, males, females, IDObject.combineIDObjectCollections(new Vector[]{males, females}));
        return page;
    }

    private int showParentMice(Vector mice, int ax, int ay, Color[] colarr, String sign, Vector page, Cage c) {
        Font f = FontManagerUS.SSB10;
        int i = 0;
        while (i < mice.size()) {
            PrintElement tpe;
            int tx = ax;
            Mouse mouse = (Mouse)mice.elementAt(i);
            if (!c.isMouseInside(mouse.getID())) {
                page.addElement(PrintElement.getFilledTextBox(ax, ay, (int)(this.ivWidth - this.ivRight), 12, "", f, Color.lightGray));
            }
            page.addElement(PrintElement.getTextElement(tx, ay, sign, f));
            tx += 14;
            if (i < colarr.length) {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, mouse.getCLLWEartagString("?", true, true), f, colarr[i]);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            } else {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, mouse.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 35;
            int nbr = 50;
            Date inDate = Cage.getInDate(mouse, c);
            if (inDate != null) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, nbr, 12, "I " + LabelMaker.getVeryShortDateString(inDate), f, null));
            } else {
                Date outDate = Cage.getLastOutDate(mouse, c);
                if (outDate != null) {
                    page.addElement(PrintElement.getFilledTextBox(tx, ay, nbr, 12, "OUT " + LabelMaker.getVeryShortDateString(outDate), f, null));
                } else {
                    page.addElement(PrintElement.getFilledTextBox(tx, ay, nbr, 12, "NEVER", f, null));
                }
            }
            tx += nbr;
            page.addElement(PrintElement.getFilledTextBox(tx += nbr, ay, 700, 12, mouse.getCLLWLineString(), f, null));
            ay += 11;
            ++i;
        }
        return ay;
    }

    private int showWuerfe(Vector wuerfe, int ax, int ay, Vector page, Vector males, Vector females, HashMap parents) {
        int origay = ay;
        Font f = FontManagerUS.SSB09;
        int i = wuerfe.size() - 1;
        while (i >= 0) {
            Wurf w = (Wurf)wuerfe.elementAt(i);
            int tx = ax;
            if (w.areAllLeft()) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, 8, 12, "*", f, null));
            }
            page.addElement(PrintElement.getFilledTextBox(tx += 8, ay, 38, 12, LabelMaker.getVeryShortDateString(w.ivDay), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 50, ay, 22, 12, w.getMaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, w.getFemaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, "T " + w.ivNumBornTotal, f, null));
            tx += 22;
            tx += 2;
            Mouse father = (Mouse)parents.get(new Long(w.ivFatherID));
            if (father != null) {
                int pos = males.indexOf(father);
                PrintElement tpe = null;
                tpe = pos < Wurf.FATHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, Wurf.FATHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            Mouse mother = (Mouse)parents.get(new Long(w.ivMotherID));
            if (mother != null) {
                int pos = females.indexOf(mother);
                PrintElement tpe = null;
                tpe = pos < Wurf.MOTHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, Wurf.MOTHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            if ((ay += 10) > 205) {
                ay = origay;
                ax += 180;
            }
            --i;
        }
        return ay;
    }
}

