/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.visit.Visit;

public class KoelnSPFPrinter
extends LabelPrinter {
    private static final int EARTAG_WIDTH = 39;
    private static final int LINE_HEIGHT = 14;
    private static final int CAGE_NUMBER_FIELD_WIDTH = KoelnSPFPrinter.mm(23.0);
    private static final int CAGE_NUMBER_FIELD_HEIGHT = KoelnSPFPrinter.mm(10.0);
    private static final int MIN_RAND = KoelnSPFPrinter.mm(2.0);
    private static final double RAND = 4.0;
    private int ivLinks = 0;
    private int ivRechts = 0;
    private int ivOben = 0;
    private int ivUnten = 0;

    public KoelnSPFPrinter() {
        super("K\u00f6ln SPF", 212.59842519685043, 368.5039370078741);
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivLinks = 11;
        this.ivRechts = (int)(this.ivWidth - 11.338582677165356);
        this.ivOben = 11;
        this.ivUnten = (int)(this.ivHeight - 11.338582677165356);
    }

    public LabelPrinter getClone() {
        KoelnSPFPrinter clone = new KoelnSPFPrinter();
        this.copyValues(clone);
        return clone;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        if (cage.isMatingCage()) {
            this.printMatingCage((Graphics2D)graphics, cage);
        } else {
            this.printStockCage((Graphics2D)graphics, cage);
        }
    }

    private void printMatingCage(Graphics2D g, Cage c) {
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 1, 2, null, false, false, false, true, true, false, true, false, false, false);
        if (wuerfe == null) {
            this.printStockCage(g, c);
            return;
        }
        int you = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        KoelnSPFPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        KoelnSPFPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, KoelnSPFPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, this.ivLinks + MIN_RAND, this.ivOben + MIN_RAND, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, KoelnSPFPrinter.mm(0.8), 0, Color.white);
        int orXStart = this.ivLinks + MIN_RAND + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND;
        int orBreite = (int)(this.ivWidth - 11.338582677165356) - orXStart;
        int orLineHeight = KoelnSPFPrinter.mm(3.5);
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB10, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + KoelnSPFPrinter.mm(0.2);
        String ownerName = c.getLabelOwnerString(false);
        if (ownerName != null) {
            LabelMaker.makeMitRandDrumrum(g, ownerName, FontManagerUS.SSB10, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + KoelnSPFPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        int akty = you;
        int signWith = 39;
        int restWidth = this.ivRechts - this.ivLinks - signWith;
        int restStart = this.ivLinks + 39;
        Mouse father = null;
        if (males.size() == 1) {
            father = (Mouse)males.elementAt(0);
            LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB14, this.ivLinks, akty, 39, 28, 0, 0, null);
            LabelMaker.make(g, KoelnSPFPrinter.getEartag(father), FontManagerUS.SSB10, this.ivLinks, akty + 28, 39, 14, 0, 0, Wurf.FATHER_COLORS[0]);
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 39, akty + 28, KoelnSPFPrinter.mm(0.1));
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 39, akty + 42, KoelnSPFPrinter.mm(0.1));
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, KoelnSPFPrinter.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + KoelnSPFPrinter.getGenotype(father) + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, "DoB: " + LabelMaker.getVeryShortDateString(KoelnSPFPrinter.getBirthday(father)), FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, "Din: " + LabelMaker.getVeryShortDateString(KoelnSPFPrinter.getInDate(father, c)), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            KoelnSPFPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, " " + father.getCLLWLineString() + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth, 14, 0, 2, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            akty += 42;
        }
        int i = 0;
        while (i < females.size()) {
            Mouse mother = (Mouse)females.elementAt(i);
            LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB14, this.ivLinks, akty, 39, 28, 0, 0, null);
            LabelMaker.make(g, KoelnSPFPrinter.getEartag(mother), FontManagerUS.SSB10, this.ivLinks, akty + 28, 39, 14, 0, 0, Wurf.MOTHER_COLORS[i % Wurf.MOTHER_COLORS.length]);
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 39, akty + 28, KoelnSPFPrinter.mm(0.1));
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivLinks + 39, akty + 42, KoelnSPFPrinter.mm(0.1));
            KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, this.ivRechts, akty + 42, KoelnSPFPrinter.mm(0.8));
            int iay = akty;
            LabelMaker.make(g, " " + KoelnSPFPrinter.getGenotype(mother) + " ", FontManagerUS.SSB10, restStart, iay, restWidth, 14, 0, 2, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, "DoB: " + LabelMaker.getVeryShortDateString(KoelnSPFPrinter.getBirthday(mother)), FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 0, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, "Din: " + LabelMaker.getVeryShortDateString(KoelnSPFPrinter.getInDate(mother, c)), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            KoelnSPFPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            LabelMaker.make(g, " " + mother.getCLLWLineString() + " ", FontManagerUS.SSB10, restStart, iay += 14, restWidth / 2, 14, 0, 2, null);
            KoelnSPFPrinter.drawRect(g, restStart, iay, restStart + restWidth / 2, iay + 14, KoelnSPFPrinter.mm(0.1));
            Date pd = KoelnSPFPrinter.getPlugday(mother);
            if (pd != null) {
                LabelMaker.make(g, "PD: " + LabelMaker.getVeryShortDateString(pd), FontManagerUS.SSB10, restStart + restWidth / 2, iay, restWidth - restWidth / 2, 14, 0, 0, null);
            }
            KoelnSPFPrinter.drawRect(g, restStart + restWidth / 2, iay, restStart + restWidth, iay + 14, KoelnSPFPrinter.mm(0.1));
            akty += 42;
            ++i;
        }
        int y5 = akty;
        int y6 = y5 + 28;
        int y8 = y5 + 14;
        int datw = 51;
        int totwidth = this.ivRechts - this.ivLinks;
        int nbw1 = (totwidth - datw - 78) / 2;
        int nbw2 = totwidth - datw - 78 - nbw1;
        int x3 = this.ivLinks + datw;
        int x4 = x3 + nbw1;
        int x5 = x4 + nbw2;
        int x5a = x5 + 39;
        int x6 = this.ivRechts;
        LabelMaker.make(g, "DOB", FontManagerUS.SSB10, this.ivLinks, y5, datw, y6 - y5, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB10, x3, y5, nbw1 + nbw2, y8 - y5, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB10, x3, y8, nbw1, y6 - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB10, x4, y8, nbw2, y6 - y8, 0, 0, null);
        LabelMaker.make(g, "Parents", FontManagerUS.SSB10, x5, y5, 78, y8 - y5, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSB10, x5, y8, 39, y6 - y8, 0, 0, null);
        LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSB10, x5a, y8, 39, y6 - y8, 0, 0, null);
        int y = y6;
        int i2 = 0;
        while (i2 < wuerfe.size()) {
            Wurf wurf = (Wurf)wuerfe.elementAt(i2);
            LabelMaker.makeWithDate(g, wurf.ivDay, FontManagerUS.SSP10, this.ivLinks, y, x3 - this.ivLinks, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumMaleBorn, FontManagerUS.SSP10, x3, y, x4 - x3, 14, 0, 0, null);
            LabelMaker.make(g, wurf.ivNumFemaleBorn, FontManagerUS.SSP10, x4, y, x5 - x4, 14, 0, 0, null);
            Color back = null;
            if (father != null && wurf.ivFatherID == father.getID()) {
                back = Wurf.FATHER_COLORS[0];
            }
            LabelMaker.make(g, KoelnSPFPrinter.getJustEartag(wurf.ivFatherID, c.getGroup()), FontManagerUS.SSP10, x5, y, x5a - x5, 14, 0, 0, back);
            back = null;
            if (females.size() > 0 && wurf.ivMotherID == ((Mouse)females.elementAt(0)).getID()) {
                back = Wurf.MOTHER_COLORS[0];
            } else if (females.size() > 1 && wurf.ivMotherID == ((Mouse)females.elementAt(1)).getID()) {
                back = Wurf.MOTHER_COLORS[1];
            }
            LabelMaker.make(g, KoelnSPFPrinter.getJustEartag(wurf.ivMotherID, c.getGroup()), FontManagerUS.SSP10, x5a, y, x6 - x5a, 14, 0, 0, back);
            y += 14;
            ++i2;
        }
        if (y != y6) {
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x3, y, x3, y6);
            g.drawLine(x4, y, x4, y6);
            g.drawLine(x5, y, x5, y6);
            g.drawLine(x5a, y, x5a, y6);
            g.drawLine(x6, y, x6, y6);
            int ly = y6;
            while (ly <= y) {
                g.drawLine(this.ivLinks, ly, this.ivRechts, ly);
                ly += 14;
            }
        }
        KoelnSPFPrinter.drawRect(g, this.ivLinks, y5, x3, y6, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, x3, y5, x5, y6, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, x5, y5, x6, y6, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, x6, y5, this.ivRechts, y6, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, KoelnSPFPrinter.mm(0.8));
    }

    private static void drawRect(Graphics2D g, int ulx, int uly, int lrx, int lry, float width) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(width));
        g.drawRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private static void fillRect(Graphics2D g, int ulx, int uly, int lrx, int lry, Color col) {
        g.setColor(col);
        g.fillRect(ulx, uly, lrx - ulx, lry - uly);
    }

    private void printStockCage(Graphics2D g, Cage c) {
        int you = this.ivLinks + CAGE_NUMBER_FIELD_HEIGHT + 2 * MIN_RAND;
        KoelnSPFPrinter.makeFill(c, g, this.ivLinks, this.ivOben, this.ivRechts, you);
        KoelnSPFPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, you, KoelnSPFPrinter.mm(0.8));
        LabelMaker.make(g, c.getNumberString(), FontManagerUS.SSB16, this.ivLinks + MIN_RAND, this.ivOben + MIN_RAND, CAGE_NUMBER_FIELD_WIDTH, CAGE_NUMBER_FIELD_HEIGHT, KoelnSPFPrinter.mm(0.8), 0, Color.white);
        int orXStart = this.ivLinks + MIN_RAND + CAGE_NUMBER_FIELD_WIDTH + MIN_RAND;
        int orBreite = (int)(this.ivWidth - 11.338582677165356) - orXStart;
        int orLineHeight = KoelnSPFPrinter.mm(3.5);
        int ay = this.ivOben + MIN_RAND;
        String permission = c.getLicenseString("permiss.: ");
        if (permission != null) {
            LabelMaker.makeMitRandDrumrum(g, permission, FontManagerUS.SSB10, orXStart, ay - 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + KoelnSPFPrinter.mm(0.2);
        String ownerName = c.getLabelOwnerString(false);
        if (ownerName != null) {
            LabelMaker.makeMitRandDrumrum(g, ownerName, FontManagerUS.SSB10, orXStart, ay, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight + KoelnSPFPrinter.mm(0.2);
        String rackname = c.getRackName();
        if (rackname != null) {
            LabelMaker.makeMitRandDrumrum(g, rackname, FontManagerUS.SSB10, orXStart, ay + 1, orBreite, orLineHeight, 0, 0, null);
        }
        ay += orLineHeight;
        int akty = you;
        int hlh = KoelnSPFPrinter.mm(6.0);
        int signWidth = KoelnSPFPrinter.mm(6.0);
        int datw = 51;
        int totwidth = this.ivRechts - this.ivLinks;
        int gtWidth = totwidth - signWidth - datw - 39;
        int pos1 = this.ivLinks;
        int pos2 = pos1 + signWidth;
        int pos3 = pos2 + 39;
        int pos4 = pos3 + datw;
        LabelMaker.make(g, "", FontManagerUS.SSB11, pos1, akty, signWidth, hlh, 0, 0, null);
        LabelMaker.make(g, "ID", FontManagerUS.SSB11, pos2, akty, 39, hlh, 0, 0, null);
        LabelMaker.make(g, "Born", FontManagerUS.SSB11, pos3, akty, datw, hlh, 0, 0, null);
        LabelMaker.make(g, "Genotype", FontManagerUS.SSB11, pos4, akty, gtWidth, hlh, 0, 0, null);
        KoelnSPFPrinter.drawRect(g, this.ivLinks, akty, pos1, akty + hlh, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, pos1, akty, pos2, akty + hlh, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, pos2, akty, pos3, akty + hlh, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, pos3, akty, pos4, akty + hlh, KoelnSPFPrinter.mm(0.8));
        KoelnSPFPrinter.drawRect(g, pos4, akty, this.ivRechts, akty + hlh, KoelnSPFPrinter.mm(0.8));
        int yVorMaeusen = akty += hlh;
        int yd = akty;
        Vector v = c.getActualMice();
        Collections.sort(v, AllgUtils.MOUSE_ET_SORTER);
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            String gts = mausi.getGenotype();
            gts = gts != null && !gts.equals("?") ? " " + gts + " " : "";
            String ets = mausi.getCLLWEartagString("?", true, true);
            Date bds = KoelnSPFPrinter.getBirthday(mausi);
            int sex = mausi.getSex();
            if (sex == 1) {
                LabelMaker.make(g, DefaultManager.getMale(), FontManagerUS.SSP10, pos1, yd, signWidth, 14, 0, 0, null);
            } else if (sex == 2) {
                LabelMaker.make(g, DefaultManager.getFemale(), FontManagerUS.SSP10, pos1, yd, signWidth, 14, 0, 0, null);
            }
            LabelMaker.make(g, ets, FontManagerUS.SSP10, pos2, yd, 39, 14, 0, 0, null);
            LabelMaker.makeWithDate(g, bds, FontManagerUS.SSP10, pos3, yd, datw, 14, 0, 0, null);
            LabelMaker.make(g, gts, FontManagerUS.SSP10, pos4, yd, gtWidth, 14, 0, 2, null);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(this.ivLinks, yd += 14, this.ivRechts, yd);
            ++i;
        }
        g.drawLine(pos1, yd, pos1, yVorMaeusen);
        g.drawLine(pos2, yd, pos2, yVorMaeusen);
        g.drawLine(pos3, yd, pos3, yVorMaeusen);
        g.drawLine(pos4, yd, pos4, yVorMaeusen);
        KoelnSPFPrinter.drawRect(g, this.ivLinks, this.ivOben, this.ivRechts, this.ivUnten, KoelnSPFPrinter.mm(0.8));
    }

    private static String getGenotype(Mouse mausi) {
        if (mausi != null) {
            return mausi.getGenotype();
        }
        return "";
    }

    private static String getEartag(Mouse mausi) {
        if (mausi != null) {
            return mausi.getCLLWEartagString("?", true, true);
        }
        return "";
    }

    private static String getJustEartag(long mausid, String group) {
        int et;
        Mouse mausi;
        if (mausid != 0L && (mausi = MouseManager.getMouse(mausid, group)) != null && (et = mausi.getInt("MOS_EARTAG", -1)) > 0) {
            return Integer.toString(et);
        }
        return "";
    }

    private static Date getBirthday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_BIRTHDAY");
        }
        return null;
    }

    private static Date getPlugday(Mouse mausi) {
        if (mausi != null) {
            return mausi.getDate("MOS_PLUGDATE");
        }
        return null;
    }

    private static Date getInDate(Mouse mausi, Cage cagi) {
        Visit vis;
        Visit[] varr;
        if (mausi != null && cagi != null && (varr = (Visit[])mausi.get("MOS_VISIT")) != null && (vis = Visit.findLatestUnfinishedVisit(varr, mausi.getID(), cagi.getID())) != null) {
            return vis.ivStartDate;
        }
        return null;
    }

    private static void makeFill(Cage c, Graphics2D g, int links, int oben, int rechts, int unten) {
        Color[] ccol = c.getColor(0);
        if (ccol != null && ccol.length != 0) {
            if (ccol.length == 1 && ccol[0] != CageColorManager.NULL_COLOR && !(ccol[0] instanceof MusterColor)) {
                KoelnSPFPrinter.fillRect(g, links, oben, rechts, unten, ccol[0]);
            } else {
                Graphics2D g2d = g;
                g2d.setPaint(CageDisplayManager.getTexture(links, 0, ccol, rechts - links, true));
                KoelnSPFPrinter.fillRect(g, links, oben, rechts, unten, null);
            }
        }
    }
}

