/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManagerUS;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.CoatColor;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PageFormatGenerator;
import mausoleum.printing.labelprinters.LIMESPrintBrotherQL570;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class LIMESPrinter
extends LabelPrinter {
    private static final int BREIT = 100;
    private static final int HOCH = 62;
    private static final double RAND = 8.503937007874017;
    private static final int I_BREIT = 266;
    private static final int I_HOCH = 158;
    private static final int LINE_HEIGHT = 14;
    private static final int LINE_HEIGHT_OBEN = 12;
    private static final int LINE_HEIGHT_TAB = 10;
    private static final int LINE_HEIGHT_SM = 9;
    private static final int LINKS = LIMESPrinter.mm(20.0);
    private static final int RECHTS = LIMESPrinter.mm(30.0);
    private static final int MITTE_BR = 266 - LINKS - RECHTS;
    private static final int OBEN = 36;
    private static final int COLW_STOCK_SEX = LIMESPrinter.mm(8.0);
    private static final int COLW_STOCK_ID = LIMESPrinter.mm(12.0);
    private static final int COLW_STOCK_EARTAG = LIMESPrinter.mm(18.0);
    private static final int COLW_STOCK_GEBTAG = LIMESPrinter.mm(15.0);
    private static final int COLW_STOCK_FARBE = LIMESPrinter.mm(18.0);
    private static final int COLW_STOCK_GENOTYP = 266 - COLW_STOCK_SEX - COLW_STOCK_ID - COLW_STOCK_EARTAG - COLW_STOCK_GEBTAG - COLW_STOCK_FARBE;
    private static final int COLW_MATING_GEBTAG = LIMESPrinter.mm(20.0);
    private static final int COLW_MATING_ANZ_JUNGTIERE = LIMESPrinter.mm(25.0);
    private static final int COLW_MATING_ABSETZDATUM = LIMESPrinter.mm(25.0);
    private static final int COLW_MATING_BEMERKUNGEN = 266 - COLW_MATING_GEBTAG - COLW_MATING_ANZ_JUNGTIERE - COLW_MATING_ABSETZDATUM;
    private static final int COLW_MOUSE_DATUM = LIMESPrinter.mm(19.0);
    private static final int COLW_MOUSE_VP = LIMESPrinter.mm(14.0);
    private static final int COLW_MOUSE_EARTAG = LIMESPrinter.mm(22.0);
    private static final int COLW_MOUSE_LINE = LIMESPrinter.mm(25.0);
    private static final int COLW_MOUSE_GEWICHT = 266 - COLW_MOUSE_DATUM - COLW_MOUSE_VP - COLW_MOUSE_EARTAG - COLW_MOUSE_LINE;
    private static final Comparator MOUSE_BY_ID_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                Mouse m1 = (Mouse)o1;
                Mouse m2 = (Mouse)o2;
                return m1.getLongID().compareTo(m2.getLongID());
            }
            return 0;
        }
    };
    private static final Integer NO_SPECIAL_DATE = new Integer(Integer.MAX_VALUE);
    private static final Long NO_OWNER = new Long(0L);

    public static void simplePrint(Cage cage, Graphics graphics, double rand) {
        Room room;
        Graphics2D g = (Graphics2D)graphics;
        if (rand != 0.0) {
            g.translate(rand, rand);
        }
        g.setColor(Color.black);
        g.setStroke(DUENN_STROKE);
        g.drawRect(0, 0, 266, 158);
        g.setColor(Color.black);
        g.setStroke(DICK_STROKE);
        g.drawLine(LINKS, 0, LINKS, 36);
        g.drawLine(LINKS + MITTE_BR, 0, LINKS + MITTE_BR, 36);
        g.drawLine(0, 36, 266, 36);
        g.drawLine(0, 24, LINKS, 24);
        int akty = 0;
        LabelMaker.make(g, cage.getGroup(), FontManagerUS.SSB12, LINKS, akty, MITTE_BR, 14, 0, 0, null);
        akty += 12;
        User owner = null;
        boolean ueberGruppe = false;
        boolean ueberGURU = false;
        boolean multiple = false;
        HashSet userIDs = LIMESPrinter.getUserIDs(cage);
        if (!userIDs.isEmpty()) {
            if (userIDs.size() == 1) {
                if (userIDs.contains(NO_OWNER)) {
                    owner = LIMESPrinter.getFirstGuru(cage);
                    ueberGURU = true;
                } else {
                    Long uid = (Long)userIDs.iterator().next();
                    if (uid > 0L) {
                        owner = (User)ObjectStore.getObjectDeadOrAlive(6, uid, cage.getGroup(), null, false);
                    } else {
                        owner = (User)ObjectStore.getObjectDeadOrAlive(6, -uid.longValue(), cage.getGroup(), null, false);
                        ueberGruppe = true;
                    }
                }
            } else {
                Vector v;
                multiple = true;
                HashSet<Long> negative = new HashSet<Long>();
                Iterator iterator = userIDs.iterator();
                while (iterator.hasNext()) {
                    Long userID = (Long)iterator.next();
                    if (userID.equals(NO_OWNER) || userID >= 0L) continue;
                    negative.add(userID);
                }
                userIDs.remove(NO_OWNER);
                userIDs.removeAll(negative);
                if (userIDs.isEmpty()) {
                    ueberGruppe = true;
                    iterator = negative.iterator();
                    while (iterator.hasNext()) {
                        Long invID = (Long)iterator.next();
                        userIDs.add(new Long(-invID.longValue()));
                    }
                    v = ObjectStore.getObjectsDeadOrAlive(6, userIDs, cage.getGroup(), null, false);
                    Collections.sort(v, User.USER_COMP_BY_RANK_DOWN_AND_NAME_UP);
                    owner = (User)v.firstElement();
                }
                v = ObjectStore.getObjectsDeadOrAlive(6, userIDs, cage.getGroup(), null, false);
                Collections.sort(v, User.USER_COMP_BY_RANK_DOWN_AND_NAME_UP);
                owner = (User)v.firstElement();
            }
        }
        if (owner != null) {
            String prefix = multiple ? "* " : "";
            String userName = owner.getName();
            if (ueberGruppe) {
                userName = "[" + userName + "]";
            } else if (ueberGURU) {
                userName = "<" + userName + ">";
            }
            LabelMaker.make(g, String.valueOf(prefix) + userName, FontManagerUS.SSB12, LINKS, akty, MITTE_BR, 12, 0, 0, null);
            akty += 12;
            String telNr = owner.getString("USR_TELNR", null);
            if (telNr != null) {
                if (ueberGruppe) {
                    telNr = "[" + telNr + "]";
                } else if (ueberGURU) {
                    telNr = "<" + telNr + ">";
                }
                LabelMaker.make(g, String.valueOf(prefix) + telNr, FontManagerUS.SSB10, LINKS, akty, MITTE_BR, 12, 0, 0, null);
            }
        }
        LabelMaker.make(g, cage.getCageNumberWithSub(), FontManagerUS.SSB18, 0, 0, LINKS, 24, 0, 0, null);
        int[] mcarr = LIMESPrinter.getMiceCount(cage);
        LabelMaker.make(g, String.valueOf(mcarr[0]) + " / " + mcarr[1], FontManagerUS.SSB13, 0, 24, LINKS, 12, 0, 0, null);
        String rackName = cage.getRackName();
        if (rackName != null) {
            if (rackName.startsWith("[S] ")) {
                rackName = rackName.substring("[S] ".length(), rackName.length()).trim();
            }
            LabelMaker.make(g, rackName, FontManagerUS.SSB11, LINKS + MITTE_BR, 0, RECHTS, 12, 0, 0, null);
        }
        int rhalb = RECHTS / 2;
        int xm1 = LINKS + MITTE_BR + rhalb / 2;
        int xm2 = xm1 + rhalb;
        g.setStroke(DICK_STROKE);
        if (cage.isGVOCage()) {
            LabelMaker.make(g, "S1", FontManagerUS.SSB13, LINKS + MITTE_BR - 1, 10, rhalb, 24, 0, 0, null);
            g.drawArc(xm1 - 12, 12, 20, 20, 0, 360);
        }
        if ((room = cage.getRoom()) != null && room.getInt("ROM_SECURITY", 0) == 300) {
            g.drawArc(xm2 - 12, 12, 20, 20, 0, 360);
            LabelMaker.make(g, "S2", FontManagerUS.SSB13, LINKS + MITTE_BR + rhalb - 1, 10, rhalb, 24, 0, 0, null);
        }
        if (cage.isMatingCage()) {
            LIMESPrinter.printMatingCage(g, cage);
        } else {
            LIMESPrinter.printStockCage(g, cage, mcarr[0] != 0 && mcarr[1] != 0, mcarr);
        }
        if (rand != 0.0) {
            g.translate(-rand, -rand);
        }
    }

    private static User getFirstGuru(Cage cage) {
        Vector v = ObjectStore.getActualObjects(6, cage.getGroup());
        if (v != null) {
            TreeMap<String, User> tm = new TreeMap<String, User>(StringHelper.CASE_INSENSITIVE_COMPARER);
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                User tuser = (User)iterator.next();
                if (tuser.getInt("USR_MODE", 0) != 42) continue;
                tm.put(tuser.getName(), tuser);
            }
            return (User)tm.get(tm.firstKey());
        }
        return null;
    }

    private static HashSet getUserIDs(Cage cage) {
        HashSet<Long> userIDs = new HashSet<Long>();
        Vector mice = cage.getActualMice();
        if (mice != null) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                boolean hattewas = false;
                long[] uids = (long[])mouse.get("MOS_OWNER");
                if (uids != null && uids.length != 0) {
                    userIDs.add(new Long(uids[0]));
                    hattewas = true;
                } else {
                    long[] ownerGroupIDs = (long[])mouse.get("MOS_OWNERGROUPS");
                    if (ownerGroupIDs != null && ownerGroupIDs.length != 0) {
                        int i = 0;
                        while (i < ownerGroupIDs.length) {
                            IDObjectGroup iog = (IDObjectGroup)ObjectStore.getObjectDeadOrAlive(19, ownerGroupIDs[i], mouse.getGroup(), null, false);
                            if (iog != null && (uids = (long[])iog.get("IOG_IDS")) != null && uids.length != 0) {
                                userIDs.add(new Long(-uids[0]));
                                hattewas = true;
                            }
                            ++i;
                        }
                    }
                }
                if (hattewas) continue;
                userIDs.add(NO_OWNER);
            }
        }
        return userIDs;
    }

    public static void simplePrint(Mouse mouse, Graphics graphics, double rand) {
        Room room;
        Graphics2D g = (Graphics2D)graphics;
        if (rand != 0.0) {
            g.translate(rand, rand);
        }
        g.setColor(Color.black);
        g.setStroke(DUENN_STROKE);
        g.drawRect(0, 0, 266, 158);
        if (mouse.getSex() != 2) {
            LabelMaker.make(g, "Nicht verwendbar", FontManagerUS.SSB28, 0, 0, 266, 158, 0, 0, null);
            return;
        }
        g.setColor(Color.black);
        g.setStroke(DICK_STROKE);
        g.drawLine(LINKS + MITTE_BR, 0, LINKS + MITTE_BR, 36);
        g.drawLine(0, 36, 266, 36);
        int akty = 0;
        LabelMaker.make(g, mouse.getGroup(), FontManagerUS.SSB12, 0, akty, LINKS + MITTE_BR, 14, 0, 0, null);
        akty += 12;
        Vector<Mouse> mice = new Vector<Mouse>(1);
        mice.add(mouse);
        User user = Cage.getMainUser(mice, mouse.getGroup());
        if (user != null) {
            LabelMaker.make(g, user.getName(), FontManagerUS.SSB12, 0, akty, LINKS + MITTE_BR, 14, 0, 0, null);
            akty += 12;
            String telNr = user.getString("USR_TELNR", null);
            if (telNr != null) {
                LabelMaker.make(g, telNr, FontManagerUS.SSB10, 0, akty, LINKS + MITTE_BR, 14, 0, 0, null);
            }
        }
        int rhalb = RECHTS / 2;
        int xm1 = LINKS + MITTE_BR + rhalb / 2;
        int xm2 = xm1 + rhalb;
        g.setStroke(DICK_STROKE);
        if (mouse.isGVO()) {
            g.drawArc(xm1 - 14, 7, 24, 24, 0, 360);
            LabelMaker.make(g, "S1", FontManagerUS.SSB13, LINKS + MITTE_BR - 1, 5, rhalb, 28, 0, 0, null);
        }
        if ((room = mouse.getRoom()) != null && room.getInt("ROM_SECURITY", 0) == 300) {
            g.drawArc(xm2 - 12, 12, 20, 20, 0, 360);
            LabelMaker.make(g, "S2", FontManagerUS.SSB13, LINKS + MITTE_BR + rhalb - 1, 10, rhalb, 24, 0, 0, null);
        }
        int y = 36;
        y = LIMESPrinter.makeParent(mouse, "\u2640", g, y, null, -1L);
        y = LIMESPrinter.showLicenses(y, mice, g);
        int x = 0;
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MOUSE_DATUM, 14, "Datum", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MOUSE_VP, 14, "VP +/-", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MOUSE_EARTAG, 14, "\u2642 techn. ID", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MOUSE_LINE, 14, "\u2642 Line", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MOUSE_GEWICHT, 14, "Gewicht", FontManagerUS.SSP10, false, false);
        LIMESPrinter.fillHorizLines(g, y += 4);
        if (rand != 0.0) {
            g.translate(-rand, -rand);
        }
    }

    private static boolean isAdult(Mouse mouse) {
        return mouse.getAgeInDays(0) >= 16;
    }

    private static int[] getMiceCount(Cage cage) {
        int[] res = new int[2];
        Vector mice = cage.getActualMice();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            int n = LIMESPrinter.isAdult(mouse) ? 0 : 1;
            res[n] = res[n] + 1;
        }
        return res;
    }

    private static void printMatingCage(Graphics2D g, Cage c) {
        HashMap sepDatesByMaleID = new HashMap();
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 1, 2, sepDatesByMaleID, false, false, false, false, true, false, false, false, false, false);
        int y = 36;
        int i = 0;
        while (i < males.size() && y + 28 < 158) {
            y = LIMESPrinter.makeParent((Mouse)males.elementAt(i), "\u2642", g, y, null, -1L);
            ++i;
        }
        i = 0;
        while (i < females.size() && y + 28 < 158) {
            y = LIMESPrinter.makeParent((Mouse)females.elementAt(i), "\u2640", g, y, males, c.getID());
            ++i;
        }
        y = LIMESPrinter.showLicenses(y, c.getActualMice(), g);
        LIMESPrinter.showWuerfe(g, y, wuerfe, c.getGroup());
    }

    private static void printStockCage(Graphics2D g, Cage c, boolean mixedMode, int[] adultsAndKids) {
        Mouse mouse;
        int y = 36;
        Vector miceToShow = c.getActualMice();
        TreeSet<String> linesTreeset = new TreeSet<String>();
        TreeSet<String> strainsTreeset = new TreeSet<String>();
        boolean hadUndefinedLines = false;
        boolean hadUndefinedStrains = false;
        Iterator iterator = c.getActualMice().iterator();
        while (iterator.hasNext()) {
            Mouse mouse2 = (Mouse)iterator.next();
            Line line = mouse2.getLine();
            if (line == null) {
                hadUndefinedLines = true;
            } else {
                linesTreeset.add(line.getBrowseName());
            }
            Vector strains = mouse2.getStrains();
            if (strains == null || strains.isEmpty()) {
                hadUndefinedStrains = true;
                continue;
            }
            Iterator iterator2 = strains.iterator();
            while (iterator2.hasNext()) {
                Strain strain = (Strain)iterator2.next();
                strainsTreeset.add(strain.getBrowseName());
            }
        }
        y += 2;
        y = LIMESPrinter.showStrainsOrLines(y, linesTreeset, hadUndefinedLines, g, FontManagerUS.SSB09);
        y = LIMESPrinter.showStrainsOrLines(y, strainsTreeset, hadUndefinedStrains, g, FontManagerUS.SSI08);
        g.setStroke(DICK_STROKE);
        g.drawLine(0, y += 2, 266, y);
        y = LIMESPrinter.showLicenses(y, c.getActualMice(), g);
        g.setStroke(DUENN_STROKE);
        int x = 0;
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_SEX, 14, "\u2642/\u2640", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_ID, 14, "ID", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_EARTAG, 14, "Prefix-ET", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_GEBTAG, 14, "Geb.", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_FARBE, 14, "Farbe", FontManagerUS.SSP10, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_STOCK_GENOTYP, 14, "Genotyp", FontManagerUS.SSP10, false, false);
        g.drawLine(0, y += 14, 266, y);
        int max = 158;
        Vector<Mouse> reallyShowMice = new Vector<Mouse>(miceToShow.size());
        Iterator iterator2 = miceToShow.iterator();
        while (iterator2.hasNext()) {
            mouse = (Mouse)iterator2.next();
            if (!LIMESPrinter.isAdult(mouse)) continue;
            reallyShowMice.add(mouse);
        }
        Collections.sort(reallyShowMice, MOUSE_BY_ID_COMPARATOR);
        iterator2 = reallyShowMice.iterator();
        while (iterator2.hasNext() && y < max) {
            mouse = (Mouse)iterator2.next();
            x = 0;
            x = LIMESPrinter.nameAndVertLine(g, x, y - 2, COLW_STOCK_SEX, 14, LIMESPrinter.getSex(mouse), FontManagerUS.SSB08, true, false);
            x = LIMESPrinter.nameAndVertLine(g, x, y - 2, COLW_STOCK_ID, 14, LIMESPrinter.getIDString(mouse), FontManagerUS.SSP8, true, false);
            x = LIMESPrinter.nameAndVertLine(g, x, y - 2, COLW_STOCK_EARTAG, 14, mouse.getCLLWEartagString(), FontManagerUS.SSP8, true, true);
            x = LIMESPrinter.nameAndVertLine(g, x, y - 2, COLW_STOCK_GEBTAG, 14, LabelMaker.getVeryShortDateString(mouse.getDate("MOS_BIRTHDAY")), FontManagerUS.SSB09, true, false);
            x = LIMESPrinter.nameAndVertLine(g, x, y - 2, COLW_STOCK_FARBE, 14, LIMESPrinter.getCoatColor(mouse), FontManagerUS.SSB09, true, false);
            g.drawLine(0, y += 10, 266, y);
        }
        LIMESPrinter.fillHorizLines(g, y);
    }

    private static int nameAndVertLine(Graphics2D g, int x, int y, int w, int h, String s, Font f, boolean mitstrich, boolean zeigDasRechte) {
        if (s != null && s.trim().length() != 0) {
            int pw;
            int lw;
            int wsw;
            if (zeigDasRechte && (wsw = StringHelper.getStringWidth(s, f, 0)) > (lw = w - 5) && (pw = StringHelper.getStringWidth("...", f, 0)) < lw) {
                while (pw + wsw > lw) {
                    s = s.substring(1, s.length());
                    wsw = StringHelper.getStringWidth(s, f, 0);
                }
                s = "..." + s;
            }
            LabelMaker.make(g, s, f, x, y, w, h, 0, 0, null);
        }
        x += w;
        if (mitstrich) {
            g.drawLine(x, y, x, 158);
        }
        return x;
    }

    private static String getCoatColor(Mouse mouse) {
        return CoatColor.getDescr(mouse.getCoatColor(), true, null);
    }

    private static String getSex(Mouse mouse) {
        int sex = mouse.getSex();
        return DefaultManager.getSexString(sex, mouse.getSexVariant(0), true, true);
    }

    private static void showWuerfe(Graphics2D g, int y, Vector wuerfe, String group) {
        int x = 0;
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MATING_GEBTAG, 14, "Wurfdatum", FontManagerUS.SSP9, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MATING_ANZ_JUNGTIERE, 14, "Anzahl Junge", FontManagerUS.SSP9, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MATING_ABSETZDATUM, 14, "Absetzdatum", FontManagerUS.SSP9, true, false);
        x = LIMESPrinter.nameAndVertLine(g, x, y, COLW_MATING_BEMERKUNGEN, 14, "Bemerkungen", FontManagerUS.SSP9, true, false);
        g.drawLine(0, y += 14, 266, y);
        if (wuerfe != null) {
            if (wuerfe.size() > 1) {
                Wurf.sortWuerfe(wuerfe, true);
            }
            g.setStroke(DUENN_STROKE);
        }
        LIMESPrinter.fillHorizLines(g, y);
    }

    private static void fillHorizLines(Graphics2D g, int y) {
        while (y + 10 < 158) {
            g.drawLine(0, y += 10, 266, y);
        }
    }

    private static int makeParent(Mouse parent, String sexSign, Graphics2D g, int y, Vector males, long cageID) {
        int COLW_M1_GEBTAG = LIMESPrinter.mm(18.0);
        int COLW_M1_LINE = 266 - LINKS - COLW_M1_GEBTAG;
        int COLW_M1_GT = 266 - LINKS;
        int ym = y;
        int startVP = males == null ? Integer.MIN_VALUE : LIMESPrinter.getMatingDate(parent, males, cageID);
        g.setStroke(DUENN_STROKE);
        g.drawLine(LINKS, y, LINKS, y + 28);
        LabelMaker.make(g, sexSign, FontManagerUS.SSB12, 0, y, LINKS / 4, 14, 0, 0, null);
        LabelMaker.make(g, LIMESPrinter.getIDString(parent), FontManagerUS.SSP9, LINKS / 4, y, LINKS * 3 / 4, 14, 0, 0, null);
        LabelMaker.make(g, parent.getCLLWEartagString(), FontManagerUS.SSB10, 0, y += 14, LINKS, 14, 0, 0, null);
        y = ym;
        int x = LINKS;
        LabelMaker.make(g, LabelMaker.getVeryShortDateString((Date)parent.get("MOS_BIRTHDAY")), FontManagerUS.SSB08, x, y, COLW_M1_GEBTAG, 9, 0, 0, null);
        g.setStroke(DUENN_STROKE);
        g.drawRect(x, y, COLW_M1_GEBTAG, 9);
        x += COLW_M1_GEBTAG;
        if (startVP != Integer.MIN_VALUE) {
            LabelMaker.make(g, "V:" + LabelMaker.getVeryShortDateString(startVP), FontManagerUS.SSB08, x, y, COLW_M1_GEBTAG, 9, 0, 0, null);
            g.setStroke(DUENN_STROKE);
            g.drawRect(x, y, COLW_M1_GEBTAG, 9);
            x += COLW_M1_GEBTAG;
        }
        LabelMaker.make(g, "S: " + parent.getCLLWStrainString(), FontManagerUS.SSI08, x + 2, y, COLW_M1_LINE - 4, 9, 0, 2, null);
        LabelMaker.make(g, "L: " + parent.getCLLWLineString(), FontManagerUS.SSB08, LINKS + 2, y += 9, COLW_M1_GT - 4, 9, 0, 2, null);
        LabelMaker.make(g, "G: " + parent.getGenotype(null), FontManagerUS.SSB08, LINKS + 2, y += 9, COLW_M1_GT - 4, 9, 0, 2, null);
        y = ym + 28;
        g.setStroke(DICK_STROKE);
        g.drawLine(0, y, 266, y);
        return y;
    }

    private static int getMatingDate(Mouse female, Vector males, long cageID) {
        if (males.size() == 1 && cageID != -1L) {
            Mouse male = (Mouse)males.firstElement();
            Visit[] femVis = (Visit[])female.get("MOS_VISIT");
            Visit[] malVis = (Visit[])male.get("MOS_VISIT");
            if (femVis != null && malVis != null) {
                Visit femLast = Visit.findLastStartedUnfinishedVisit(femVis, female.getID(), cageID);
                Visit malLast = Visit.findLastStartedUnfinishedVisit(malVis, male.getID(), cageID);
                if (femLast != null && malLast != null) {
                    int malStart;
                    int femStart = MyDate.getTage(femLast.ivStartDate);
                    return femStart > (malStart = MyDate.getTage(malLast.ivStartDate)) ? femStart : malStart;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    private static int showStrainsOrLines(int y, TreeSet names, boolean hadUndefineds, Graphics2D g, Font font) {
        StringBuilder msb = new StringBuilder();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (msb.length() != 0) {
                msb.append(" // ");
            }
            msb.append(name);
        }
        if (hadUndefineds) {
            if (msb.length() != 0) {
                msb.append(" // ");
            }
            msb.append("?");
        }
        return LIMESPrinter.makeFullWrap(msb.toString(), y, font, 0, 266, 2, 9, g, 0);
    }

    private static int showLicenses(int y, Vector mice, Graphics2D g) {
        TreeSet haltungsStrings = new TreeSet();
        TreeSet unklareStrings = new TreeSet();
        TreeMap spDateByTVStrings = new TreeMap();
        Vector sammler = new Vector();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            LIMESPrinter.collectLicencesStrings(mouse, haltungsStrings, spDateByTVStrings, unklareStrings, sammler);
        }
        y = LIMESPrinter.showLicString(haltungsStrings, y, FontManagerUS.SSP9, g, "H-Liz");
        y = LIMESPrinter.showLicString(spDateByTVStrings, y, FontManagerUS.SSP9, g, "TV-Liz");
        y = LIMESPrinter.showLicString(unklareStrings, y, FontManagerUS.SSP9, g, "Unklare Liz");
        haltungsStrings.clear();
        haltungsStrings = null;
        unklareStrings.clear();
        unklareStrings = null;
        spDateByTVStrings.clear();
        spDateByTVStrings = null;
        sammler.clear();
        sammler = null;
        return y;
    }

    private static int showLicString(TreeSet ts, int y, Font font, Graphics2D g, String prefix) {
        if (!ts.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            Iterator iterator = ts.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                msb.append(s);
            }
            y += 2;
            y = LIMESPrinter.makeFullWrap(String.valueOf(prefix) + ": " + msb.toString(), y, font, 0, 266, 2, 9, g, 2);
            g.drawLine(0, y += 2, 266, y);
        }
        return y;
    }

    private static int showLicString(TreeMap ts, int y, Font font, Graphics2D g, String prefix) {
        if (!ts.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            Iterator iterator = ts.keySet().iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                msb.append(s);
                Integer fruehest = (Integer)ts.get(s);
                if (fruehest == NO_SPECIAL_DATE) continue;
                msb.append(" [").append(DatumFormat.getVeryShortDateString(fruehest)).append("]");
            }
            y += 2;
            y = LIMESPrinter.makeFullWrap(String.valueOf(prefix) + ": " + msb.toString(), y, font, 0, 266, 2, 9, g, 2);
            g.drawLine(0, y += 2, 266, y);
        }
        return y;
    }

    private static String getIDString(Mouse mouse) {
        String res = Long.toString(mouse.getID());
        if (res.length() > 5) {
            res = "..." + res.substring(res.length() - 5, res.length());
        }
        return res;
    }

    private static void collectLicencesStrings(Mouse mouse, TreeSet haltungsStrings, TreeMap tvStrings, TreeSet unklareStrings, Vector sammler) {
        sammler.clear();
        mouse.getLicenses(sammler);
        if (!sammler.isEmpty()) {
            Iterator iterator = sammler.iterator();
            while (iterator.hasNext()) {
                License lic = (License)iterator.next();
                if (lic.isHaltungsLicense()) {
                    haltungsStrings.add(lic.getBrowseNameWITHOUTServicePrefix());
                    continue;
                }
                if (lic.isTierversuchsLicense()) {
                    String key;
                    Integer bisher;
                    Integer specDate = (Integer)mouse.get("MOS_SPDAT");
                    if (specDate == null) {
                        specDate = NO_SPECIAL_DATE;
                    }
                    Integer fruehester = (bisher = (Integer)tvStrings.get(key = lic.getBrowseNameWITHOUTServicePrefix())) != null && bisher < specDate ? bisher : specDate;
                    tvStrings.put(key, fruehester);
                    continue;
                }
                unklareStrings.add(lic.getBrowseNameWITHOUTServicePrefix());
            }
        }
    }

    public LIMESPrinter() {
        super("LIMES", 283.46456692913387, 175.74803149606302);
        this.ivLeft = 8.503937007874017;
        this.ivTop = 8.503937007874017;
        this.ivRight = 8.503937007874017;
        this.ivBottom = 8.503937007874017;
        this.ivRotated = false;
        PageFormatGenerator.createPageformatForLabelPrinter(this);
        this.ivPageFormat.setOrientation(1);
    }

    public LabelPrinter getClone() {
        LIMESPrinter clone = new LIMESPrinter();
        this.copyValues(clone);
        return clone;
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.ivPageFormat;
    }

    public PageFormat getPageFormatForPreview() {
        return this.ivPageFormat;
    }

    public void printIt() {
        new LIMESPrintBrotherQL570(this.ivDocument).printIt();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        Object ooo = this.ivDocument.elementAt(pageIndex);
        if (ooo instanceof Cage) {
            this.simplePrint((Cage)ooo, graphics);
        } else if (ooo instanceof Mouse) {
            this.simplePrint((Mouse)ooo, graphics);
        } else if (ooo instanceof Vector) {
            this.simplePrint((Vector)ooo, graphics);
        }
        return 0;
    }

    public void simplePrint(Cage cage, Graphics graphics) {
        LIMESPrinter.simplePrint(cage, graphics, 8.503937007874017);
    }

    public void simplePrint(Mouse mouse, Graphics graphics) {
        LIMESPrinter.simplePrint(mouse, graphics, 8.503937007874017);
    }
}

