/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManager;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelColumn;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;

public class OsloPrinter
extends LabelPrinter {
    private static final String DEFAULT_PRINTER = "\t<LabelPrinter name=\"Oslo\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"125\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"OwnerAndLicenseOslo\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"2\"></line>\n\t\t\t<line typ=\"CageNrAndMouseCount\" font=\"5\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"MultiLineComment\" anzLines=\"3\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"SystemID\" font=\"3\"></col>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private boolean ivMatingZwang = false;

    public static OsloPrinter createPrinter() {
        XMLNode xn = XMLParser.parseXMLString(DEFAULT_PRINTER);
        return new OsloPrinter(xn);
    }

    public static OsloPrinter createMatingPrinter() {
        XMLNode xn = XMLParser.parseXMLString(DEFAULT_PRINTER);
        OsloPrinter op = new OsloPrinter(xn);
        op.ivName = "Oslo Mating";
        op.ivMatingZwang = true;
        return op;
    }

    public OsloPrinter(XMLNode xn) {
        super(xn);
    }

    public OsloPrinter() {
    }

    public LabelPrinter getClone() {
        OsloPrinter clone = new OsloPrinter();
        clone.ivMatingZwang = this.ivMatingZwang;
        this.copyValues(clone);
        return clone;
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage() || this.ivMatingZwang) {
            return this.handleMatingCage(c);
        }
        return super.handleCage(c);
    }

    public Vector handleMatingCage(Cage c) {
        Mouse mouse;
        Vector page = new Vector(100);
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, this.ivMatingZwang, 20, 20, null, false, false, true, false, false, false, true, false, false, false);
        if (wuerfe == null) {
            return super.handleCage(c);
        }
        HashMap<Object, Mouse> parents = new HashMap<Object, Mouse>();
        Vector<Mouse> toRemove = new Vector<Mouse>();
        Iterator iter = males.iterator();
        while (iter.hasNext()) {
            mouse = (Mouse)iter.next();
            parents.put(mouse.get("IDO_ID"), mouse);
            if (c.isMouseInside(mouse.getID())) continue;
            toRemove.add(mouse);
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            males.remove(iter.next());
        }
        toRemove.clear();
        iter = females.iterator();
        while (iter.hasNext()) {
            mouse = (Mouse)iter.next();
            parents.put(mouse.get("IDO_ID"), mouse);
            if (c.isMouseInside(mouse.getID())) continue;
            toRemove.add(mouse);
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            females.remove(iter.next());
        }
        int anzAdults = parents.size();
        String mouseCount = "(" + anzAdults + " adults)";
        if (anzAdults == 1) {
            mouseCount = "(" + anzAdults + " adult)";
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            String ltyp = ll.getType();
            ay = ltyp.equalsIgnoreCase("Line") ? (ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this)) : (ltyp.equalsIgnoreCase("Strain") ? (ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this)) : (ltyp.equalsIgnoreCase("MultiLineComment") ? (ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this)) : (ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this))));
            ++i;
        }
        ay = this.showParentMice(females, ax, ay, Wurf.MOTHER_COLORS, DefaultManager.getFemale(), page, c);
        ay += 3;
        ay = this.showParentMice(males, ax, ay, Wurf.FATHER_COLORS, DefaultManager.getMale(), page, c);
        ay += 5;
        ay = this.showWuerfe(wuerfe, ax, ay, page, males, females, parents);
        return page;
    }

    private int showParentMice(Vector mice, int ax, int ay, Color[] colarr, String sign, Vector page, Cage c) {
        Font f = FontManagerUS.SSB10;
        int i = 0;
        while (i < mice.size()) {
            PrintElement tpe;
            int tx = ax;
            Mouse mausi = (Mouse)mice.elementAt(i);
            page.addElement(PrintElement.getTextElement(tx, ay, sign, f));
            tx += 14;
            if (i < colarr.length) {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, String.valueOf(mausi.getID()), f, colarr[i]);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            } else {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, String.valueOf(mausi.getID()), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            int nbr = 45;
            page.addElement(PrintElement.getFilledTextBox(tx += 35, ay, nbr, 12, LabelMaker.getVeryShortDateString(mausi.getDate("MOS_BIRTHDAY")), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += nbr, ay, nbr, 12, "(" + LabelMaker.getVeryShortDateString(Cage.getInDate(mausi, c)) + ")", f, null));
            mausi.getMultiFontGenotype(FontManager.getGenotypeArray(false, FontManagerUS.SSB10, 1.0), false);
            LabelColumn.handleLabelColumnObject(mausi.getMultiFontGenotype(FontManager.getGenotypeArray(false, FontManagerUS.SSB10, 1.0), false), page, tx += nbr + 5, ay, 700, f);
            ay += 11;
            ++i;
        }
        return ay;
    }

    private int showWuerfe(Vector wuerfe, int ax, int ay, Vector page, Vector males, Vector females, HashMap parents) {
        int origay = ay;
        Font f = FontManagerUS.SSB09;
        Font f2 = FontManagerUS.SSB08;
        int i = wuerfe.size() - 1;
        while (i >= 0) {
            Wurf w = (Wurf)wuerfe.elementAt(i);
            int tx = ax;
            if (w.areAllLeft()) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, 8, 10, "*", f, null));
            }
            page.addElement(PrintElement.getFilledTextBox(tx += 8, ay, 38, 10, LabelMaker.getVeryShortDateString(w.ivDay), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 50, ay, 22, 10, "T " + w.ivNumBornTotal, f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 10, w.getFemaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 10, w.getMaleNumberString(), f, null));
            tx += 22;
            tx += 2;
            int pos = -1;
            Mouse father = (Mouse)parents.get(new Long(w.ivFatherID));
            if (father != null) {
                pos = males.indexOf(father);
            }
            PrintElement tpe = null;
            if (pos < Wurf.FATHER_COLORS.length && pos != -1) {
                tpe = PrintElement.getFilledTextBox(tx, ay, 30, 10, String.valueOf(w.ivFatherID), f2, Wurf.FATHER_COLORS[pos]);
            } else if (w.ivFatherID != -3L) {
                page.add(PrintElement.getBoxElement(tx, ay, 29, 10, 0.5f));
                tpe = PrintElement.getFilledTextBox(tx, ay, 29, 10, String.valueOf(w.ivFatherID), f2, null);
            }
            if (tpe != null) {
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tpe = null;
            tx += 30;
            pos = -1;
            Mouse mother = (Mouse)parents.get(new Long(w.ivMotherID));
            if (mother != null) {
                pos = females.indexOf(mother);
            }
            if (pos < Wurf.MOTHER_COLORS.length && pos != -1) {
                tpe = PrintElement.getFilledTextBox(tx, ay, 30, 10, String.valueOf(w.ivMotherID), f2, Wurf.MOTHER_COLORS[pos]);
            } else if (w.ivMotherID != -3L) {
                page.add(PrintElement.getBoxElement(tx, ay, 29, 10, 0.5f));
                tpe = PrintElement.getFilledTextBox(tx, ay, 29, 10, String.valueOf(w.ivMotherID), f2, null);
            }
            if (tpe != null) {
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            if ((ay += 10) > 205) {
                ay = origay;
                ax += 180;
            }
            --i;
        }
        return ay;
    }
}

