/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.printing.labelprinters;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.XMLNode;
import de.hannse.netobjects.util.XMLParser;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.FontManagerUS;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelLine;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.printing.util.LabelMaker;
import mausoleum.printing.util.Wurf;

public class StanfordPrinter
extends LabelPrinter {
    private static final String DEFAULT_PRINTER = "\t<LabelPrinter name=\"Stanford_1\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"RackPosGroupStanford\" font=\"4\"></line>\n\t\t\t<line typ=\"OwnerStanford\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"Tag\" font=\"3\"></col>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t</mice>\n\t</LabelPrinter>\n";
    private static final String DEFAULT_PRINTER_CAESAR = "\t<LabelPrinter name=\"caesar\" weddingsred=\"true\" rotated=\"1\" onecardperpage=\"1\" width=\"131\" height=\"75\" top=\"5\" left=\"5\" right=\"10\">\n\t\t<lines>\n\t\t\t<line typ=\"RackPosGroupStanford\" font=\"4\"></line>\n\t\t\t<line typ=\"OwnerStanford\" font=\"4\"></line>\n\t\t\t<line typ=\"Empty\" font=\"4\"></line>\n\t\t\t<line typ=\"PolygonOhneOwner\" font=\"5\" orientation=\"center\"></line>\n\t\t\t<line typ=\"Line\" font=\"4\"></line>\n\t\t\t<line typ=\"Strain\" font=\"4\"></line>\n\t\t\t<line typ=\"Comment\" font=\"3\"></line>\n\t\t</lines>\n\t\t<mice>\n\t\t\t<col typ=\"Tag\" font=\"3\"></col>\n\t\t\t<col typ=\"EarTag\" font=\"3\"></col>\n\t\t\t<col typ=\"Sex\" font=\"3\"></col>\n\t\t\t<col typ=\"Genotype\" font=\"3\"></col>\n\t\t\t<col typ=\"Birthday\" font=\"3\"></col>\n\t\t\t<col typ=\"Entryday\" font=\"3\"></col>\n\t\t\t<col typ=\"ParentsMitTag\" font=\"1\" />\n\t\t</mice>\n\t</LabelPrinter>\n";
    private boolean ivCeasarMode = false;

    public static StanfordPrinter createPrinter(boolean isCaesarMode) {
        StanfordPrinter sp = null;
        if (isCaesarMode) {
            sp = new StanfordPrinter(XMLParser.parseXMLString(DEFAULT_PRINTER_CAESAR));
            sp.ivCeasarMode = true;
        } else {
            sp = new StanfordPrinter(XMLParser.parseXMLString(DEFAULT_PRINTER));
        }
        return sp;
    }

    private StanfordPrinter(XMLNode xn) {
        super(xn);
    }

    private StanfordPrinter() {
    }

    public LabelPrinter getClone() {
        StanfordPrinter clone = new StanfordPrinter();
        this.copyValues(clone);
        clone.ivCeasarMode = this.ivCeasarMode;
        return clone;
    }

    public Vector handleCage(Cage c) {
        if (c.isMatingCage()) {
            return this.handleMatingCage(c);
        }
        if (this.ivCeasarMode) {
            return super.handleCage(c, LabelLine.getSexedContentString(c, true));
        }
        return super.handleCage(c);
    }

    public Vector handleMatingCage(Cage c) {
        Vector page = new Vector(100);
        Vector males = new Vector();
        Vector females = new Vector();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(c, males, females, false, 20, 20, null, false, false, false, false, true, false, true, false, false, false);
        if (wuerfe == null) {
            return super.handleCage(c);
        }
        int anzAdults = males.size() + females.size();
        String mouseCount = "(" + anzAdults + " adults)";
        if (anzAdults == 1) {
            mouseCount = "(" + anzAdults + " adult)";
        }
        int ax = (int)this.ivLeft;
        int ay = (int)this.ivTop;
        int i = 0;
        while (i < this.ivLines.size()) {
            LabelLine ll = (LabelLine)this.ivLines.elementAt(i);
            String ltyp = ll.getType();
            if (!(ltyp.equalsIgnoreCase("Line") || ltyp.equalsIgnoreCase("Strain") || ltyp.equalsIgnoreCase("Comment"))) {
                ay += ll.generateOutput(c, page, ax, ay, this.ivWeddingsRed, mouseCount, this);
            }
            ++i;
        }
        ay = this.showParentMice(males, ax, ay, Wurf.FATHER_COLORS, DefaultManager.getMale(), page, c);
        ay += 3;
        ay = this.showParentMice(females, ax, ay, Wurf.MOTHER_COLORS, DefaultManager.getFemale(), page, c);
        ay += 5;
        ay = this.showWuerfe(wuerfe, ax, ay, page, males, females, IDObject.combineIDObjectCollections(new Vector[]{males, females}));
        return page;
    }

    private int showParentMice(Vector mice, int ax, int ay, Color[] colarr, String sign, Vector page, Cage c) {
        Font f = FontManagerUS.SSB10;
        int i = 0;
        while (i < mice.size()) {
            PrintElement tpe;
            int tx = ax;
            Mouse mausi = (Mouse)mice.elementAt(i);
            page.addElement(PrintElement.getTextElement(tx, ay, sign, f));
            tx += 14;
            if (i < colarr.length) {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, mausi.getCLLWEartagString("?", true, true), f, colarr[i]);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            } else {
                tpe = PrintElement.getFilledTextBox(tx, ay, 35, 12, mausi.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            int nbr = 60;
            page.addElement(PrintElement.getFilledTextBox(tx += 35, ay, nbr, 12, "I " + LabelMaker.getDateString(Cage.getInDate(mausi, c)), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += nbr, ay, nbr, 12, "B " + LabelMaker.getDateString(mausi.getDate("MOS_BIRTHDAY")), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += nbr, ay, 700, 12, mausi.getCLLWLineString(), f, null));
            ay += 11;
            ++i;
        }
        return ay;
    }

    private int showWuerfe(Vector wuerfe, int ax, int ay, Vector page, Vector males, Vector females, HashMap parents) {
        int origay = ay;
        Font f = FontManagerUS.SSB09;
        int i = wuerfe.size() - 1;
        while (i >= 0) {
            Wurf w = (Wurf)wuerfe.elementAt(i);
            int tx = ax;
            if (w.areAllLeft()) {
                page.addElement(PrintElement.getFilledTextBox(tx, ay, 8, 12, "*", f, null));
            }
            page.addElement(PrintElement.getFilledTextBox(tx += 8, ay, 38, 12, LabelMaker.getDateString(w.ivDay), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 60, ay, 22, 12, w.getMaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, w.getFemaleNumberString(), f, null));
            page.addElement(PrintElement.getFilledTextBox(tx += 22, ay, 22, 12, "T " + w.ivNumBornTotal, f, null));
            tx += 22;
            tx += 2;
            Mouse father = (Mouse)parents.get(new Long(w.ivFatherID));
            if (father != null) {
                int pos = males.indexOf(father);
                PrintElement tpe = null;
                tpe = pos < Wurf.FATHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, Wurf.FATHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, father.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            Mouse mother = (Mouse)parents.get(new Long(w.ivMotherID));
            if (mother != null) {
                int pos = females.indexOf(mother);
                PrintElement tpe = null;
                tpe = pos < Wurf.MOTHER_COLORS.length && pos != -1 ? PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, Wurf.MOTHER_COLORS[pos]) : PrintElement.getFilledTextBox(tx, ay, 30, 12, mother.getCLLWEartagString("?", true, true), f, null);
                page.addElement(tpe);
                tpe.ivOrientation = 2;
            }
            tx += 30;
            if ((ay += 10) > 205) {
                ay = origay;
                ax += 180;
            }
            --i;
        }
        return ay;
    }
}

