/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack;

import java.awt.event.MouseEvent;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.MDisposable;
import mausoleum.mouse.Mouse;
import mausoleum.rack.ERPFiller;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.RackGraphicsManager;

public class ExtendedRackPos
implements MDisposable {
    public static final int POS_VORN = 1;
    public static final int POS_HINTEN = 2;
    public static final int POS_ORCUS = 3;
    public static final int POS_TABLE = 4;
    public static final int POS_MOUSEPOOL = 5;
    public static final int POS_NIRGENDS = -1;
    public int ivFeldKennung = -1;
    public RackPos ivRackPos = null;
    private Vector ivCages = null;
    private Vector ivMice = null;
    public int dx;
    public int dy;
    public boolean ivDraggingAllowed = true;
    public RackPos ivBlockingRackPos = null;

    public static ExtendedRackPos calcERP(MouseEvent e) {
        ExtendedRackPos erg = new ExtendedRackPos();
        if (e.getSource() instanceof ERPFiller) {
            ERPFiller erpf = (ERPFiller)e.getSource();
            erpf.fillERP(erg, e.getX(), e.getY());
            erg.ivDraggingAllowed = erg.ivDraggingAllowed & (!Mouse.areMiceRoomAccesibilityRestricted(erg.ivMice) && !Cage.areCagesRoomAccesibilityRestricted(erg.ivCages));
        }
        return erg;
    }

    public void mDispose() {
        this.ivRackPos = null;
        this.ivBlockingRackPos = null;
    }

    public Cage getRelevantCage() {
        Cage cage = this.getSingleCage();
        if (cage != null && cage.hasSubCages()) {
            if (this.dx < RackGraphicsManager.getCageWidth() / 2) {
                return cage.getLeftSubCage();
            }
            return cage.getRightSubCage();
        }
        return cage;
    }

    public int cageCount() {
        if (this.ivCages != null) {
            return this.ivCages.size();
        }
        return 0;
    }

    public Cage getSingleCage() {
        if (this.ivCages != null && this.ivCages.size() == 1) {
            return (Cage)this.ivCages.firstElement();
        }
        return null;
    }

    public void setCage(Cage c) {
        if (this.ivCages != null) {
            this.ivCages.clear();
        } else {
            this.ivCages = new Vector();
        }
        if (c != null) {
            this.ivCages.add(c);
        }
    }

    public void setCages(Vector cages) {
        if (this.ivCages != null) {
            this.ivCages.clear();
        } else {
            this.ivCages = new Vector();
        }
        if (cages != null) {
            this.ivCages.addAll(cages);
        }
    }

    public Vector getCages() {
        Vector erg = new Vector();
        if (this.ivCages != null) {
            erg.addAll(this.ivCages);
        }
        return erg;
    }

    public int mouseCount() {
        if (this.ivMice != null) {
            return this.ivMice.size();
        }
        return 0;
    }

    public void setMice(Vector mice) {
        if (this.ivMice != null) {
            this.ivMice.clear();
        } else {
            this.ivMice = new Vector();
        }
        if (mice != null) {
            this.ivMice.addAll(mice);
        }
    }

    public Vector getMice() {
        Vector erg = new Vector();
        if (this.ivMice != null) {
            erg.addAll(this.ivMice);
        }
        return erg;
    }
}

