/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.TaskExtended;
import mausoleum.objectstore.QuotableIDObject;
import mausoleum.room.Room;
import mausoleum.ui.UIDef;

public class Rack
extends QuotableIDObject
implements Comparable {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final String RCK_PREFIX = "RCK_";
    public static final String SIDES = "RCK_SIDES";
    public static final String ROWS = "RCK_ROWS";
    public static final String COLUMNS = "RCK_COLUMNS";
    public static final String CAGES = "RCK_CAGES";
    public static final String ROOM = "RCK_ROOM";
    public static final String NAME = "RCK_NAME";
    public static final String HALTUNGSFORM = "RCK_HAFO";
    public static final String OCCUPIED = "RCK_OCC";
    public static final String[] ATTRIBUTES_RACK;
    public static final String[] ORDERED_ATTRIBUTES;
    private static final int MINI_CAGEBREITE;
    private static final int MINI_CAGEHOEHE;
    private static final Color FREMD_BELEGT;
    private static final int INSET_RL;
    private static final Border BORDER;
    private transient JLabel ivThumbLabel = null;
    private transient JLabel ivTextLabel = null;
    private transient BufferedImage ivThumb = null;
    private transient ImageIcon ivThumbIcon = null;
    private transient int ivThumbWidth = 0;
    private transient int ivThumbHeight = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        String[] stringArray = new String[16];
        stringArray[0] = SIDES;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = ROWS;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = COLUMNS;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = CAGES;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = ROOM;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = NAME;
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = OCCUPIED;
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("[Z");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = HALTUNGSFORM;
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        ATTRIBUTES_RACK = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", SIDES, ROWS, COLUMNS, CAGES, ROOM, NAME, OCCUPIED, "QIO_GNAMES", "QIO_QUOTA", HALTUNGSFORM};
        MINI_CAGEBREITE = UIDef.getScaled(6);
        MINI_CAGEHOEHE = UIDef.getScaled(4);
        FREMD_BELEGT = new Color(230, 230, 230);
        INSET_RL = UIDef.getScaled(8);
        BORDER = new EmptyBorder(1, INSET_RL, UIDef.getScaled(5), INSET_RL);
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        long[] arr;
        IDObject ido;
        long l;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Name = " + this.getString(NAME, ""));
        target.add("Sides = " + this.getInt(SIDES, 0));
        target.add("Rows = " + this.getInt(ROWS, 0));
        target.add("Columns = " + this.getInt(COLUMNS, 0));
        int platz = this.getInt(SIDES, 0) * this.getInt(ROWS, 0) * this.getInt(COLUMNS, 0);
        target.add("Capacity = " + platz + " cages");
        target.add("Keeping type = " + this.getString(HALTUNGSFORM, ""));
        int used = 0;
        long[] cages = (long[])this.get(CAGES);
        if (cages != null) {
            int i = 0;
            while (i < cages.length) {
                if (cages[i] > 0L) {
                    ++used;
                }
                ++i;
            }
        }
        target.add("Used = " + used + " cages");
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(10))) && (l = this.getLong(ROOM, 0L)) != 0L) {
            ido = ObjectStore.getObjectDeadOrAlive(10, l, group, null, false);
            target.add("Room: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 10 + "|" + l);
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(2))) && (arr = (long[])this.get(CAGES)) != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != 0L) {
                    ido = ObjectStore.getObjectDeadOrAlive(2, arr[i], group, null, false);
                    target.add("Cage: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + arr[i]);
                }
                ++i;
            }
        }
    }

    public boolean isRoomAccesibilityRestricted() {
        Room room = this.getRoom();
        if (room != null) {
            return !room.isAccessibleForGroups();
        }
        return false;
    }

    public Room getRoom() {
        return (Room)ObjectStore.getObjectDeadOrAlive(10, this.getLong(ROOM, 0L), this.getString("IDO_GROUP"), null, false);
    }

    public long getRoomID(long defVal) {
        Room room = this.getRoom();
        if (room != null) {
            return room.getID(defVal);
        }
        return defVal;
    }

    public long getBuildingID(long defVal) {
        Room room;
        if ("service".equals(this.getGroup()) && (room = this.getRoom()) != null) {
            return room.getBuildingID(defVal);
        }
        return defVal;
    }

    public boolean canSitInRoom() {
        return true;
    }

    public Long getServiceRoomID() {
        Room room;
        if (this.isAlive() && (room = this.getRoom()) != null) {
            return room.getServiceRoomID();
        }
        return null;
    }

    public String getName(String nullVal) {
        if (ProcessDefinition.isClient() && this.isSharedWithOtherGroups() && !MausoleumClient.isServiceCaretaker()) {
            return "[S] " + this.getString(NAME, nullVal);
        }
        return this.getString(NAME, nullVal);
    }

    public String getBrowseName() {
        return this.getName();
    }

    public String getName() {
        return this.getName("Rack " + this.getID());
    }

    public boolean isEmpty() {
        long[] cages = (long[])this.get(CAGES);
        if (cages != null) {
            int i = 0;
            while (i < cages.length) {
                if (cages[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isEmptyAlsoWithShareds() {
        if (MausoleumClient.isHeadOfService()) {
            boolean[] blockeds = (boolean[])this.get(OCCUPIED);
            if (blockeds != null) {
                int i = 0;
                while (i < blockeds.length) {
                    if (blockeds[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        Vector groups = this.getSharedGroups();
        if (groups == null || groups.isEmpty()) {
            boolean[] blockeds;
            long[] cages = (long[])this.get(CAGES);
            if (cages != null) {
                int i = 0;
                while (i < cages.length) {
                    if (cages[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((blockeds = (boolean[])this.get(OCCUPIED)) != null) {
                int i = 0;
                while (i < blockeds.length) {
                    if (blockeds[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public Vector getCages(boolean onlyMatings) {
        Vector<Cage> erg = new Vector<Cage>();
        String group = this.getString("IDO_GROUP");
        long[] cages = (long[])this.get(CAGES);
        if (cages != null) {
            int i = 0;
            while (i < cages.length) {
                Cage cage = this.getCage(cages, i, group);
                if (cage != null && (!onlyMatings || cage.isMatingCage())) {
                    erg.add(cage);
                }
                ++i;
            }
        }
        return erg;
    }

    private Cage getCage(long[] cages, int pos, String group) {
        if (cages[pos] != 0L) {
            return (Cage)ObjectStore.getObjectDeadOrAlive(2, cages[pos], group, null, true);
        }
        return null;
    }

    public Cage getCage(int side, int row, int col) {
        int pos = this.calcPos(side, row, col);
        long[] cages = (long[])this.get(CAGES);
        if (cages != null && pos < cages.length) {
            return this.getCage(cages, pos, this.getString("IDO_GROUP"));
        }
        return null;
    }

    public static int calcPos(int side, int row, int col, int totRows, int totCols) {
        return side * totRows * totCols + row * totCols + col;
    }

    public int calcPos(int side, int row, int col) {
        return Rack.calcPos(side, row, col, this.getInt(ROWS), this.getInt(COLUMNS));
    }

    public int getArraySize() {
        return this.getInt(SIDES) * this.getInt(ROWS) * this.getInt(COLUMNS);
    }

    public void makeCageVector() {
        int groesse = this.getArraySize();
        if (groesse == 0) {
            this.set(CAGES, null);
            return;
        }
        long[] cages = new long[groesse];
        int i = 0;
        while (i < groesse) {
            cages[i] = 0L;
            ++i;
        }
        this.set(CAGES, cages);
    }

    public ImageIcon getImage() {
        return this.ivThumbIcon;
    }

    public void performCagePutzette(Vector commands) {
        int seiten = this.getInt(SIDES);
        int rows = this.getInt(ROWS);
        int cols = this.getInt(COLUMNS);
        int side = 0;
        while (side < seiten) {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    Cage cage = this.getCage(side, row, col);
                    if (cage != null && cage.isDead()) {
                        StringBuffer msb = new StringBuffer();
                        msb.append("RKCLEARPOS").append(" ");
                        msb.append(this.getID()).append(" ");
                        msb.append(side).append(" ");
                        msb.append(row).append(" ");
                        msb.append(col);
                        commands.addElement(msb.toString());
                    }
                    ++col;
                }
                ++row;
            }
            ++side;
        }
    }

    public JLabel getThumbLabel() {
        this.ensurePresenceOfThumb();
        this.ivThumbLabel.setText(" " + this.getName() + " ");
        return this.ivThumbLabel;
    }

    public String getTaskTooltip() {
        String tooltip = null;
        Vector allCages = this.getAllRealCages();
        if (allCages != null && !allCages.isEmpty()) {
            Vector mice = new Vector();
            Iterator iterator = allCages.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                mice.addAll(cage.getActualMice());
            }
            if (!mice.isEmpty()) {
                tooltip = TaskExtended.getToolTipStringTasks(mice, null, false);
            }
        }
        return tooltip;
    }

    public Vector getAllRealCages() {
        Vector<Cage> v = new Vector<Cage>();
        int seiten = this.getInt(SIDES);
        int cols = this.getInt(COLUMNS);
        int rows = this.getInt(ROWS);
        int side = 0;
        while (side < seiten) {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    Cage cage = this.getCageAlsoFromSharedRack(side, row, col);
                    if (cage != null && !(cage instanceof BlockingCage)) {
                        v.add(cage);
                    }
                    ++col;
                }
                ++row;
            }
            ++side;
        }
        return v;
    }

    public void ensurePresenceOfThumb() {
        if (this.ivThumb == null) {
            int seiten = this.getInt(SIDES);
            this.ivThumbWidth = seiten == 2 ? UIDef.getScaled(3) + 2 * MINI_CAGEBREITE * this.getInt(COLUMNS) : UIDef.getScaled(2) + MINI_CAGEBREITE * this.getInt(COLUMNS);
            this.ivThumbHeight = 2 + MINI_CAGEHOEHE * this.getInt(ROWS);
            this.ivThumb = new BufferedImage(this.ivThumbWidth, this.ivThumbHeight, 2);
            this.ivThumbIcon = new ImageIcon(this.ivThumb);
            int th = UIDef.getScaled(16);
            int tw = this.ivThumbWidth + UIDef.getScaled(2) * INSET_RL;
            String name = " " + this.getString(NAME) + " ";
            this.ivThumbLabel = new JLabel(name);
            this.ivThumbLabel.setBorder(BORDER);
            this.ivThumbLabel.setOpaque(true);
            this.ivThumbLabel.setForeground(Color.black);
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivThumbLabel.setFont(this.isEmpty() ? FontManager.getFont("SSP11") : FontManager.getFont("SSB11"));
            } else {
                this.ivThumbLabel.setFont(FontManager.getFont("SSB11"));
            }
            this.ivThumbLabel.setVerticalTextPosition(3);
            this.ivThumbLabel.setHorizontalTextPosition(0);
            this.ivThumbLabel.setIconTextGap(1);
            this.ivThumbLabel.setIcon(this.ivThumbIcon);
            this.ivThumbLabel.setHorizontalAlignment(0);
            Dimension d = new Dimension(tw, th + UIDef.getScaled(6) + this.ivThumbHeight);
            this.ivThumbLabel.setMinimumSize(d);
            this.ivThumbLabel.setMaximumSize(d);
            this.ivThumbLabel.setPreferredSize(d);
            this.ivTextLabel = new JLabel(name);
            this.ivTextLabel.setOpaque(true);
            this.ivTextLabel.setForeground(Color.black);
            this.ivTextLabel.setFont(FontManager.getFont("SSB12"));
            this.ivTextLabel.setHorizontalTextPosition(0);
            this.ivTextLabel.setHorizontalAlignment(2);
            d = new Dimension(tw, th);
            this.ivTextLabel.setMinimumSize(d);
            this.ivTextLabel.setMaximumSize(d);
            this.ivTextLabel.setPreferredSize(d);
        }
    }

    public JComponent getLabelFor(int sside, int srow, int scol, Color scolor, int cagenr) {
        int thumbWidth = 2 + MINI_CAGEBREITE * this.getInt(COLUMNS);
        int thumbHeight = 2 + MINI_CAGEHOEHE * this.getInt(ROWS);
        BufferedImage thumb = new BufferedImage(thumbWidth, thumbHeight, 2);
        ImageIcon thumbIcon = new ImageIcon(thumb);
        StringBuilder msb = new StringBuilder(" ");
        if (cagenr != -1) {
            msb.append("[").append(cagenr).append("] ");
        }
        if (this.getInt(SIDES) == 2) {
            msb.append(Babel.get(sside == 0 ? "FRONT" : "BACK"));
        }
        msb.append(" ");
        msb.append(Babel.get("ROW_SHORT")).append(":").append(srow + 1).append(" ");
        msb.append(Babel.get("COL_SHORT")).append(":").append(scol + 1).append(" ");
        JLabel thumbLabel = new JLabel(msb.toString());
        thumbLabel.setBorder(BORDER);
        thumbLabel.setForeground(Color.black);
        thumbLabel.setFont(FontManager.getFont("SSB11"));
        thumbLabel.setVerticalTextPosition(3);
        thumbLabel.setHorizontalTextPosition(0);
        thumbLabel.setIconTextGap(1);
        thumbLabel.setIcon(thumbIcon);
        thumbLabel.setHorizontalAlignment(0);
        Graphics g = thumb.getGraphics();
        g.setColor(Color.white);
        g.fillRect(1, 1, thumbWidth - 1, thumbHeight - 1);
        int cols = this.getInt(COLUMNS);
        int rows = this.getInt(ROWS);
        Color otherCage = UIDef.GRAY_COLOR;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Color color;
                int cx = col * MINI_CAGEBREITE + 1;
                int cy = row * MINI_CAGEHOEHE + 1;
                Color color2 = row == srow && col == scol ? scolor : (color = this.istPosBelegt(sside, row, col, false) ? otherCage : Color.white);
                if (color != Color.white) {
                    g.setColor(color);
                    g.fillRect(cx + 1, cy + 1, MINI_CAGEBREITE - 2, MINI_CAGEHOEHE - 2);
                    Color bcol = new Color((255 + color.getRed()) / 2, (255 + color.getGreen()) / 2, (255 + color.getBlue()) / 2);
                    g.setColor(bcol);
                    g.drawLine(cx, cy, cx + MINI_CAGEBREITE - 1, cy);
                    g.drawLine(cx, cy, cx, cy + MINI_CAGEHOEHE - 1);
                    bcol = new Color(color.getRed() / 2, color.getGreen() / 2, color.getBlue() / 2);
                    g.setColor(bcol);
                    g.drawLine(cx + 1, cy + MINI_CAGEHOEHE - 1, cx + MINI_CAGEBREITE - 1, cy + MINI_CAGEHOEHE - 1);
                    g.drawLine(cx + MINI_CAGEBREITE - 1, cy + 1, cx + MINI_CAGEBREITE - 1, cy + MINI_CAGEHOEHE - 1);
                }
                ++col;
            }
            ++row;
        }
        g.setColor(Color.black);
        g.drawLine(0, 0, thumbWidth, 0);
        g.drawLine(0, thumbHeight - 1, thumbWidth, thumbHeight - 1);
        g.drawLine(0, 0, 0, thumbHeight - 1);
        g.drawLine(thumbWidth - 1, 0, thumbWidth - 1, thumbHeight - 1);
        JPanel pan = new JPanel(new BorderLayout(0, 3));
        pan.add("Center", thumbLabel);
        JLabel lab = new JLabel(" " + this.getString(NAME) + " ");
        lab.setForeground(Color.black);
        lab.setFont(FontManager.getFont("SSB11"));
        lab.setHorizontalAlignment(0);
        pan.add("North", lab);
        return pan;
    }

    public void prepareImage() {
        this.ensurePresenceOfThumb();
        Graphics g = this.ivThumb.getGraphics();
        g.setColor(Color.white);
        g.fillRect(1, 1, this.ivThumbWidth - 1, this.ivThumbHeight - 1);
        g.setColor(Color.black);
        g.drawLine(0, 0, this.ivThumbWidth, 0);
        g.drawLine(0, this.ivThumbHeight - 1, this.ivThumbWidth, this.ivThumbHeight - 1);
        g.drawLine(0, 0, 0, this.ivThumbHeight - 1);
        g.drawLine(this.ivThumbWidth - 1, 0, this.ivThumbWidth - 1, this.ivThumbHeight - 1);
        int seiten = this.getInt(SIDES);
        int cols = this.getInt(COLUMNS);
        int rows = this.getInt(ROWS);
        if (seiten == 2) {
            g.drawLine(this.ivThumbWidth / 2, 0, this.ivThumbWidth / 2, this.ivThumbHeight - 1);
        }
        int side = 0;
        while (side < seiten) {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    int cx = side * (cols * MINI_CAGEBREITE + 1) + col * MINI_CAGEBREITE + 1;
                    int cy = row * MINI_CAGEHOEHE + 1;
                    Cage cage = this.getCageAlsoFromSharedRack(side, row, col);
                    if (cage != null) {
                        Color color = Color.white;
                        Color[] ccols = cage.getColor();
                        if (ccols != null && ccols.length >= 1) {
                            if (ccols.length == 1) {
                                if (ccols[0] != null) {
                                    color = ccols[0];
                                }
                            } else {
                                int cr = 0;
                                int cg = 0;
                                int cb = 0;
                                int anz = 0;
                                int i = 0;
                                while (i < ccols.length) {
                                    if (ccols[i] != null) {
                                        cr += ccols[i].getRed();
                                        cg += ccols[i].getGreen();
                                        cb += ccols[i].getBlue();
                                        ++anz;
                                    }
                                    ++i;
                                }
                                if (anz > 0) {
                                    color = new Color(cr / anz, cg / anz, cb / anz);
                                }
                            }
                        }
                        if (color != Color.white) {
                            g.setColor(color);
                            g.fillRect(cx + 1, cy + 1, MINI_CAGEBREITE - 2, MINI_CAGEHOEHE - 2);
                        }
                        Color bcol = new Color((255 + color.getRed()) / 2, (255 + color.getGreen()) / 2, (255 + color.getBlue()) / 2);
                        g.setColor(bcol);
                        g.drawLine(cx, cy, cx + MINI_CAGEBREITE - 1, cy);
                        g.drawLine(cx, cy, cx, cy + MINI_CAGEHOEHE - 1);
                        bcol = new Color(color.getRed() / 2, color.getGreen() / 2, color.getBlue() / 2);
                        g.setColor(bcol);
                        g.drawLine(cx + 1, cy + MINI_CAGEHOEHE - 1, cx + MINI_CAGEBREITE - 1, cy + MINI_CAGEHOEHE - 1);
                        g.drawLine(cx + MINI_CAGEBREITE - 1, cy + 1, cx + MINI_CAGEBREITE - 1, cy + MINI_CAGEHOEHE - 1);
                    } else if (this.istPosBelegt(side, row, col, true)) {
                        g.setColor(FREMD_BELEGT);
                        g.fillRect(cx, cy, MINI_CAGEBREITE, MINI_CAGEHOEHE);
                    }
                    ++col;
                }
                ++row;
            }
            ++side;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        if (o instanceof Rack) {
            Rack u2 = (Rack)o;
            return this.getName().compareToIgnoreCase(u2.getName());
        }
        return 0;
    }

    public boolean setAndPropagateCages(long[] newRackCages, Hashtable objectBag, HashMap serviceRoomOverride) {
        if (ProcessDefinition.isServer()) {
            this.set(CAGES, newRackCages);
            objectBag.put(this.getIdentifierString(), this);
            if (this.isSharedWithOtherGroups()) {
                Rack.propagateCageOccupation((Rack)ObjectStore.getObjectDeadOrAlive(3, this.getLong("IDO_SERVID", 0L), "service", objectBag, false), objectBag, serviceRoomOverride);
            }
            return true;
        }
        return false;
    }

    public static void propagateCageOccupation(Rack serviceRack, Hashtable objectBag, HashMap serviceRoomOverride) {
        if (ProcessDefinition.isServer() && serviceRack != null) {
            Rack uRack;
            String group;
            Iterator iter;
            Long srovr;
            if (Log.shouldLog(0)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("mausoleum.rack.Rack");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.subdebug("start propagateCageOccupation", clazz);
            }
            if ((srovr = serviceRack.getServiceRoomID()) == null) {
                srovr = AllgUtils.NIX_ROOM;
            }
            if (serviceRoomOverride != null) {
                serviceRoomOverride.put(serviceRack.getIdentifierString(), srovr);
            }
            boolean[] occArr = new boolean[serviceRack.getArraySize()];
            HashMap hm = serviceRack.getSubObjectsByGroupOnServer(objectBag);
            if (hm != null) {
                iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    group = (String)iter.next();
                    if (Log.shouldLog(0)) {
                        String string = "pco addOccupation group [" + group + "]";
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.rack.Rack");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.subdebug(string, clazz);
                    }
                    uRack = (Rack)hm.get(group);
                    if (serviceRoomOverride != null) {
                        serviceRoomOverride.put(uRack.getIdentifierString(), srovr);
                    }
                    uRack.addOccupation(occArr);
                }
            }
            serviceRack.set(OCCUPIED, occArr);
            objectBag.put(serviceRack.getIdentifierString(), serviceRack);
            if (hm != null) {
                iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    group = (String)iter.next();
                    if (Log.shouldLog(0)) {
                        String string = "pco setOccupation group [" + group + "]";
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.rack.Rack");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.subdebug(string, clazz);
                    }
                    uRack = (Rack)hm.get(group);
                    uRack.set(OCCUPIED, occArr);
                    objectBag.put(uRack.getIdentifierString(), uRack);
                }
                if (Log.shouldLog(0)) {
                    Class<?> clazz = class$5;
                    if (clazz == null) {
                        try {
                            clazz = class$5 = Class.forName("mausoleum.rack.Rack");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.subdebug("pco setOccupation done for all relevant groups", clazz);
                }
            }
        }
    }

    public void addOccupation(boolean[] occArr) {
        long[] cages = (long[])this.get(CAGES);
        if (cages != null) {
            int i = 0;
            while (i < cages.length) {
                if (cages[i] != 0L) {
                    occArr[i] = true;
                }
                ++i;
            }
        }
    }

    public boolean istPosBelegt(int s, int r, int c, boolean onlyOtherGroups) {
        int pos = this.calcPos(s, r, c);
        if (pos >= 0) {
            long[] cages = (long[])this.get(CAGES);
            if (cages != null && pos < cages.length && cages[pos] != 0L) {
                return !onlyOtherGroups;
            }
            boolean[] occArr = (boolean[])this.get(OCCUPIED);
            if (occArr != null) {
                if (pos < occArr.length) {
                    return occArr[pos];
                }
                throw new IllegalArgumentException("Size of shared rack wrong!");
            }
            return false;
        }
        throw new IllegalArgumentException("Calculated position negative!");
    }

    public String getGroupForPos(int side, int row, int col) {
        if (ProcessDefinition.isServer() && this.getGroup().equals("service")) {
            int cpos = this.calcPos(side, row, col);
            HashMap hm = this.getSubObjectsByGroupOnServer(null);
            if (hm != null) {
                Iterator iter = hm.keySet().iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    Rack uRack = (Rack)hm.get(group);
                    long[] carr = (long[])uRack.get(CAGES);
                    if (carr == null || carr.length <= cpos || carr[cpos] <= 0L) continue;
                    return group;
                }
            }
        }
        return null;
    }

    public Cage getCageAlsoFromSharedRack(int side, int row, int col) {
        if (MausoleumClient.isServiceCaretaker()) {
            String[] groups = (String[])this.get("IDO_UGROUPS");
            long[] objectIDs = (long[])this.get("IDO_UGROUPIDS");
            if (groups != null && objectIDs != null && groups.length == objectIDs.length) {
                int i = 0;
                while (i < objectIDs.length) {
                    Cage c;
                    Rack subRack = (Rack)ObjectStore.getClientObject(3, objectIDs[i], groups[i]);
                    if (subRack != null && (c = subRack.getCage(side, row, col)) != null) {
                        return c;
                    }
                    ++i;
                }
            }
            return null;
        }
        return this.getCage(side, row, col);
    }

    public int anzCagesInServiceRack() {
        boolean[] occ;
        int sum = 0;
        if (this.getGroup().equals("service") && (occ = (boolean[])this.get(OCCUPIED)) != null) {
            int i = 0;
            while (i < occ.length) {
                if (occ[i]) {
                    ++sum;
                }
                ++i;
            }
        }
        return sum;
    }

    public String getGraphicsInfo(int modus) {
        block21: {
            if (ProcessDefinition.isServer() && this.getGroup().equals("service")) {
                try {
                    HashMap legendByColor;
                    ColorMode cmode = CageColorManager.getColorMode(modus);
                    if (cmode == null) break block21;
                    int seiten = this.getInt(SIDES);
                    int rows = this.getInt(ROWS);
                    int cols = this.getInt(COLUMNS);
                    Object[] masterArray = new Object[seiten * rows * cols];
                    String[] groups = (String[])this.get("IDO_UGROUPS");
                    long[] objectIDs = (long[])this.get("IDO_UGROUPIDS");
                    Object[] ergebnis = new Object[4];
                    ergebnis[0] = new int[]{seiten, cols, rows};
                    ergebnis[3] = masterArray;
                    HashMap hashMap = legendByColor = cmode.hasVaryingColorColorCodes() ? new HashMap() : null;
                    if (groups != null && objectIDs != null && groups.length == objectIDs.length) {
                        int i = 0;
                        while (i < objectIDs.length) {
                            Rack subRack = (Rack)ObjectStore.getObjectDeadOrAlive(3, objectIDs[i], groups[i], null, true);
                            if (subRack != null) {
                                int side = 0;
                                while (side < seiten) {
                                    int row = 0;
                                    while (row < rows) {
                                        int col = 0;
                                        while (col < cols) {
                                            Cage cage = subRack.getCage(side, row, col);
                                            if (cage != null) {
                                                try {
                                                    Object[] cageArr = new Object[3];
                                                    cageArr[0] = cmode.getCageColor(cage, legendByColor, cage.getActualMice(), null);
                                                    cageArr[1] = Integer.toString(cage.getInt("CAG_PSEUDOID"));
                                                    masterArray[Rack.calcPos((int)side, (int)row, (int)col, (int)rows, (int)cols)] = cageArr;
                                                }
                                                catch (Exception e) {
                                                    Log.error("Problem creating Service graphics [2]", e, this);
                                                }
                                            }
                                            ++col;
                                        }
                                        ++row;
                                    }
                                    ++side;
                                }
                            }
                            ++i;
                        }
                        if (cmode.hasVaryingColorColorCodes()) {
                            Vector<Color> legendColors = new Vector<Color>();
                            Vector legendStrings = new Vector();
                            if (legendByColor != null && !legendByColor.isEmpty()) {
                                Iterator iter = legendByColor.keySet().iterator();
                                while (iter.hasNext()) {
                                    Color col = (Color)iter.next();
                                    legendColors.add(col);
                                    legendStrings.add(legendByColor.get(col));
                                }
                            }
                            if (legendColors != null && !legendColors.isEmpty()) {
                                Color[] colis = new Color[legendColors.size()];
                                String[] legends = new String[legendColors.size()];
                                int i2 = 0;
                                while (i2 < legendColors.size()) {
                                    Color col = (Color)legendColors.elementAt(i2);
                                    Vector v = (Vector)legendStrings.elementAt(i2);
                                    StringBuffer msb = new StringBuffer();
                                    int j = 0;
                                    while (j < v.size()) {
                                        if (j != 0) {
                                            msb.append("\n");
                                        }
                                        String s = (String)v.elementAt(j);
                                        msb.append(s.trim());
                                        ++j;
                                    }
                                    colis[i2] = col;
                                    legends[i2] = msb.toString();
                                    ++i2;
                                }
                                ergebnis[1] = colis;
                                ergebnis[2] = legends;
                            } else {
                                ergebnis[1] = null;
                                ergebnis[2] = null;
                            }
                        } else {
                            ergebnis[1] = null;
                            ergebnis[2] = null;
                        }
                    }
                    return IDObjectXMLHandler.getTransport(ergebnis, false, true);
                }
                catch (Throwable e) {
                    Log.error("Problem creating Service graphics [1]", e, this);
                }
            }
        }
        return null;
    }
}

