/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.RequestManager;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.AftermathObject;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackFrame;

public class RackManager
extends ObjectManager {
    public static RackManager cvInstance;

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new RackManager();
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static void eliminateGhostCages() {
        if (MausoleumClient.isRegularOrTGService()) {
            Vector commands = new Vector();
            Enumeration en = cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Rack r = (Rack)en.nextElement();
                r.performCagePutzette(commands);
            }
            if (!commands.isEmpty()) {
                int i = 0;
                while (i < commands.size()) {
                    String command = (String)commands.elementAt(i);
                    RequestManager.sendCommandRequestAndGetAnswer(command, UserManager.getFirstGroup());
                    ++i;
                }
            }
        }
    }

    public static boolean isNameAlreadyTaken(String name, String group) {
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            Rack r = (Rack)en.nextElement();
            if (!name.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public static Vector getRacksInRoom(long rid) {
        Vector<Rack> res = new Vector<Rack>();
        Vector v = cvInstance.getActualObjectVectorAllGroups();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Rack rack = (Rack)v.elementAt(i);
                if (rack.getLong("RCK_ROOM") == rid) {
                    res.add(rack);
                }
                ++i;
            }
        }
        return res;
    }

    public static boolean istEinRackInRaum(long rid, String group) {
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            Rack r = (Rack)en.nextElement();
            if (r.getLong("RCK_ROOM") != rid) continue;
            return true;
        }
        return false;
    }

    public static Rack findGroupRack(String group, long serviceRackID) {
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            Rack rack = (Rack)en.nextElement();
            if (!rack.isSharedWithOtherGroups() || rack.getLong("IDO_SERVID", 0L) != serviceRackID) continue;
            return rack;
        }
        return null;
    }

    private RackManager() {
        super(3);
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && or.ivKamVonWoanders && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) && RackFrame.getInstance() != null) {
            String group = UserManager.getFirstGroup();
            if (MausoleumClient.isServiceCaretaker()) {
                group = "service";
            }
            Iterator iter = sentObjects.iterator();
            while (iter.hasNext()) {
                IDObject obj = (IDObject)iter.next();
                if (!(obj instanceof Rack) || !group.equals(obj.getGroup()) || RackFrame.getRackID() != obj.getID()) continue;
                RackFrame.getInstance().adaptToRack((Rack)obj, true, false);
            }
        }
    }
}

