/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RackPos
implements Externalizable {
    static final long serialVersionUID = -8717671986526504937L;
    public long ivRackID;
    public int ivSide;
    public int ivRow;
    public int ivColumn;

    public RackPos() {
        this.ivRackID = 1L;
        this.ivSide = 0;
        this.ivRow = 0;
        this.ivColumn = 0;
    }

    public RackPos(long rackID, int side, int row, int column) {
        this.ivRackID = rackID;
        this.ivSide = side;
        this.ivRow = row;
        this.ivColumn = column;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RackPos) {
            RackPos rp = (RackPos)obj;
            return this.ivRackID == rp.ivRackID && this.ivSide == rp.ivSide && this.ivRow == rp.ivRow && this.ivColumn == rp.ivColumn;
        }
        return false;
    }

    public int getSortValue() {
        return (int)this.ivRackID * 100000 + this.ivSide * 10000 + this.ivRow * 100 + this.ivColumn;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ivSide = in.readInt();
        this.ivRow = in.readInt();
        this.ivColumn = in.readInt();
        this.ivRackID = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.ivSide);
        out.writeInt(this.ivRow);
        out.writeInt(this.ivColumn);
        out.writeLong(this.ivRackID);
    }
}

