/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mausoleum.cage.Cage;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.mouse.Mouse;
import mausoleum.rack.ERPFiller;
import mausoleum.rack.ExtendedRackPos;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.tables.PoolFrame;
import mausoleum.tables.models.MTCagePool;
import mausoleum.tables.models.MTMousePool;

public class MausoleumPool
extends JComponent
implements ERPFiller {
    private static final long serialVersionUID = 11531331L;
    private static final Vector MOUSE_POOL = new Vector();
    private static final Vector CAGE_POOL = new Vector();
    public static final MTMousePool MPOOL_TABLE = new MTMousePool();
    public static final MTCagePool CPOOL_TABLE = new MTCagePool();
    public static final MausoleumPool POOL_COMPONENT = new MausoleumPool();
    private static final String TITLE = "Pool";
    private ExtendedRackPos ivERPTarget = null;
    private final JPopupMenu ivPopupMenu = new JPopupMenu();
    private Image ivCageImage = null;

    public static void addPoolMice(Vector target) {
        target.addAll(MOUSE_POOL);
    }

    public static void addToPool(Vector idObjects) {
        MausoleumPool.modifyPool(idObjects, true);
    }

    public static void removeFromPool(Vector idObjects) {
        MausoleumPool.modifyPool(idObjects, false);
    }

    public static boolean addPossible(Vector idObjects) {
        return MausoleumPool.modPossible(idObjects, true);
    }

    public static boolean removePossible(Vector idObjects) {
        return MausoleumPool.modPossible(idObjects, false);
    }

    private static boolean modPossible(Vector idObjects, boolean add) {
        if (idObjects != null && !idObjects.isEmpty()) {
            int[] indT = new int[1];
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                MausoleumPool.getPoolAndIndex((IDObject)iter.next(), indT);
                if ((!add || indT[0] != -1) && (add || indT[0] == -1)) continue;
                return true;
            }
        }
        return false;
    }

    private static Vector getPoolAndIndex(IDObject ido, int[] indT) {
        Vector pool = null;
        if (ido instanceof Mouse) {
            pool = MOUSE_POOL;
        } else if (ido instanceof Cage) {
            pool = CAGE_POOL;
        }
        indT[0] = MausoleumPool.indexInCart(ido, pool);
        return pool;
    }

    private static void modifyPool(Vector idObjects, boolean add) {
        boolean miceChanged = false;
        boolean cagesChanged = false;
        if (idObjects != null && !idObjects.isEmpty()) {
            int[] indT = new int[1];
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                Vector pool = MausoleumPool.getPoolAndIndex(ido, indT);
                if (pool == null) continue;
                boolean changed = false;
                if (add) {
                    if (indT[0] == -1) {
                        pool.add(ido);
                        changed = true;
                    }
                } else if (indT[0] != -1) {
                    pool.removeElementAt(indT[0]);
                    changed = true;
                }
                if (!changed) continue;
                if (pool == CAGE_POOL) {
                    cagesChanged = true;
                    continue;
                }
                if (pool != MOUSE_POOL) continue;
                miceChanged = true;
            }
        }
        if (cagesChanged) {
            MausoleumPool.POOL_COMPONENT.ivCageImage = ImageProvider.getCageImage(CAGE_POOL);
            CPOOL_TABLE.setTable(CAGE_POOL, true);
        }
        if (miceChanged) {
            MPOOL_TABLE.setTable(MOUSE_POOL, true);
        }
        POOL_COMPONENT.repaint();
    }

    public static void clearPool() {
        MOUSE_POOL.clear();
        CAGE_POOL.clear();
        CPOOL_TABLE.setTable(CAGE_POOL);
        MPOOL_TABLE.setTable(MOUSE_POOL);
        MausoleumPool.POOL_COMPONENT.ivCageImage = ImageProvider.getCageImage(CAGE_POOL);
        POOL_COMPONENT.repaint();
    }

    public static void showPool() {
        PoolFrame.showPool(MausoleumPool.collectFromPool(MOUSE_POOL), MausoleumPool.collectFromPool(CAGE_POOL));
    }

    private static Vector collectFromPool(Vector pool) {
        Vector<IDObject> erg = new Vector<IDObject>();
        Iterator iter = pool.iterator();
        while (iter.hasNext()) {
            IDObject ido = (IDObject)iter.next();
            IDObject actObject = ObjectStore.getObjectDeadOrAlive(ido.getTyp(), ido.getID(), ido.getGroup(), null, false);
            if (actObject == null) continue;
            erg.add(actObject);
        }
        return erg;
    }

    private static int indexInCart(IDObject ido, Vector pool) {
        if (ido != null && pool != null) {
            long id = ido.getID();
            int i = 0;
            while (i < pool.size()) {
                IDObject tido = (IDObject)pool.elementAt(i);
                if (tido.getID() == id) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static void reactOnClick(MouseEvent e) {
        if (e.isMetaDown()) {
            MausoleumPool.POOL_COMPONENT.ivPopupMenu.show(POOL_COMPONENT, e.getX(), e.getY());
        } else if (!(e.getClickCount() != 2 || MOUSE_POOL.isEmpty() && CAGE_POOL.isEmpty())) {
            MausoleumPool.showPool();
        }
    }

    private MausoleumPool() {
        JMenuItem item = new JMenuItem(Babel.get("POOL_CLEAR"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.clearPool();
            }
        });
        this.ivPopupMenu.add(item);
        item = new JMenuItem(Babel.get("POOL_SHOW"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MausoleumPool.showPool();
            }
        });
        this.ivPopupMenu.add(item);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        MausoleumImageStore.fillDimWithImage(g, "inspectorButton", d);
        CageDisplayManager.drawOrcusPoolString(TITLE, d, g);
        if (!MOUSE_POOL.isEmpty()) {
            ImageProvider.drawMiceStuff(g, ImageProvider.getDefMouseImage(MOUSE_POOL), this.getSize().width / 2, this.getSize().height, MOUSE_POOL.size());
        }
        if (this.ivCageImage != null) {
            int w;
            int x = w = this.getSize().width / 2;
            int bx = (w - this.ivCageImage.getWidth(null)) / 2;
            int by = this.getSize().height - this.ivCageImage.getHeight(null) - 4;
            g.drawImage(this.ivCageImage, x + bx, by, null);
        }
        if (this.ivERPTarget != null) {
            g.setColor(Color.red);
            g.drawRect(1, 1, d.width - 3, d.height - 3);
            g.drawRect(2, 2, d.width - 5, d.height - 5);
            g.drawRect(3, 3, d.width - 7, d.height - 7);
        } else {
            g.setColor(Color.white);
            g.drawLine(d.width - 1, d.height - 1, d.width - 1, 0);
            g.drawLine(d.width - 1, d.height - 1, 0, d.height - 1);
            g.setColor(Color.black);
            g.drawLine(0, 0, d.width, 0);
            g.drawLine(0, 0, 0, d.height);
        }
    }

    private void clearTarget() {
        if (this.ivERPTarget != null) {
            this.ivERPTarget = null;
            this.repaint();
        }
    }

    public void deliver(ExtendedRackPos source, ExtendedRackPos target) {
        if (source.mouseCount() != 0) {
            MausoleumPool.addToPool(source.getMice());
        } else if (source.cageCount() != 0) {
            MausoleumPool.addToPool(source.getCages());
        }
    }

    public void fillERP(ExtendedRackPos erp, int x, int y) {
        int w = this.getSize().width / 2;
        if (x < w) {
            erp.setCages(null);
            if (MOUSE_POOL.isEmpty()) {
                erp.setMice(null);
            } else {
                Vector mice = new Vector();
                mice.addAll(MOUSE_POOL);
                erp.setMice(mice);
            }
        } else {
            erp.setMice(null);
            if (CAGE_POOL.isEmpty()) {
                erp.setCages(null);
            } else if (CAGE_POOL.size() == 1) {
                erp.setCage((Cage)CAGE_POOL.firstElement());
            } else {
                Vector cages = new Vector();
                cages.addAll(CAGE_POOL);
                erp.setCages(cages);
            }
        }
        erp.ivFeldKennung = 5;
        erp.ivRackPos = new RackPos(0L, -1, 0, 0);
    }

    public boolean setDragTarget(ExtendedRackPos target, ExtendedRackPos source) {
        boolean tolerable = false;
        if (target != null && source != null && target.ivFeldKennung != -1 && source.ivFeldKennung != 5 && (source.mouseCount() > 0 || source.cageCount() > 0)) {
            tolerable = true;
        }
        if (tolerable) {
            this.ivERPTarget = target;
            this.repaint();
        } else {
            this.clearTarget();
        }
        return tolerable;
    }
}

