/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import mausoleum.helper.FontManager;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.rack.frame.RackComboChangeListener;
import mausoleum.room.RoomStatusListener;

public class RackComboBox
extends JComboBox
implements ActionListener,
RoomStatusListener {
    private static final long serialVersionUID = 1651311L;
    public static Comparator RACK_EMPTY_COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Rack && arg1 instanceof Rack) {
                Rack rack0 = (Rack)arg0;
                Rack rack1 = (Rack)arg1;
                boolean e0 = rack0.isEmpty();
                boolean e1 = rack1.isEmpty();
                if (e0 && !e1) {
                    return 1;
                }
                if (!e0 && e1) {
                    return -1;
                }
                return rack0.getName().compareToIgnoreCase(rack1.getName());
            }
            return 0;
        }
    };
    private RackComboChangeListener ivRackComboChangeListener = null;
    private final Vector ivRacksInRoom = new Vector();
    private final Vector ivRacksOutside = new Vector();

    public static void getDisplayableRacks(Vector racksInRoom, Vector racksOutside) {
        block14: {
            racksInRoom.clear();
            racksOutside.clear();
            Vector racks = null;
            if (MausoleumClient.isRegularOrTGService()) {
                racks = RackManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
            } else if (MausoleumClient.isServiceCaretaker()) {
                racks = RackManager.cvInstance.getActualObjectVector("service");
            }
            if (racks == null || racks.isEmpty()) break block14;
            long roomId = RoomAction.cvRoomID;
            if (roomId == 0L) {
                int i = 0;
                while (i < racks.size()) {
                    Rack r = (Rack)racks.elementAt(i);
                    if (r.isAlive()) {
                        if (r.getLong("RCK_ROOM") == 0L) {
                            racksOutside.addElement(r);
                        } else {
                            racksInRoom.addElement(r);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < racks.size()) {
                    Rack r = (Rack)racks.elementAt(i);
                    if (r.isAlive()) {
                        if (r.getLong("RCK_ROOM") == 0L) {
                            racksOutside.addElement(r);
                        } else if (r.getLong("RCK_ROOM") == roomId) {
                            racksInRoom.addElement(r);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public RackComboBox(RackComboChangeListener rf) {
        this.ivRackComboChangeListener = rf;
        this.addActionListener(this);
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 123123123L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Rack r;
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (MausoleumClient.isRegularOrTGService() && (r = (Rack)value) != null && r.isEmpty()) {
                    c.setFont(FontManager.getFont("SSP11"));
                }
                return c;
            }
        });
        RoomAction.addListener(this);
    }

    public void dispose() {
        this.removeActionListener(this);
        this.ivRackComboChangeListener = null;
        this.ivRacksInRoom.clear();
        this.ivRacksOutside.clear();
        RoomAction.removeListener(this);
    }

    public void setSelectedRack(Rack r) {
        String group = null;
        long id = -1L;
        if (MausoleumClient.isRegularOrTGService()) {
            group = r.getGroup();
            id = r.getID();
        } else if (MausoleumClient.isServiceCaretaker()) {
            group = "service";
            id = r.getTopLevelID(id);
        }
        if (group != null && id != -1L) {
            int i = 0;
            while (i < this.getItemCount()) {
                Rack rack = (Rack)this.getItemAt(i);
                if (rack != null && rack.getGroup().equals(group) && rack.getID() == id) {
                    this.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void adjust() {
        int prevRacksSize = this.getItemCount();
        long prevSelRackID = -1L;
        Rack selRack = (Rack)this.getSelectedItem();
        if (selRack != null) {
            prevSelRackID = selRack.getID();
        }
        this.removeAllItems();
        RackComboBox.getDisplayableRacks(this.ivRacksInRoom, this.ivRacksOutside);
        int indexToSelect = -1;
        Vector v = new Vector(40);
        v.addAll(this.ivRacksInRoom);
        v.addAll(this.ivRacksOutside);
        Collections.sort(v, RACK_EMPTY_COMPARER);
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Rack rack = (Rack)iter.next();
            if (rack.getID() == prevSelRackID) {
                indexToSelect = this.getItemCount();
            }
            this.addItem(rack);
        }
        if (this.getItemCount() == 0) {
            this.setEnabled(false);
            if (this.ivRackComboChangeListener != null) {
                this.ivRackComboChangeListener.adaptToRack(null, false, false);
            }
        } else {
            this.setEnabled(true);
            if (indexToSelect == -1) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedIndex(indexToSelect);
            }
            if (prevRacksSize == 0 || indexToSelect == -1) {
                selRack = (Rack)this.getSelectedItem();
                if (this.ivRackComboChangeListener != null) {
                    this.ivRackComboChangeListener.adaptToRack(selRack, false, false);
                }
            }
        }
    }

    public void setSelectedIndex(int arg0) {
        super.setSelectedIndex(arg0);
        Rack rack = (Rack)this.getSelectedItem();
        this.setToolTipText(rack == null ? null : rack.getTaskTooltip());
    }

    public void checkArrivedRack(Rack testRack) {
        String relevantGroup = null;
        if (MausoleumClient.isRegularOrTGService()) {
            if (!UserRoomRestriction.isObjectRestricted(testRack)) {
                relevantGroup = UserManager.getFirstGroup();
            }
        } else if (MausoleumClient.isServiceCaretaker()) {
            relevantGroup = "service";
        }
        boolean doSelect = false;
        if (relevantGroup != null && relevantGroup.equals(testRack.getGroup())) {
            long tid = testRack.getID();
            boolean isDa = false;
            int i = 0;
            while (i < this.getItemCount()) {
                Rack rack = (Rack)this.getItemAt(i);
                if (rack != null && rack.getID() == tid) {
                    isDa = true;
                    if (MausoleumClient.isServiceCaretaker() && i == this.getSelectedIndex()) {
                        doSelect = true;
                    }
                }
                ++i;
            }
            boolean adjustIt = false;
            adjustIt = testRack.isAlive() ? !isDa : isDa;
            if (adjustIt) {
                this.adjust();
            }
            this.repaint();
            if (doSelect && this.ivRackComboChangeListener != null) {
                this.ivRackComboChangeListener.adaptToRack((Rack)this.getSelectedItem(), true, false);
            }
        }
    }

    public void roomStatusChanged() {
        this.adjust();
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.ivRackComboChangeListener != null) {
            this.ivRackComboChangeListener.adaptToRack((Rack)this.getSelectedItem(), false, false);
        }
    }
}

