/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.alert.Alert;
import mausoleum.cage.BlockingCage;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.objectstore.CommandManagerMouse;
import mausoleum.rack.ERPFiller;
import mausoleum.rack.ExtendedRackPos;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.BlinkConsumer;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.RackBlinker;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.task.standards.StandardTask;
import mausoleum.visit.Visit;

public class RackField
extends JComponent
implements BlinkConsumer,
ERPFiller,
ObjectConsumer {
    private static final long serialVersionUID = 78948643L;
    private static final int RAND = RackGraphicsManager.SMALL_MARGIN;
    public static final Color UNZUGAENGLICH_COL = new Color(240, 240, 240, 160);
    private static final int[] CONSUMERTYPES = new int[]{2, 7, 16, 8, 1};
    private RackFrame ivRackFrame;
    private final boolean ivFront;
    private final int ivSide;
    private Rack ivRack = null;
    private Cage[] ivCages = null;
    private ExtendedRackPos ivERPTarget = null;
    public Vector ivSelCages = null;
    private boolean ivDrawAll = true;
    private Image ivNormImage = null;
    private Image ivSelImage = null;
    public boolean ivUnzugaenglich = false;
    public final HashMap ivCageVerboteByCIDString = new HashMap();

    public RackField(boolean isFront, RackFrame rtf) {
        this.ivRackFrame = rtf;
        this.ivFront = isFront;
        this.ivSide = this.ivFront ? 0 : 1;
        ObjectStoreClient.addConsumer((ObjectConsumer)this, CONSUMERTYPES);
        this.setDoubleBuffered(false);
    }

    public void somethingChanged() {
        this.ivNormImage = null;
        this.ivSelImage = null;
    }

    public void setSelectedVector(Vector v) {
        if (v.isEmpty()) {
            this.ivSelCages = null;
            RackBlinker.removeConsumer(this);
            this.paint(true);
        } else {
            this.ivSelCages = v;
            this.ivSelImage = null;
            RackBlinker.addConsumer(this);
        }
    }

    public boolean setDragTarget(ExtendedRackPos target, ExtendedRackPos source) {
        boolean tolerable = false;
        if (source != null && target != null && target.ivFeldKennung != -1) {
            String commonGroup;
            if (source.mouseCount() > 0) {
                String commonGroup2 = IDObject.commonGroup(source.getMice());
                if (commonGroup2 != null && this.zugaenglich(target, commonGroup2)) {
                    Cage c;
                    int anz = target.cageCount();
                    if (anz == 0) {
                        tolerable = true;
                    } else if (anz == 1 && (c = target.getRelevantCage()) != null && c.isTouchable() && !c.areMiceInside(source.getMice()) && c.getGroup("").equals(commonGroup2)) {
                        tolerable = true;
                    }
                }
            } else if (source.cageCount() == 1 && target.cageCount() == 0 && (commonGroup = IDObject.commonGroup(source.getCages())) != null && this.zugaenglich(target, commonGroup)) {
                tolerable = true;
            }
        }
        if (tolerable) {
            this.ivERPTarget = target;
            this.repaint();
        } else {
            this.clearTarget();
        }
        return tolerable;
    }

    public void manageZugaenglich(ExtendedRackPos source) {
        this.ivCageVerboteByCIDString.clear();
        boolean repaint = false;
        if (source != null && this.ivRack != null && (MausoleumClient.isServiceCaretaker() || MausoleumClient.isRegularOrTGService())) {
            Vector mice = null;
            String commonGroup = null;
            if (source.mouseCount() > 0) {
                mice = source.getMice();
                if (!mice.isEmpty() && this.ivCages != null) {
                    commonGroup = IDObject.commonGroup(mice);
                    int i = 0;
                    while (i < this.ivCages.length) {
                        CageDisplayManager.checkVerbote(this.ivCages[i], mice, commonGroup, this.ivCageVerboteByCIDString);
                        ++i;
                    }
                    repaint = true;
                }
            } else if (source.cageCount() == 1) {
                mice = source.getCages();
                commonGroup = IDObject.commonGroup(mice);
            }
            if (mice != null && MausoleumClient.isServiceCaretaker()) {
                if (commonGroup != null && RackManager.findGroupRack(commonGroup, this.ivRack.getID()) == null && !this.ivUnzugaenglich) {
                    this.ivUnzugaenglich = true;
                    repaint = true;
                }
            } else if (mice != null && MausoleumClient.isRegularOrTGService() && this.ivRack != null && this.ivRack.isRoomAccesibilityRestricted() && !this.ivUnzugaenglich) {
                this.ivUnzugaenglich = true;
                repaint = true;
            }
        }
        if (repaint) {
            this.somethingChanged();
            this.repaint();
        }
    }

    public void clearUnzugaenglichkeit() {
        this.ivCageVerboteByCIDString.clear();
        this.ivUnzugaenglich = false;
        this.somethingChanged();
        this.repaint();
    }

    public void dispose() {
        this.ivRackFrame = null;
        this.ivRack = null;
        this.ivCages = null;
        this.ivERPTarget = null;
        if (this.ivSelCages != null) {
            this.ivSelCages.clear();
        }
        this.ivSelCages = null;
        this.ivNormImage = null;
        this.ivSelImage = null;
        this.ivCageVerboteByCIDString.clear();
    }

    private boolean zugaenglich(ExtendedRackPos target, String commonGroup) {
        if (this.ivRack != null) {
            if (MausoleumClient.isServiceCaretaker()) {
                long serviceRackID = this.ivRack.getID();
                Rack gruppenRack = RackManager.findGroupRack(commonGroup, serviceRackID);
                if (gruppenRack == null) {
                    this.ivUnzugaenglich = true;
                    this.repaint();
                    return false;
                }
            } else if (MausoleumClient.isRegularOrTGService() && this.ivRack.isRoomAccesibilityRestricted()) {
                this.ivUnzugaenglich = true;
                this.repaint();
                return false;
            }
            return true;
        }
        return false;
    }

    private void clearTarget() {
        if (this.ivERPTarget != null) {
            this.ivERPTarget = null;
            this.repaint();
        }
    }

    public void fillERP(ExtendedRackPos erp, int x, int y) {
        erp.ivFeldKennung = this.ivFront ? 1 : 2;
        erp.setCages(null);
        erp.ivRackPos = null;
        erp.dx = 0;
        erp.ivDraggingAllowed = false;
        if (this.ivRack == null) {
            return;
        }
        int realx = (x - RAND) / this.getXProg();
        int realy = (y - RAND) / this.getYProg();
        if (realx < 0 || realx >= this.ivRack.getInt("RCK_COLUMNS") || realy < 0 || realy >= this.ivRack.getInt("RCK_ROWS")) {
            return;
        }
        if (x - RAND > realx * this.getXProg() + RackGraphicsManager.getCageWidth()) {
            return;
        }
        if (y - RAND > realy * this.getYProg() + RackGraphicsManager.getCageHeight()) {
            return;
        }
        erp.ivRackPos = new RackPos(this.ivRack.getID(), this.ivSide, realy, realx);
        Cage cage = this.ivCages[realy * this.ivRack.getInt("RCK_COLUMNS") + realx];
        if (cage != null) {
            erp.dx = x - RAND - realx * this.getXProg();
            if (cage instanceof BlockingCage) {
                erp.ivBlockingRackPos = erp.ivRackPos;
                erp.ivRackPos = null;
            } else if (cage.itsMine(null) || Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS")) {
                erp.setCage(cage);
                erp.ivDraggingAllowed = !cage.isRoomAccesibilityRestricted() && Privileges.hasPrivilege("MOVE_CAGES") && (cage.isTouchable() || Privileges.hasPrivilege("TOUCH_FOREIGN_CAGES"));
            } else {
                erp.ivRackPos = null;
            }
        }
    }

    public void deliver(ExtendedRackPos source, ExtendedRackPos target) {
        if (this.ivRack != null) {
            if (source.mouseCount() > 0) {
                this.putMiceInRack(target, source.getMice());
            } else if (source.cageCount() == 1) {
                this.putCageInRack(source.getSingleCage(), target.ivRackPos);
            }
        }
    }

    private void putCageInRack(Cage c, RackPos trp) {
        if (this.ivRack != null && trp != null && c != null && !trp.equals((c = c.getSuperCageIfThere()).get("CAG_POS"))) {
            long gruppenRackID = trp.ivRackID;
            Rack gruppenRack = this.ivRack;
            if (MausoleumClient.isServiceCaretaker()) {
                long serviceRackID = trp.ivRackID;
                gruppenRackID = 0L;
                String group = c.getGroup();
                gruppenRack = RackManager.findGroupRack(group, serviceRackID);
                if (gruppenRack != null) {
                    gruppenRackID = gruppenRack.getID();
                } else {
                    String com;
                    ObjectRequest or;
                    boolean ok = Alert.showAlert(Babel.get("RACK_NOT_AVIALABLE"), false);
                    if (ok && (or = RequestManager.sendCommandRequestAndGetAnswer(com = "ALLG_ATTACH_TO_SERVICE " + serviceRackID + " " + Base64Manager.encodeBase64(group) + " " + 3, "service")) != null && or.isFinished() && (gruppenRack = RackManager.findGroupRack(group, serviceRackID)) != null) {
                        gruppenRackID = gruppenRack.getID();
                    }
                }
            }
            if (gruppenRackID != 0L) {
                Vector<Cage> cages = new Vector<Cage>();
                cages.add(c);
                Vector changingMice = new Vector();
                if (!PopeAlert.checkForRoomSecurity(null, cages, null, gruppenRack, null, changingMice)) {
                    return;
                }
                StringBuffer msb = new StringBuffer(String.valueOf(CommandManagerExecutive.getServiceRoomTag(gruppenRack, "")) + "CSETR" + " " + c.getID() + " " + gruppenRackID + " " + trp.ivSide + " " + trp.ivRow + " " + trp.ivColumn);
                TaskExtended.getRoomTransferTaskCommand(changingMice, msb, MyDate.HEUTE);
                TrafficReport.appendTrafficInfoClientSide(c, -1L, "TRD_CAGE_DROPPED_IN_RACK", msb);
                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), c.getGroup());
                Vector<Cage> v = new Vector<Cage>();
                v.addElement(c);
                RackFrame.getInstance().selectCages(v, 2);
            }
        }
    }

    private void putMiceInRack(ExtendedRackPos erp, Vector mice) {
        String commonGroup = IDObject.commonGroup(mice);
        if (commonGroup != null) {
            Vector paarungsSammler;
            long cageID = 0L;
            Cage targetCage = erp.getSingleCage();
            if (targetCage != null) {
                if (!targetCage.getGroup().equals(commonGroup)) {
                    return;
                }
                cageID = targetCage.hasSubCages() ? (erp.dx < RackGraphicsManager.getCageWidth() / 2 ? targetCage.getLong("CAG_SUBCAGEL") : targetCage.getLong("CAG_SUBCAGER")) : targetCage.getID();
            }
            Cage target = null;
            if (cageID != 0L) {
                target = (Cage)ObjectStore.getClientObject(2, cageID, commonGroup);
            }
            if (!PopeAlert.makeCompleteMatingCheck(target, mice, paarungsSammler = new Vector())) {
                return;
            }
            if (!PopeAlert.checkForCageGomorrha(cageID, mice, commonGroup)) {
                return;
            }
            if (!PopeAlert.checkForEartag100Collision(cageID, mice, commonGroup)) {
                return;
            }
            Vector changingMice = new Vector();
            if (!PopeAlert.checkForRoomSecurity(mice, null, null, this.ivRack, null, changingMice)) {
                return;
            }
            Date transferDate = CalendarRequester.getDate((Frame)Inspector.getInspector(), Visit.findLatestStartDate(Mouse.getLastVisits(mice)), new Date());
            if (transferDate == null) {
                return;
            }
            int actionDate = (int)(transferDate.getTime() / 86400000L);
            StringBuffer msb = new StringBuffer();
            if (cageID == 0L) {
                cageID = Cage.getNewCageID(transferDate, commonGroup);
                if (cageID == 0L) {
                    Alert.showAlert(Babel.get("COULDNOTCREATECAGE"), true);
                    return;
                }
                RackPos trp = erp.ivRackPos;
                if (trp == null) {
                    return;
                }
                Rack gruppenRack = null;
                long rackID = trp.ivRackID;
                if (MausoleumClient.isServiceCaretaker()) {
                    Enumeration en = RackManager.cvInstance.getActualObjectEnumeration(commonGroup);
                    while (en.hasMoreElements()) {
                        Rack rack = (Rack)en.nextElement();
                        if (!rack.isSharedWithOtherGroups() || rack.getLong("IDO_SERVID", 0L) != rackID) continue;
                        gruppenRack = rack;
                    }
                    if (gruppenRack != null) {
                        rackID = gruppenRack.getID();
                    }
                } else {
                    gruppenRack = (Rack)ObjectStore.getObjectDeadOrAlive(3, rackID, commonGroup, null, true);
                }
                if (rackID != 0L) {
                    msb.append(CommandManagerExecutive.getServiceRoomTag(gruppenRack, ""));
                    msb.append("CSETR");
                    msb.append(" ").append(cageID);
                    msb.append(" ").append(rackID);
                    msb.append(" ").append(trp.ivSide);
                    msb.append(" ").append(trp.ivRow);
                    msb.append(" ").append(trp.ivColumn).append("\n");
                }
            }
            TaskExtended.addExactPoolingTaskFinish(mice, cageID, msb, actionDate);
            long millis = transferDate.getTime();
            int i = 0;
            while (i < mice.size()) {
                Mouse mausi = (Mouse)mice.elementAt(i);
                TaskExtended.addTaskFinishsToComBuff(mausi, mausi.getTaskKey(), "TASK_AC_TRANSFER", 0L, msb, actionDate);
                CommandManagerMouse.appendTransferCommand(mausi, cageID, millis, msb, true);
                ++i;
            }
            StandardTask.checkForToAndFromMating(mice, paarungsSammler, msb, actionDate);
            TaskExtended.getRoomTransferTaskCommand(changingMice, msb, actionDate);
            TrafficReport.appendTrafficInfoClientSide(mice, millis, "TRD_MICE_DROPPED_IN_RACK", msb);
            RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), commonGroup);
            if (!mice.isEmpty()) {
                Cage c;
                Mouse tm = (Mouse)mice.elementAt(0);
                if ((tm = MouseManager.getMouse(tm.getID(), commonGroup)) != null && (c = tm.getActCage()) != null) {
                    Vector<Cage> v = new Vector<Cage>();
                    v.addElement(c);
                    this.ivRackFrame.selectCages(v, 2);
                }
            }
        }
    }

    public void setRack(Rack rack) {
        boolean hasCagesOnMySide = false;
        if (rack != null) {
            if (this.ivFront) {
                hasCagesOnMySide = true;
            } else {
                boolean bl = hasCagesOnMySide = rack.getInt("RCK_SIDES", 0) > 1;
            }
        }
        if (hasCagesOnMySide) {
            this.ivRack = rack;
            int cols = this.ivRack.getInt("RCK_COLUMNS");
            int rows = this.ivRack.getInt("RCK_ROWS");
            this.ivCages = new Cage[cols * rows];
            int pos = 0;
            Point p = new Point();
            p.y = 0;
            while (p.y < rows) {
                p.x = 0;
                while (p.x < cols) {
                    if (this.ivRack.istPosBelegt(this.ivSide, p.y, p.x, true)) {
                        Cage sharedCage;
                        Cage rein = BlockingCage.BLOCKER;
                        if (MausoleumClient.isServiceCaretaker() && (sharedCage = this.ivRack.getCageAlsoFromSharedRack(this.ivSide, p.y, p.x)) != null) {
                            rein = sharedCage;
                        }
                        this.ivCages[pos++] = rein;
                    } else {
                        this.ivCages[pos++] = this.ivRack.getCage(this.ivSide, p.y, p.x);
                    }
                    ++p.x;
                }
                ++p.y;
            }
        } else {
            this.ivRack = null;
            this.ivCages = null;
        }
        this.somethingChanged();
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.ivRack != null) {
            if (this.ivDrawAll) {
                if (this.ivNormImage == null) {
                    this.ivNormImage = this.createImage(true);
                }
                g.drawImage(this.ivNormImage, 0, 0, null);
            } else {
                if (this.ivSelImage == null) {
                    this.ivSelImage = this.createImage(false);
                }
                g.drawImage(this.ivSelImage, 0, 0, null);
            }
            if (this.ivERPTarget != null && this.ivERPTarget.ivRackPos != null) {
                int cx = this.ivERPTarget.ivRackPos.ivColumn;
                int cy = this.ivERPTarget.ivRackPos.ivRow;
                Cage targetCage = this.ivERPTarget.getSingleCage();
                if (targetCage != null) {
                    if (targetCage.hasSubCages()) {
                        Cage c;
                        if (this.ivERPTarget.dx < RackGraphicsManager.getCageWidth() / 2) {
                            c = targetCage.getLeftSubCage();
                            if (c != null) {
                                CageDisplayManager.drawFramedLeftCagePolygon(g, RAND + cx * this.getXProg(), RAND + cy * this.getYProg(), RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                            }
                        } else {
                            c = targetCage.getRightSubCage();
                            if (c != null) {
                                CageDisplayManager.drawFramedRightCagePolygon(g, RAND + cx * this.getXProg(), RAND + cy * this.getYProg(), RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                            }
                        }
                    } else {
                        CageDisplayManager.drawFramedCagePolygon(g, RAND + cx * this.getXProg(), RAND + cy * this.getYProg(), RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                    }
                } else {
                    CageDisplayManager.drawFramedCagePolygon(g, RAND + cx * this.getXProg(), RAND + cy * this.getYProg(), RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight);
                }
            }
            if (this.ivUnzugaenglich) {
                Dimension dim = this.getSize();
                g.setColor(UNZUGAENGLICH_COL);
                g.fillRect(0, 0, dim.width, dim.height);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int d = dim.height / 2;
                int x = (dim.width - d) / 2;
                int y = (dim.height - d) / 2;
                g.setColor(Color.red);
                g.fillArc(x, y, d, d, 0, 360);
                d = dim.height / 2 * 3 / 4;
                x = (dim.width - d) / 2;
                y = (dim.height - d) / 2;
                g.setColor(Color.white);
                g.fillArc(x, y, d, d, 0, 360);
            }
        }
    }

    private Image createImage(boolean drawall) {
        Dimension d = this.getSize();
        BufferedImage timg = new BufferedImage(d.width, d.height, 1);
        Graphics g = ((Image)timg).getGraphics();
        while (g == null) {
            try {
                System.out.println(String.valueOf(this.getClass().getName()) + " waiting for timg");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = ((Image)timg).getGraphics();
        }
        MausoleumImageStore.fillDimWithImage(g, "inspectorButton", d);
        if (this.ivRack != null && this.ivCages != null) {
            Vector checkSelection = null;
            if (!drawall && this.ivSelCages != null) {
                checkSelection = this.ivSelCages;
            }
            RackGraphicsManager.paintCages(g, this.ivCages, this.ivRack.getInt("RCK_COLUMNS"), this.ivRack.getInt("RCK_ROWS"), RAND, this.getXProg(), this.getYProg(), RackGraphicsManager.cvCageWidth, RackGraphicsManager.cvCageHeight, checkSelection, this.ivCageVerboteByCIDString);
        }
        g.setColor(Color.black);
        g.drawLine(d.width - 1, d.height - 1, d.width - 1, 0);
        g.drawLine(d.width - 1, d.height - 1, 0, d.height - 1);
        g.setColor(Color.white);
        g.drawLine(0, 0, d.width, 0);
        g.drawLine(0, 0, 0, d.height);
        return timg;
    }

    private int getXProg() {
        return RackGraphicsManager.getCageWidth() + RackGraphicsManager.CAGESEP;
    }

    private int getYProg() {
        return RackGraphicsManager.getCageHeight() + RackGraphicsManager.CAGESEP;
    }

    public void paint(boolean drawAll) {
        this.ivDrawAll = drawAll;
        this.repaint();
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
        if (obj instanceof Cage || obj instanceof Mouse) {
            if (obj instanceof Mouse) {
                Mouse mouse = (Mouse)obj;
                CageColorManager.prepareCage(mouse.getActCage());
            }
            this.setRack(this.ivRack);
            return;
        }
        this.somethingChanged();
        this.repaint();
    }
}

