/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.rack.frame;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.main.DefaultManager;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.ui.UIDef;

public class RackGraphicsManager {
    private static final String FILENAME = "files/windows/cageSize.txt";
    public static final String C_RACK_COMBO = "COMBO";
    public static final String C_BUTTON_NEW = "BUTT1";
    public static final String C_BUTTON_REMOVE = "BUTT2";
    public static final String C_BUTTON_MOVE = "BUTT4";
    public static final String C_BUTTON_NAME = "BUTT5";
    public static final String C_DISPLAY_COMBO = "BUTT6";
    public static final String C_TRIANGLE_RESTR_BUT = "TRIANGLE_RESTR";
    public static final String C_FRONTFIELD = "FRONTFIELD";
    public static final String C_BACKFIELD = "BACKFIELD";
    public static final String C_ORCUSFIELD = "ORCUSFIELD";
    public static final String C_SCROLLBAR = "SCROLLBAR";
    public static final String C_RACKCTABLE = "RACKCTABLE";
    public static final String C_ORCUSCTABLE = "ORCUSCTABLE";
    public static final String C_MOUSETABLE = "MOUSETABLE";
    public static final String C_OVERVIEW_BUT = "OVERVIEW";
    public static final String C_CAGECARD_BUT = "CAGECARD";
    public static final String C_MOUSE_POOL = "MOUSE_POOL";
    public static final int MINIMUM_CAGE_WIDTH = UIDef.getScaled(28);
    public static final int MINIMUM_CAGE_HEIGHT = MINIMUM_CAGE_WIDTH / 2;
    private static final int DEFAULT_CAGE_WIDTH = UIDef.getScaled(55);
    private static final int DEFAULT_CAGE_HEIGHT = DEFAULT_CAGE_WIDTH / 2;
    public static final int CAGELABEL_CAGE_WIDTH_UNSCALED = 36;
    public static final int CAGELABEL_CAGE_HEIGHT_UNSCALED = 18;
    public static final int CAGELABEL_CAGE_WIDTH = UIDef.getScaled(36);
    public static final int CAGELABEL_CAGE_HEIGHT = CAGELABEL_CAGE_WIDTH / 2;
    private static final int MINIMUM_ORCUS_HEIGHT = UIDef.getScaled(40);
    public static final int CAGESEP = UIDef.getScaled(3);
    private static final int MIN_TOP_BUT_WIDTH = UIDef.getScaled(60);
    public static final int BIG_MARGIN = UIDef.getScaled(4);
    public static final int SMALL_MARGIN = UIDef.getScaled(3);
    private static final int RACKCOMBO_WIDTH = UIDef.getScaled(160);
    public static final int BUTTON_HEIGHT = UIDef.getScaled(24);
    private static final int COLORMODE_COMBO_WIDTH = UIDef.getScaled(170);
    private static final int MIN_COLS = 5;
    private static final int MIN_ROWS = 4;
    private static final int OVERVIEW_BUT_WIDTH = UIDef.getScaled(130);
    private static final int POOL_WIDTH = UIDef.getScaled(110);
    private static final int MOUSE_TABLE_HEIGHT = UIDef.getScaled(123);
    private static final int CAGE_TABLE_HEIGHT = MOUSE_TABLE_HEIGHT * 3 / 2;
    private static final int MOUSE_TABLE_MIN_HEIGHT = UIDef.getScaled(70);
    private static final int CAGE_TABLE_MIN_HEIGHT = UIDef.getScaled(85);
    private static final int SCROLLBAR_HEIGHT = UIDef.getScaled(18);
    private static final int FIX_HEIGHT = BIG_MARGIN + BUTTON_HEIGHT + BIG_MARGIN + SMALL_MARGIN + SCROLLBAR_HEIGHT + BIG_MARGIN + CAGE_TABLE_HEIGHT + SMALL_MARGIN + BIG_MARGIN;
    private static final int FIX_WIDTH = BIG_MARGIN + SMALL_MARGIN + BIG_MARGIN;
    private static final int MARG_TOP = BIG_MARGIN;
    private static final int MARG_AFTER_BUT = BIG_MARGIN;
    private static final int MARG_AFTER_FIELDS = SMALL_MARGIN;
    private static final int MARG_AFTER_SCROLLER = BIG_MARGIN;
    private static final int MARG_AFTER_CAGE = SMALL_MARGIN;
    private static final int MARG_BOTTOM = BIG_MARGIN;
    private static final int MARG_SUM = MARG_TOP + MARG_AFTER_BUT + MARG_AFTER_FIELDS + MARG_AFTER_SCROLLER + MARG_AFTER_CAGE + MARG_BOTTOM;
    public static int cvCageWidth = DEFAULT_CAGE_WIDTH;
    public static int cvCageHeight = DEFAULT_CAGE_HEIGHT;
    public static int cvMiceHeight = MOUSE_TABLE_HEIGHT;

    static {
        String s = FileManager.getStringFromFile(FILENAME);
        if (s != null) {
            Vector v = StringHelper.splitStringByAny(s, " ");
            if (v.size() >= 1) {
                try {
                    cvCageWidth = Integer.parseInt((String)v.elementAt(0));
                    if (cvCageWidth < MINIMUM_CAGE_WIDTH) {
                        cvCageWidth = MINIMUM_CAGE_WIDTH;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v.size() >= 2) {
                try {
                    cvCageHeight = Integer.parseInt((String)v.elementAt(1));
                    if (cvCageHeight < MINIMUM_CAGE_HEIGHT) {
                        cvCageHeight = MINIMUM_CAGE_HEIGHT;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v.size() >= 3) {
                try {
                    cvMiceHeight = Integer.parseInt((String)v.elementAt(2));
                    if (cvMiceHeight < MOUSE_TABLE_HEIGHT) {
                        cvMiceHeight = MOUSE_TABLE_HEIGHT;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void paintCages(Graphics g, Cage[] carr, int cols, int rows, int rand, int xprog, int yprog, int cageWidth, int cageHeight, Vector checkSelection, HashMap cageVerbote) {
        int pos = 0;
        int y = 0;
        while (y < rows) {
            int x = 0;
            while (x < cols) {
                CageDisplayManager.paintCage(carr[pos++], g, rand + x * xprog, rand + y * yprog, cageWidth, cageHeight, checkSelection, cageVerbote);
                ++x;
            }
            ++y;
        }
    }

    public static void calcNewCageHeight(Dimension newWindowSize, Insets insets, Rack r) {
        int newRackfieldWidth;
        int newCageWidth;
        int newInnerWidth = newWindowSize.width - insets.left - insets.right;
        int newInnerHeight = newWindowSize.height - insets.top - insets.bottom;
        int cols = 5;
        int rows = 4;
        if (r != null) {
            cols = r.getInt("RCK_COLUMNS");
            rows = r.getInt("RCK_ROWS");
        }
        if (cols < 5) {
            cols = 5;
        }
        if (rows < 4) {
            rows = 4;
        }
        if ((newCageWidth = ((newRackfieldWidth = (newInnerWidth - FIX_WIDTH) / 2) - 2 * SMALL_MARGIN - (cols - 1) * CAGESEP) / cols) < MINIMUM_CAGE_WIDTH) {
            newCageWidth = MINIMUM_CAGE_WIDTH;
        }
        cvCageWidth = newCageWidth;
        cvCageHeight = newCageWidth / 2;
        Dimension rfd = RackGraphicsManager.calcDimensionForRackField(r, false);
        cvMiceHeight = newInnerHeight - (rfd.height + FIX_HEIGHT + RackGraphicsManager.getOrcusHeight());
        if (cvMiceHeight < MOUSE_TABLE_HEIGHT) {
            cvMiceHeight = MOUSE_TABLE_HEIGHT;
        }
        FileManager.prepareDirs("files/windows");
        String s = String.valueOf(cvCageWidth) + " " + cvCageHeight + " " + cvMiceHeight;
        FileManager.saveStringToFile(FILENAME, s);
    }

    private static Dimension calcDimensionForRackField(Rack rack, boolean ignoreMinimum) {
        return RackGraphicsManager.calcDimensionForRackField(rack, RackGraphicsManager.getCageWidth(), RackGraphicsManager.getCageHeight(), ignoreMinimum);
    }

    private static Dimension calcDimensionForRackField(Rack rack, int cageWidth, int cageHeight, boolean ignoreMinimum) {
        int width = RackGraphicsManager.getMinimalWidth();
        int height = RackGraphicsManager.getMinimalHeight();
        if (rack != null) {
            int cols = rack.getInt("RCK_COLUMNS");
            int rows = rack.getInt("RCK_ROWS");
            if (ignoreMinimum || cols > 5) {
                width = cols * cageWidth + (cols - 1) * CAGESEP + 2 * SMALL_MARGIN;
            }
            if (ignoreMinimum || rows > 4) {
                height = rows * cageHeight + (rows - 1) * CAGESEP + 2 * SMALL_MARGIN;
            }
        }
        return new Dimension(width, height);
    }

    private static int getAnzTopButs(HashMap componentsByKey) {
        int anz = 0;
        if (componentsByKey.containsKey(C_BUTTON_NEW)) {
            ++anz;
        }
        if (componentsByKey.containsKey(C_BUTTON_REMOVE)) {
            ++anz;
        }
        if (componentsByKey.containsKey(C_BUTTON_MOVE)) {
            ++anz;
        }
        if (componentsByKey.containsKey(C_BUTTON_NAME)) {
            ++anz;
        }
        return anz;
    }

    public static Dimension calcMinimumSize(Rack rack, Insets insets, HashMap componentsByKey) {
        int aktMinWidth = RackGraphicsManager.getAktRackMinimalWidth(rack);
        int aktMinHeight = RackGraphicsManager.getAktRackMinimalHeight(rack);
        int gesamtBreite = 2 * BIG_MARGIN + SMALL_MARGIN + 2 * aktMinWidth;
        int anzTopButs = RackGraphicsManager.getAnzTopButs(componentsByKey);
        int topRowMinWidth = anzTopButs * MIN_TOP_BUT_WIDTH + RACKCOMBO_WIDTH + COLORMODE_COMBO_WIDTH + (anzTopButs + 1) * SMALL_MARGIN + 2 * BIG_MARGIN;
        if (topRowMinWidth > gesamtBreite) {
            gesamtBreite = topRowMinWidth;
        }
        int buttonHeight = BUTTON_HEIGHT;
        int orcusHeight = RackGraphicsManager.getOrcusHeight();
        int fieldHeight = aktMinHeight;
        int cageHeight = CAGE_TABLE_MIN_HEIGHT;
        int mouseHeight = MOUSE_TABLE_MIN_HEIGHT;
        int wantedHeight = MARG_SUM + buttonHeight + orcusHeight + fieldHeight + SCROLLBAR_HEIGHT + cageHeight + mouseHeight;
        return new Dimension(gesamtBreite + insets.left + insets.right, wantedHeight + insets.top + insets.bottom);
    }

    public static Dimension calcSizeForRack(Rack rack, HashMap componentsByKey, boolean forceSizeToFit, Dimension aktSize) {
        Dimension dimensionOfOneSide = RackGraphicsManager.calcDimensionForRackField(rack, false);
        int innereBreite = SMALL_MARGIN + 2 * dimensionOfOneSide.width;
        int gesamtBreite = 2 * BIG_MARGIN + innereBreite;
        int orcusHeight = RackGraphicsManager.getOrcusHeight();
        int fieldHeight = dimensionOfOneSide.height;
        int cageHeight = CAGE_TABLE_HEIGHT;
        int mouseHeight = cvMiceHeight;
        if (!forceSizeToFit) {
            gesamtBreite = aktSize.width;
            innereBreite = gesamtBreite - 2 * BIG_MARGIN;
            int wantedHeight = MARG_SUM + BUTTON_HEIGHT + orcusHeight + fieldHeight + SCROLLBAR_HEIGHT + cageHeight + mouseHeight;
            if (wantedHeight > aktSize.height) {
                int possCT = cageHeight - CAGE_TABLE_MIN_HEIGHT;
                int possMT = mouseHeight - MOUSE_TABLE_MIN_HEIGHT;
                int diff = wantedHeight - aktSize.height;
                if (possCT + possMT >= diff) {
                    double pro = (double)diff / ((double)possCT + (double)possMT);
                    int antM = (int)(pro * (double)possMT);
                    int antC = diff - antM;
                    cageHeight -= antC;
                    mouseHeight -= antM;
                } else {
                    cageHeight = CAGE_TABLE_MIN_HEIGHT;
                    mouseHeight = MOUSE_TABLE_MIN_HEIGHT;
                    int wantedHeightOhne = MARG_SUM + BUTTON_HEIGHT + orcusHeight + SCROLLBAR_HEIGHT + cageHeight + mouseHeight;
                    diff = wantedHeightOhne + fieldHeight - aktSize.height;
                    int cWidth = RackGraphicsManager.getCageWidth();
                    int cHeight = RackGraphicsManager.getCageHeight();
                    while (diff > 0) {
                        cHeight = --cWidth / 2;
                        int nfh = RackGraphicsManager.calcDimensionForRackField((Rack)rack, (int)cWidth, (int)cHeight, (boolean)false).height;
                        diff = wantedHeightOhne + nfh - aktSize.height;
                    }
                    cvCageWidth = cWidth;
                    cvCageHeight = cHeight;
                    cvMiceHeight = mouseHeight - diff;
                    dimensionOfOneSide = RackGraphicsManager.calcDimensionForRackField(rack, false);
                    orcusHeight = RackGraphicsManager.getOrcusHeight();
                    fieldHeight = dimensionOfOneSide.height;
                    mouseHeight = cvMiceHeight;
                    cageHeight = aktSize.height - (MARG_SUM + BUTTON_HEIGHT + orcusHeight + fieldHeight + SCROLLBAR_HEIGHT + mouseHeight);
                    FileManager.prepareDirs("files/windows");
                    String s = String.valueOf(cvCageWidth) + " " + cvCageHeight + " " + cvMiceHeight;
                    FileManager.saveStringToFile(FILENAME, s);
                }
            }
        }
        int aktY = MARG_TOP;
        int buttonGroupWidth = innereBreite - RACKCOMBO_WIDTH - SMALL_MARGIN - COLORMODE_COMBO_WIDTH - SMALL_MARGIN;
        int anzTopButs = RackGraphicsManager.getAnzTopButs(componentsByKey);
        int butw = anzTopButs == 0 ? 0 : ((buttonGroupWidth -= BUTTON_HEIGHT + SMALL_MARGIN) - (anzTopButs - 1) * SMALL_MARGIN) / anzTopButs;
        int lbutw = anzTopButs == 0 ? 0 : buttonGroupWidth - (anzTopButs - 1) * (SMALL_MARGIN + butw);
        int aktX = BIG_MARGIN;
        RackGraphicsManager.setComponentBounds(C_RACK_COMBO, aktX, aktY, RACKCOMBO_WIDTH, BUTTON_HEIGHT, componentsByKey);
        aktX += RACKCOMBO_WIDTH + SMALL_MARGIN;
        if (componentsByKey.containsKey(C_BUTTON_NEW)) {
            RackGraphicsManager.setComponentBounds(C_BUTTON_NEW, aktX, aktY, butw, BUTTON_HEIGHT, componentsByKey);
            aktX += butw + SMALL_MARGIN;
        }
        if (componentsByKey.containsKey(C_BUTTON_REMOVE)) {
            RackGraphicsManager.setComponentBounds(C_BUTTON_REMOVE, aktX, aktY, butw, BUTTON_HEIGHT, componentsByKey);
            aktX += butw + SMALL_MARGIN;
        }
        if (componentsByKey.containsKey(C_BUTTON_MOVE)) {
            RackGraphicsManager.setComponentBounds(C_BUTTON_MOVE, aktX, aktY, butw, BUTTON_HEIGHT, componentsByKey);
            aktX += butw + SMALL_MARGIN;
        }
        if (componentsByKey.containsKey(C_BUTTON_NAME)) {
            RackGraphicsManager.setComponentBounds(C_BUTTON_NAME, aktX, aktY, lbutw, BUTTON_HEIGHT, componentsByKey);
            aktX += lbutw + SMALL_MARGIN;
        }
        RackGraphicsManager.setComponentBounds(C_DISPLAY_COMBO, aktX, aktY, COLORMODE_COMBO_WIDTH, BUTTON_HEIGHT, componentsByKey);
        RackGraphicsManager.setComponentBounds(C_TRIANGLE_RESTR_BUT, aktX += COLORMODE_COMBO_WIDTH + SMALL_MARGIN, aktY, BUTTON_HEIGHT, BUTTON_HEIGHT, componentsByKey);
        aktX += BUTTON_HEIGHT;
        aktY += BUTTON_HEIGHT + MARG_AFTER_BUT;
        Dimension rdoos = RackGraphicsManager.calcDimensionForRackField(rack, true);
        int fw = rdoos.width;
        int fh = rdoos.height;
        mouseHeight += fieldHeight - fh;
        if (rack != null && rack.getInt("RCK_SIDES", 0) == 1) {
            int lfx = (gesamtBreite - fw) / 2;
            RackGraphicsManager.setComponentBounds(C_FRONTFIELD, lfx, aktY, fw, fh, componentsByKey);
            RackGraphicsManager.setComponentBounds(C_BACKFIELD, 0, 0, 0, 0, componentsByKey);
        } else {
            int xoff = (innereBreite - SMALL_MARGIN - 2 * fw) / 2;
            int lfx = BIG_MARGIN + xoff;
            int rfx = lfx + fw + SMALL_MARGIN;
            RackGraphicsManager.setComponentBounds(C_FRONTFIELD, lfx, aktY, fw, fh, componentsByKey);
            RackGraphicsManager.setComponentBounds(C_BACKFIELD, rfx, aktY, fw, fh, componentsByKey);
        }
        aktY += fh + MARG_AFTER_FIELDS;
        int zusw = OVERVIEW_BUT_WIDTH + POOL_WIDTH;
        int x3a1 = BIG_MARGIN;
        int w3a1 = innereBreite - zusw;
        int x3a2 = x3a1 + w3a1;
        int x3a3 = x3a2 + OVERVIEW_BUT_WIDTH;
        RackGraphicsManager.setComponentBounds(C_ORCUSFIELD, x3a1, aktY, w3a1, orcusHeight, componentsByKey);
        int fOrcusHeight = orcusHeight + SCROLLBAR_HEIGHT;
        int voh = fOrcusHeight / 2;
        int vuh = fOrcusHeight - voh;
        RackGraphicsManager.setComponentBounds(C_OVERVIEW_BUT, x3a2, aktY, OVERVIEW_BUT_WIDTH, voh, componentsByKey);
        RackGraphicsManager.setComponentBounds(C_CAGECARD_BUT, x3a2, aktY + voh, OVERVIEW_BUT_WIDTH, vuh, componentsByKey);
        RackGraphicsManager.setComponentBounds(C_MOUSE_POOL, x3a3, aktY, POOL_WIDTH, fOrcusHeight, componentsByKey);
        RackGraphicsManager.setComponentBounds(C_SCROLLBAR, BIG_MARGIN, aktY += orcusHeight, w3a1, SCROLLBAR_HEIGHT, componentsByKey);
        aktY += SCROLLBAR_HEIGHT + MARG_AFTER_SCROLLER;
        if (DefaultManager.showCageTablesInRackDisplay()) {
            int lbr = (innereBreite - SMALL_MARGIN) / 2;
            int rbr = innereBreite - SMALL_MARGIN - lbr;
            RackGraphicsManager.setComponentBounds(C_RACKCTABLE, BIG_MARGIN, aktY, lbr, cageHeight, componentsByKey);
            RackGraphicsManager.setComponentBounds(C_ORCUSCTABLE, BIG_MARGIN + SMALL_MARGIN + lbr, aktY, rbr, cageHeight, componentsByKey);
            aktY += cageHeight + MARG_AFTER_CAGE;
        } else {
            RackGraphicsManager.setComponentBounds(C_RACKCTABLE, 0, 0, 0, 0, componentsByKey);
            RackGraphicsManager.setComponentBounds(C_ORCUSCTABLE, 0, 0, 0, 0, componentsByKey);
            mouseHeight += cageHeight + MARG_AFTER_CAGE;
        }
        int mtw = innereBreite;
        RackGraphicsManager.setComponentBounds(C_MOUSETABLE, BIG_MARGIN, aktY, mtw, mouseHeight, componentsByKey);
        return new Dimension(gesamtBreite, aktY += mouseHeight + MARG_BOTTOM);
    }

    private static void setComponentBounds(String key, int x, int y, int w, int h, HashMap componentsByKey) {
        Component c = (Component)componentsByKey.get(key);
        if (c != null) {
            Rectangle or = c.getBounds();
            if (or.x != x || or.y != y || or.width != w || or.height != h) {
                c.setBounds(x, y, w, h);
            }
        }
    }

    private static int getMinimalWidth() {
        return 5 * RackGraphicsManager.getCageWidth() + 4 * CAGESEP + 2 * SMALL_MARGIN;
    }

    private static int getMinimalHeight() {
        return 4 * RackGraphicsManager.getCageHeight() + 3 * CAGESEP + 2 * SMALL_MARGIN;
    }

    private static int getAktRackMinimalWidth(Rack rack) {
        int anzCols = rack != null ? rack.getInt("RCK_COLUMNS", 5) : 5;
        return anzCols * MINIMUM_CAGE_WIDTH + (anzCols - 1) * CAGESEP + 2 * SMALL_MARGIN;
    }

    private static int getAktRackMinimalHeight(Rack rack) {
        int anzRows = rack != null ? rack.getInt("RCK_ROWS", 4) : 4;
        return anzRows * MINIMUM_CAGE_HEIGHT + (anzRows - 1) * CAGESEP + 2 * SMALL_MARGIN;
    }

    public static int getCageHeight() {
        return cvCageHeight;
    }

    public static int getCageWidth() {
        return cvCageWidth;
    }

    public static int getMiceHeight() {
        return cvMiceHeight;
    }

    public static int getOrcusHeight() {
        int h = RackGraphicsManager.getCageHeight() + 4 * BIG_MARGIN;
        if (h < MINIMUM_ORCUS_HEIGHT) {
            h = MINIMUM_ORCUS_HEIGHT;
        }
        return h;
    }
}

